/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.service;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.ExilServiceInterface;
import com.exilant.exility.dataservice.SQLTask;
import java.sql.Connection;
import org.apache.log4j.Logger;

public class DescriptionService
implements ExilServiceInterface {
    static DescriptionService singletonInstance;
    private static final Logger LOGGER;
    private static final String SERVICE_ID = "serviceID";
    private static final String KEY_VALUE = "keyValue";

    public static DescriptionService getService() {
        if (singletonInstance == null) {
            singletonInstance = new DescriptionService();
        }
        return singletonInstance;
    }

    private DescriptionService() {
    }

    @Override
    public void doService(DataCollection dc) {
        String[] serviceID = dc.getValueList(SERVICE_ID);
        String[] keyValue = dc.getValueList(KEY_VALUE);
        if (dc.hasList(SERVICE_ID)) {
            serviceID = dc.getValueList(SERVICE_ID);
        } else if (dc.hasName(SERVICE_ID)) {
            serviceID = new String[]{dc.getValue(SERVICE_ID)};
        } else {
            dc.addMessage("exilNoServiceID");
            return;
        }
        if (dc.hasList(KEY_VALUE)) {
            keyValue = dc.getValueList(KEY_VALUE);
        } else if (dc.hasName(KEY_VALUE)) {
            keyValue = new String[]{dc.getValue(KEY_VALUE)};
        } else {
            dc.addMessage("exilNoKeyValue");
            return;
        }
        int kount = serviceID.length;
        if (keyValue.length != kount) {
            dc.addMessage("exilKeyValueMismatch", " " + kount, " " + keyValue.length);
            return;
        }
        Connection con = null;
        con = null;
        SQLTask task = SQLTask.getTask();
        try {
            for (int i = 0; i < kount; ++i) {
                dc.addValue(KEY_VALUE, keyValue[i]);
                task.execute(serviceID[i], serviceID[i] + "_" + keyValue[i], dc, con, false, false, "");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("SQLTask failed " + e.getMessage()), (Throwable)e);
            dc.addMessage("exilDBError", e.getMessage());
        }
    }

    static {
        LOGGER = Logger.getLogger(DescriptionService.class);
    }
}

