/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.dataservice;

import com.exilant.exility.dataservice.DatabaseConnectionException;
import java.sql.Connection;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class DBHandler {
    private static final Logger LOGGER = Logger.getLogger(DBHandler.class);
    private static final String datasource = "java:/ezgovDatabasePool";
    private static final String errConnOpenString = "Unable to get a connection from Pool:java:/ezgovDatabasePool. Please make sure that the connection pool is set up properly";
    private static final String errStmtString = "Unable to Close the statement";
    private static final String errConnCloseString = "Unable to Close the statement";
    private static final String infoGetCon = "Requesting a new connection";
    private static final String infoRelCon = "Releasing connection";
    private static final String infoCrtCon = "Creating a new connection";
    private static DataSource ds = null;

    public static Connection getConnection() throws DatabaseConnectionException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)infoCrtCon);
            }
            return ds.getConnection();
        }
        catch (Exception exception) {
            LOGGER.fatal((Object)errConnOpenString, (Throwable)exception);
            throw new DatabaseConnectionException(errConnOpenString, exception);
        }
    }

    public static void returnConnection(Connection connection, Statement statement) throws DatabaseConnectionException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)infoRelCon);
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Unable to Close the statement", (Throwable)exception);
            throw new DatabaseConnectionException("Unable to Close the statement", exception);
        }
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            LOGGER.fatal((Object)errConnOpenString, (Throwable)exception);
            throw new DatabaseConnectionException("Unable to Close the statement", exception);
        }
    }

    static {
        InitialContext initCtx = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)infoGetCon);
            }
            initCtx = new InitialContext();
            ds = (DataSource)initCtx.lookup(datasource);
        }
        catch (Exception e) {
            LOGGER.fatal((Object)"Data Source not bound. Please check the jndi name.");
        }
        finally {
            try {
                if (initCtx != null) {
                    initCtx.close();
                }
            }
            catch (NamingException ne) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("Error closing context" + ne));
                }
                throw new DatabaseConnectionException(ne.getMessage());
            }
        }
    }
}

