/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.reports;

import com.exilant.eGov.src.reports.OpeningBalanceBean;
import com.exilant.eGov.src.reports.OpeningBalanceInputBean;
import com.exilant.exility.common.TaskFailedException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Scope(value="prototype")
@Service
public class OpeningBalance {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    List<Object[]> resultset;
    Query pstmt = null;
    private String fundId = "";
    private String finYear = "";
    private String deptId = "";
    private double grandTotalDr = 0.0;
    private double grandTotalCr = 0.0;
    private String fund = "";
    private String checkFund = "";
    private String glcode = "";
    private String name = "";
    private String narration = "";
    private String deptcode = "";
    private String functioncode = "";
    private Double debit;
    private Double credit;
    private Double balance;
    ArrayList al = new ArrayList();
    private static final Logger LOGGER = Logger.getLogger(OpeningBalance.class);

    public ArrayList getOBReport(OpeningBalanceInputBean OPBean) throws TaskFailedException {
        try {
            String deptid;
            String fuId = OPBean.getObFund_id();
            if (fuId != null) {
                this.fundId = OPBean.getObFund_id();
            }
            if ((deptid = OPBean.getDeptId()) != null) {
                this.deptId = OPBean.getDeptId();
            }
            this.finYear = OPBean.getFinYear();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("finYear --> " + this.finYear + " fundid  " + this.fundId));
            }
            this.getReport();
            this.formatReport();
        }
        catch (SQLException exception) {
            LOGGER.error((Object)("EXP=" + exception.getMessage()), (Throwable)exception);
        }
        return this.al;
    }

    private void getReport() throws SQLException {
        String query = " ";
        String fundCondition = "";
        String deptCondition = "";
        double totalDr = 0.0;
        double totalCr = 0.0;
        new DecimalFormat();
        new DecimalFormat("###############.00");
        if (!this.fundId.equalsIgnoreCase("")) {
            fundCondition = " and b.id=? ";
        }
        if (!this.deptId.equalsIgnoreCase("")) {
            deptCondition = " and a.DEPARTMENTID=? ";
        }
        query = "SELECT b.name AS \"fund\",c.glcode AS \"accountcode\",c.name AS \"accountname\",'' as \"narration\",SUM(a.openingdebitbalance) AS \"debit\", SUM(a.openingcreditbalance)AS \"credit\",dept.code AS \"deptcode\",fn.code AS \"functioncode\"  FROM TRANSACTIONSUMMARY a,FUND  b,CHARTOFACCOUNTS c, eg_department dept,function fn  WHERE c.id in (select glcodeid from chartofaccountdetail  ) and a.departmentid= dept.id and fn.id = a.functionid and  a.financialyearid=? " + fundCondition + deptCondition + " AND a.fundid=b.id AND a.glcodeid=c.id AND (a.openingdebitbalance>0 OR a.openingcreditbalance>0) GROUP BY b.name, c.glcode,c.name,dept.code,fn.code union";
        query = query + " SELECT b.name AS \"fund\",c.glcode AS \"accountcode\",c.name AS \"accountname\",a.narration as \"narration\",SUM(a.openingdebitbalance) AS \"debit\", SUM(a.openingcreditbalance)AS \"credit\",dept.code AS \"deptcode\",fn.code AS \"functioncode\"  FROM TRANSACTIONSUMMARY a,FUND  b,CHARTOFACCOUNTS c, eg_department dept,function fn  WHERE c.id not in (select glcodeid from chartofaccountdetail  ) and a.departmentid= dept.id and fn.id = a.functionid and  a.financialyearid=? " + fundCondition + deptCondition + " AND a.fundid=b.id AND a.glcodeid=c.id AND (a.openingdebitbalance>0 OR a.openingcreditbalance>0) GROUP BY b.name, c.glcode,c.name,dept.code,fn.code, a.narration ";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Opening balance Query ...." + query));
        }
        try {
            List list;
            OpeningBalanceBean ob = null;
            this.pstmt = this.persistenceService.getSession().createSQLQuery(query);
            int i = 0;
            this.pstmt.setLong(i++, Long.valueOf(this.finYear).longValue());
            if (!this.fundId.equalsIgnoreCase("")) {
                this.pstmt.setLong(i++, Long.valueOf(this.fundId).longValue());
            }
            if (!this.deptId.equalsIgnoreCase("")) {
                this.pstmt.setLong(i++, Long.valueOf(this.deptId).longValue());
            }
            this.pstmt.setLong(i++, Long.valueOf(this.finYear).longValue());
            if (!this.fundId.equalsIgnoreCase("")) {
                this.pstmt.setLong(i++, Long.valueOf(this.fundId).longValue());
            }
            if (!this.deptId.equalsIgnoreCase("")) {
                this.pstmt.setLong(i++, Long.valueOf(this.deptId).longValue());
            }
            this.resultset = list = this.pstmt.list();
            for (Object[] element : this.resultset) {
                if (!this.checkFund.equalsIgnoreCase(element[0].toString()) && !this.checkFund.equalsIgnoreCase("")) {
                    OpeningBalanceBean opeBalDiff = new OpeningBalanceBean();
                    opeBalDiff.setFund("&nbsp;");
                    opeBalDiff.setAccCode("&nbsp;");
                    opeBalDiff.setAccName("<b>&nbsp;&nbsp;&nbsp; Difference&nbsp;&nbsp;</b>");
                    double diff = totalDr - totalCr;
                    if (diff > 0.0) {
                        opeBalDiff.setDebit("&nbsp;");
                        opeBalDiff.setCredit("<b>" + OpeningBalance.numberToString(Double.valueOf(diff).toString()).toString() + "</b>");
                    } else {
                        opeBalDiff.setDebit("<b>" + OpeningBalance.numberToString(Double.valueOf(diff).toString()).toString() + "</b>");
                        opeBalDiff.setCredit("&nbsp;");
                    }
                    this.al.add(opeBalDiff);
                    OpeningBalanceBean opeBal = new OpeningBalanceBean();
                    opeBal.setFund("&nbsp;");
                    opeBal.setAccCode("&nbsp;");
                    opeBal.setAccName("<b>&nbsp;&nbsp;&nbsp; Total:&nbsp;&nbsp;</b>");
                    if (diff > 0.0) {
                        opeBal.setDebit("<b>" + OpeningBalance.numberToString(Double.valueOf(totalDr).toString()).toString() + "</b>");
                        opeBal.setCredit("<b>" + OpeningBalance.numberToString(Double.valueOf(totalCr += diff).toString()).toString() + "</b>");
                    } else {
                        opeBal.setDebit("<b>" + OpeningBalance.numberToString(Double.valueOf(totalDr += diff * -1.0).toString()).toString() + "</b>");
                        opeBal.setCredit("<b>" + OpeningBalance.numberToString(Double.valueOf(totalCr).toString()).toString() + "</b>");
                    }
                    this.al.add(opeBal);
                    totalDr = 0.0;
                    totalCr = 0.0;
                }
                this.fund = element[0].toString();
                this.glcode = element[1].toString();
                this.name = element[2].toString();
                if (element[3] != null) {
                    this.narration = this.formatStringToFixedLength(element[3].toString(), 30);
                }
                this.debit = Double.parseDouble(element[4].toString());
                this.credit = Double.parseDouble(element[5].toString());
                this.deptcode = element[6].toString();
                this.functioncode = element[7].toString();
                ob = new OpeningBalanceBean();
                ob.setFund(this.fund);
                ob.setAccCode(this.glcode);
                ob.setAccName(this.name);
                ob.setDescription(this.narration);
                ob.setDeptcode(this.deptcode);
                ob.setFunctioncode(this.functioncode);
                if (this.debit != null && this.credit != null) {
                    this.balance = this.debit - this.credit;
                    if (this.balance > 0.0) {
                        ob.setDebit(OpeningBalance.numberToString(this.balance.toString()).toString());
                        ob.setCredit("&nbsp;");
                    } else {
                        this.balance = this.credit - this.debit;
                        ob.setDebit("&nbsp;");
                        ob.setCredit(OpeningBalance.numberToString(this.balance.toString()).toString());
                    }
                }
                totalDr += this.debit.doubleValue();
                this.grandTotalDr += this.debit.doubleValue();
                totalCr += this.credit.doubleValue();
                this.grandTotalCr += this.credit.doubleValue();
                this.al.add(ob);
                this.checkFund = this.fund;
            }
            OpeningBalanceBean opeBalDiff = new OpeningBalanceBean();
            opeBalDiff.setFund("&nbsp;");
            opeBalDiff.setAccCode("&nbsp;");
            opeBalDiff.setAccName("<b>&nbsp;&nbsp;&nbsp; Difference&nbsp;&nbsp;</b>");
            opeBalDiff.setDescription("&nbsp;");
            opeBalDiff.setDeptcode("&nbsp;");
            opeBalDiff.setFunctioncode("&nbsp;");
            double diff = totalDr - totalCr;
            if (diff > 0.0) {
                opeBalDiff.setDebit("&nbsp;");
                opeBalDiff.setCredit("<b>" + OpeningBalance.numberToString(Double.valueOf(diff).toString()).toString() + "</b>");
            } else {
                opeBalDiff.setDebit("<b>" + OpeningBalance.numberToString(Double.valueOf(diff).toString()).toString() + "</b>");
                opeBalDiff.setCredit("&nbsp;");
            }
            this.al.add(opeBalDiff);
            OpeningBalanceBean opeBal = new OpeningBalanceBean();
            opeBal.setFund("&nbsp;");
            opeBal.setAccCode("&nbsp;");
            opeBal.setAccName("<b>&nbsp;&nbsp;&nbsp; Total:&nbsp;&nbsp;</b>");
            opeBal.setDescription("&nbsp;");
            opeBal.setDeptcode("&nbsp;");
            opeBal.setFunctioncode("&nbsp;");
            if (diff > 0.0) {
                opeBal.setDebit("<b>" + OpeningBalance.numberToString(Double.valueOf(totalDr).toString()).toString() + "</b>");
                opeBal.setCredit("<b>" + OpeningBalance.numberToString(Double.valueOf(totalCr += diff).toString()).toString() + "</b>");
            } else {
                opeBal.setDebit("<b>" + OpeningBalance.numberToString(Double.valueOf(totalDr += diff * -1.0).toString()).toString() + "</b>");
                opeBal.setCredit("<b>" + OpeningBalance.numberToString(Double.valueOf(totalCr).toString()).toString() + "</b>");
            }
            this.al.add(opeBal);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error in getReport", (Throwable)e);
            throw new SQLException();
        }
    }

    private void formatReport() {
        new DecimalFormat();
        double diff = this.grandTotalDr - this.grandTotalCr;
        OpeningBalanceBean ob = new OpeningBalanceBean();
        ob.setFund("<hr>&nbsp;<hr>");
        ob.setAccCode("<hr>&nbsp;<hr>");
        ob.setAccName("<hr><b>&nbsp;&nbsp;&nbsp;Grand Total:</b><hr>");
        ob.setDescription("<hr>&nbsp;<hr>");
        ob.setDeptcode("&nbsp;");
        ob.setFunctioncode("&nbsp;");
        if (diff > 0.0) {
            this.grandTotalCr += diff;
            ob.setDebit("<hr>&nbsp;<b>" + OpeningBalance.numberToString(Double.valueOf(this.grandTotalDr).toString()).toString() + "</b><hr>");
            ob.setCredit("<hr>&nbsp;<b>" + OpeningBalance.numberToString(Double.valueOf(this.grandTotalCr).toString()).toString() + "</b><hr>");
        } else {
            this.grandTotalDr += diff * -1.0;
            ob.setDebit("<hr>&nbsp;<b>" + OpeningBalance.numberToString(Double.valueOf(this.grandTotalDr).toString()).toString() + "</b><hr>");
            ob.setCredit("<hr>&nbsp;<b>" + OpeningBalance.numberToString(Double.valueOf(this.grandTotalCr).toString()).toString() + "</b><hr>");
        }
        this.al.add(ob);
    }

    public void isCurDate(Connection conn, String VDate) throws TaskFailedException {
        try {
            int ret;
            String today = new SimpleDateFormat("dd/MM/yyyy").format(new Date());
            String[] dt2 = today.split("/");
            String[] dt1 = VDate.split("/");
            int n = Integer.parseInt(dt2[2]) > Integer.parseInt(dt1[2]) ? 1 : (Integer.parseInt(dt2[2]) < Integer.parseInt(dt1[2]) ? -1 : (Integer.parseInt(dt2[1]) > Integer.parseInt(dt1[1]) ? 1 : (Integer.parseInt(dt2[1]) < Integer.parseInt(dt1[1]) ? -1 : (Integer.parseInt(dt2[0]) > Integer.parseInt(dt1[0]) ? 1 : (ret = Integer.parseInt(dt2[0]) < Integer.parseInt(dt1[0]) ? -1 : 0)))));
            if (ret == -1) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception " + ex), (Throwable)ex);
            throw new TaskFailedException("Date Should be within the today's date");
        }
    }

    public static StringBuffer numberToString(String strNumberToConvert) {
        String strNumber = "";
        String signBit = "";
        if (strNumberToConvert.startsWith("-")) {
            strNumber = "" + strNumberToConvert.substring(1, strNumberToConvert.length());
            signBit = "-";
        } else {
            strNumber = "" + strNumberToConvert;
        }
        DecimalFormat dft = new DecimalFormat("##############0.00");
        String strtemp = "" + dft.format(Double.parseDouble(strNumber));
        StringBuffer strbNumber = new StringBuffer(strtemp);
        int intLen = strbNumber.length();
        for (int i = intLen - 6; i > 0; i -= 2) {
            strbNumber.insert(i, ',');
        }
        if (signBit.equals("-")) {
            strbNumber = strbNumber.insert(0, "-");
        }
        return strbNumber;
    }

    public String formatStringToFixedLength(String str, int fixedLength) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"insidde formatStringToFixedLength");
        }
        String string = str == null ? "&nbsp;" : (str = str.trim().equalsIgnoreCase("") ? "&nbsp;" : str);
        if (str.equalsIgnoreCase("&nbsp;") || str.length() <= fixedLength) {
            return str;
        }
        String formattedString = "";
        for (int sIndex = 0; sIndex < str.length(); sIndex += fixedLength) {
            formattedString = sIndex + fixedLength >= str.length() ? formattedString + str.substring(sIndex, str.length()) : formattedString + str.substring(sIndex, sIndex + fixedLength) + "<BR>";
        }
        return formattedString;
    }
}

