/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.eGov.src.domain;

import com.exilant.eGov.src.common.EGovernCommon;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.updateservice.PrimaryKeyGenerator;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ScheduleMapping {
    private static final Logger LOGGER = Logger.getLogger(ScheduleMapping.class);
    Query pstmt = null;
    private String id = null;
    private String reportType = null;
    private String schedule = "0";
    private String scheduleName = null;
    private String createdBy = null;
    private String createdDate = "";
    private String lastModifiedBy = null;
    private String lastModifiedDate = "";
    private String repSubType = null;
    private String isRemission = null;
    private static TaskFailedException taskExc;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    EGovernCommon eGovernCommon;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
    private final SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy", Locale.getDefault());

    public void setId(String aId) {
        this.id = aId;
    }

    public int getId() {
        return Integer.valueOf(this.id);
    }

    @Transactional
    public void insert() throws SQLException, TaskFailedException {
        this.setId(String.valueOf(PrimaryKeyGenerator.getNextKey("schedulemapping")));
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            this.createdDate = formatter.format(new Date());
            this.setCreatedDate(this.createdDate);
            this.lastModifiedDate = null;
            this.setCreatedDate(this.createdDate);
            this.setLastModifiedDate(this.lastModifiedDate);
            String insertQuery = "INSERT INTO schedulemapping (id, reportType,schedule, scheduleName, createdBy, createdDate, lastModifiedBy,lastModifiedDate,repSubType,isRemission) values(?,?,?,?,?,?,?,?,?,?)";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"INSERT INTO schedulemapping (id, reportType,schedule, scheduleName, createdBy, createdDate, lastModifiedBy,lastModifiedDate,repSubType,isRemission) values(?,?,?,?,?,?,?,?,?,?)");
            }
            this.pstmt = this.persistenceService.getSession().createSQLQuery("INSERT INTO schedulemapping (id, reportType,schedule, scheduleName, createdBy, createdDate, lastModifiedBy,lastModifiedDate,repSubType,isRemission) values(?,?,?,?,?,?,?,?,?,?)");
            this.pstmt.setString(0, this.id);
            this.pstmt.setString(1, this.reportType);
            this.pstmt.setString(2, this.schedule);
            this.pstmt.setString(3, this.scheduleName);
            this.pstmt.setString(4, this.createdBy);
            this.pstmt.setString(5, this.createdDate);
            this.pstmt.setString(6, this.lastModifiedBy);
            this.pstmt.setString(7, this.lastModifiedDate);
            this.pstmt.setString(8, this.repSubType);
            this.pstmt.setString(9, this.isRemission);
            this.pstmt.executeUpdate();
        }
        catch (Exception e) {
            LOGGER.error((Object)("ERROR" + e.getMessage()), (Throwable)e);
            throw taskExc;
        }
    }

    @Transactional
    public void update() throws SQLException, TaskFailedException {
        try {
            this.newUpdate();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error inside update" + e.getMessage()), (Throwable)e);
        }
    }

    public void newUpdate() throws TaskFailedException, SQLException {
        this.lastModifiedDate = this.eGovernCommon.getCurrentDate();
        SQLQuery pstmt = null;
        try {
            this.lastModifiedDate = this.formatter.format(this.sdf.parse(this.lastModifiedDate));
        }
        catch (ParseException parseExp) {
            LOGGER.error((Object)("error inside newUpdate" + parseExp.getMessage()), (Throwable)parseExp);
        }
        this.setLastModifiedDate(this.lastModifiedDate);
        StringBuilder query = new StringBuilder(500);
        query.append("update schedulemapping set ");
        if (this.reportType != null) {
            query.append("REPORTTYPE=?,");
        }
        if (this.schedule != null) {
            query.append("SCHEDULE=?,");
        }
        if (this.scheduleName != null) {
            query.append("SCHEDULENAME=?,");
        }
        if (this.createdBy != null) {
            query.append("CREATEDBY=?,");
        }
        if (this.createdDate != null && !this.createdDate.isEmpty()) {
            query.append("CREATEDDATE=?,");
        }
        if (this.lastModifiedBy != null) {
            query.append("LASTMODIFIEDBY=?,");
        }
        if (this.lastModifiedDate != null) {
            query.append("LASTMODIFIEDDATE=?,");
        }
        if (this.repSubType != null) {
            query.append("REPSUBTYPE=?,");
        }
        if (this.isRemission != null) {
            query.append("ISREMISSION=?,");
        }
        int lastIndexOfComma = query.lastIndexOf(",");
        query.deleteCharAt(lastIndexOfComma);
        query.append(" where id=?");
        try {
            int i = 1;
            pstmt = this.persistenceService.getSession().createSQLQuery(query.toString());
            if (this.reportType != null) {
                pstmt.setString(i++, this.reportType);
            }
            if (this.schedule != null) {
                pstmt.setString(i++, this.schedule);
            }
            if (this.scheduleName != null) {
                pstmt.setString(i++, this.scheduleName);
            }
            if (this.createdBy != null) {
                pstmt.setString(i++, this.createdBy);
            }
            if (this.createdDate != null && !this.createdDate.isEmpty()) {
                pstmt.setString(i++, this.createdDate);
            }
            if (this.lastModifiedBy != null) {
                pstmt.setString(i++, this.lastModifiedBy);
            }
            if (this.lastModifiedDate != null) {
                pstmt.setString(i++, this.lastModifiedDate);
            }
            if (this.repSubType != null) {
                pstmt.setString(i++, this.repSubType);
            }
            if (this.isRemission != null) {
                pstmt.setString(i++, this.isRemission);
            }
            pstmt.setString(i++, this.id);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in update: " + e.getMessage()), (Throwable)e);
            throw taskExc;
        }
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(String lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getRepSubType() {
        return this.repSubType;
    }

    public void setRepSubType(String repSubType) {
        this.repSubType = repSubType;
    }

    public String getIsRemission() {
        return this.isRemission;
    }

    public void setIsRemission(String isRemission) {
        this.isRemission = isRemission;
    }
}

