/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.receipt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.egf.commons.EgovCommon;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.receipt.ReceiptVoucher;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EmployeeServiceOld;
import org.springframework.beans.factory.annotation.Autowired;

public class ReceiptService
extends PersistenceService<ReceiptVoucher, Long> {
    @Autowired
    protected EisCommonService eisCommonService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    private EmployeeServiceOld employeeServiceOld;
    private PersistenceService persistenceService;
    @Autowired
    private EgovCommon egovCommon;

    public ReceiptService() {
        super(ReceiptVoucher.class);
    }

    public ReceiptService(Class<ReceiptVoucher> type) {
        super(type);
    }

    public Position getPositionForEmployee(Employee emp) throws ApplicationRuntimeException {
        return this.eisCommonService.getPrimaryAssignmentPositionForEmp(emp.getId());
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void createVoucherfromPreApprovedVoucher(ReceiptVoucher rv) {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
        String approvedVoucherStatus = ((AppConfigValues)appList.get(0)).getValue();
        rv.getVoucherHeader().setStatus(Integer.valueOf(approvedVoucherStatus));
    }

    public void cancelVoucher(ReceiptVoucher rv) {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "cancelledstatus");
        String approvedVoucherStatus = ((AppConfigValues)appList.get(0)).getValue();
        rv.getVoucherHeader().setStatus(Integer.valueOf(approvedVoucherStatus));
    }

    public String getDesginationName() {
        Assignment assignment = this.eisCommonService.getLatestAssignmentForEmployeeByToDate(ApplicationThreadLocals.getUserId(), new Date());
        return assignment.getDesignation().getName();
    }

    public Department getDepartmentForWfItem(ReceiptVoucher rv) {
        Assignment assignment = this.eisCommonService.getLatestAssignmentForEmployeeByToDate(rv.getCreatedBy().getId(), new Date());
        return assignment.getDepartment();
    }

    public Position getPositionForWfItem(ReceiptVoucher rv) {
        return this.eisCommonService.getPositionByUserId(rv.getCreatedBy().getId());
    }

    public Boundary getBoundaryForUser(ReceiptVoucher rv) {
        return this.egovCommon.getBoundaryForUser(rv.getCreatedBy());
    }

    public Department getDepartmentForUser(User user) {
        return this.egovCommon.getDepartmentForUser(user, this.eisCommonService, this.employeeServiceOld, this.persistenceService);
    }

    public void setEmployeeServiceOld(EmployeeServiceOld employeeServiceOld) {
        this.employeeServiceOld = employeeServiceOld;
    }

    public String getReceiptHeaderforDishonor(String mode, Long bankAccId, Long bankId, String chequeDDNo, String chqueDDDate) {
        StringBuilder sb = new StringBuilder(300);
        new ArrayList();
        sb.append("FROM egcl_collectionheader rpt,egcl_collectioninstrument ci,egf_instrumentheader ih,egf_instrumenttype it,egw_status status,bank b,bankbranch bb,bankaccount ba WHERE rpt.id = ci.collectionheader AND ci.instrumentheader = ih.id AND status.id = ih.id_status AND b.id = bb.bankid AND bb.id = ba.branchid AND ba.id = ih.bankaccountid AND ih.instrumenttype = it.id and it.type  = '" + mode + "' AND ((ih.ispaycheque ='0' AND status.moduletype ='Instrument' AND status.description = 'Deposited') OR (ih.ispaycheque = '1' AND status.moduletype = 'Instrument' AND status.description = 'New'))");
        if (bankAccId != null && bankAccId != 0L && bankAccId != -1L) {
            sb.append(" AND ih.bankaccountid=" + bankAccId + "");
        }
        if ((bankAccId == null || bankAccId == 0L) && bankId != null && bankId != 0L) {
            sb.append(" AND ih.bankid=" + bankAccId + "");
        }
        if (!"".equals(chequeDDNo) && chequeDDNo != null) {
            sb.append(" AND ih.instrumentnumber=trim('" + chequeDDNo + "') ");
        }
        if (!"".equals(chqueDDDate) && chqueDDDate != null) {
            sb.append(" AND ih.instrumentdate >= '" + chqueDDDate + "' ");
        }
        return sb.toString();
    }
}

