/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.instrument;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankreconciliation;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.models.ECSType;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.cheque.AccountCheques;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.model.instrument.InstrumentAccountCodes;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentOtherDetails;
import org.egov.model.instrument.InstrumentType;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.services.instrument.BankReconciliationService;
import org.egov.services.instrument.InstrumentAccountCodesService;
import org.egov.services.instrument.InstrumentHeaderService;
import org.egov.services.instrument.InstrumentOtherDetailsService;
import org.egov.services.instrument.InstrumentTypeService;
import org.egov.services.instrument.InstrumentVoucherService;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class InstrumentService {
    public static final String STATUS_ID = "Status id";
    public static final String RECONCILED_AMOUNT = "Reconciled amount";
    public static final String INSTRUMENT_STATUS_DATE = "Instrument status date";
    public static final String PAYIN_SLIP_ID = "Payin slip id";
    public static final String VOUCHER_HEADER = "Voucher header";
    public static final String INSTRUMENT_HEADER = "Instrument header";
    public static final String BRANCH_NAME = "Bank branch name";
    public static final String PAYEE_NAME = "Payee name";
    public static final String PAY_TO = "Pay to";
    public static final String DETAIL_TYPE_ID = "Detail type id";
    public static final String DETAIL_KEY_ID = "Detail key id";
    public static final String BANK_CODE = "Bank code";
    public static final String INSTRUMENT_TYPE = "Instrument type";
    public static final String INSTRUMENT_AMOUNT = "Instrument amount";
    public static final String INSTRUMENT_DATE = "Instrument date";
    public static final String INSTRUMENT_NUMBER = "Instrument number";
    public static final String INSTRUMENT_SERIALNO = "Instrument serialNo";
    public static final String IS_NULL = "is null";
    public static final String IS_PAYCHECK = "Is pay cheque";
    public static final String BANKACCOUNTID = "Bank account id";
    public static final String ECSTYPE = "ECS Type id";
    public static final String TRANSACTION_NUMBER = "Transaction number";
    public static final String TRANSACTION_DATE = "Transaction date";
    private static final Logger LOGGER = Logger.getLogger(InstrumentService.class);
    @Autowired
    @Qualifier(value="instrumentHeaderService")
    private InstrumentHeaderService instrumentHeaderService;
    @Autowired
    @Qualifier(value="instrumentVoucherService")
    private InstrumentVoucherService instrumentVoucherService;
    @Autowired
    @Qualifier(value="instrumentAccountCodesService")
    private InstrumentAccountCodesService instrumentAccountCodesService;
    @Autowired
    @Qualifier(value="instrumentTypeService")
    private InstrumentTypeService instrumentTypeService;
    @Autowired
    @Qualifier(value="instrumentOtherDetailsService")
    private InstrumentOtherDetailsService instrumentOtherDetailsService;
    @Autowired
    @Qualifier(value="bankReconciliationService")
    private BankReconciliationService bankReconciliationService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    @Transactional
    public List<InstrumentHeader> addToInstrument(List<Map<String, Object>> paramList) {
        ArrayList<InstrumentHeader> instrList = new ArrayList<InstrumentHeader>();
        if (paramList != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("length of paramlist " + paramList.size()));
        }
        for (Map<String, Object> instrMap : paramList) {
            InstrumentHeader instrHeader = new InstrumentHeader();
            if (instrMap.get(IS_PAYCHECK) == null) {
                throw new IllegalArgumentException("Is pay chequeis null");
            }
            if (!instrMap.get(IS_PAYCHECK).equals("0") && !instrMap.get(IS_PAYCHECK).equals("1")) {
                throw new ApplicationRuntimeException("value for Is pay chequeshould be either0or 1");
            }
            instrHeader.setIsPayCheque(instrMap.get(IS_PAYCHECK).toString());
            if (instrMap.get(INSTRUMENT_TYPE) == null) {
                throw new IllegalArgumentException("Instrument typeis null");
            }
            InstrumentType instrumentType = this.getInstrumentTypeByType(instrMap.get(INSTRUMENT_TYPE).toString());
            if (instrumentType == null) {
                throw new ApplicationRuntimeException("Instrument type'" + instrMap.get(INSTRUMENT_TYPE).toString() + "' is not defined in the system ");
            }
            instrHeader.setInstrumentType(instrumentType);
            if (instrMap.get(INSTRUMENT_AMOUNT) == null) {
                throw new IllegalArgumentException("Instrument amountis null");
            }
            try {
                instrHeader.setInstrumentAmount(new BigDecimal(instrMap.get(INSTRUMENT_AMOUNT).toString()));
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new ApplicationRuntimeException("Instrument amountis not numeric");
            }
            switch (instrumentType.getType()) {
                case "cheque": {
                    this.validateAndAssignCheque(instrHeader, instrMap);
                    break;
                }
                case "dd": {
                    this.validateAndAssignCheque(instrHeader, instrMap);
                    break;
                }
                case "card": {
                    this.validateAndAssignCard(instrHeader, instrMap);
                    break;
                }
                case "online": {
                    this.validateAndAssignCard(instrHeader, instrMap);
                    break;
                }
                case "atm": {
                    this.validateAndAssingATM(instrHeader, instrMap);
                    break;
                }
                case "advice": {
                    this.validateAndAssingnAdvice(instrHeader, instrMap);
                    break;
                }
                case "bankchallan": {
                    this.validateAndAssingnAdvice(instrHeader, instrMap);
                    break;
                }
                case "cash": {
                    this.validateAndAssignCash(instrHeader, instrMap);
                    break;
                }
                case "banktobank": {
                    this.validateAndAssignCash(instrHeader, instrMap);
                    break;
                }
                case "ecs": {
                    this.validateAndAssignEcs(instrHeader, instrMap);
                }
            }
            instrHeader.setPayee(instrMap.get(PAYEE_NAME) != null ? instrMap.get(PAYEE_NAME).toString() : null);
            instrHeader.setPayTo(instrMap.get(PAY_TO) != null ? instrMap.get(PAY_TO).toString() : null);
            if (instrMap.get(DETAIL_TYPE_ID) != null) {
                Accountdetailtype detailType = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=?", new Object[]{Integer.parseInt(instrMap.get(DETAIL_TYPE_ID).toString())});
                instrHeader.setDetailTypeId(detailType);
            }
            instrHeader.setDetailKeyId(instrMap.get(DETAIL_KEY_ID) != null ? (Long)instrMap.get(DETAIL_KEY_ID) : null);
            instrHeader.setBankBranchName(instrMap.get(BRANCH_NAME) != null ? instrMap.get(BRANCH_NAME).toString() : null);
            EgwStatus status = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=upper('Instrument') and upper(description)=upper('New')");
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Created Status of Instrument" + status.getDescription()));
            }
            instrHeader.setStatusId(status);
            instrHeader.setCreatedDate(new java.util.Date());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("saving instrument details as " + instrHeader.toString()));
            }
            this.instrumentHeaderService.persist((Object)instrHeader);
            InstrumentOtherDetails io = new InstrumentOtherDetails();
            io.setInstrumentHeaderId(instrHeader);
            if (instrHeader.getTransactionDate() != null) {
                io.setInstrumentStatusDate(instrHeader.getTransactionDate());
            } else {
                io.setInstrumentStatusDate(instrHeader.getInstrumentDate());
            }
            this.instrumentOtherDetailsService.persist((Object)io);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Saved " + (Object)((Object)io)));
            }
            instrList.add(instrHeader);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("returning " + instrList.size() + " instruments"));
        }
        return instrList;
    }

    private void validateAndAssignEcs(InstrumentHeader instrHeader, Map<String, Object> instrMap) {
        if (instrMap.get(ECSTYPE) != null) {
            ECSType ecsType = this.getECSType(instrMap.get(ECSTYPE).toString());
            if (ecsType == null) {
                throw new ApplicationRuntimeException("ECS Type id'" + instrMap.get(ECSTYPE).toString() + "' is not defined in the system ");
            }
            instrHeader.setECSType(ecsType);
        }
        if (instrMap.get(TRANSACTION_NUMBER) == null) {
            throw new IllegalArgumentException("Transaction numberis null");
        }
        instrHeader.setTransactionNumber(instrMap.get(TRANSACTION_NUMBER).toString());
        if (instrMap.get(TRANSACTION_DATE) == null) {
            throw new IllegalArgumentException("Transaction dateis null");
        }
        if (new java.util.Date().compareTo((java.util.Date)instrMap.get(TRANSACTION_DATE)) == -1) {
            throw new IllegalArgumentException("Transaction datecannot be future Date");
        }
        instrHeader.setTransactionDate((java.util.Date)instrMap.get(TRANSACTION_DATE));
    }

    private void validateAndAssignCash(InstrumentHeader instrHeader, Map<String, Object> instrMap) {
        if (instrMap.get(BANKACCOUNTID) != null) {
            Bankaccount bankaccount = this.getBankaccount(instrMap.get(BANKACCOUNTID).toString());
            if (bankaccount == null) {
                throw new ApplicationRuntimeException("Bank account id'" + instrMap.get(BANKACCOUNTID).toString() + "' is not defined in the system ");
            }
            instrHeader.setBankAccountId(bankaccount);
        }
        if (instrMap.get(BANK_CODE) != null) {
            Bank bank = this.getBank(instrMap.get(BANK_CODE).toString());
            if (bank == null) {
                throw new ApplicationRuntimeException("Bank code'" + instrMap.get(BANK_CODE).toString() + "' is not defined in the system ");
            }
            instrHeader.setBankId(bank);
        }
        if (instrMap.get(TRANSACTION_NUMBER) != null) {
            instrHeader.setTransactionNumber(instrMap.get(TRANSACTION_NUMBER).toString());
        }
        if (instrMap.get(TRANSACTION_DATE) != null) {
            if (new java.util.Date().compareTo((java.util.Date)instrMap.get(TRANSACTION_DATE)) == -1) {
                throw new IllegalArgumentException("Transaction datecannot be future Date");
            }
            instrHeader.setTransactionDate((java.util.Date)instrMap.get(TRANSACTION_DATE));
        }
    }

    private void validateAndAssingnAdvice(InstrumentHeader instrHeader, Map<String, Object> instrMap) {
        if (instrMap.get(TRANSACTION_NUMBER) == null) {
            throw new IllegalArgumentException("Transaction numberis null");
        }
        instrHeader.setTransactionNumber(instrMap.get(TRANSACTION_NUMBER).toString());
        if (instrMap.get(TRANSACTION_DATE) == null) {
            throw new IllegalArgumentException("Transaction dateis null");
        }
        if (new java.util.Date().compareTo((java.util.Date)instrMap.get(TRANSACTION_DATE)) == -1) {
            throw new IllegalArgumentException("Transaction datecannot be future Date");
        }
        instrHeader.setTransactionDate((java.util.Date)instrMap.get(TRANSACTION_DATE));
        if (instrMap.get(BANKACCOUNTID) == null) {
            throw new IllegalArgumentException("Bank account idis null");
        }
        if (instrMap.get(BANKACCOUNTID) != null) {
            Bankaccount bankaccount = this.getBankaccount(instrMap.get(BANKACCOUNTID).toString());
            if (bankaccount == null) {
                throw new ApplicationRuntimeException("Bank account id'" + instrMap.get(BANKACCOUNTID).toString() + "' is not defined in the system ");
            }
            instrHeader.setBankAccountId(bankaccount);
        }
    }

    private void validateAndAssingATM(InstrumentHeader instrHeader, Map<String, Object> instrMap) {
        if (instrMap.get(TRANSACTION_NUMBER) == null) {
            throw new IllegalArgumentException("Transaction numberis null");
        }
        instrHeader.setTransactionNumber(instrMap.get(TRANSACTION_NUMBER).toString());
        if (instrMap.get(TRANSACTION_DATE) == null) {
            throw new IllegalArgumentException("Transaction dateis null");
        }
        if (new java.util.Date().compareTo((java.util.Date)instrMap.get(TRANSACTION_DATE)) == -1) {
            throw new IllegalArgumentException("Transaction datecannot be future Date");
        }
        instrHeader.setTransactionDate((java.util.Date)instrMap.get(TRANSACTION_DATE));
        if (instrMap.get(BANK_CODE) != null) {
            Bank bank = this.getBank(instrMap.get(BANK_CODE).toString());
            if (bank == null) {
                throw new ApplicationRuntimeException("Bank code'" + instrMap.get(BANK_CODE).toString() + "' is not defined in the system ");
            }
            instrHeader.setBankId(bank);
        }
    }

    private void validateAndAssignCard(InstrumentHeader instrHeader, Map<String, Object> instrMap) {
        if (instrMap.get(TRANSACTION_NUMBER) == null) {
            throw new IllegalArgumentException("Transaction numberis null");
        }
        instrHeader.setTransactionNumber(instrMap.get(TRANSACTION_NUMBER).toString());
        if (instrMap.get(TRANSACTION_DATE) == null) {
            throw new IllegalArgumentException("Transaction dateis null");
        }
        if (new java.util.Date().compareTo((java.util.Date)instrMap.get(TRANSACTION_DATE)) == -1) {
            throw new IllegalArgumentException("Transaction datecannot be future Date");
        }
        instrHeader.setTransactionDate((java.util.Date)instrMap.get(TRANSACTION_DATE));
        if (instrMap.get(INSTRUMENT_NUMBER) != null) {
            instrHeader.setInstrumentNumber((String)instrMap.get(INSTRUMENT_NUMBER));
        }
        if (instrMap.get(BANK_CODE) != null) {
            Bank bank = this.getBank(instrMap.get(BANK_CODE).toString());
            if (bank == null) {
                throw new ApplicationRuntimeException("Bank code'" + instrMap.get(BANK_CODE).toString() + "' is not defined in the system ");
            }
            instrHeader.setBankId(bank);
        }
        if (instrMap.get(BANKACCOUNTID) != null) {
            Bankaccount bankaccount = this.getBankaccount(instrMap.get(BANKACCOUNTID).toString());
            if (bankaccount == null) {
                throw new ApplicationRuntimeException("Bank account id'" + instrMap.get(BANKACCOUNTID).toString() + "' is not defined in the system ");
            }
            instrHeader.setBankAccountId(bankaccount);
        }
    }

    private void validateAndAssignCheque(InstrumentHeader instrHeader, Map<String, Object> instrMap) {
        Bank bank;
        if (instrMap.get(INSTRUMENT_NUMBER) == null) {
            throw new IllegalArgumentException("Instrument numberis null");
        }
        instrHeader.setInstrumentNumber(instrMap.get(INSTRUMENT_NUMBER).toString());
        if (instrMap.get(INSTRUMENT_SERIALNO) == null) {
            instrHeader.setSerialNo(null);
        } else {
            instrHeader.setSerialNo(this.financialYearDAO.findById((Number)Long.valueOf(instrMap.get(INSTRUMENT_SERIALNO).toString()), false));
        }
        if (instrMap.get(INSTRUMENT_DATE) == null) {
            throw new IllegalArgumentException("Instrument dateis null");
        }
        if (new java.util.Date().compareTo((java.util.Date)instrMap.get(INSTRUMENT_DATE)) == -1) {
            throw new IllegalArgumentException("Instrument datecannot be future Date");
        }
        instrHeader.setInstrumentDate((java.util.Date)instrMap.get(INSTRUMENT_DATE));
        if (instrMap.get(BANK_CODE) != null) {
            bank = this.getBank(instrMap.get(BANK_CODE).toString());
            if (bank == null) {
                throw new ApplicationRuntimeException("Bank code'" + instrMap.get(BANK_CODE).toString() + "' is not defined in the system ");
            }
        } else {
            throw new ApplicationRuntimeException("Bank codeis null");
        }
        instrHeader.setBankId(bank);
        if (instrMap.get(BANKACCOUNTID) != null) {
            Bankaccount bankaccount = this.getBankaccount(instrMap.get(BANKACCOUNTID).toString());
            if (bankaccount == null) {
                throw new ApplicationRuntimeException("Bank account id'" + instrMap.get(BANKACCOUNTID).toString() + "' is not defined in the system ");
            }
            instrHeader.setBankAccountId(bankaccount);
        }
    }

    @Transactional
    public List<InstrumentVoucher> updateInstrumentVoucherReference(List<Map<String, Object>> paramList) {
        ArrayList<InstrumentVoucher> iVouherList = new ArrayList<InstrumentVoucher>();
        for (Map<String, Object> iVoucherMap : paramList) {
            InstrumentVoucher iVoucher = new InstrumentVoucher();
            if (iVoucherMap.get(INSTRUMENT_HEADER) == null) {
                throw new ApplicationRuntimeException("Instrument headeris null");
            }
            iVoucher.setInstrumentHeaderId((InstrumentHeader)((Object)iVoucherMap.get(INSTRUMENT_HEADER)));
            if (iVoucherMap.get(VOUCHER_HEADER) == null) {
                throw new ApplicationRuntimeException("Voucher headeris null");
            }
            iVoucher.setVoucherHeaderId((CVoucherHeader)iVoucherMap.get(VOUCHER_HEADER));
            this.instrumentVoucherService.persist((Object)iVoucher);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Saved cheque and voucher Link" + (Object)((Object)iVoucher)));
            }
            if (iVoucher.getInstrumentHeaderId().getIsPayCheque().equals("1") || iVoucher.getInstrumentHeaderId().getIsPayCheque().equals("0") && iVoucher.getInstrumentHeaderId().getInstrumentType().getType().equals("bankchallan")) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Adding to Bank Reconcialation");
                }
                this.addToBankReconcilation(iVoucher.getVoucherHeaderId(), iVoucher.getInstrumentHeaderId());
            }
            iVouherList.add(iVoucher);
        }
        return iVouherList;
    }

    @Transactional
    public List<InstrumentVoucher> modifyInstrumentVoucher(List<Map<String, Object>> paramList) {
        ArrayList<InstrumentVoucher> iVouherList = new ArrayList<InstrumentVoucher>();
        for (Map<String, Object> iVoucherMap : paramList) {
            InstrumentVoucher iVoucher = new InstrumentVoucher();
            if (iVoucherMap.get(INSTRUMENT_HEADER) == null) {
                throw new ApplicationRuntimeException("Instrument headeris null");
            }
            iVoucher.setInstrumentHeaderId((InstrumentHeader)((Object)iVoucherMap.get(INSTRUMENT_HEADER)));
            if (iVoucherMap.get(VOUCHER_HEADER) == null) {
                throw new ApplicationRuntimeException("Voucher headeris null");
            }
            iVoucher.setVoucherHeaderId((CVoucherHeader)iVoucherMap.get(VOUCHER_HEADER));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("before Modification by modifyInstrumentVoucher: " + (Object)((Object)iVoucher)));
            }
            this.instrumentVoucherService.update((Object)iVoucher);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("After Modification by modifyInstrumentVoucher: " + (Object)((Object)iVoucher)));
            }
            iVouherList.add(iVoucher);
        }
        return iVouherList;
    }

    @Transactional
    public Bankreconciliation addToBankReconcilation(CVoucherHeader vouherHeader, InstrumentHeader instrumentHeader) throws ApplicationRuntimeException {
        EgwStatus instrumentReconciledStatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=upper('Instrument') and upper(description)=upper(?)", new Object[]{"Reconciled"});
        return this.addToBankReconcilationWithLoop(vouherHeader, instrumentHeader, instrumentReconciledStatus);
    }

    @Transactional
    public Bankreconciliation addToBankReconcilationWithLoop(CVoucherHeader vouherHeader, InstrumentHeader instrumentHeader, EgwStatus instrumentReconciledStatus) throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"addToBankReconcilation | Start");
        }
        if (vouherHeader == null) {
            throw new IllegalArgumentException("voucherHeaderis null");
        }
        if (instrumentHeader == null) {
            throw new IllegalArgumentException("instrumentHeaderis null");
        }
        Bankreconciliation bankreconciliation = new Bankreconciliation();
        InstrumentOtherDetails iOtherdetails = (InstrumentOtherDetails)((Object)this.instrumentOtherDetailsService.find("from InstrumentOtherDetails where instrumentHeaderId=?", new Object[]{instrumentHeader}));
        if (iOtherdetails == null) {
            iOtherdetails = new InstrumentOtherDetails();
        }
        if (instrumentHeader.getInstrumentType().getType().equalsIgnoreCase("bankchallan")) {
            iOtherdetails.setReconciledAmount(instrumentHeader.getInstrumentAmount());
            iOtherdetails.setInstrumentStatusDate(instrumentHeader.getInstrumentDate());
            instrumentHeader.setStatusId(instrumentReconciledStatus);
        } else if (instrumentHeader.getInstrumentType().getType().equalsIgnoreCase("banktobank")) {
            iOtherdetails.setReconciledAmount(instrumentHeader.getInstrumentAmount());
            iOtherdetails.setInstrumentStatusDate(instrumentHeader.getInstrumentDate());
            instrumentHeader.setStatusId(instrumentReconciledStatus);
        } else {
            bankreconciliation.setBankaccount(instrumentHeader.getBankAccountId());
            iOtherdetails.setInstrumentStatusDate(instrumentHeader.getInstrumentDate());
        }
        if (instrumentHeader.getIsPayCheque() == null) {
            throw new ApplicationRuntimeException("Is pay chequeis null in Instrument Header cannot update Transactiontype in BankReconciliation ");
        }
        if (instrumentHeader.getIsPayCheque().equals("1")) {
            bankreconciliation.setTransactiontype("Cr");
        } else if (instrumentHeader.getIsPayCheque().equals("0")) {
            bankreconciliation.setTransactiontype("Dr");
        }
        bankreconciliation.setInstrumentHeaderId(instrumentHeader.getId());
        bankreconciliation.setAmount(instrumentHeader.getInstrumentAmount());
        this.instrumentOtherDetailsService.persist((Object)iOtherdetails);
        this.bankReconciliationService.persist(bankreconciliation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"addToBankReconcilation | End");
        }
        return bankreconciliation;
    }

    @Transactional
    public List<InstrumentOtherDetails> updateInstrumentOtherDetails(List<Map<String, Object>> paramList) throws ApplicationRuntimeException {
        InstrumentHeader iHeader = null;
        InstrumentOtherDetails iOtherDetails = null;
        ArrayList<InstrumentOtherDetails> iOtherDetailsList = new ArrayList<InstrumentOtherDetails>();
        for (Map<String, Object> iOtherDetailsMap : paramList) {
            if (iOtherDetailsMap.get(INSTRUMENT_HEADER) == null) {
                throw new ApplicationRuntimeException("Instrument headeris null");
            }
            iHeader = (InstrumentHeader)((Object)iOtherDetailsMap.get(INSTRUMENT_HEADER));
            iOtherDetails = (InstrumentOtherDetails)((Object)this.instrumentOtherDetailsService.find("from InstrumentOtherDetails where instrumentHeaderId=?", new Object[]{iHeader}));
            if (iOtherDetails == null) {
                iOtherDetails = new InstrumentOtherDetails();
                iOtherDetails.setInstrumentHeaderId(iHeader);
            }
            if (iOtherDetailsMap.get(PAYIN_SLIP_ID) == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"PayinSlip Id is null");
                }
            } else {
                iOtherDetails.setPayinslipId((CVoucherHeader)iOtherDetailsMap.get(PAYIN_SLIP_ID));
            }
            if (iOtherDetailsMap.get(INSTRUMENT_STATUS_DATE) != null) {
                new Date(((java.util.Date)iOtherDetailsMap.get(INSTRUMENT_STATUS_DATE)).getTime());
                iOtherDetails.setInstrumentStatusDate(new Date(((java.util.Date)iOtherDetailsMap.get(INSTRUMENT_STATUS_DATE)).getTime()));
            }
            if (iOtherDetailsMap.get(RECONCILED_AMOUNT) != null) {
                iOtherDetails.setReconciledAmount((BigDecimal)iOtherDetailsMap.get(RECONCILED_AMOUNT));
            }
            if (iOtherDetailsMap.get(STATUS_ID) == null) {
                throw new ApplicationRuntimeException("Required Object Status is not Found in the Map ");
            }
            iHeader.setStatusId((EgwStatus)iOtherDetailsMap.get(STATUS_ID));
            if (iOtherDetailsMap.get(TRANSACTION_NUMBER) != null) {
                iHeader.setTransactionNumber((String)iOtherDetailsMap.get(TRANSACTION_NUMBER));
            }
            if (iOtherDetailsMap.get(TRANSACTION_DATE) != null) {
                iHeader.setTransactionDate((java.util.Date)iOtherDetailsMap.get(TRANSACTION_DATE));
            }
            if (iOtherDetailsMap.get(BANKACCOUNTID) != null) {
                iHeader.setBankAccountId((Bankaccount)iOtherDetailsMap.get(BANKACCOUNTID));
            }
            this.instrumentOtherDetailsService.persist((Object)iOtherDetails);
            this.instrumentHeaderService.persist((Object)iHeader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("updated  otherdetails as " + (Object)((Object)iOtherDetails)));
            }
            iOtherDetailsList.add(iOtherDetails);
        }
        return iOtherDetailsList;
    }

    @Transactional
    public boolean cancelInstrument(InstrumentHeader ih) throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Cancelling " + (Object)((Object)ih)));
        }
        boolean result = false;
        try {
            String cancelStatusQuiery = "from EgwStatus where upper(moduletype)=upper('instrument') and  upper(description)=upper('Cancelled')";
            EgwStatus cancelStatus = (EgwStatus)this.persistenceService.find("from EgwStatus where upper(moduletype)=upper('instrument') and  upper(description)=upper('Cancelled')");
            ih.setStatusId(cancelStatus);
            this.instrumentHeaderService.update((Object)ih);
            result = true;
        }
        catch (HibernateException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return result;
    }

    private Bank getBank(String bankCode) {
        return (Bank)this.persistenceService.find("from Bank where code=?", new Object[]{bankCode});
    }

    private Bankaccount getBankaccount(String bankAccountId) {
        return (Bankaccount)this.persistenceService.find("from Bankaccount where id=?", new Object[]{Long.valueOf(bankAccountId)});
    }

    private ECSType getECSType(String ecsTypeId) {
        return (ECSType)this.persistenceService.find("from ECSType where id=?", new Object[]{Long.valueOf(ecsTypeId)});
    }

    public List<InstrumentVoucher> getReconciledCheques(java.util.Date reconcilationFromDate, java.util.Date reconcilationToDate) throws ApplicationRuntimeException {
        if (reconcilationFromDate == null || reconcilationToDate == null) {
            throw new ApplicationRuntimeException("reconcilationFromDate and reconcilationToDate should not be null");
        }
        Query qry = this.persistenceService.getSession().createQuery("select iv from InstrumentVoucher iv inner join iv.instrumentHeaderId as  ih   where ih.statusId.description=:status and ih in (select iih from InstrumentOtherDetails io inner join io.instrumentHeaderId as iih where io.instrumentStatusDate>=:startDate and io.instrumentStatusDate<=:endDate )");
        qry.setString("status", "Reconciled");
        qry.setDate("startDate", reconcilationFromDate);
        qry.setDate("endDate", reconcilationToDate);
        return qry.list();
    }

    public List<InstrumentVoucher> getBouncedCheques(java.util.Date dishonoredFromDate, java.util.Date dishonoredToDate) throws ApplicationRuntimeException {
        if (dishonoredFromDate == null || dishonoredToDate == null) {
            throw new ApplicationRuntimeException("dishonoredFromDate and dishonoredToDate should not be null");
        }
        Query qry = this.persistenceService.getSession().createQuery("select iv from InstrumentVoucher iv inner join iv.instrumentHeaderId as  ih   where ih.statusId.description=:status and ih in (select iih from InstrumentOtherDetails io inner join io.instrumentHeaderId as iih where io.modifiedDate>=:startDate and io.modifiedDate<=:endDate ) order by iv.instrumentHeaderId desc");
        qry.setString("status", "Dishonored");
        qry.setDate("startDate", dishonoredFromDate);
        qry.setDate("endDate", dishonoredToDate);
        return qry.list();
    }

    public InstrumentType getInstrumentTypeById(Long id) throws ApplicationRuntimeException {
        InstrumentType iType = null;
        if (id == null) {
            throw new ApplicationRuntimeException("Instrument type id is null");
        }
        iType = (InstrumentType)((Object)this.instrumentTypeService.findById(id, false));
        return iType;
    }

    public InstrumentType getInstrumentTypeByType(String type) throws ApplicationRuntimeException {
        InstrumentType iType = null;
        if (type == null) {
            throw new ApplicationRuntimeException("Instrument typeis null");
        }
        if (type.isEmpty()) {
            throw new ApplicationRuntimeException("Instrument typeis empty");
        }
        String qry = "";
        try {
            qry = "from InstrumentType  where type=? and isActive=true";
            iType = (InstrumentType)((Object)this.instrumentTypeService.find(qry, new Object[]{type}));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while getting InstrumentType from database" + e.getMessage()), (Throwable)e);
        }
        return iType;
    }

    public EgwStatus getStatusId(String statusString) {
        String statusQury = "from EgwStatus where upper(moduletype)=upper('instrument') and  upper(description)=upper('" + statusString + "')";
        EgwStatus egwStatus = (EgwStatus)this.persistenceService.find(statusQury);
        return egwStatus;
    }

    public InstrumentHeader getInstrumentHeader(Long bankaccountId, String instrumentNo, String payTo) {
        return (InstrumentHeader)((Object)this.instrumentHeaderService.find(" from InstrumentHeader where bankAccountId.id=? and instrumentNumber=? and payTo=? ", new Object[]{bankaccountId, instrumentNo, payTo}));
    }

    public InstrumentHeader getInstrumentHeader(Long bankaccountId, String instrumentNo, String payTo, String serialNo) {
        return (InstrumentHeader)((Object)this.instrumentHeaderService.find(" from InstrumentHeader where bankAccountId.id=? and instrumentNumber=? and payTo=? and serialNo.id=? ", new Object[]{bankaccountId, instrumentNo, payTo, Long.valueOf(serialNo)}));
    }

    public InstrumentHeader getInstrumentHeaderById(Long id) {
        return (InstrumentHeader)((Object)this.instrumentHeaderService.find(" from InstrumentHeader where id=?", new Object[]{id}));
    }

    @Transactional
    public InstrumentType createInstrumentType(InstrumentType iType) {
        this.instrumentTypeService.persist((Object)iType);
        return iType;
    }

    @Transactional
    public InstrumentAccountCodes createInstrumentAccountCodes(InstrumentAccountCodes iAccCodes) {
        this.instrumentAccountCodesService.persist((Object)iAccCodes);
        return iAccCodes;
    }

    public boolean isChequeNumberWithinRange(String chequeNumber, Long bankAccountId, Integer departmentId, String serialNo) {
        AccountCheques accountCheques = new AccountCheques();
        accountCheques = serialNo != null ? (AccountCheques)((Object)this.persistenceService.find("select ac from AccountCheques ac, ChequeDeptMapping cd where ac.id = cd.accountCheque.id and  ac.bankAccountId.id=? and cd.allotedTo.id=? and ? between ac.fromChequeNumber and ac.toChequeNumber and ac.serialNo=? ", new Object[]{bankAccountId, departmentId.longValue(), chequeNumber, Long.valueOf(serialNo)})) : (AccountCheques)((Object)this.persistenceService.find("select ac from AccountCheques ac, ChequeDeptMapping cd where ac.id = cd.accountCheque.id and  ac.bankAccountId.id=? and cd.allotedTo.id=? and ? between ac.fromChequeNumber and ac.toChequeNumber ", new Object[]{bankAccountId, departmentId.longValue(), chequeNumber}));
        return accountCheques != null;
    }

    public boolean isChequeNumberUnique(String chequeNumber, Long bankAccountId, String serialNo) {
        InstrumentType instrumentType = this.getInstrumentTypeByType("cheque");
        List list = new ArrayList();
        list = serialNo != null ? this.instrumentHeaderService.findAllBy("from InstrumentHeader where instrumentNumber=? and instrumentType.id=? and bankAccountId.id=? and isPayCheque='1' and serialNo.id=?", new Object[]{chequeNumber, instrumentType.getId(), bankAccountId, Long.valueOf(serialNo)}) : this.instrumentHeaderService.findAllBy("from InstrumentHeader where instrumentNumber=? and instrumentType.id=? and bankAccountId.id=? and isPayCheque='1' ", new Object[]{chequeNumber, instrumentType.getId(), bankAccountId});
        return list == null || list.size() <= 0;
    }

    public boolean isRtgsNumberUnique(String chequeNumber, Long bankAccountId) {
        InstrumentType instrumentType = this.getInstrumentTypeByType("advice");
        List list = this.instrumentHeaderService.findAllBy("from InstrumentHeader where transactionNumber=? and instrumentType.id=? and bankAccountId.id=? and isPayCheque=1 ", new Object[]{chequeNumber, instrumentType.getId(), bankAccountId});
        return list == null || list.size() <= 0;
    }

    public boolean isChequeIsSurrenderdForReassign(String chequeNumber, Long bankAccountId, String serialNo) {
        InstrumentType instrumentType = this.getInstrumentTypeByType("cheque");
        List list = this.instrumentHeaderService.findAllBy("from InstrumentHeader where instrumentNumber=? and instrumentType.id=? and bankAccountId.id=? and statusId in (?) and serialNo.id=?", new Object[]{chequeNumber, instrumentType.getId(), bankAccountId, this.getStatusId("Surrender_For_Reassign"), Long.valueOf(serialNo)});
        return list != null && list.size() > 0;
    }

    public boolean isChequeNumberValid(String chequeNumber, Long bankAccountId, Integer departmentId, String serialNo) {
        if (!this.isChequeNumberWithinRange(chequeNumber, bankAccountId, departmentId, serialNo)) {
            return false;
        }
        return this.isChequeNumberUnique(chequeNumber, bankAccountId, serialNo);
    }

    public boolean isRtgsNumberValid(String chequeNumber, Long bankAccountId) {
        return this.isRtgsNumberUnique(chequeNumber, bankAccountId);
    }

    public void unDeposit(Long payinslipId) {
        InstrumentOtherDetails iOtherdetails = (InstrumentOtherDetails)((Object)this.instrumentOtherDetailsService.find("from InstrumentOtherDetails  io where payinslipId.id=?", new Object[]{payinslipId}));
        InstrumentHeader iHeader = iOtherdetails.getInstrumentHeaderId();
        iHeader.setStatusId(this.getStatusId("New"));
        this.instrumentHeaderService.persist((Object)iHeader);
        iOtherdetails.setPayinslipId(null);
        this.instrumentOtherDetailsService.persist((Object)iOtherdetails);
    }

    @Transactional
    public void surrenderCheques(List<InstrumentHeader> suurenderChequelist) {
        for (InstrumentHeader instrumentHeader : suurenderChequelist) {
            String reason = instrumentHeader.getSurrendarReason();
            if (reason != null) {
                if (reason.indexOf(124) != -1) {
                    if (reason.substring(reason.indexOf(124) + 1, reason.length()).equalsIgnoreCase("Y")) {
                        instrumentHeader.setStatusId(this.getStatusId("Surrender_For_Reassign"));
                        instrumentHeader.setSurrendarReason(reason.substring(0, reason.indexOf(124)));
                    } else {
                        instrumentHeader.setSurrendarReason(reason.substring(0, reason.indexOf(124)));
                        instrumentHeader.setStatusId(this.getStatusId("Surrendered"));
                    }
                } else {
                    instrumentHeader.setStatusId(this.getStatusId("Surrendered"));
                }
            } else {
                instrumentHeader.setStatusId(this.getStatusId("Surrendered"));
            }
            InstrumentOtherDetails instrumentOtherDetails = (InstrumentOtherDetails)((Object)this.instrumentOtherDetailsService.find("from InstrumentOtherDetails where instrumentHeaderId=?", new Object[]{instrumentHeader}));
            if (instrumentOtherDetails != null) {
                instrumentOtherDetails.setInstrumentStatusDate(new java.util.Date());
            } else {
                instrumentOtherDetails = new InstrumentOtherDetails();
                instrumentOtherDetails.setInstrumentHeaderId(instrumentHeader);
                instrumentOtherDetails.setInstrumentStatusDate(new java.util.Date());
            }
            this.instrumentHeaderService.persist((Object)instrumentHeader);
            this.instrumentOtherDetailsService.persist((Object)instrumentOtherDetails);
        }
    }

    @Transactional
    public void updateInstrumentOtherDetailsStatus(InstrumentHeader instrumentHeader, java.util.Date statusDate, BigDecimal reconciledAmount) {
        InstrumentOtherDetails instrumentOtherDetails = (InstrumentOtherDetails)((Object)this.instrumentOtherDetailsService.find("from InstrumentOtherDetails where instrumentHeaderId.id=?", new Object[]{instrumentHeader.getId()}));
        instrumentOtherDetails.setInstrumentStatusDate(statusDate);
        instrumentOtherDetails.setReconciledAmount(reconciledAmount);
        this.instrumentOtherDetailsService.persist((Object)instrumentOtherDetails);
    }

    @Transactional
    public void editInstruments(InstrumentOtherDetails instrumentOtherDetails) {
        InstrumentHeader instrumentHeader = instrumentOtherDetails.getInstrumentHeaderId();
        instrumentHeader.setStatusId(this.getStatusId("New"));
        this.instrumentHeaderService.update((Object)instrumentHeader);
        this.instrumentOtherDetailsService.delete((Object)instrumentOtherDetails);
        Bankreconciliation bankreconciliation = (Bankreconciliation)this.persistenceService.find("from Bankreconciliation where instrumentHeaderId=?", new Object[]{instrumentHeader.getId()});
        this.bankReconciliationService.delete(bankreconciliation);
        ContraJournalVoucher contraJournalVoucher = (ContraJournalVoucher)((Object)this.persistenceService.find("from ContraJournalVoucher where instrumentHeaderId=?", new Object[]{instrumentHeader}));
        this.persistenceService.delete((Object)contraJournalVoucher);
    }

    public boolean isReassigningChequeNumberValid(String chequeNumber, Long bankAccountId, Integer departmentId, String serialNo) {
        if (!this.isChequeNumberWithinRange(chequeNumber, bankAccountId, departmentId, serialNo)) {
            return false;
        }
        return this.isChequeIsSurrenderdForReassign(chequeNumber, bankAccountId, serialNo);
    }
}

