/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.financingsource;

import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.Fundsource;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class FinancingSourceService
extends PersistenceService<Fundsource, Integer> {
    private static final Logger LOGGER = Logger.getLogger(FinancingSourceService.class);

    public FinancingSourceService() {
        super(Fundsource.class);
    }

    public FinancingSourceService(Class<Fundsource> type) {
        super(type);
    }

    public List<Fundsource> getFinancialSourceBasedOnSubScheme(Integer subSchemeId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"FinancingSourceService | getFinancialSourceBasedOnSubScheme | Start ");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Received sub scheme id = " + subSchemeId));
        }
        Criteria criteria = this.getSession().createCriteria(Fundsource.class);
        criteria.add((Criterion)Restrictions.eq((String)"isactive", (Object)true));
        if (!subSchemeId.equals(-1)) {
            Criterion subschmeNull = Restrictions.isNull((String)"subSchemeId");
            SimpleExpression subschme = Restrictions.eq((String)"subSchemeId.id", (Object)subSchemeId);
            LogicalExpression orExp = Restrictions.or((Criterion)subschme, (Criterion)subschmeNull);
            criteria.add((Criterion)orExp);
            criteria.addOrder(Order.asc((String)"name"));
        }
        List listFundSource = criteria.list();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("financial source list size = " + listFundSource.size()));
        }
        return listFundSource;
    }

    public List<Fundsource> getListOfSharedFinancialSource() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"FinancingSourceService | getListOfSharedFinancialSource | Start ");
        }
        Criteria criteria = this.getSession().createCriteria(Fundsource.class);
        criteria.add((Criterion)Restrictions.eq((String)"isactive", (Object)true));
        criteria.add(Restrictions.isNull((String)"subSchemeId"));
        criteria.addOrder(Order.asc((String)"name"));
        List listFundSource = criteria.list();
        return listFundSource;
    }
}

