/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.cheque;

import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.commons.Bankaccount;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.cheque.AccountCheques;
import org.egov.model.cheque.ChequeDeptMapping;
import org.egov.model.masters.ChequeDetail;
import org.egov.services.cheque.ChequeDeptMappingService;
import org.egov.utils.Constants;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class AccountChequesService
extends PersistenceService<AccountCheques, Long> {
    private static final Logger LOGGER = Logger.getLogger(AccountChequesService.class);
    @Autowired
    @Qualifier(value="chequeDeptMappingService")
    private ChequeDeptMappingService chequeDeptMappingService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;

    public AccountChequesService() {
        super(AccountCheques.class);
    }

    public AccountChequesService(Class<AccountCheques> type) {
        super(type);
    }

    @Transactional
    public void createCheques(List<ChequeDetail> chequeDetailsList, Map<String, String> chequeIdMap, Map<String, AccountCheques> chequeMap, Bankaccount bankaccount, String deletedChqDeptId) {
        Session session = this.getSession();
        for (ChequeDetail chequeDetail : chequeDetailsList) {
            AccountCheques accountCheques;
            if (!chequeDetail.getNextChqPresent().equalsIgnoreCase("No") || !chequeDetail.getIsExhusted().equalsIgnoreCase("No")) continue;
            if (chequeDetail.getAccountChequeId() != null && null == chequeIdMap.get(chequeDetail.getAccountChequeId().toString())) {
                session.createQuery("delete from ChequeDeptMapping where accountCheque.id=" + chequeDetail.getAccountChequeId()).executeUpdate();
                session.createQuery("delete from AccountCheques where id=" + chequeDetail.getAccountChequeId()).executeUpdate();
                chequeIdMap.put(chequeDetail.getAccountChequeId().toString(), chequeDetail.getAccountChequeId().toString());
            }
            if (null == chequeMap.get(chequeDetail.getFromChqNo() + chequeDetail.getToChqNo() + chequeDetail.getSerialNo())) {
                accountCheques = new AccountCheques();
                accountCheques.setBankAccountId(bankaccount);
                accountCheques.setFromChequeNumber(chequeDetail.getFromChqNo());
                accountCheques.setToChequeNumber(chequeDetail.getToChqNo());
                accountCheques.setSerialNo(Long.valueOf(chequeDetail.getSerialNo()));
                try {
                    accountCheques.setReceivedDate(Constants.DDMMYYYYFORMAT2.parse(chequeDetail.getReceivedDate()));
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("ERROR" + e.getMessage()), (Throwable)e);
                }
                this.persist((Object)accountCheques);
                chequeMap.put(accountCheques.getFromChequeNumber() + accountCheques.getToChequeNumber() + accountCheques.getSerialNo(), accountCheques);
            } else {
                accountCheques = chequeMap.get(chequeDetail.getFromChqNo() + chequeDetail.getToChqNo() + chequeDetail.getSerialNo());
            }
            ChequeDeptMapping chqDept = new ChequeDeptMapping();
            chqDept.setAccountCheque(accountCheques);
            Department dept = (Department)this.persistenceService.find("from Department where id=" + chequeDetail.getDeptId());
            chqDept.setAllotedTo(dept);
            this.chequeDeptMappingService.persist(chqDept);
        }
    }

    @Transactional
    public void deleteRecords(String deletedChqDeptId, Bankaccount bankaccount) {
        Session session = this.getSession();
        if (null != deletedChqDeptId && !deletedChqDeptId.equalsIgnoreCase("")) {
            Query qry = session.createQuery("delete from ChequeDeptMapping where id in (" + deletedChqDeptId + ")");
            qry.executeUpdate();
        }
        StringBuffer accChqDelquery = new StringBuffer();
        accChqDelquery.append("delete from AccountCheques where id in ( select id from AccountCheques where id not in").append("( select ac.id from AccountCheques ac,ChequeDeptMapping cd where ac.id=cd.accountCheque.id ").append(" and ac.bankAccountId.id=:bankAccId) and bankAccountId.id=:bankAccId)");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("AccountChequeAction | save | accChqDelquery " + accChqDelquery.toString()));
        }
        Query delqry = session.createQuery(accChqDelquery.toString());
        delqry.setLong("bankAccId", bankaccount.getId().longValue());
        delqry.executeUpdate();
    }

    public List<ChequeDeptMapping> getChequeListByBankAccId(Long bankAccountId) {
        return this.persistenceService.findAllBy("from ChequeDeptMapping where accountCheque.bankAccountId.id =?", new Object[]{bankAccountId});
    }
}

