/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.egov.model.contra.TransactionSummary;
import org.egov.model.repository.TransactionSummaryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TransactionSummaryService {
    private final TransactionSummaryRepository transactionSummaryRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public TransactionSummaryService(TransactionSummaryRepository transactionSummaryRepository) {
        this.transactionSummaryRepository = transactionSummaryRepository;
    }

    @Transactional
    public TransactionSummary create(TransactionSummary transactionSummary) {
        return (TransactionSummary)((Object)this.transactionSummaryRepository.save((Object)transactionSummary));
    }

    @Transactional
    public TransactionSummary update(TransactionSummary transactionSummary) {
        return (TransactionSummary)((Object)this.transactionSummaryRepository.save((Object)transactionSummary));
    }

    public List<TransactionSummary> findAll() {
        return this.transactionSummaryRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public TransactionSummary findOne(Long id) {
        return (TransactionSummary)((Object)this.transactionSummaryRepository.findOne(id));
    }

    @Transactional
    public void delete(TransactionSummary transactionSummary) {
        this.transactionSummaryRepository.delete((Object)transactionSummary);
    }

    public List<TransactionSummary> searchTransactionsForNonSubledger(Long finYear, Long fund, Long functn, Long department, Long glcodeId) {
        TypedQuery query = this.entityManager.createQuery("select ts from TransactionSummary ts where ts.financialyear.id=:finYear and ts.fund.id=:fund and ts.functionid.id=:functn and ts.departmentid.id=:department and ts.glcodeid.id=:glcodeId and ts.glcodeid.id not in (select glCodeId.id from CChartOfAccountDetail ) ", TransactionSummary.class);
        query.setParameter("finYear", (Object)finYear);
        query.setParameter("fund", (Object)fund.intValue());
        query.setParameter("functn", (Object)functn);
        query.setParameter("department", (Object)department);
        query.setParameter("glcodeId", (Object)glcodeId);
        return query.getResultList();
    }

    public List<TransactionSummary> searchTransactionsForSubledger(Long finYear, Long fund, Long functn, Long department, Long glcodeId, Integer accountDetailTypeId, Integer accountDetailKeyId) {
        TypedQuery query = this.entityManager.createQuery("select ts from TransactionSummary ts where ts.financialyear.id=:finYear and ts.fund.id=:fund and ts.functionid.id=:functn and ts.departmentid.id=:department and ts.glcodeid.id=:glcodeId and ts.accountdetailkey=:accountDetailKeyId and ts.accountdetailtype.id =:accountDetailTypeId ", TransactionSummary.class);
        query.setParameter("finYear", (Object)finYear);
        query.setParameter("fund", (Object)fund.intValue());
        query.setParameter("functn", (Object)functn);
        query.setParameter("department", (Object)department);
        query.setParameter("glcodeId", (Object)glcodeId);
        query.setParameter("accountDetailKeyId", (Object)accountDetailKeyId);
        query.setParameter("accountDetailTypeId", (Object)accountDetailTypeId);
        return query.getResultList();
    }

    public TransactionSummary getTransactionSummary(Long glcodeId, Long accountDetailTypeId, Integer accountDetailKey) {
        TypedQuery query = this.entityManager.createQuery("from TransactionSummary where glcodeid.id=:glcodeid and accountdetailtype.id=:accountdetailtype and accountdetailkey=:accountdetailkey", TransactionSummary.class);
        query.setParameter("glcodeid", (Object)glcodeId);
        query.setParameter("accountdetailtype", (Object)accountDetailTypeId.intValue());
        query.setParameter("accountdetailkey", (Object)accountDetailKey);
        List summaries = query.getResultList();
        if (!summaries.isEmpty()) {
            return (TransactionSummary)((Object)summaries.get(0));
        }
        return null;
    }
}

