/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.utils;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FinancialUtils {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusByModuleAndCode(String moduleType, String code) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode(moduleType, code);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<EgwStatus> getStatusByModule(String moduleType) {
        return this.egwStatusHibernateDAO.getStatusByModule(moduleType);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusById(Integer id) {
        return this.egwStatusHibernateDAO.findById(id, true);
    }
}

