/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.expensebill.service;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.egf.billsubtype.service.EgBillSubTypeService;
import org.egov.egf.expensebill.repository.ExpenseBillRepository;
import org.egov.egf.utils.FinancialUtils;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ExpenseBillService {
    @PersistenceContext
    private EntityManager entityManager;
    private final ExpenseBillRepository expenseBillRepository;
    @Autowired
    private EgBillSubTypeService egBillSubTypeService;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private SubSchemeService subSchemeService;
    @Autowired
    private FinancialUtils financialUtils;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public ExpenseBillService(ExpenseBillRepository expenseBillRepository) {
        this.expenseBillRepository = expenseBillRepository;
    }

    public EgBillregister getById(Long id) {
        return (EgBillregister)this.expenseBillRepository.findOne(id);
    }

    @Transactional
    public EgBillregister create(EgBillregister egBillregister) {
        egBillregister.setBilltype("Final Bill");
        egBillregister.setExpendituretype("Expense");
        egBillregister.setPassedamount(egBillregister.getBillamount());
        egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("EXPENSEBILL", "CREATED"));
        egBillregister.getEgBillregistermis().setEgBillregister(egBillregister);
        egBillregister.getEgBillregistermis().setLastupdatedtime(new Date());
        if (egBillregister.getEgBillregistermis().getEgBillSubType() != null && egBillregister.getEgBillregistermis().getEgBillSubType().getId() != null) {
            egBillregister.getEgBillregistermis().setEgBillSubType(this.egBillSubTypeService.getById(egBillregister.getEgBillregistermis().getEgBillSubType().getId()));
        }
        if (egBillregister.getEgBillregistermis().getScheme() != null && egBillregister.getEgBillregistermis().getScheme().getId() != null) {
            egBillregister.getEgBillregistermis().setScheme((Scheme)this.schemeService.findById(egBillregister.getEgBillregistermis().getScheme().getId(), false));
        } else {
            egBillregister.getEgBillregistermis().setScheme(null);
        }
        if (egBillregister.getEgBillregistermis().getSubScheme() != null && egBillregister.getEgBillregistermis().getSubScheme().getId() != null) {
            egBillregister.getEgBillregistermis().setSubScheme((SubScheme)this.subSchemeService.findById(egBillregister.getEgBillregistermis().getSubScheme().getId(), false));
        } else {
            egBillregister.getEgBillregistermis().setSubScheme(null);
        }
        this.populateBillDetails(egBillregister);
        return (EgBillregister)this.expenseBillRepository.save(egBillregister);
    }

    private void populateBillDetails(EgBillregister egBillregister) {
        egBillregister.getEgBilldetailes().addAll(egBillregister.getBillDetails());
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            details.setEgBillregister(egBillregister);
            details.setLastupdatedtime(new Date());
        }
        if (!egBillregister.getBillPayeedetails().isEmpty()) {
            this.populateBillPayeeDetails(egBillregister);
        }
    }

    private void populateBillPayeeDetails(EgBillregister egBillregister) {
        EgBillPayeedetails payeeDetail = null;
        for (EgBilldetails details : egBillregister.getEgBilldetailes()) {
            for (EgBillPayeedetails payeeDetails : egBillregister.getBillPayeedetails()) {
                if (!details.getGlcodeid().equals(payeeDetails.getEgBilldetailsId().getGlcodeid())) continue;
                payeeDetail = new EgBillPayeedetails();
                payeeDetail.setEgBilldetailsId(details);
                payeeDetail.setAccountDetailTypeId(payeeDetails.getAccountDetailTypeId());
                payeeDetail.setAccountDetailKeyId(payeeDetails.getAccountDetailKeyId());
                payeeDetail.setDebitAmount(payeeDetails.getDebitAmount());
                payeeDetail.setCreditAmount(payeeDetails.getCreditAmount());
                payeeDetail.setLastUpdatedTime(new Date());
                details.getEgBillPaydetailes().add(payeeDetail);
            }
        }
    }

    @Transactional
    public EgBillregister update(EgBillregister egBillregister) {
        return (EgBillregister)this.expenseBillRepository.save(egBillregister);
    }
}

