/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.pagemanager;

import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.ExilServiceInterface;
import com.exilant.exility.common.XMLGenerator;
import com.exilant.exility.service.DataService;
import com.exilant.exility.service.DescriptionService;
import com.exilant.exility.service.ListService;
import com.exilant.exility.service.TreeService;
import com.exilant.exility.service.UpdateService;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ServiceAgent {
    private static final Logger LOGGER = Logger.getLogger(ServiceAgent.class);
    private static ServiceAgent agent;
    private HashMap services;

    public static ServiceAgent getAgent() {
        if (agent == null) {
            agent = new ServiceAgent();
            agent.getInitialHashMap();
        }
        return agent;
    }

    private ServiceAgent() {
    }

    public void deliverService(String serviceName, DataCollection dc) {
        Object service = this.services.get(serviceName);
        if (service == null) {
            dc.addMessage("exilNoServiceName", serviceName);
        } else {
            try {
                ((ExilServiceInterface)service).doService(dc);
            }
            catch (Exception e) {
                LOGGER.error((Object)("exilServerError" + e.getMessage()));
                dc.addMessage("exilServerError", e.getMessage());
            }
        }
    }

    private void getInitialHashMap() {
        HashMap<String, ExilServiceInterface> classes = new HashMap<String, ExilServiceInterface>();
        classes.put("DataService", DataService.getService());
        classes.put("UpdateService", UpdateService.getService());
        classes.put("DescriptionService", DescriptionService.getService());
        classes.put("ListService", ListService.getService());
        classes.put("TreeService", TreeService.getService());
        this.services = classes;
    }

    public static void main(String[] args) {
        DataCollection dc = new DataCollection();
        dc.addValue("serviceID", "getCustomerData");
        dc.addValue("nameStartingWith", "startOfName");
        dc.addValue("codeFrom", "codeStart");
        dc.addValue("codeTo", "codeEnd");
        ServiceAgent anAgent = ServiceAgent.getAgent();
        anAgent.deliverService("ListService", dc);
        XMLGenerator generator = XMLGenerator.getInstance();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)generator.toXML(dc, "", ""));
        }
    }
}

