/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.GLEngine;

import com.exilant.GLEngine.CoaCache;
import com.exilant.GLEngine.GLAccount;
import com.exilant.GLEngine.GLParameter;
import com.exilant.GLEngine.RequiredValidator;
import com.exilant.GLEngine.Transaxtion;
import com.exilant.GLEngine.TransaxtionParameter;
import com.exilant.eGov.src.transactions.ExilPrecision;
import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CGeneralLedgerDetail;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.service.ChartOfAccountDetailService;
import org.egov.dao.budget.BudgetDetailsHibernateDAO;
import org.egov.dao.recoveries.TdsHibernateDAO;
import org.egov.deduction.model.EgRemittanceGldtl;
import org.egov.infra.cache.impl.ApplicationCacheManager;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.recoveries.Recovery;
import org.egov.services.voucher.VoucherService;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class ChartOfAccounts {
    static ChartOfAccounts singletonInstance;
    private static final Logger LOGGER;
    private static final String ROOTNODE = "/COA";
    private static final String GLACCCODENODE = "GlAccountCodes";
    private static final String GLACCIDNODE = "GlAccountIds";
    private static final String ACCOUNTDETAILTYPENODE = "AccountDetailType";
    private static final String EXP = "Exp=";
    private static final String EXILRPERROR = "exilRPError";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private TdsHibernateDAO tdsHibernateDAO;
    @Autowired
    private CoaCache coaCache;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService<CGeneralLedger, Long> generalLedgerPersistenceService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService<CGeneralLedgerDetail, Long> generalLedgerDetPersistenceService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService<EgRemittanceGldtl, Long> remitanceDetPersistenceService;
    @Autowired
    @Qualifier(value="chartOfAccountDetailService")
    private ChartOfAccountDetailService chartOfAccountDetailService;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    private ApplicationCacheManager applicationCacheManager;
    @Autowired
    private BudgetDetailsHibernateDAO budgetDetailsDAO;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private FinancialYearHibernateDAO financialYearDAO;
    @Autowired
    private RequiredValidator rv;

    @Deprecated
    public static ChartOfAccounts getInstance() throws TaskFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"getInstancw called");
        }
        return singletonInstance;
    }

    public void loadAccountData() throws TaskFailedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"loadAccountData called");
        }
        HashMap hm = null;
        try {
            hm = (HashMap)this.applicationCacheManager.get((Object)ROOTNODE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hm == null) {
            this.coaCache.loadAccountData();
        }
    }

    private synchronized void loadParameters(HashMap glAccountCodes, HashMap glAccountIds) throws TaskFailedException {
        List chList = this.chartOfAccountDetailService.findAllBy("from CChartOfAccountDetail", new Object[0]);
        for (CChartOfAccountDetail chartOfAccountDetail : chList) {
            GLParameter parameter = new GLParameter();
            parameter.setDetailId(chartOfAccountDetail.getDetailTypeId().getId());
            parameter.setDetailName(chartOfAccountDetail.getDetailTypeId().getAttributename());
            GLAccount glAccCode = ChartOfAccounts.getGlAccCode(chartOfAccountDetail.getGlCodeId(), glAccountCodes);
            GLAccount glAccId = ChartOfAccounts.getGlAccId(chartOfAccountDetail.getGlCodeId(), glAccountIds);
            if (glAccCode != null && glAccCode.getGLParameters() != null) {
                glAccCode.getGLParameters().add(parameter);
            }
            if (glAccId == null || glAccId.getGLParameters() == null) continue;
            glAccId.getGLParameters().add(parameter);
        }
    }

    private static Integer getIntegerValue(Object[] element) {
        return element != null ? Integer.valueOf(Integer.parseInt(element[0].toString())) : null;
    }

    private static Long getLongValue(Object[] element) {
        return element != null ? Long.valueOf(element[0].toString()) : null;
    }

    private static GLAccount getGlAccCode(CChartOfAccounts glCodeId, Map glAccountCodes) {
        for (Object key : glAccountCodes.keySet()) {
            if (!((String)key).equalsIgnoreCase(glCodeId.getGlcode())) continue;
            return (GLAccount)glAccountCodes.get(key);
        }
        return null;
    }

    private static GLAccount getGlAccId(CChartOfAccounts glCodeId, Map glAccountIds) {
        for (Object key : glAccountIds.keySet()) {
            if (!key.toString().equalsIgnoreCase(glCodeId.getId().toString())) continue;
            return (GLAccount)glAccountIds.get(key);
        }
        return null;
    }

    private boolean validateGLCode(Transaxtion txn, DataCollection dc) throws TaskFailedException {
        GLAccount glAcc;
        HashMap hm;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Inside the ValidateGLCode2");
        }
        if ((hm = this.getGlAccountCodes()) == null) {
            LOGGER.error((Object)"Account Codes not initialized");
            dc.addMessage("Account Codes not initialized", txn.getGlCode() + " For " + txn.getGlName());
            return false;
        }
        if (hm.get(txn.getGlCode()) == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("looking for:" + txn.getGlCode() + ":"));
            }
            Iterator itr = hm.keySet().iterator();
            while (itr.hasNext()) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("GLCode:" + (String)itr.next() + ":"));
            }
        }
        Object obj = hm.get(txn.getGlCode());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Class Name:" + obj.getClass()));
        }
        if ((glAcc = (GLAccount)hm.get(txn.getGlCode())) == null) {
            dc.addMessage("exilInvalidCode", txn.getGlCode() + " For " + txn.getGlName());
            return false;
        }
        txn.setGlName(glAcc.getName());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)(txn.getGlCode() + " is activefor posting :" + glAcc.isActiveForPosting()));
        }
        if (!glAcc.isActiveForPosting()) {
            dc.addMessage("exilInActiveAccount", txn.getGlCode() + " For " + txn.glName);
            return false;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Classification....in   :" + glAcc.getClassification()));
        }
        if (glAcc.getClassification() != 4L) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"classification is not detailed code");
            }
            dc.addMessage("exilNotDetailAccount", txn.getGlCode());
            return false;
        }
        if (Double.parseDouble(txn.getDrAmount()) > 0.0 && Double.parseDouble(txn.getCrAmount()) > 0.0) {
            dc.addMessage("exilInvalidTrxn");
            return false;
        }
        return this.isRequiredPresent(txn, glAcc, dc);
    }

    public boolean validateGLCode(Transaxtion txn) throws Exception {
        GLAccount glAcc;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"Inside the ValidateGLCode1");
        }
        if ((glAcc = (GLAccount)this.getGlAccountCodes().get(txn.getGlCode())) == null) {
            LOGGER.error((Object)"GLCode is null");
            return false;
        }
        txn.setGlName(glAcc.getName());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)(txn.getGlCode() + " is activefor posting :" + glAcc.isActiveForPosting()));
        }
        if (!glAcc.isActiveForPosting()) {
            throw new TaskFailedException("The COA(GlCode) " + txn.getGlCode() + "  used is not active for posting. Kindly modify COA from detailed code screen and then proceed for creating voucher");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Classification....:" + glAcc.getClassification()));
        }
        if (glAcc.getClassification() != 4L) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"classification is not detailed code");
            }
            throw new TaskFailedException("Cannot post to " + txn.getGlCode());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Going to check the Amount.Debit: " + txn.getDrAmount() + " ** Credit :" + txn.getCrAmount()));
        }
        if (Double.parseDouble(txn.getDrAmount()) > 0.0 && Double.parseDouble(txn.getCrAmount()) > 0.0) {
            throw new TaskFailedException("Both Debit and Credit cannot be greater than Zero.");
        }
        return this.isRequiredPresent(txn, glAcc);
    }

    private boolean isRequiredPresent(Transaxtion txn, GLAccount glAcc, DataCollection dc) throws TaskFailedException {
        int requiredCount = 0;
        int foundCount = 0;
        ArrayList glParamList = glAcc.getGLParameters();
        for (int i = 0; i < glParamList.size(); ++i) {
            GLParameter glPrm = (GLParameter)glParamList.get(i);
            ++requiredCount;
            for (int j = 0; j < txn.transaxtionParameters.size(); ++j) {
                TransaxtionParameter txnPrm = (TransaxtionParameter)txn.transaxtionParameters.get(j);
                if (!txnPrm.getDetailName().equalsIgnoreCase(glPrm.getDetailName())) continue;
                RequiredValidator rv = new RequiredValidator();
                int id = glPrm.getDetailId();
                if (rv.validateKey(id, txnPrm.getDetailKey())) {
                    ++foundCount;
                    continue;
                }
                dc.addMessage("exilWrongData", txnPrm.getDetailName());
                return false;
            }
        }
        if (foundCount < requiredCount) {
            dc.addMessage("exilDataInsufficient");
            return false;
        }
        return true;
    }

    private boolean isRequiredPresent(Transaxtion txn, GLAccount glAcc) throws Exception {
        int requiredCount = 0;
        int foundCount = 0;
        ArrayList glParamList = glAcc.getGLParameters();
        for (int i = 0; i < glParamList.size(); ++i) {
            GLParameter glPrm = (GLParameter)glParamList.get(i);
            TransaxtionParameter txnPrm1 = (TransaxtionParameter)txn.transaxtionParameters.get(0);
            if (glPrm.getDetailId() == Integer.parseInt(txnPrm1.getDetailTypeId())) {
                ++requiredCount;
            }
            for (int j = 0; j < txn.transaxtionParameters.size(); ++j) {
                TransaxtionParameter txnPrm = (TransaxtionParameter)txn.transaxtionParameters.get(j);
                if (!txnPrm.getDetailName().equalsIgnoreCase(glPrm.getDetailName())) continue;
                int id = glPrm.getDetailId();
                if (this.rv.validateKey(id, txnPrm.getDetailKey())) {
                    ++foundCount;
                    continue;
                }
                return false;
            }
        }
        return foundCount >= requiredCount;
    }

    private boolean validateTxns(Transaxtion[] txnList, DataCollection dc) throws TaskFailedException {
        if (txnList.length < 2) {
            dc.addMessage("exilWrongTrxn");
            return false;
        }
        double dbAmt = 0.0;
        double crAmt = 0.0;
        try {
            for (Transaxtion element : txnList) {
                Transaxtion txn = element;
                if (!this.validateGLCode(txn, dc)) {
                    return false;
                }
                dbAmt += Double.parseDouble(txn.getDrAmount());
                crAmt += Double.parseDouble(txn.getCrAmount());
            }
        }
        catch (Exception e) {
            dc.addMessage(EXILRPERROR, e.toString());
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskFailedException();
        }
        if ((dbAmt = ExilPrecision.convertToDouble(dbAmt, 2)) != (crAmt = ExilPrecision.convertToDouble(crAmt, 2))) {
            dc.addMessage("exilAmountMismatch");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateTxns(Transaxtion[] txnList) throws Exception {
        if (txnList.length < 2) {
            return false;
        }
        double dbAmt = 0.0;
        double crAmt = 0.0;
        try {
            for (Transaxtion element : txnList) {
                Transaxtion txn = element;
                if (!this.validateGLCode(txn)) {
                    boolean bl = false;
                    return bl;
                }
                dbAmt += Double.parseDouble(txn.getDrAmount());
                crAmt += Double.parseDouble(txn.getCrAmount());
            }
        }
        catch (TaskFailedException e) {
            throw new TaskFailedException(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            int n = 0;
            return n != 0;
        }
        finally {
            RequiredValidator.clearEmployeeMap();
        }
        dbAmt = ExilPrecision.convertToDouble(dbAmt, 2);
        crAmt = ExilPrecision.convertToDouble(crAmt, 2);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Total Checking.....Debit total is :" + dbAmt + "  Credit total is :" + crAmt));
        }
        if (dbAmt != crAmt) {
            throw new TaskFailedException("Total debit and credit not matching. Total debit amount is: " + dbAmt + " Total credit amount is :" + crAmt);
        }
        return true;
    }

    @Transactional(readOnly=true)
    private boolean checkBudget(Transaxtion[] txnList) throws Exception, ValidationException {
        HashMap<String, Object> paramMap = null;
        Transaxtion txnObj = null;
        CVoucherHeader voucherHeader = null;
        Transaxtion[] transaxtionArray = txnList;
        int n = transaxtionArray.length;
        for (int i = 0; i < n; ++i) {
            Transaxtion element;
            txnObj = element = transaxtionArray[i];
            voucherHeader = (CVoucherHeader)this.voucherService.getSession().get(CVoucherHeader.class, (Serializable)Long.valueOf(txnObj.voucherHeaderId));
            paramMap = new HashMap<String, Object>();
            if (txnObj.getDrAmount() == null || txnObj.getDrAmount().equals("")) {
                paramMap.put("debitAmt", null);
            } else {
                paramMap.put("debitAmt", new BigDecimal(txnObj.getDrAmount() + ""));
            }
            if (txnObj.getCrAmount() == null || txnObj.getCrAmount().equals("")) {
                paramMap.put("creditAmt", null);
            } else {
                paramMap.put("creditAmt", new BigDecimal(txnObj.getCrAmount() + ""));
            }
            if (voucherHeader.getFundId() != null) {
                paramMap.put("fundid", voucherHeader.getFundId().getId());
            }
            if (voucherHeader.getVouchermis().getDepartmentid() != null) {
                paramMap.put("deptid", voucherHeader.getVouchermis().getDepartmentid().getId());
            }
            if (txnObj.functionId != null && !txnObj.functionId.equals("")) {
                paramMap.put("functionid", Long.valueOf(txnObj.functionId));
            }
            if (voucherHeader.getVouchermis().getFunctionary() != null) {
                paramMap.put("functionaryid", voucherHeader.getVouchermis().getFunctionary().getId());
            }
            if (voucherHeader.getVouchermis().getSchemeid() != null) {
                paramMap.put("schemeid", voucherHeader.getVouchermis().getSchemeid().getId());
            }
            if (voucherHeader.getVouchermis().getSubschemeid() != null) {
                paramMap.put("subschemeid", voucherHeader.getVouchermis().getSubschemeid().getId());
            }
            if (voucherHeader.getVouchermis().getDivisionid() != null) {
                paramMap.put("boundaryid", voucherHeader.getVouchermis().getDivisionid().getId());
            }
            paramMap.put("glcode", txnObj.getGlCode());
            paramMap.put("asondate", voucherHeader.getVoucherDate());
            paramMap.put("mis.budgetcheckreq", voucherHeader.getVouchermis().isBudgetCheckReq());
            paramMap.put("voucherHeader", voucherHeader);
            if (txnObj.getBillId() != null) {
                paramMap.put("bill", txnObj.getBillId());
            }
            if (this.budgetDetailsDAO.budgetaryCheck(paramMap)) continue;
            throw new ValidationException("Budget check failed: Insufficient Budget for " + txnObj.getGlCode(), "Budget check failed: Insufficient Budget for " + txnObj.getGlCode(), new String[0]);
        }
        return true;
    }

    @Transactional
    public boolean postTransaxtions(Transaxtion[] txnList, String vDate) throws Exception, ValidationException {
        if (!this.checkBudget(txnList)) {
            throw new Exception("Budgetary check is failed");
        }
        this.loadAccountData();
        try {
            if (!this.validPeriod(vDate)) {
                throw new TaskFailedException("Voucher Date is not within an open period. Please use an open period for posting");
            }
            if (!this.validateTxns(txnList)) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskFailedException(e.getMessage());
        }
        return this.postInGL(txnList);
    }

    private void checkfuctreqd(String glcode, String fuctid, DataCollection dc) throws Exception {
        String sql = "select FUNCTIONREQD from chartofaccounts where glcode = ?";
        SQLQuery pst = this.persistenceService.getSession().createSQLQuery("select FUNCTIONREQD from chartofaccounts where glcode = ?");
        pst.setString(0, glcode);
        List rs = null;
        rs = pst.list();
        for (Object[] element : rs) {
            if (Integer.parseInt(element[0].toString()) != 1) continue;
            if (fuctid.length() > 0 && fuctid != null) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("in COA33--" + fuctid));
                continue;
            }
            dc.addMessage("exilError", "Select functionName for this glcode " + glcode);
            throw new TaskFailedException();
        }
    }

    private boolean postInGL(Transaxtion[] txnList, DataCollection dc) throws ParseException {
        CGeneralLedger gLedger = null;
        CGeneralLedgerDetail gLedgerDet = null;
        EgRemittanceGldtl egRemitGldtl = null;
        Transaxtion[] transaxtionArray = txnList;
        int n = transaxtionArray.length;
        for (int i = 0; i < n; ++i) {
            String fucid;
            Transaxtion element;
            Transaxtion txn = element = transaxtionArray[i];
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("GL Code is :" + txn.getGlCode() + " Debit Amount :" + Double.parseDouble(txn.getDrAmount()) + " Credit Amt :" + Double.parseDouble(txn.getCrAmount())));
            }
            if (Double.parseDouble(txn.getDrAmount()) == 0.0 && Double.parseDouble(txn.getCrAmount()) == 0.0) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)"Comming in the zero  block");
                continue;
            }
            GLAccount glAcc = (GLAccount)this.getGlAccountCodes().get(txn.getGlCode());
            gLedger = new CGeneralLedger();
            if (txn.getVoucherLineId() != null) {
                gLedger.setVoucherlineId(Integer.valueOf(Integer.parseInt(txn.getVoucherLineId())));
            }
            CChartOfAccounts cChartOfAccounts = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{glAcc.getId()});
            gLedger.setGlcodeId(cChartOfAccounts);
            gLedger.setGlcode(txn.getGlCode());
            gLedger.setDebitAmount(Double.valueOf(Double.parseDouble(txn.getDrAmount())));
            gLedger.setCreditAmount(Double.valueOf(Double.parseDouble(txn.getCrAmount())));
            gLedger.setDescription(txn.getNarration());
            CVoucherHeader cVoucherHeader = (CVoucherHeader)this.voucherService.findById(Long.valueOf(txn.getVoucherHeaderId()), false);
            gLedger.setVoucherHeaderId(cVoucherHeader);
            gLedger.setEffectiveDate(new Date());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Value of function in COA before setting :" + txn.getFunctionId()));
            }
            if (txn.getFunctionId() != null && !txn.getFunctionId().equals("")) {
                gLedger.setFunctionId(Integer.valueOf(Integer.parseInt(txn.getFunctionId())));
            } else {
                gLedger.setFunctionId(null);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("txn.getGlCode()" + txn.getGlCode()));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("txn.getFunctionId()" + txn.getFunctionId()));
            }
            if ((fucid = txn.getFunctionId()) != null && !fucid.equals("")) {
                try {
                    this.checkfuctreqd(txn.getGlCode(), txn.getFunctionId(), dc);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Inside checkfuctreqd" + e.getMessage()), (Throwable)e);
                    return false;
                }
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Value of function id in COA --" + txn.getFunctionId()));
            }
            try {
                this.generalLedgerPersistenceService.persist((Object)gLedger);
            }
            catch (Exception e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("error in the gl++++++++++" + e), (Throwable)e);
                }
                return false;
            }
            if (glAcc.getGLParameters().size() <= 0) continue;
            ArrayList glParamList = glAcc.getGLParameters();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("glParamList size.... :" + glParamList.size()));
            }
            ArrayList txnPrm = txn.getTransaxtionParam();
            String detKeyId = "";
            for (int a = 0; a < glParamList.size(); ++a) {
                try {
                    GLParameter glPrm = (GLParameter)glParamList.get(a);
                    for (int z = 0; z < txnPrm.size(); ++z) {
                        TransaxtionParameter tParam = (TransaxtionParameter)txnPrm.get(z);
                        if (!tParam.getDetailName().equalsIgnoreCase(glPrm.getDetailName()) || !tParam.getGlcodeId().equals(gLedger.getGlcodeId().getId())) continue;
                        detKeyId = tParam.getDetailKey();
                        gLedgerDet = new CGeneralLedgerDetail();
                        gLedgerDet.setGeneralLedgerId(gLedger);
                        Accountdetailtype acctype = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=?", new Object[]{glPrm.getDetailId()});
                        gLedgerDet.setDetailTypeId(acctype);
                        gLedgerDet.setDetailKeyId(Integer.valueOf(Integer.parseInt(detKeyId)));
                        gLedgerDet.setAmount(new BigDecimal(tParam.getDetailAmt()));
                        this.generalLedgerDetPersistenceService.persist((Object)gLedgerDet);
                        try {
                            if (!this.validRecoveryGlcode(String.valueOf(gLedger.getGlcodeId().getId())) || !(gLedger.getCreditAmount() > 0.0)) continue;
                            egRemitGldtl = new EgRemittanceGldtl();
                            egRemitGldtl.setGeneralledgerdetail(gLedgerDet);
                            egRemitGldtl.setGldtlamt(gLedgerDet.getAmount());
                            Recovery tdsentry = null;
                            if (tParam.getTdsId() != null) {
                                tdsentry = (Recovery)((Object)this.persistenceService.find("from TDS where id=?", new Object[]{Long.parseLong(tParam.getTdsId())}));
                            }
                            egRemitGldtl.setRecovery(tdsentry);
                            this.remitanceDetPersistenceService.persist((Object)egRemitGldtl);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("Error while inserting to eg_remittance_gldtl " + e), (Throwable)e);
                            return false;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Inside postInGL " + e.getMessage()), (Throwable)e);
                    dc.addMessage(EXILRPERROR, "General Ledger Details Error " + e.toString());
                    return false;
                }
            }
        }
        return true;
    }

    @Transactional
    private boolean postInGL(Transaxtion[] txnList) throws Exception {
        CGeneralLedger gLedger = null;
        CGeneralLedgerDetail gLedgerDet = null;
        EgRemittanceGldtl egRemitGldtl = null;
        Transaxtion[] transaxtionArray = txnList;
        int n = transaxtionArray.length;
        for (int i = 0; i < n; ++i) {
            Transaxtion element;
            Transaxtion txn = element = transaxtionArray[i];
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("GL Code is :" + txn.getGlCode() + ":txn.getFunctionId()" + txn.getFunctionId() + "  Debit Amount :" + String.valueOf(txn.getDrAmount()) + " Credit Amt :" + String.valueOf(txn.getCrAmount())));
            }
            if (String.valueOf(txn.getDrAmount()) == "0" && String.valueOf(txn.getCrAmount()) == "0") {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Comming in the zero  block");
                }
                return false;
            }
            gLedger = new CGeneralLedger();
            GLAccount glAcc = (GLAccount)this.getGlAccountCodes().get(txn.getGlCode());
            if (txn.getVoucherLineId() != null) {
                gLedger.setVoucherlineId(Integer.valueOf(Integer.parseInt(txn.getVoucherLineId())));
            }
            CChartOfAccounts cChartOfAccounts = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{glAcc.getId()});
            gLedger.setGlcodeId(cChartOfAccounts);
            gLedger.setGlcode(txn.getGlCode());
            gLedger.setDebitAmount(Double.valueOf(Double.parseDouble(txn.getDrAmount())));
            gLedger.setCreditAmount(Double.valueOf(Double.parseDouble(txn.getCrAmount())));
            gLedger.setDescription(txn.getNarration());
            CVoucherHeader cVoucherHeader = (CVoucherHeader)this.voucherService.findById(Long.valueOf(txn.getVoucherHeaderId()), false);
            gLedger.setVoucherHeaderId(cVoucherHeader);
            gLedger.setEffectiveDate(new Date());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Value of function in COA before setting :" + txn.getFunctionId()));
            }
            if (txn.getFunctionId() != null && !txn.getFunctionId().trim().equals("") && !txn.getFunctionId().equals("0")) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("txn.getFunctionId()" + txn.getFunctionId()));
                }
                gLedger.setFunctionId(Integer.valueOf(Integer.parseInt(txn.getFunctionId())));
            } else {
                if (glAcc.getFunctionRequired() != null && glAcc.getFunctionRequired().booleanValue()) {
                    ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                    errors.add(new ValidationError("exp", "function is required for account code : " + txn.getGlCode()));
                    throw new ValidationException(errors);
                }
                gLedger.setFunctionId(null);
            }
            try {
                this.generalLedgerPersistenceService.persist((Object)gLedger);
            }
            catch (Exception e) {
                LOGGER.error((Object)("error in the gl++++++++++" + e), (Throwable)e);
                return false;
            }
            if (glAcc.getGLParameters().size() <= 0) continue;
            ArrayList glParamList = glAcc.getGLParameters();
            HashSet temp = new HashSet();
            temp.addAll(glParamList);
            glParamList.clear();
            glParamList.addAll(temp);
            ArrayList txnPrm = txn.getTransaxtionParam();
            String detKeyId = "";
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("glParamList size :" + glParamList.size()));
            }
            for (int a = 0; a < glParamList.size(); ++a) {
                try {
                    GLParameter glPrm = (GLParameter)glParamList.get(a);
                    for (int z = 0; z < txnPrm.size(); ++z) {
                        TransaxtionParameter tParam = (TransaxtionParameter)txnPrm.get(z);
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)("tParam.getGlcodeId():" + tParam.getGlcodeId()));
                        }
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)("gLedger.getglCodeId():" + gLedger.getGlcodeId()));
                        }
                        if (!tParam.getDetailName().equalsIgnoreCase(glPrm.getDetailName()) || !tParam.getGlcodeId().equals(gLedger.getGlcodeId().getId().toString())) continue;
                        gLedgerDet = new CGeneralLedgerDetail();
                        detKeyId = tParam.getDetailKey();
                        gLedgerDet.setGeneralLedgerId(gLedger);
                        Accountdetailtype acctype = (Accountdetailtype)this.persistenceService.getSession().load(Accountdetailtype.class, (Serializable)Integer.valueOf(glPrm.getDetailId()));
                        gLedgerDet.setDetailTypeId(acctype);
                        gLedgerDet.setDetailKeyId(Integer.valueOf(Integer.parseInt(detKeyId)));
                        gLedgerDet.setAmount(new BigDecimal(tParam.getDetailAmt()));
                        this.generalLedgerDetPersistenceService.persist((Object)gLedgerDet);
                        try {
                            if (!this.validRecoveryGlcode(String.valueOf(gLedger.getGlcodeId().getId())) || !(gLedger.getCreditAmount() > 0.0)) continue;
                            egRemitGldtl = new EgRemittanceGldtl();
                            egRemitGldtl.setGeneralledgerdetail(gLedgerDet);
                            egRemitGldtl.setGldtlamt(gLedgerDet.getAmount());
                            Recovery tdsentry = null;
                            if (tParam.getTdsId() != null) {
                                tdsentry = (Recovery)((Object)this.persistenceService.find("from Recovery where id=?", new Object[]{Long.parseLong(tParam.getTdsId())}));
                            }
                            if (tdsentry != null) {
                                egRemitGldtl.setRecovery(tdsentry);
                            }
                            this.remitanceDetPersistenceService.persist((Object)egRemitGldtl);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("Error while inserting to eg_remittance_gldtl " + e), (Throwable)e);
                            return false;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("inside postInGL" + e.getMessage()), (Throwable)e);
                    throw new TaskFailedException();
                }
            }
        }
        return true;
    }

    private boolean updateInGL(Transaxtion[] txnList, DataCollection dc) throws TaskFailedException, ParseException, SQLException {
        EgRemittanceGldtl egRemitGldtl;
        CGeneralLedgerDetail gLedgerDet;
        CGeneralLedger gLedger;
        block26: {
            gLedger = null;
            gLedgerDet = null;
            egRemitGldtl = null;
            ArrayList<String> glHeaderId = new ArrayList<String>();
            Transaxtion txn1 = txnList[0];
            int VoucherHeaderId = Integer.parseInt(txn1.getVoucherHeaderId());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("VoucherHeaderId----" + VoucherHeaderId));
            }
            String query = "select id from generalledger where voucherheaderid= ? order by id";
            SQLQuery pst = this.persistenceService.getSession().createSQLQuery("select id from generalledger where voucherheaderid= ? order by id");
            pst.setInteger(0, VoucherHeaderId);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("select id from generalledger where voucherheaderid=" + VoucherHeaderId + " order by id"));
            }
            List resultset = pst.list();
            int c = 0;
            for (Object[] element : resultset) {
                glHeaderId.add(c, element[0].toString());
                ++c;
            }
            int count = glHeaderId.size();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("count**********" + count));
            }
            for (int k = 0; k < count; ++k) {
                try {
                    String delremitsql = "delete from eg_remittance_gldtl where gldtlid in (select id from generalledgerdetail where generalledgerid='" + glHeaderId.get(k).toString() + "')";
                    pst = this.persistenceService.getSession().createSQLQuery(delremitsql);
                    pst.setString(0, glHeaderId.get(k).toString());
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("deleting remittance Query " + delremitsql));
                    }
                    pst.executeUpdate();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("delete from generalledgerdetail where generalledgerid='" + glHeaderId.get(k).toString() + "'"));
                    }
                    String delGenLedDet = "delete from generalledgerdetail where generalledgerid= ?";
                    pst = this.persistenceService.getSession().createSQLQuery("delete from generalledgerdetail where generalledgerid= ?");
                    pst.setString(0, glHeaderId.get(k).toString());
                    int del = pst.executeUpdate();
                    if (del <= 0 || !LOGGER.isInfoEnabled()) continue;
                    LOGGER.info((Object)("Records deleted from general ledger detail for GLH " + glHeaderId.get(k).toString()));
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Exp in reading from generalledgerdetail: " + e), (Throwable)e);
                    throw new TaskFailedException(e.getMessage());
                }
            }
            if (count > 0) {
                try {
                    String genLed = "DELETE FROM generalledger WHERE voucherheaderid= ?";
                    pst = this.persistenceService.getSession().createSQLQuery("DELETE FROM generalledger WHERE voucherheaderid= ?");
                    pst.setInteger(0, VoucherHeaderId);
                    int del = pst.executeUpdate();
                    if (del > 0 && LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)("DELETE FROM generalledger WHERE voucherheaderid=" + VoucherHeaderId));
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isInfoEnabled()) break block26;
                    LOGGER.info((Object)("Exp in reading from generalledger: " + e), (Throwable)e);
                }
            }
        }
        for (Transaxtion txn : txnList) {
            GLAccount glAcc = (GLAccount)this.getGlAccountCodes().get(txn.getGlCode());
            gLedger = new CGeneralLedger();
            if (txn.getVoucherLineId() != null) {
                gLedger.setVoucherlineId(Integer.valueOf(Integer.parseInt(txn.getVoucherLineId())));
            }
            CChartOfAccounts cChartOfAccounts = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{glAcc.getId()});
            gLedger.setGlcodeId(cChartOfAccounts);
            gLedger.setGlcode(txn.getGlCode());
            gLedger.setDebitAmount(Double.valueOf(Double.parseDouble(txn.getDrAmount())));
            gLedger.setCreditAmount(Double.valueOf(Double.parseDouble(txn.getCrAmount())));
            gLedger.setDescription(txn.getNarration());
            CVoucherHeader cVoucherHeader = (CVoucherHeader)this.persistenceService.find("from CVoucherHeader where id=?", new Object[]{Long.parseLong(txn.getVoucherHeaderId())});
            gLedger.setVoucherHeaderId(cVoucherHeader);
            gLedger.setEffectiveDate(new Date());
            gLedger.setFunctionId(Integer.valueOf(Integer.parseInt(txn.getFunctionId())));
            try {
                this.generalLedgerPersistenceService.persist((Object)gLedger);
            }
            catch (Exception e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("error in the gl++++++++++" + e), (Throwable)e);
                }
                dc.addMessage("exilSQLError", e.toString());
                return false;
            }
            if (glAcc.getGLParameters().size() <= 0) continue;
            ArrayList glParamList = glAcc.getGLParameters();
            ArrayList txnPrm = txn.getTransaxtionParam();
            String detKeyId = "";
            for (int a = 0; a < glParamList.size(); ++a) {
                try {
                    GLParameter glPrm = (GLParameter)glParamList.get(a);
                    for (int z = 0; z < txnPrm.size(); ++z) {
                        TransaxtionParameter tParam = (TransaxtionParameter)txnPrm.get(z);
                        if (!tParam.getDetailName().equalsIgnoreCase(glPrm.getDetailName()) || !tParam.getGlcodeId().equals(gLedger.getGlcodeId().getId().toString())) continue;
                        detKeyId = tParam.getDetailKey();
                        gLedgerDet = new CGeneralLedgerDetail();
                        gLedgerDet.setGeneralLedgerId(gLedger);
                        Accountdetailtype acctype = (Accountdetailtype)this.persistenceService.find("from Accountdetailtype where id=?", new Object[]{glPrm.getDetailId()});
                        gLedgerDet.setDetailTypeId(acctype);
                        gLedgerDet.setDetailKeyId(Integer.valueOf(Integer.parseInt(detKeyId)));
                        gLedgerDet.setAmount(new BigDecimal(tParam.getDetailAmt()));
                        this.generalLedgerDetPersistenceService.persist((Object)gLedgerDet);
                        try {
                            if (!this.validRecoveryGlcode(String.valueOf(gLedger.getGlcodeId().getId())) || !(gLedger.getCreditAmount() > 0.0)) continue;
                            egRemitGldtl = new EgRemittanceGldtl();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("----------" + gLedger.getGlcode()));
                            }
                            egRemitGldtl.setGeneralledgerdetail(gLedgerDet);
                            egRemitGldtl.setGldtlamt(gLedgerDet.getAmount());
                            Recovery tdsentry = null;
                            if (tParam.getTdsId() != null) {
                                tdsentry = (Recovery)((Object)this.persistenceService.find("from Recovery where id=?", new Object[]{Long.parseLong(tParam.getTdsId())}));
                            }
                            egRemitGldtl.setRecovery(tdsentry);
                            this.remitanceDetPersistenceService.persist((Object)egRemitGldtl);
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("Error while inserting to eg_remittance_gldtl " + e), (Throwable)e);
                            return false;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Inside updateInGl" + e.getMessage()), (Throwable)e);
                    throw new TaskFailedException();
                }
            }
        }
        return true;
    }

    public String getGLCode(String detailName, String detailKey, Connection con) throws TaskFailedException {
        String code = "";
        try {
            String str = "select glcode as \"code\" from chartofaccounts,bankaccount where bankaccount.glcodeid=chartofaccounts.id and bankaccount.id= ?";
            PreparedStatement pst = con.prepareStatement("select glcode as \"code\" from chartofaccounts,bankaccount where bankaccount.glcodeid=chartofaccounts.id and bankaccount.id= ?");
            pst.setString(0, detailKey);
            ResultSet resultset = pst.executeQuery();
            if (resultset.next()) {
                code = resultset.getString("code");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error" + e.toString()), (Throwable)e);
        }
        return code;
    }

    public String getFiscalYearID(String voucherDate, Connection con, DataCollection dc) {
        String fiscalyearid = "";
        String sql = "select ID as \"fiscalperiodID\" from fiscalperiod where to_date(?,'dd-mon-yyyy') between startingdate and endingdate";
        try {
            PreparedStatement pst = con.prepareStatement("select ID as \"fiscalperiodID\" from fiscalperiod where to_date(?,'dd-mon-yyyy') between startingdate and endingdate");
            pst.setString(0, voucherDate);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                fiscalyearid = rs.getString("fiscalperiodID");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Excepion in getFiscalYearID() " + e), (Throwable)e);
        }
        return fiscalyearid;
    }

    private boolean validPeriod(String vDate) throws TaskFailedException {
        try {
            if (this.isClosedForPosting(vDate)) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Inside validPeriod " + e.getMessage()), (Throwable)e);
            throw new TaskFailedException();
        }
        return true;
    }

    public void test() throws TaskFailedException {
        Iterator it = this.getGlAccountCodes().keySet().iterator();
        while (it.hasNext()) {
            GLAccount glAcc = (GLAccount)this.getGlAccountCodes().get(it.next());
            ArrayList a = glAcc.getGLParameters();
            for (int i = 0; i < a.size(); ++i) {
                GLParameter gLParameter = (GLParameter)a.get(i);
            }
        }
    }

    public HashMap getAccountDetailType() {
        LOGGER.debug((Object)"in getAccountDetailType():jndi name is :");
        HashMap retMap = null;
        try {
            HashMap cacheValuesHashMap = new HashMap();
            try {
                cacheValuesHashMap = (HashMap)this.applicationCacheManager.get((Object)ROOTNODE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cacheValuesHashMap != null && !cacheValuesHashMap.isEmpty()) {
                retMap = (HashMap)cacheValuesHashMap.get(ACCOUNTDETAILTYPENODE);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)(EXP + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return retMap;
    }

    public HashMap getGlAccountCodes() {
        LOGGER.debug((Object)"in getGlAccountCodes():jndi name is :");
        HashMap retMap = null;
        try {
            HashMap cacheValuesHashMap = new HashMap();
            try {
                cacheValuesHashMap = (HashMap)this.applicationCacheManager.get((Object)ROOTNODE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cacheValuesHashMap != null && !cacheValuesHashMap.isEmpty()) {
                retMap = (HashMap)cacheValuesHashMap.get(GLACCCODENODE);
            }
            if (retMap != null) {
                LOGGER.debug((Object)("in getGlAccountCodes() size is :" + retMap.size()));
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)(EXP + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return retMap;
    }

    public HashMap getGlAccountIds() {
        LOGGER.debug((Object)"in getGlAccountIds():jndi name is :");
        HashMap retMap = null;
        try {
            HashMap cacheValuesHashMap = new HashMap();
            try {
                cacheValuesHashMap = (HashMap)this.applicationCacheManager.get((Object)ROOTNODE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cacheValuesHashMap != null && !cacheValuesHashMap.isEmpty()) {
                retMap = (HashMap)cacheValuesHashMap.get(GLACCIDNODE);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)(EXP + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return retMap;
    }

    private boolean validRecoveryGlcode(String glcodeId) throws TaskFailedException {
        Recovery tds = this.tdsHibernateDAO.findActiveTdsByGlcodeId(Long.valueOf(glcodeId));
        return tds != null;
    }

    public boolean isClosedForPosting(String date) throws TaskFailedException {
        boolean isClosed = true;
        Object chkqry = null;
        Object psmt = null;
        SQLQuery psmt1 = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            CFinancialYear financialYearByDate = this.financialYearDAO.getFinancialYearByDate(formatter.parse(date));
            if (financialYearByDate != null) {
                isClosed = false;
            }
            if (!isClosed) {
                List rs = null;
                String qry = "SELECT id FROM closedPeriods WHERE to_char(startingDate, 'DD-MON-YYYY')<='" + date + "' AND endingDate>='" + date + "'";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)qry);
                }
                isClosed = (rs = (psmt1 = this.persistenceService.getSession().createSQLQuery(qry)).list()) != null && rs.size() > 0;
            }
        }
        catch (HibernateException e) {
            isClosed = true;
            LOGGER.error((Object)("Exception occured while getting the data " + e.getMessage()), (Throwable)new HibernateException(e.getMessage()));
        }
        catch (Exception e) {
            isClosed = true;
            LOGGER.error((Object)("Exception occured while getting the data " + e.getMessage()), (Throwable)new Exception(e.getMessage()));
        }
        return isClosed;
    }

    static {
        LOGGER = Logger.getLogger(ChartOfAccounts.class);
    }
}

