/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.voucher;

import com.exilant.exility.common.TaskFailedException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.CVoucherHeader;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.model.voucher.WorkflowBean;
import org.egov.services.voucher.JournalVoucherActionHelper;
import org.egov.services.voucher.VoucherService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class PreApprovedActionHelper {
    @Autowired
    @Qualifier(value="journalVoucherActionHelper")
    private JournalVoucherActionHelper journalVoucherActionHelper;
    @Autowired
    @Qualifier(value="voucherService")
    private VoucherService voucherService;
    @Autowired
    @Qualifier(value="createVoucher")
    private CreateVoucher createVoucher;

    @Transactional
    public CVoucherHeader createVoucherFromBill(CVoucherHeader voucherHeader, WorkflowBean workflowBean, Long billId, String voucherNumber, Date voucherDate) throws ApplicationRuntimeException, SQLException, TaskFailedException {
        try {
            Long voucherHeaderId = this.createVoucher.createVoucherFromBill(billId.intValue(), null, voucherNumber, voucherDate);
            voucherHeader = (CVoucherHeader)this.voucherService.findById(voucherHeaderId, false);
            voucherHeader = this.sendForApproval(voucherHeader, workflowBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return voucherHeader;
    }

    @Transactional
    public CVoucherHeader sendForApproval(CVoucherHeader voucherHeader, WorkflowBean workflowBean) {
        try {
            voucherHeader = this.journalVoucherActionHelper.transitionWorkFlow(voucherHeader, workflowBean);
            this.voucherService.applyAuditing((AbstractAuditable)voucherHeader.getState());
            this.voucherService.persist(voucherHeader);
        }
        catch (ValidationException e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return voucherHeader;
    }
}

