/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.voucher;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.billsaccounting.services.VoucherConstant;
import org.egov.commons.Bankaccount;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FunctionDAO;
import org.egov.commons.dao.FunctionaryHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.commons.dao.FundSourceHibernateDAO;
import org.egov.commons.dao.SchemeHibernateDAO;
import org.egov.commons.dao.SubSchemeHibernateDAO;
import org.egov.commons.service.BankAccountService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.model.brs.BrsEntrieMis;
import org.egov.model.brs.BrsEntries;
import org.egov.model.voucher.BankEntriesNotInBankBook;
import org.egov.services.instrument.BankEntriesService;
import org.egov.services.voucher.VoucherHeaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class BankEntriesNotInBankBookActionHelper {
    @Autowired
    @Qualifier(value="bankAccountService")
    private BankAccountService bankAccountService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private CreateVoucher createVoucher;
    @Autowired
    private FunctionDAO functionDAO;
    @Autowired
    private FundHibernateDAO fundDAO;
    @Autowired
    private FunctionaryHibernateDAO functionaryDAO;
    @Autowired
    private SchemeHibernateDAO schemeDAO;
    @Autowired
    private SubSchemeHibernateDAO subSchemeDAO;
    @Autowired
    private FundSourceHibernateDAO fundSourceDAO;
    @Autowired
    @Qualifier(value="voucherHeaderService")
    private VoucherHeaderService voucherHeaderService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="bankEntriesService")
    private BankEntriesService bankEntriesService;

    @Transactional
    public void create(CVoucherHeader voucherHeader, Integer bankaccount, List<BankEntriesNotInBankBook> bankEntriesNotInBankBookList) throws Exception {
        try {
            ArrayList<BrsEntries> bankEntries = new ArrayList<BrsEntries>();
            BrsEntries bankEntry = new BrsEntries();
            BrsEntrieMis bankEntryMis = new BrsEntrieMis();
            Bankaccount bankAccount = (Bankaccount)this.bankAccountService.findById((Serializable)Long.valueOf(bankaccount.longValue()), false);
            CChartOfAccounts coa = new CChartOfAccounts();
            for (BankEntriesNotInBankBook bankEntriesNotInBankBook : bankEntriesNotInBankBookList) {
                if (bankEntriesNotInBankBook.getBeId() != null) {
                    if (bankEntriesNotInBankBook.getCreateVoucher() == null || !bankEntriesNotInBankBook.getCreateVoucher().booleanValue()) continue;
                    bankEntry = new BrsEntries();
                    bankEntry = (BrsEntries)((Object)this.bankEntriesService.findById(bankEntriesNotInBankBook.getBeId(), false));
                    bankEntriesNotInBankBook.setDate(bankEntry.getTxnDate());
                    bankEntriesNotInBankBook.setType(bankEntry.getType());
                    bankEntriesNotInBankBook.setAmount(bankEntry.getTxnAmount());
                    bankEntry.setVoucherHeaderId(this.createVoucher(voucherHeader, bankEntriesNotInBankBook, bankAccount, bankEntry.getGlCodeId()));
                    this.bankEntriesService.update((Object)bankEntry);
                    continue;
                }
                bankEntry = new BrsEntries();
                bankEntryMis = new BrsEntrieMis();
                bankEntry.setBankaccountId(bankAccount);
                bankEntry.setRefNo(bankEntriesNotInBankBook.getRefNum());
                bankEntry.setType(bankEntriesNotInBankBook.getType());
                bankEntry.setTxnDate(bankEntriesNotInBankBook.getDate());
                bankEntry.setTxnAmount(bankEntriesNotInBankBook.getAmount());
                bankEntry.setRemarks(bankEntriesNotInBankBook.getRemarks());
                coa = this.chartOfAccountsHibernateDAO.findById((Number)Long.valueOf(bankEntriesNotInBankBook.getGlcodeDetail()), false);
                bankEntry.setGlCodeId(coa);
                if (voucherHeader.getVouchermis().getFunction() != null && voucherHeader.getVouchermis().getFunction().getId() != null) {
                    bankEntryMis.setFunction(this.functionDAO.getFunctionById(voucherHeader.getVouchermis().getFunction().getId()));
                }
                if (voucherHeader.getVouchermis().getDepartmentid() != null) {
                    bankEntryMis.setDepartment(this.departmentService.getDepartmentById(voucherHeader.getVouchermis().getDepartmentid().getId()));
                }
                if (voucherHeader.getFundId() != null) {
                    bankEntryMis.setFund(this.fundDAO.fundById(voucherHeader.getFundId().getId(), false));
                }
                if (voucherHeader.getVouchermis().getSchemeid() != null) {
                    bankEntryMis.setScheme(this.schemeDAO.findById((Number)voucherHeader.getVouchermis().getSchemeid().getId(), false));
                }
                if (voucherHeader.getVouchermis().getSubschemeid() != null) {
                    bankEntryMis.setSubscheme(this.subSchemeDAO.findById((Number)voucherHeader.getVouchermis().getSubschemeid().getId(), false));
                }
                if (voucherHeader.getVouchermis().getFundsource() != null) {
                    bankEntryMis.setFundsource(this.fundSourceDAO.findById((Number)voucherHeader.getVouchermis().getFundsource().getId(), false));
                }
                if (voucherHeader.getVouchermis().getFunctionary() != null) {
                    bankEntryMis.setFunctionary(this.functionaryDAO.findById((Number)voucherHeader.getVouchermis().getFunctionary().getId(), false));
                }
                bankEntryMis.setBankentries(bankEntry);
                bankEntry.getBankentriesMis().add(bankEntryMis);
                if (bankEntriesNotInBankBook.getCreateVoucher() != null && bankEntriesNotInBankBook.getCreateVoucher().booleanValue()) {
                    bankEntry.setVoucherHeaderId(this.createVoucher(voucherHeader, bankEntriesNotInBankBook, bankAccount, coa));
                }
                bankEntries.add(bankEntry);
            }
            for (BrsEntries brsEntries : bankEntries) {
                this.bankEntriesService.persist((Object)brsEntries);
            }
        }
        catch (ValidationException e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
    }

    @Transactional
    public CVoucherHeader createVoucher(CVoucherHeader voucherHeader, BankEntriesNotInBankBook object, Bankaccount account, CChartOfAccounts coa) {
        voucherHeader.setName("JVGeneral");
        voucherHeader.setType("Journal Voucher");
        voucherHeader.setVoucherDate(object.getDate());
        HashMap<String, Object> headerDetails = this.createHeaderAndMisDetails(voucherHeader);
        ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> subledgerdetails = new ArrayList<HashMap<String, Object>>();
        CVoucherHeader voucher = new CVoucherHeader();
        try {
            HashMap<String, Object> detailMap = null;
            detailMap = new HashMap<String, Object>();
            detailMap.put("glcode", coa.getGlcode());
            if (object.getType().equals("Receipt")) {
                detailMap.put("debitamount", BigDecimal.ZERO);
                detailMap.put("creditamount", object.getAmount());
            } else {
                detailMap.put("debitamount", object.getAmount());
                detailMap.put("creditamount", BigDecimal.ZERO);
            }
            accountdetails.add(detailMap);
            detailMap = new HashMap();
            detailMap.put("glcode", account.getChartofaccounts().getGlcode());
            if (object.getType().equals("Receipt")) {
                detailMap.put("debitamount", object.getAmount());
                detailMap.put("creditamount", BigDecimal.ZERO);
            } else {
                detailMap.put("debitamount", BigDecimal.ZERO);
                detailMap.put("creditamount", object.getAmount());
            }
            accountdetails.add(detailMap);
            voucher = this.createVoucher.createVoucher(headerDetails, accountdetails, subledgerdetails);
            voucher.setStatus(Integer.valueOf(0));
            this.voucherHeaderService.applyAuditing((AbstractAuditable)voucher);
            this.voucherHeaderService.persist(voucher);
        }
        catch (ValidationException e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)e.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return voucher;
    }

    protected HashMap<String, Object> createHeaderAndMisDetails(CVoucherHeader voucherHeader) throws ValidationException {
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", voucherHeader.getName());
        headerdetails.put("vouchertype", voucherHeader.getType());
        headerdetails.put((String)VoucherConstant.VOUCHERSUBTYPE, voucherHeader.getVoucherSubType());
        headerdetails.put("vouchernumber", voucherHeader.getVoucherNumber());
        headerdetails.put("voucherdate", voucherHeader.getVoucherDate());
        headerdetails.put("description", voucherHeader.getDescription());
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            headerdetails.put("departmentcode", voucherHeader.getVouchermis().getDepartmentid().getCode());
        }
        if (voucherHeader.getFundId() != null) {
            headerdetails.put("fundcode", voucherHeader.getFundId().getCode());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            headerdetails.put("schemecode", voucherHeader.getVouchermis().getSchemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            headerdetails.put("subschemecode", voucherHeader.getVouchermis().getSubschemeid().getCode());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            headerdetails.put("fundsourcecode", voucherHeader.getVouchermis().getFundsource().getCode());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            headerdetails.put("divisionid", voucherHeader.getVouchermis().getDivisionid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            headerdetails.put("functionarycode", voucherHeader.getVouchermis().getFunctionary().getCode());
        }
        if (voucherHeader.getVouchermis().getFunction() != null) {
            headerdetails.put("functioncode", voucherHeader.getVouchermis().getFunction().getCode());
        }
        return headerdetails;
    }
}

