/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.recoveries;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.EgPartytype;
import org.egov.commons.EgwTypeOfWork;
import org.egov.dao.recoveries.EgDeductionDetailsHibernateDAO;
import org.egov.dao.recoveries.TdsHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.recoveries.EgDeductionDetails;
import org.egov.model.recoveries.Recovery;
import org.egov.utils.Constants;

public class RecoveryService
extends PersistenceService<Recovery, Long> {
    private EgDeductionDetailsHibernateDAO egDeductionDetHibernateDao;
    private TdsHibernateDAO tdsHibernateDAO;
    private static final Logger LOGGER = Logger.getLogger(RecoveryService.class);
    private static final String EMPTY_STRING = "";

    public RecoveryService(Class<Recovery> recovery) {
        this.type = recovery;
    }

    public Recovery getTdsById(Long tdsId) {
        return this.tdsHibernateDAO.findById(tdsId, false);
    }

    public List<Recovery> findByEstDate(String estimateDate) throws ApplicationRuntimeException {
        try {
            return this.tdsHibernateDAO.findByEstDate(estimateDate);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception in searching Tds by estimate Date" + e.getMessage(), (Throwable)e);
        }
    }

    public Recovery getTdsByType(String type) {
        return this.tdsHibernateDAO.getTdsByType(type);
    }

    public List<Recovery> getAllTdsByPartyType(String partyType) {
        return this.tdsHibernateDAO.getAllTdsByPartyType(partyType);
    }

    public List getAllTds() {
        return this.tdsHibernateDAO.getAllTds();
    }

    public void createTds(Recovery tds) {
        this.tdsHibernateDAO.create(tds);
    }

    public void updateTds(Recovery tds) {
        this.tdsHibernateDAO.update(tds);
    }

    public Recovery findById(Long id) {
        return this.tdsHibernateDAO.findById(id, false);
    }

    public EgDeductionDetails getEgDeductionDetailsById(Integer deductionId) {
        return this.egDeductionDetHibernateDao.findById(deductionId, false);
    }

    public void createEgDeductionDetails(EgDeductionDetails egDeductionDetails) {
        this.egDeductionDetHibernateDao.create(egDeductionDetails);
    }

    public void updateEgDeductionDetails(EgDeductionDetails egDeductionDetails) {
        this.egDeductionDetHibernateDao.update(egDeductionDetails);
    }

    public void deleteEgDeductionDetails(EgDeductionDetails egDeductionDetails) {
        try {
            this.egDeductionDetHibernateDao.delete(egDeductionDetails);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception in Deleting EgDeductionDetails." + e.getMessage(), (Throwable)e);
        }
    }

    public List<EgDeductionDetails> findByTds(Recovery tds) {
        return this.egDeductionDetHibernateDao.findByTds(tds);
    }

    public List<Recovery> getAllActiveTds() {
        return this.tdsHibernateDAO.getAllActiveTds();
    }

    public List<Recovery> getAllActiveAutoRemitTds() {
        return this.tdsHibernateDAO.getAllActiveAutoRemitTds();
    }

    public List<Recovery> getActiveTdsFilterBy(String estimateDate, BigDecimal estCost, EgPartytype egPartytype, EgwTypeOfWork egwTypeOfWork, EgwTypeOfWork egwSubTypeOfWork) {
        return this.tdsHibernateDAO.getActiveTdsFilterBy(estimateDate, estCost, egPartytype, egwTypeOfWork, egwSubTypeOfWork);
    }

    public List<EgDeductionDetails> getEgDeductionDetailsFilterBy(Recovery tds, BigDecimal amount, String date, EgwTypeOfWork egwTypeOfWork, EgwTypeOfWork egwSubTypeOfWork) {
        return this.egDeductionDetHibernateDao.getEgDeductionDetailsFilterBy(tds, amount, date, egwTypeOfWork, egwSubTypeOfWork);
    }

    public List<Recovery> recoveryForPartyContractor(Date asOndate) throws ValidationException {
        return this.tdsHibernateDAO.recoveryForPartyContractor(asOndate);
    }

    public void setEgDeductionDetHibernateDao(EgDeductionDetailsHibernateDAO egDeductionDetHibernateDao) {
        this.egDeductionDetHibernateDao = egDeductionDetHibernateDao;
    }

    public void setTdsHibernateDAO(TdsHibernateDAO tdsHibernateDAO) {
        this.tdsHibernateDAO = tdsHibernateDAO;
    }

    public EgPartytype getPartytypeByCode(String code) {
        return this.tdsHibernateDAO.getPartytypeByCode(code);
    }

    public EgwTypeOfWork getTypeOfWorkByCode(String code) {
        return this.tdsHibernateDAO.getTypeOfWorkByCode(code);
    }

    public EgPartytype getSubPartytypeByCode(String code) {
        return this.tdsHibernateDAO.getSubPartytypeByCode(code);
    }

    public Recovery getTdsByTypeAndPartyType(String type, EgPartytype egPartytype) {
        return this.tdsHibernateDAO.getTdsByTypeAndPartyType(type, egPartytype);
    }

    public BigDecimal getDeductionAmount(String recoveryCode, String partyType, String subPartyType, String docType, BigDecimal grossAmount, Date asOnDate) throws Exception {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
        BigDecimal incomeTax = new BigDecimal(0);
        BigDecimal surcharge = new BigDecimal(0);
        BigDecimal education = new BigDecimal(0);
        BigDecimal total = new BigDecimal(0);
        BigDecimal deductionAmt = new BigDecimal(0);
        EgDeductionDetails egDeductionDetails = null;
        if (null == recoveryCode || recoveryCode.trim().equals(EMPTY_STRING)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Recovery Code is missing");
            }
            throw new ValidationException(EMPTY_STRING, "Recovery Code is missing", new String[0]);
        }
        if (null == partyType || partyType.trim().equals(EMPTY_STRING)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Party Type is missing");
            }
            throw new ValidationException(EMPTY_STRING, "Party Type is missing", new String[0]);
        }
        if (null == grossAmount) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Gross Amount is missing");
            }
            throw new ValidationException(EMPTY_STRING, "Gross Amount is missing", new String[0]);
        }
        if (null == asOnDate) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"AsOnDate is missing");
            }
            throw new ValidationException(EMPTY_STRING, "AsOnDate is missing", new String[0]);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getDeductionAmount() -> recoveryCode :" + recoveryCode + " | partyType :" + partyType + " | grossAmount :" + grossAmount + " | asOnDate :" + dateFormatter.format(asOnDate) + " | docType :" + docType));
        }
        EgwTypeOfWork egwTypeOfWork = null;
        EgPartytype egSubPartytype = null;
        EgPartytype egPartytype = this.getPartytypeByCode(partyType);
        Recovery recovery = this.getTdsByTypeAndPartyType(recoveryCode, egPartytype);
        if (recovery == null) {
            throw new ValidationException(EMPTY_STRING, "Recovery with " + recoveryCode + " code  and " + egPartytype + " party type is invalid.", new String[0]);
        }
        if (recovery.getRecoveryMode().charValue() == 'M') {
            return BigDecimal.valueOf(-1L);
        }
        if (null != docType) {
            egwTypeOfWork = this.getTypeOfWorkByCode(docType);
        }
        if (null != subPartyType) {
            egSubPartytype = this.getSubPartytypeByCode(subPartyType);
        }
        try {
            egDeductionDetails = this.egDeductionDetHibernateDao.findEgDeductionDetailsForDeduAmt(recovery, egPartytype, egSubPartytype, egwTypeOfWork, asOnDate);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in egDeductionDetails fetching :" + e));
            throw new ValidationException(EMPTY_STRING, "Error while fetching the date for this " + recoveryCode + " code for this " + dateFormatter.format(asOnDate) + " date. " + e.getMessage(), new String[0]);
        }
        if (null == egDeductionDetails) {
            throw new ValidationException(EMPTY_STRING, "There is no data for this " + recoveryCode + " code for this " + dateFormatter.format(asOnDate) + " date.", new String[0]);
        }
        if (null != recovery.getCalculationType() && recovery.getCalculationType().equalsIgnoreCase("flat")) {
            if (null != egDeductionDetails.getFlatAmount()) {
                deductionAmt = egDeductionDetails.getFlatAmount();
            }
        } else {
            if (null != egDeductionDetails.getIncometax()) {
                incomeTax = egDeductionDetails.getIncometax();
            }
            if (null != egDeductionDetails.getSurcharge()) {
                surcharge = egDeductionDetails.getSurcharge();
            }
            if (null != egDeductionDetails.getEducation()) {
                education = egDeductionDetails.getEducation();
            }
            total = incomeTax.add(surcharge).add(education);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("total IT/SC/EC " + total));
            }
            deductionAmt = grossAmount.multiply(total.divide(new BigDecimal(100)));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("deductionAmt :" + deductionAmt));
        }
        deductionAmt = deductionAmt.setScale(2, 4);
        return deductionAmt;
    }
}

