/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.instrument;

import java.util.Date;
import org.apache.log4j.Logger;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.DishonorCheque;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EisUtilService;
import org.egov.services.instrument.FinancialIntegrationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class DishonorChequeService
extends PersistenceService<DishonorCheque, Long> {
    private static final Logger LOGGER = Logger.getLogger((String)"DishonorChequeService.class");
    private SimpleWorkflowService<DishonorCheque> dishonorChqWorkflowService;
    private EisUtilService eisService;
    private FinancialIntegrationService financialIntegrationService;

    public DishonorCheque approve(DishonorCheque dishonorChq, String workFlowAction, String approverComments) {
        this.startWorkflow(dishonorChq, workFlowAction, approverComments);
        return dishonorChq;
    }

    public void startWorkflow(DishonorCheque dishonorCheque, String workFlowAction, String approverComments) {
        if (null == dishonorCheque.getState()) {
            Position pos = this.eisService.getPrimaryPositionForUser(Long.valueOf(dishonorCheque.getPayinSlipCreator().longValue()), new Date());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)(pos.getName() + "" + pos.getId()));
            }
            if (null != this.financialIntegrationService) {
                this.financialIntegrationService.updateSourceInstrumentVoucher("INSTRUMENT_DISHONOR_INITIATED", dishonorCheque.getInstrumentHeader().getId());
            }
            dishonorCheque.start().withOwner(pos).withComments("DishonorCheque Work flow started");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("---------" + (Object)((Object)dishonorCheque)));
            }
            this.dishonorChqWorkflowService.transition("forward", (StateAware)dishonorCheque, "Created by SM");
        }
        if (null != workFlowAction && !"".equals(workFlowAction)) {
            String comments = null == approverComments || "".equals(approverComments.trim()) ? "" : approverComments;
            this.dishonorChqWorkflowService.transition(workFlowAction.toLowerCase(), (StateAware)dishonorCheque, comments);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.error((Object)("---------" + dishonorCheque.getState().getId()));
        }
    }

    public SimpleWorkflowService<DishonorCheque> getDishonorChqWorkflowService() {
        return this.dishonorChqWorkflowService;
    }

    public void setDishonorChqWorkflowService(SimpleWorkflowService<DishonorCheque> dishonorChqWorkflowService) {
        this.dishonorChqWorkflowService = dishonorChqWorkflowService;
    }

    public EisUtilService getEisService() {
        return this.eisService;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public FinancialIntegrationService getFinancialIntegrationService() {
        return this.financialIntegrationService;
    }

    public void setFinancialIntegrationService(FinancialIntegrationService financialIntegrationService) {
        this.financialIntegrationService = financialIntegrationService;
    }
}

