/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.deduction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.deduction.model.EgRemittance;
import org.egov.deduction.model.EgRemittanceDetail;
import org.egov.deduction.model.EgRemittanceGldtl;
import org.egov.eis.entity.DrawingOfficer;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.Miscbilldetail;
import org.egov.model.deduction.AutoRemittanceBean;
import org.egov.model.payment.Paymentheader;
import org.egov.model.recoveries.Recovery;
import org.egov.model.recoveries.RemittanceSchedulePayment;
import org.egov.model.recoveries.RemittanceSchedulerLog;
import org.egov.pims.commons.Position;
import org.egov.services.deduction.RemittancePersistenceService;
import org.egov.services.payment.PaymentService;
import org.egov.services.recoveries.RecoveryService;
import org.egov.utils.FinancialConstants;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.DoubleType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ScheduledRemittanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledRemittanceService.class);
    private static final int fundIndex = 0;
    private static final int bankAccountIdIndex = 1;
    private static final int detailTypeIndex = 2;
    private static final int detailKeyIndex = 3;
    private Map<Integer, String> fundMap;
    private Map<Integer, String> deptMap;
    private Map<Integer, Integer> deptDOMap;
    private Map<String, Integer> receiptBankAccountMap;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    CreateVoucher createVoucher;
    private FinancialYearDAO financialYearDAO;
    private RecoveryService recoveryService;
    private PersistenceService<EgRemittanceGldtl, Integer> egRemittancegldtlService;
    private RemittancePersistenceService remittancePersistenceService;
    private PaymentService paymentService;
    private PersistenceService<RemittanceSchedulerLog, Integer> remittanceSchedulerLogService;
    private SimpleWorkflowService<Paymentheader> paymentWorkflowService;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
    private List<String> receiptFundCodes;
    private EisCommonService eisCommonService;
    private HashMap<String, Integer> GJVBankAccountMap;
    private ArrayList<String> GJVFundCodes;
    private java.util.Date startDate;
    private final java.util.Date today = new java.util.Date();
    private String glcode;
    private String jobName;
    private java.util.Date lastRunDate;
    private StringBuffer errorMessage = new StringBuffer(1024);
    private Recovery recovery;
    private Map<String, List<AutoRemittanceBean>> voucherGroupMap = new HashMap<String, List<AutoRemittanceBean>>();
    Map<String, Double> detailKeyGroupeMap = new HashMap<String, Double>();
    private List<AutoRemittanceBean> recoveries;
    String remitted;
    private boolean isControlCode = true;
    private Long schedularLogId;
    private boolean successForAutoRemittance = true;
    private User user;
    private Position nextOwner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchRecovery(String recoveryGlcode, String recoveryjobName, Long recoverySchedularLogId, Integer deptId, java.util.Date recoverylastRunDate) {
        this.glcode = recoveryGlcode;
        this.jobName = recoveryjobName;
        this.lastRunDate = recoverylastRunDate;
        this.schedularLogId = recoverySchedularLogId;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting job :{} with glcode {} on {} " + this.jobName, (Object)this.glcode, (Object)new java.util.Date().toString());
        }
        try {
            this.loadCommonData();
            this.validate(this.glcode);
            new java.util.Date();
            this.recovery = (Recovery)((Object)this.recoveryService.find("from Recovery where chartofaccounts.glcode=" + this.glcode));
            if (this.recovery == null) {
                LOGGER.error("glcode is not mapped to tds :" + this.glcode + "\n");
                throw new ApplicationRuntimeException("glcode is not mapped to tds  : " + this.glcode);
            }
            this.remitted = this.recovery.getRemitted();
            List coads = this.remittancePersistenceService.getPersistenceService().findAllBy("from CChartOfAccountDetail where glcodeId=?", new Object[]{this.recovery.getChartofaccounts()});
            if (coads == null || coads.size() == 0) {
                this.isControlCode = false;
            }
            for (Integer dept : this.deptMap.keySet()) {
                DrawingOfficer drawingOfficer;
                if (deptId != null && !dept.equals(deptId)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("**********************************************");
                    LOGGER.debug("Starting for Department :" + this.deptMap.get(dept));
                }
                if ((drawingOfficer = this.validateDrawingOfficer(this.errorMessage, dept)) == null) continue;
                this.detailKeyGroupeMap = new HashMap<String, Double>();
                this.voucherGroupMap = new HashMap<String, List<AutoRemittanceBean>>();
                if (!this.isControlCode) {
                    this.recoveries = this.searchNonControlCodeRecoveryByCOA(dept);
                    if (this.recoveries.isEmpty()) {
                        this.errorMessage.append("  No Recoveries found for " + this.deptMap.get(dept) + "\n");
                        continue;
                    }
                    this.createRemittanceForNonControlCodeRecovery(dept, drawingOfficer);
                    continue;
                }
                this.recoveries = this.searchRecoveryByCOA(dept);
                if (this.recoveries.isEmpty()) {
                    this.errorMessage.append("  No Recoveries found for " + this.deptMap.get(dept) + "\n");
                    continue;
                }
                String voucherCombination = null;
                String detailKeyCombination = null;
                for (AutoRemittanceBean bean : this.recoveries) {
                    if (bean.getBankAccountId() == 0) {
                        bean.setBankAccountId(this.receiptBankAccountMap.get(this.fundMap.get(bean.getFundId())));
                    } else if (bean.getBankAccountId() == -1) {
                        bean.setBankAccountId(this.GJVBankAccountMap.get(this.fundMap.get(bean.getFundId())));
                    }
                    voucherCombination = bean.getFundId() + "-" + bean.getBankAccountId();
                    detailKeyCombination = voucherCombination + "-" + bean.getDetailtypeId() + "-" + bean.getDetailkeyId();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(bean.toString());
                        LOGGER.debug("detailKeyCombination:" + detailKeyCombination);
                    }
                    if (this.voucherGroupMap.get(voucherCombination) == null) {
                        this.voucherGroupMap.put(voucherCombination, new ArrayList());
                        this.voucherGroupMap.get(voucherCombination).add(bean);
                    } else {
                        this.voucherGroupMap.get(voucherCombination).add(bean);
                    }
                    if (this.detailKeyGroupeMap.get(detailKeyCombination) == null) {
                        this.detailKeyGroupeMap.put(detailKeyCombination, bean.getPendingAmount());
                        continue;
                    }
                    this.detailKeyGroupeMap.put(detailKeyCombination, this.detailKeyGroupeMap.get(detailKeyCombination) + bean.getPendingAmount());
                }
                for (String voucher : this.voucherGroupMap.keySet()) {
                    try {
                        Bankaccount ba;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(" Starting for VoucherCombination :" + voucher);
                        }
                        if ((ba = (Bankaccount)this.remittancePersistenceService.getPersistenceService().find(" from  Bankaccount where id=" + Integer.parseInt(voucher.split("-")[1]) + "")) == null) {
                            LOGGER.error("Bank Glcode for fundId " + this.fundMap.get(Integer.parseInt(voucher.split("-")[0])) + " ,recoverId:" + this.recovery.getType() + " not found");
                            this.errorMessage.append("Bank Glcode for fundId " + this.fundMap.get(Integer.parseInt(voucher.split("-")[0])) + " ,recoverId:" + this.recovery.getType() + " not found \n");
                            continue;
                        }
                        CVoucherHeader voucherHeader = this.createPayment(dept, voucher, drawingOfficer, ba);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("VoucherCreated :" + voucherHeader.getVoucherNumber());
                        }
                        List<Integer> glIds = this.createRemittance(voucher, voucherHeader);
                        this.updateRemittancedateInLeddger(glIds);
                        this.updateScheduleLogDetail(voucherHeader, this.schedularLogId);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(" Remittance Created SuccessFully for " + voucher);
                        }
                        this.persistenceService.getSession().flush();
                        this.persistenceService.getSession().clear();
                    }
                    catch (ValidationException e) {
                        this.errorMessage.append(dept + ":" + e.getErrors().toString() + "\n");
                        this.successForAutoRemittance = false;
                    }
                    catch (Exception e) {
                        this.errorMessage.append(dept + ":" + e.getMessage() + "\n");
                        this.successForAutoRemittance = false;
                    }
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Done for Department :" + this.deptMap.get(dept));
                LOGGER.debug("**********************************************");
            }
        }
        catch (ValidationException ve) {
            this.successForAutoRemittance = false;
            this.errorMessage.append(ve.getErrors().toString());
        }
        catch (ApplicationRuntimeException e) {
            this.successForAutoRemittance = false;
            this.errorMessage.append(e.getMessage() + "\n");
        }
        catch (Exception e) {
            this.successForAutoRemittance = false;
            this.errorMessage.append(e.getMessage() + "\n");
        }
        finally {
            this.updateScheduleLog(this.errorMessage.toString(), this.jobName, this.glcode, true, this.schedularLogId);
        }
        return this.successForAutoRemittance;
    }

    private boolean createRemittanceForNonControlCodeRecovery(Integer dept, DrawingOfficer drawingOfficer) {
        String voucherCombination = null;
        for (AutoRemittanceBean bean : this.recoveries) {
            if (bean.getBankAccountId() == 0) {
                bean.setBankAccountId(this.receiptBankAccountMap.get(this.fundMap.get(bean.getFundId())));
            } else if (bean.getBankAccountId() == -1) {
                bean.setBankAccountId(this.GJVBankAccountMap.get(this.fundMap.get(bean.getFundId())));
            }
            voucherCombination = bean.getFundId() + "-" + bean.getBankAccountId();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(bean.toString());
                LOGGER.debug("voucherCombination:" + voucherCombination);
            }
            if (this.voucherGroupMap.get(voucherCombination) == null) {
                this.voucherGroupMap.put(voucherCombination, new ArrayList());
                this.voucherGroupMap.get(voucherCombination).add(bean);
                continue;
            }
            this.voucherGroupMap.get(voucherCombination).add(bean);
        }
        for (String voucher : this.voucherGroupMap.keySet()) {
            try {
                Bankaccount ba;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(" Starting for VoucherCombination :" + voucher);
                }
                if ((ba = (Bankaccount)this.remittancePersistenceService.getPersistenceService().find(" from  Bankaccount where id=" + Integer.parseInt(voucher.split("-")[1]) + "")) == null) {
                    LOGGER.error("Bank Glcode for fundId " + this.fundMap.get(Integer.parseInt(voucher.split("-")[0])) + " ,recoverId:" + this.recovery.getType() + " not found");
                    this.errorMessage.append("Bank Glcode for fundId " + this.fundMap.get(Integer.parseInt(voucher.split("-")[0])) + " ,recoverId:" + this.recovery.getType() + " not found \n");
                    continue;
                }
                CVoucherHeader voucherHeader = this.createPayment(dept, voucher, drawingOfficer, ba);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("VoucherCreated :" + voucherHeader.getVoucherNumber());
                }
                List<Integer> glIds = this.createRemittance(voucher, voucherHeader);
                this.updateRemittancedateInLeddger(glIds);
                this.updateScheduleLogDetail(voucherHeader, this.schedularLogId);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(" Remittance Created SuccessFully for " + voucher);
                }
                this.persistenceService.getSession().flush();
                this.persistenceService.getSession().clear();
            }
            catch (ValidationException e) {
                this.errorMessage.append(dept + ":" + e.getErrors() + "\n");
            }
            catch (Exception e) {
                this.errorMessage.append(dept + ":" + e.getMessage() + "\n");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Done for Department :" + this.deptMap.get(dept));
            LOGGER.debug("**********************************************");
        }
        return true;
    }

    private List<AutoRemittanceBean> getNonControleCodeReceiptRecoveries(Integer dept, int bankaccount) {
        StringBuffer qry = new StringBuffer(2048);
        qry.append(" SELECT DISTINCT gl.id AS generalledgerId,  vh.fundid  AS fundId,  gl.debitAmount      AS gldtlAmount, " + bankaccount + " AS bankAccountId  " + " FROM VOUCHERHEADER vh ,  VOUCHERMIS mis,  GENERALLEDGER gl ,  VOUCHERHEADER payinslip,fund f,  " + " EGF_INSTRUMENTHEADER ih,EGF_INSTRUMENTOTHERDETAILS io , egcl_collectionvoucher cv,egcl_collectioninstrument ci, TDS recovery " + " WHERE  recovery.GLCODEID =gl.GLCODEID  AND vh.ID =gl.VOUCHERHEADERID" + " AND gl.remittanceDate    IS NULL AND mis.VOUCHERHEADERID   =vh.ID AND vh.STATUS =0 and vh.fundid=f.id " + " AND io.payinslipid =payinslip.id and io.instrumentheaderid=ih.id " + " and cv.voucherheaderid= vh.id and ci.collectionheaderid= cv.collectionheaderid and ci.instrumentmasterid= ih.id " + " and payinslip.status=0 AND ih.id_status NOT     IN  (" + " select id from egw_status where moduletype='Instrument' and  description in ('" + "Cancelled" + "','" + "Surrendered" + "','" + "Surrender_For_Reassign" + "') )" + " AND recovery.ID      =" + this.recovery.getId() + " AND payinslip.voucherdate    >= :startdate  ");
        if (this.lastRunDate != null) {
            qry.append(" and  payinslip.voucherdate    <= :lastrundate");
        }
        if (this.receiptFundCodes != null && !this.receiptFundCodes.isEmpty()) {
            qry.append(" and  f.code in (:fundCodes) ");
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(qry.toString());
        query.addScalar("generalledgerId", (Type)IntegerType.INSTANCE).addScalar("fundId", (Type)IntegerType.INSTANCE).addScalar("gldtlAmount", (Type)DoubleType.INSTANCE).addScalar("bankAccountId", (Type)IntegerType.INSTANCE);
        if (this.lastRunDate != null) {
            query.setDate("lastrundate", (java.util.Date)new Date(this.lastRunDate.getTime()));
        }
        if (this.startDate != null) {
            query.setDate("startdate", (java.util.Date)new Date(this.startDate.getTime()));
        }
        if (this.receiptFundCodes != null && !this.receiptFundCodes.isEmpty()) {
            query.setParameterList("fundCodes", this.receiptFundCodes);
        }
        query.setResultTransformer(Transformers.aliasToBean(AutoRemittanceBean.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ReceiptRecoveries query " + qry);
        }
        return query.list();
    }

    private DrawingOfficer validateDrawingOfficer(StringBuffer errorMessage, Integer dept) {
        if (this.deptDOMap.get(dept) == null) {
            LOGGER.error("Drawing officer Mapping Not found for department code " + this.deptMap.get(dept));
            errorMessage.append("Drawing officer Mapping Not found for department code " + this.deptMap.get(dept) + "\n");
            return null;
        }
        DrawingOfficer drawingOfficer1 = (DrawingOfficer)this.remittancePersistenceService.getPersistenceService().find("from DrawingOfficer where id=? ", new Object[]{(int)this.deptDOMap.get(dept)});
        if (drawingOfficer1.getTan() == null) {
            LOGGER.error("Drawing officer Mapping Not found for department code " + this.deptMap.get(dept));
            errorMessage.append("Drawing officer Mapping Not found for department code " + this.deptMap.get(dept) + "\n");
            return null;
        }
        return drawingOfficer1;
    }

    private void updateScheduleLogDetail(CVoucherHeader voucherHeader, Long schedularLogId) {
        RemittanceSchedulePayment rsPaymentLog = new RemittanceSchedulePayment();
        rsPaymentLog.setVoucherheaderId(voucherHeader);
        rsPaymentLog.setSchId((RemittanceSchedulerLog)this.persistenceService.getSession().load(RemittanceSchedulerLog.class, (Serializable)schedularLogId));
        this.persistenceService.getSession().save((Object)rsPaymentLog);
    }

    private void updateRemittancedateInLeddger(List<Integer> glIds) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting updateRemittancedateInLeddger with  " + glIds.size() + " glIds detailed as" + glIds);
        }
        int size = glIds.size();
        int suceessCount = 0;
        if (size <= 999) {
            SQLQuery glQuery = this.persistenceService.getSession().createSQLQuery("update generalledger set remittancedate=:date where id in (:glIds)");
            glQuery.setDate("date", (java.util.Date)new Date(new java.util.Date().getTime()));
            glQuery.setParameterList("glIds", glIds);
            suceessCount += glQuery.executeUpdate();
        } else {
            SQLQuery glQuery;
            int fromIndex = 0;
            int toIndex = 999;
            while (size % 1000 >= 1000) {
                glQuery = this.persistenceService.getSession().createSQLQuery("update generalledger set remittancedate=:date where id in (:glIds)");
                glQuery.setDate("date", (java.util.Date)new Date(new java.util.Date().getTime()));
                glQuery.setParameterList("glIds", glIds.subList(fromIndex, toIndex));
                suceessCount += glQuery.executeUpdate();
                fromIndex += 1000;
                toIndex += 1000;
                size -= 1000;
            }
            glQuery = this.persistenceService.getSession().createSQLQuery("update generalledger set remittancedate=:date where id in (:glIds)");
            glQuery.setDate("date", (java.util.Date)new Date(new java.util.Date().getTime()));
            glQuery.setParameterList("glIds", glIds.subList(toIndex + 1, size));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Completed updateRemittancedateInLeddger " + suceessCount);
        }
    }

    private void loadCommonData() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting loadCommonData");
        }
        if (this.deptMap == null) {
            this.deptMap = this.getDepartments();
        }
        if (this.fundMap == null) {
            this.fundMap = this.getFunds();
        }
        this.deptDOMap = this.getDOsForDepartment();
        this.loadReceiptBankAccounts();
        this.loadGJVbankAccounts();
        this.loadStartDate();
        this.loadNextOwner();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("loadCommonData Completed");
        }
    }

    private void loadNextOwner() {
        this.user = (User)this.remittancePersistenceService.getPersistenceService().find("from User where userName='ASSTBUDGET'");
        this.nextOwner = this.eisCommonService.getPositionByUserId(this.user.getId());
    }

    private void loadGJVbankAccounts() {
        try {
            this.GJVBankAccountMap = new HashMap();
            String value = "";
            List appConfigList = this.remittancePersistenceService.getPersistenceService().findAllBy("from AppConfig where key_name = 'AuoRemittance_Account_Number_For_GJV'", new Object[0]);
            if (appConfigList == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("AuoRemittance_Account_Number_For_GJV app config key not defined", "AuoRemittance_Account_Number_For_GJV app config key not defined")));
            }
            for (AppConfig appConfig : appConfigList) {
                for (AppConfigValues appConfigVal : appConfig.getAppDataValues()) {
                    value = appConfigVal.getValue();
                    List bankAcountsList = this.remittancePersistenceService.getPersistenceService().findAllBy("from Bankaccount ba where accountNumber=?", new Object[]{value.split("-")[1]});
                    if (bankAcountsList.size() == 1) {
                        this.GJVBankAccountMap.put(value.split("-")[0], ((Bankaccount)bankAcountsList.get(0)).getId().intValue());
                        continue;
                    }
                    throw new ValidationException(Arrays.asList(new ValidationError("AuoRemittance_Account_Number_For_Receipts app config value  does not return proper single account", "AuoRemittance_Account_Number_For_GJV app config value  does not return proper single account")));
                }
            }
            this.GJVFundCodes = new ArrayList();
            for (String s : this.GJVBankAccountMap.keySet()) {
                this.GJVFundCodes.add(s);
            }
            LOGGER.debug("Funds Mapped for GJVs:" + this.GJVFundCodes);
        }
        catch (NullPointerException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("AuoRemittance_Account_Number_For_GJV app config key not defined", "AuoRemittance_Account_Number_For_GJV app config key not defined")));
        }
    }

    private void loadReceiptBankAccounts() {
        try {
            this.receiptBankAccountMap = new HashMap<String, Integer>();
            String value = "";
            List appConfigList = this.remittancePersistenceService.getPersistenceService().findAllBy("from AppConfig where key_name = 'AuoRemittance_Account_Number_For_Receipts'", new Object[0]);
            if (appConfigList == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("AuoRemittance_Account_Number_For_Receipts app config key not defined", "AuoRemittance_Account_Number_For_Receipts app config key not defined")));
            }
            for (AppConfig appConfig : appConfigList) {
                for (AppConfigValues appConfigVal : appConfig.getAppDataValues()) {
                    value = appConfigVal.getValue();
                    List bankAcountsList = this.remittancePersistenceService.getPersistenceService().findAllBy("from Bankaccount ba where accountNumber=?", new Object[]{value.split("-")[1]});
                    if (bankAcountsList.size() == 1) {
                        this.receiptBankAccountMap.put(value.split("-")[0], ((Bankaccount)bankAcountsList.get(0)).getId().intValue());
                        continue;
                    }
                    throw new ValidationException(Arrays.asList(new ValidationError("AuoRemittance_Account_Number_For_Receipts app config value  does not return proper single account", "AuoRemittance_Account_Number_For_Receipts app config value  does not return proper single account")));
                }
            }
            this.receiptFundCodes = new ArrayList<String>();
            for (String s : this.receiptBankAccountMap.keySet()) {
                this.receiptFundCodes.add(s);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Funds Mapped for Receipts:" + this.receiptFundCodes);
            }
        }
        catch (NullPointerException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("AuoRemittance_Account_Number_For_Receipts app config key not defined", "AuoRemittance_Account_Number_For_Receipts app config key not defined")));
        }
    }

    private Map<Integer, Integer> getDOsForDepartment() {
        List list = this.persistenceService.getSession().createSQLQuery("select department_id,drawingofficer_id from eg_dept_do_mapping  order by  department_id").list();
        LinkedHashMap<Integer, Integer> deptMap = new LinkedHashMap<Integer, Integer>();
        for (Object[] dept : list) {
            BigDecimal id = (BigDecimal)dept[0];
            BigDecimal officer = (BigDecimal)dept[1];
            deptMap.put(id.intValue(), officer.intValue());
        }
        if (list == null || list.isEmpty()) {
            throw new ValidationException(Arrays.asList(new ValidationError("Department Drawing officer not found", "Department Drawing officer not found")));
        }
        return deptMap;
    }

    private Map<Integer, String> getDepartments() {
        List list = this.persistenceService.getSession().createSQLQuery("select id_dept,dept_Code from eg_department  order by dept_Code").list();
        LinkedHashMap<Integer, String> deptMap = new LinkedHashMap<Integer, String>();
        for (Object[] dept : list) {
            BigDecimal id = (BigDecimal)dept[0];
            deptMap.put(id.intValue(), (String)dept[1]);
        }
        return deptMap;
    }

    private void validate(String glcode) {
    }

    private void updateScheduleLog(String message, String jobName, String glcode, boolean success, Long schedularLogId) {
        RemittanceSchedulerLog record = (RemittanceSchedulerLog)this.persistenceService.getSession().load(RemittanceSchedulerLog.class, (Serializable)schedularLogId);
        record.setGlcode(glcode);
        record.setLastRunDate(new java.util.Date());
        if (success) {
            record.setStatus("success");
        } else {
            record.setStatus("failure");
        }
        if (jobName != null && jobName.equalsIgnoreCase("Manual")) {
            record.setSchType(FinancialConstants.REMITTANCE_SCHEDULER_SCHEDULAR_TYPE_MANUAL);
        } else {
            record.setSchType(FinancialConstants.REMITTANCE_SCHEDULER_SCHEDULAR_TYPE_AUTO);
        }
        record.setRemarks(message);
        record.setSchJobName(jobName);
        record.setCreatedDate(new java.util.Date());
        record.setCreatedBy(ApplicationThreadLocals.getUserId().intValue());
        this.remittanceSchedulerLogService.persist((Object)record);
    }

    private List<Integer> createRemittance(String voucher, CVoucherHeader voucherHeader) {
        ArrayList<Integer> glIds = new ArrayList<Integer>();
        EgRemittance remit = new EgRemittance();
        remit.setFund(voucherHeader.getFundId());
        remit.setRecovery(this.recovery);
        CFinancialYear financialYearByDate = this.financialYearDAO.getFinancialYearByDate(voucherHeader.getVoucherDate());
        remit.setFinancialyear(financialYearByDate);
        remit.setCreateddate(this.today);
        remit.setCreatedby(BigDecimal.valueOf(ApplicationThreadLocals.getUserId()));
        remit.setLastmodifiedby(BigDecimal.valueOf(ApplicationThreadLocals.getUserId()));
        remit.setLastmodifieddate(this.today);
        remit.setMonth(BigDecimal.valueOf(this.today.getMonth()));
        remit.setVoucherheader(voucherHeader);
        remit.setAsOnDate(voucherHeader.getVoucherDate());
        HashSet<EgRemittanceDetail> egRemittanceDetail = new HashSet<EgRemittanceDetail>();
        EgRemittanceDetail remitDetail = null;
        int count = 0;
        for (AutoRemittanceBean bean : this.voucherGroupMap.get(voucher)) {
            remitDetail = new EgRemittanceDetail();
            remitDetail.setEgRemittance(remit);
            remitDetail.setRemittedamt(BigDecimal.valueOf(bean.getPendingAmount()));
            remitDetail.setLastmodifieddate(this.today);
            if (this.isControlCode) {
                EgRemittanceGldtl remittancegldtl = (EgRemittanceGldtl)this.egRemittancegldtlService.getSession().load(EgRemittanceGldtl.class, (Serializable)Integer.valueOf(bean.getRemittanceGldtlId()));
                remittancegldtl.setRemittedamt(BigDecimal.valueOf(bean.getGldtlAmount()));
                remitDetail.setEgRemittanceGldtl(remittancegldtl);
            } else {
                remitDetail.setGeneralLedger((CGeneralLedger)this.remittancePersistenceService.getSession().load(CGeneralLedger.class, (Serializable)Long.valueOf(bean.getGeneralledgerId())));
                remitDetail.setRemittedamt(BigDecimal.valueOf(bean.getGldtlAmount()));
            }
            egRemittanceDetail.add(remitDetail);
            glIds.add(bean.getGeneralledgerId());
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("No of remittance Items added. You can see if the transaction is getting slower here " + ++count);
        }
        remit.setEgRemittanceDetail(egRemittanceDetail);
        this.remittancePersistenceService.persist(remit);
        return glIds;
    }

    private CVoucherHeader createPayment(Integer dept, String voucher, DrawingOfficer drawingOfficer, Bankaccount ba) {
        double totalAmount = 0.0;
        HashMap<String, Object> subledgertDetailMap = null;
        HashMap<String, Object> detailMap = null;
        ArrayList<HashMap<String, Object>> accountdetails = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> subledgerDetails = new ArrayList<HashMap<String, Object>>();
        detailMap = new HashMap<String, Object>();
        if (!this.isControlCode) {
            List<AutoRemittanceBean> uniquelist = this.voucherGroupMap.get(voucher);
            Iterator iterator = uniquelist.iterator();
            while (iterator.hasNext()) {
                AutoRemittanceBean bean = (AutoRemittanceBean)iterator.next();
                totalAmount += bean.getGldtlAmount();
            }
        } else {
            for (String detail : this.detailKeyGroupeMap.keySet()) {
                if (!detail.startsWith(voucher)) continue;
                totalAmount += this.detailKeyGroupeMap.get(detail).doubleValue();
                String[] split = detail.split("-");
                subledgertDetailMap = new HashMap<String, Object>();
                subledgertDetailMap.put("detailtypeid", split[2]);
                subledgertDetailMap.put("detailkeyid", split[3]);
                subledgertDetailMap.put("glcode", this.glcode);
                subledgertDetailMap.put("debitamount", this.detailKeyGroupeMap.get(detail));
                subledgerDetails.add(subledgertDetailMap);
            }
        }
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", "Remittance Payment");
        headerdetails.put("vouchertype", "Payment");
        headerdetails.put("voucherdate", this.today);
        headerdetails.put("departmentcode", this.deptMap.get(dept));
        headerdetails.put("fundcode", this.fundMap.get(Integer.parseInt(voucher.split("-")[0])));
        detailMap = new HashMap();
        detailMap.put("creditamount", 0);
        detailMap.put("debitamount", totalAmount);
        detailMap.put("glcode", this.glcode);
        accountdetails.add(detailMap);
        detailMap = new HashMap();
        detailMap.put("creditamount", totalAmount);
        detailMap.put("debitamount", 0);
        detailMap.put("glcode", ba.getChartofaccounts().getGlcode());
        accountdetails.add(detailMap);
        CVoucherHeader voucherHeader = this.createVoucher.createPreApprovedVoucher(headerdetails, accountdetails, subledgerDetails);
        Paymentheader ph = new Paymentheader();
        ph.setVoucherheader(voucherHeader);
        ph.setBankaccount(ba);
        ph.setPaymentAmount(BigDecimal.valueOf(totalAmount));
        ph.setType("rtgs");
        ph.setDrawingOfficer(drawingOfficer);
        this.paymentService.persist(ph);
        Miscbilldetail miscbillDetail = new Miscbilldetail();
        miscbillDetail.setBillamount(BigDecimal.valueOf(totalAmount));
        miscbillDetail.setPaidamount(BigDecimal.valueOf(totalAmount));
        miscbillDetail.setPassedamount(BigDecimal.valueOf(totalAmount));
        miscbillDetail.setPayVoucherHeader(voucherHeader);
        miscbillDetail.setPaidto(this.remitted);
        this.persistenceService.getSession().save((Object)miscbillDetail);
        ph.start().withOwner(this.nextOwner);
        this.paymentWorkflowService.transition("uac_ao_approve|" + this.user.getId(), (StateAware)ph, "created from schedular");
        return voucherHeader;
    }

    private Map<Integer, String> getFunds() {
        List list = this.persistenceService.getSession().createSQLQuery("select id,code from Fund where isactive=true order by code").list();
        HashMap<Integer, String> fundMap = new HashMap<Integer, String>();
        for (Object[] fund : list) {
            BigDecimal id = (BigDecimal)fund[0];
            fundMap.put(id.intValue(), (String)fund[1]);
        }
        return fundMap;
    }

    private List<AutoRemittanceBean> searchRecoveryByCOA(Integer deptId) {
        this.recoveries = new ArrayList<AutoRemittanceBean>();
        this.recoveries.addAll(this.getReceiptRecoveries(deptId, 0));
        this.recoveries.addAll(this.getJVRecoveries(deptId));
        this.recoveries.addAll(this.getGJVRecovries(deptId, -1));
        return this.recoveries;
    }

    private List<AutoRemittanceBean> searchNonControlCodeRecoveryByCOA(Integer dept) {
        this.recoveries = new ArrayList<AutoRemittanceBean>();
        this.recoveries.addAll(this.getNonControleCodeReceiptRecoveries(dept, 0));
        this.recoveries.addAll(this.getNonControleCodeJVRecoveries(dept));
        this.recoveries.addAll(this.getNonControleCodeGJVRecovries(dept, -1));
        return this.recoveries;
    }

    private Collection<? extends AutoRemittanceBean> getNonControleCodeGJVRecovries(Integer dept, int bankaccount) {
        StringBuffer qry = new StringBuffer(2048);
        qry.append(" SELECT DISTINCT gl.id AS generalledgerId,  vh.fundid           AS fundId,  gl.creditamount      AS gldtlAmount, " + bankaccount + " AS bankAccountId " + " FROM VOUCHERHEADER vh ,  VOUCHERMIS mis,  GENERALLEDGER gl , fund f, TDS recovery " + " WHERE  recovery.GLCODEID =gl.GLCODEID  AND vh.ID =gl.VOUCHERHEADERID" + " AND gl.remittanceDate    IS NULL AND mis.VOUCHERHEADERID   =vh.ID AND vh.STATUS =0 and vh.fundid=f.id " + " and vh.name='" + "JVGeneral" + "' and vh.moduleid is null " + " AND recovery.ID      =" + this.recovery.getId() + " AND vh.voucherdate    >= :startdate  ");
        if (this.lastRunDate != null) {
            qry.append(" and  vh.voucherdate    <= :lastrundate");
        }
        if (this.receiptFundCodes != null && !this.receiptFundCodes.isEmpty()) {
            qry.append(" and  f.code in (:fundCodes) ");
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(qry.toString());
        query.addScalar("generalledgerId", (Type)IntegerType.INSTANCE).addScalar("fundId", (Type)IntegerType.INSTANCE).addScalar("gldtlAmount", (Type)DoubleType.INSTANCE).addScalar("bankAccountId", (Type)IntegerType.INSTANCE);
        if (this.lastRunDate != null) {
            query.setDate("lastrundate", (java.util.Date)new Date(this.lastRunDate.getTime()));
        }
        if (this.startDate != null) {
            query.setDate("startdate", (java.util.Date)new Date(this.startDate.getTime()));
        }
        if (this.receiptFundCodes != null && !this.receiptFundCodes.isEmpty()) {
            query.setParameterList("fundCodes", this.receiptFundCodes);
        }
        query.setResultTransformer(Transformers.aliasToBean(AutoRemittanceBean.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ReceiptRecoveries query " + qry);
        }
        return query.list();
    }

    private List<AutoRemittanceBean> getNonControleCodeJVRecoveries(Integer dept) {
        StringBuffer qry = new StringBuffer(2048);
        qry.append(" SELECT DISTINCT gl.id AS generalledgerId,  vh.fundid           AS fundId,  gl.creditamount      AS gldtlAmount,ih.bankaccountid AS bankAccountId  FROM VOUCHERHEADER vh ,  VOUCHERMIS mis,  GENERALLEDGER gl ,  VOUCHERHEADER payment,   EGF_INSTRUMENTHEADER ih, EGF_INSTRUMENTVOUCHER iv ,TDS recovery,miscbilldetail mb  WHERE  recovery.GLCODEID =gl.GLCODEID  AND vh.ID =gl.VOUCHERHEADERID  AND gl.remittanceDate    IS NULL AND mis.VOUCHERHEADERID   =vh.ID AND vh.STATUS =0   AND ih.id =iv.instrumentheaderid  AND iv.voucherheaderid    =payment.id and payment.status=0 AND ih.id_status NOT     IN (select id from egw_status where moduletype='Instrument' and description in ('Cancelled','Surrendered','Surrender_For_Reassign')  ) and mb.billvhid=vh.id and mb.payvhid=payment.id  AND recovery.ID      =" + this.recovery.getId() + "  ");
        if (this.lastRunDate != null) {
            qry.append(" and (ih.instrumentdate<= :lastrundate or ih.transactiondate<=:lastrundate )");
        }
        if (this.startDate != null) {
            qry.append(" and (ih.instrumentdate >=:startdate or ih.transactiondate>=:startdate )");
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(qry.toString());
        query.addScalar("generalledgerId", (Type)IntegerType.INSTANCE).addScalar("fundId", (Type)IntegerType.INSTANCE).addScalar("gldtlAmount", (Type)DoubleType.INSTANCE).addScalar("bankAccountId", (Type)IntegerType.INSTANCE);
        if (this.lastRunDate != null) {
            query.setDate("lastrundate", (java.util.Date)new Date(this.lastRunDate.getTime()));
        }
        if (this.startDate != null) {
            query.setDate("startdate", (java.util.Date)new Date(this.startDate.getTime()));
        }
        query.setResultTransformer(Transformers.aliasToBean(AutoRemittanceBean.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getNonControleCodeJVRecoveries query " + qry);
        }
        return query.list();
    }

    private void loadStartDate() {
        SimpleDateFormat stringToDate = new SimpleDateFormat("dd/MM/yyyy");
        String value = null;
        try {
            List appConfigList = this.remittancePersistenceService.getPersistenceService().findAllBy("from AppConfig where key_name = 'AutoRemittance_Start_Date'", new Object[0]);
            if (appConfigList == null) {
                throw new ValidationException(Arrays.asList(new ValidationError("AutoRemittance_Start_Date app config key not defined", "AutoRemittance_Start_Date app config key not defined")));
            }
            for (AppConfig appConfig : appConfigList) {
                for (AppConfigValues appConfigVal : appConfig.getAppDataValues()) {
                    value = appConfigVal.getValue();
                }
            }
            this.startDate = stringToDate.parse(value);
        }
        catch (ParseException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("Error in parsing AutoRemittance_Start_Date app config value (should be in dd/mm/yyyy format)", "Error in parsing AutoRemittance_Start_Date app config value (should be in dd/mm/yyyy format)")));
        }
        catch (NullPointerException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("AutoRemittance_Start_Date app config value  not added", "AutoRemittance_Start_Date app config  value  not added")));
        }
    }

    private List<AutoRemittanceBean> getGJVRecovries(Integer deptId, Integer gjvBankAccountId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Fetching GJVRecovries");
        }
        StringBuffer queryStr = new StringBuffer("SELECT distinct gl.id as generalledgerId,  vh.fundid AS fundId,  egr.GLDTLAMT AS gldtlAmount,   gld.DETAILTYPEID  AS detailtypeId, gld.DETAILKEYID   AS detailkeyId,   egr.ID   AS remittanceGldtlId, " + gjvBankAccountId + " as bankAccountId,  " + " egr.GLDTLAMT- (SELECT case when SUM(egd.REMITTEDAMT) = NULL then 0 else SUM(egd.REMITTEDAMT) end     " + " FROM EG_REMITTANCE_GLDTL egr1,     eg_remittance_detail egd,     eg_remittance eg,     voucherheader vh   WHERE vh.status!    =4  " + " AND eg.PAYMENTVHID  =vh.id   AND egd.remittanceid=eg.id   AND egr1.id         =egd.remittancegldtlid  " + " AND egr1.id         =egr.id   ) AS pendingAmount FROM VOUCHERHEADER vh ,  " + " VOUCHERMIS mis,   GENERALLEDGER gl ," + " GENERALLEDGERDETAIL gld,   EG_REMITTANCE_GLDTL egr,   TDS recovery5_ WHERE recovery5_.GLCODEID =gl.GLCODEID AND" + " gld.ID                =egr.GLDTLID AND gl.ID                 =gld.GENERALLEDGERID AND vh.ID   =gl.VOUCHERHEADERID " + " and gl.remittanceDate is null " + " AND mis.VOUCHERHEADERID   =vh.ID AND vh.STATUS=0 and vh.moduleid is null  and vh.name= '" + "JVGeneral" + "'" + " AND mis.departmentid  =  " + deptId + " AND vh.moduleid is null" + " AND egr.GLDTLAMT-   (SELECT case when SUM(egd.REMITTEDAMT) = NULL then 0 else SUM(egd.REMITTEDAMT) end   FROM EG_REMITTANCE_GLDTL egr1,  " + " eg_remittance_detail egd,     eg_remittance eg,     voucherheader vh   WHERE vh.status !=4  " + " AND eg.PAYMENTVHID   =vh.id   AND egd.remittanceid =eg.id   AND egr1.id          =egd.remittancegldtlid   " + " AND egr1.id          =egr.id   )                   >0 AND recovery5_.ID      =" + this.recovery.getId());
        if (this.lastRunDate != null) {
            queryStr.append(" and vh.voucherdate<= '" + this.sdf.format(this.lastRunDate) + "' ");
        }
        if (this.startDate != null) {
            queryStr.append(" and vh.voucherdate>= '" + this.sdf.format(this.startDate) + "' ");
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(queryStr.toString());
        query.addScalar("generalledgerId", (Type)IntegerType.INSTANCE).addScalar("fundId", (Type)IntegerType.INSTANCE).addScalar("gldtlAmount", (Type)DoubleType.INSTANCE).addScalar("detailtypeId", (Type)IntegerType.INSTANCE).addScalar("detailkeyId", (Type)IntegerType.INSTANCE).addScalar("remittanceGldtlId", (Type)IntegerType.INSTANCE).addScalar("pendingAmount", (Type)DoubleType.INSTANCE).addScalar("bankAccountId", (Type)IntegerType.INSTANCE);
        query.setResultTransformer(Transformers.aliasToBean(AutoRemittanceBean.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Query for GJVRecovries" + queryStr);
        }
        return query.list();
    }

    private List<AutoRemittanceBean> getJVRecoveries(Integer deptId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Fetching JVRecoveries");
        }
        StringBuffer queryStr = new StringBuffer("SELECT distinct gl.id as generalledgerId,  vh.fundid AS fundId,  egr.GLDTLAMT AS gldtlAmount,   gld.DETAILTYPEID  AS detailtypeId, gld.DETAILKEYID   AS detailkeyId,   egr.ID   AS remittanceGldtlId,ih.bankaccountid as bankAccountId,   egr.GLDTLAMT- (SELECT case when SUM(egd.REMITTEDAMT) = NULL then 0 else SUM(egd.REMITTEDAMT) end     FROM EG_REMITTANCE_GLDTL egr1,     eg_remittance_detail egd,     eg_remittance eg,     voucherheader vh   WHERE vh.status!    =4   AND eg.PAYMENTVHID  =vh.id   AND egd.remittanceid=eg.id   AND egr1.id         =egd.remittancegldtlid   AND egr1.id         =egr.id   ) AS pendingAmount FROM VOUCHERHEADER vh left outer JOIN miscbilldetail mb on vh.id=mb.billvhid ,   VOUCHERMIS mis,   GENERALLEDGER gl,   voucherheader ph,   egf_instrumentheader ih,   egf_instrumentvoucher iv , GENERALLEDGERDETAIL gld,   EG_REMITTANCE_GLDTL egr,   TDS recovery5_ WHERE recovery5_.GLCODEID =gl.GLCODEID AND gld.ID                =egr.GLDTLID AND gl.ID                 =gld.GENERALLEDGERID AND vh.ID   =gl.VOUCHERHEADERID  and gl.remittanceDate is null  AND mis.VOUCHERHEADERID   =vh.ID AND vh.STATUS=0 AND mb.payvhid =ph.id AND ih.id =iv.instrumentheaderid  AND iv.voucherheaderid    =ph.id and ph.status!=4 AND ih.id_status NOT    IN ( select id from egw_status where moduletype='Instrument' and description in ('Cancelled','Surrendered','Surrender_For_Reassign')  ) AND mis.departmentid  =  " + deptId + " AND egr.GLDTLAMT-   (SELECT case when SUM(egd.REMITTEDAMT) = NULL then 0 else SUM(egd.REMITTEDAMT) end   FROM EG_REMITTANCE_GLDTL egr1,  " + " eg_remittance_detail egd,     eg_remittance eg,     voucherheader vh   WHERE vh.status !=4  " + " AND eg.PAYMENTVHID   =vh.id   AND egd.remittanceid =eg.id   AND egr1.id          =egd.remittancegldtlid   " + " AND egr1.id          =egr.id   )                   >0 AND recovery5_.ID      =" + this.recovery.getId());
        if (this.lastRunDate != null) {
            queryStr.append(" and (ih.instrumentdate<='" + this.sdf.format(this.lastRunDate) + "'  or ih.transactiondate<='" + this.sdf.format(this.lastRunDate) + "') ");
        }
        if (this.startDate != null) {
            queryStr.append(" and (ih.instrumentdate>='" + this.sdf.format(this.startDate) + "' or ih.transactiondate>='" + this.sdf.format(this.startDate) + "' ) ");
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(queryStr.toString());
        query.addScalar("generalledgerId", (Type)IntegerType.INSTANCE).addScalar("fundId", (Type)IntegerType.INSTANCE).addScalar("gldtlAmount", (Type)DoubleType.INSTANCE).addScalar("detailtypeId", (Type)IntegerType.INSTANCE).addScalar("detailkeyId", (Type)IntegerType.INSTANCE).addScalar("remittanceGldtlId", (Type)IntegerType.INSTANCE).addScalar("pendingAmount", (Type)DoubleType.INSTANCE).addScalar("bankAccountId", (Type)IntegerType.INSTANCE);
        query.setResultTransformer(Transformers.aliasToBean(AutoRemittanceBean.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JVRecoveries query " + queryStr);
        }
        return query.list();
    }

    private List getReceiptRecoveries(Integer deptId, Integer receiptBankAccountId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Fetching ReceiptRecoveries");
        }
        StringBuffer queryStr = new StringBuffer("SELECT distinct gl.id as generalledgerId,  vh.fundid AS fundId,  egr.GLDTLAMT AS gldtlAmount,   gld.DETAILTYPEID  AS detailtypeId, gld.DETAILKEYID   AS detailkeyId,   egr.ID   AS remittanceGldtlId," + receiptBankAccountId + " as bankAccountId, " + " egr.GLDTLAMT- (SELECT case when SUM(egd.REMITTEDAMT) = NULL then 0 else SUM(egd.REMITTEDAMT) end    " + " FROM EG_REMITTANCE_GLDTL egr1,     eg_remittance_detail egd,     eg_remittance eg,     voucherheader vh   WHERE vh.status!    =4  " + " AND eg.PAYMENTVHID  =vh.id   AND egd.remittanceid=eg.id   AND egr1.id         =egd.remittancegldtlid  " + " AND egr1.id         =egr.id   ) AS pendingAmount FROM VOUCHERHEADER vh ,  " + " VOUCHERMIS mis,   GENERALLEDGER gl,   voucherheader payinslip, fund f,  egf_instrumentheader ih,  egf_instrumentotherdetails io," + " GENERALLEDGERDETAIL gld,   EG_REMITTANCE_GLDTL egr,  egcl_collectionvoucher cv, egcl_collectioninstrument ci,TDS recovery5_ WHERE recovery5_.GLCODEID =gl.GLCODEID AND" + " gld.ID                =egr.GLDTLID AND gl.ID                 =gld.GENERALLEDGERID AND vh.ID   =gl.VOUCHERHEADERID " + " and gl.remittanceDate is null and f.id=vh.fundid " + " AND mis.VOUCHERHEADERID   =vh.ID AND vh.STATUS=0  AND io.payinslipid =payinslip.id " + " and cv.voucherheaderid= vh.id \tand ci.collectionheaderid= cv.collectionheaderid and ci.instrumentmasterid= ih.id" + " and payinslip.status=0 AND ih.id_status NOT     IN (" + "select id from egw_status where moduletype='Instrument' and description in ('" + "Cancelled" + "','" + "Surrendered" + "','" + "Surrender_For_Reassign" + "') " + " ) AND mis.departmentid  =  " + deptId + " AND egr.GLDTLAMT-   (SELECT case when SUM(egd.REMITTEDAMT) = NULL then 0 else SUM(egd.REMITTEDAMT) end   FROM EG_REMITTANCE_GLDTL egr1,  " + " eg_remittance_detail egd,     eg_remittance eg,     voucherheader vh   WHERE vh.status !=4  " + " AND eg.PAYMENTVHID   =vh.id   AND egd.remittanceid =eg.id   AND egr1.id          =egd.remittancegldtlid   " + " AND egr1.id          =egr.id   )                   >0 AND recovery5_.ID      =" + this.recovery.getId());
        if (this.lastRunDate != null) {
            queryStr.append(" and payinslip.voucherdate<='" + this.sdf.format(this.lastRunDate) + "' ");
        }
        if (this.startDate != null) {
            queryStr.append(" and payinslip.voucherdate>='" + this.sdf.format(this.startDate) + "'");
        }
        if (this.receiptFundCodes != null && !this.receiptFundCodes.isEmpty()) {
            queryStr.append(" and f.code in (:fundCodes) ");
        }
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(queryStr.toString());
        query.addScalar("generalledgerId", (Type)IntegerType.INSTANCE).addScalar("fundId", (Type)IntegerType.INSTANCE).addScalar("gldtlAmount", (Type)DoubleType.INSTANCE).addScalar("detailtypeId", (Type)IntegerType.INSTANCE).addScalar("detailkeyId", (Type)IntegerType.INSTANCE).addScalar("remittanceGldtlId", (Type)IntegerType.INSTANCE).addScalar("pendingAmount", (Type)DoubleType.INSTANCE).addScalar("bankAccountId", (Type)IntegerType.INSTANCE);
        if (this.receiptFundCodes != null && !this.receiptFundCodes.isEmpty()) {
            query.setParameterList("fundCodes", this.receiptFundCodes);
        }
        query.setResultTransformer(Transformers.aliasToBean(AutoRemittanceBean.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ReceiptRecoveries query " + queryStr);
        }
        return query.list();
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public void setRemittancePersistenceService(RemittancePersistenceService remittancePersistenceService) {
        this.remittancePersistenceService = remittancePersistenceService;
    }

    public void setRecoveryService(RecoveryService recoveryService) {
        this.recoveryService = recoveryService;
    }

    public void setEgRemittancegldtlService(PersistenceService<EgRemittanceGldtl, Integer> egRemittancegldtlService) {
        this.egRemittancegldtlService = egRemittancegldtlService;
    }

    public RemittancePersistenceService getRemittancePersistenceService() {
        return this.remittancePersistenceService;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public void setPaymentWorkflowService(SimpleWorkflowService<Paymentheader> paymentWorkflowService) {
        this.paymentWorkflowService = paymentWorkflowService;
    }

    public void setRemittanceSchedulerLogService(PersistenceService<RemittanceSchedulerLog, Integer> remittanceSchedulerLogService) {
        this.remittanceSchedulerLogService = remittanceSchedulerLogService;
    }

    public PersistenceService<RemittanceSchedulerLog, Integer> getRemittanceSchedulerLogService() {
        return this.remittanceSchedulerLogService;
    }

    public Map<Integer, Integer> getDeptDOMap() {
        return this.deptDOMap;
    }

    public void setDeptDOMap(Map<Integer, Integer> deptDOMap) {
        this.deptDOMap = deptDOMap;
    }

    public boolean isSuccessForAutoRemittance() {
        return this.successForAutoRemittance;
    }

    public void setSuccessForAutoRemittance(boolean successForAutoRemittance) {
        this.successForAutoRemittance = successForAutoRemittance;
    }

    public StringBuffer getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(StringBuffer errorMessage) {
        this.errorMessage = errorMessage;
    }
}

