/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.cheque;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bankaccount;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.utils.EntityType;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.payment.ChequeAssignment;
import org.egov.model.payment.Paymentheader;
import org.egov.utils.Constants;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ChequeAssignmentService
extends PersistenceService<Paymentheader, Long> {
    public SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
    public final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy", Constants.LOCALE);
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private Query query;
    private List<ChequeAssignment> finalCBillChequeAssignmentList;
    private List<ChequeAssignment> tempExpenseChequeAssignmentList;
    private List<ChequeAssignment> finalChequeAssignmentList;
    private static final Logger LOGGER = Logger.getLogger(ChequeAssignmentService.class);
    private static final String DELIMETER = "~";
    private String approvedstatus = "";
    private String statusId = "";
    private List<BigDecimal> cBillGlcodeIdList = null;
    private String instrumentReconciledStatus = "";
    private String instrumentNewStatus = "";
    private String filterConditions = "";
    public List<CChartOfAccounts> purchaseBillGlcodeList = new ArrayList<CChartOfAccounts>();
    public List<CChartOfAccounts> worksBillGlcodeList = new ArrayList<CChartOfAccounts>();
    public List<CChartOfAccounts> salaryBillGlcodeList = new ArrayList<CChartOfAccounts>();
    public List<CChartOfAccounts> contingentBillGlcodeList = new ArrayList<CChartOfAccounts>();
    @Autowired
    private ChartOfAccountsDAO coaDAO;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;

    public ChequeAssignmentService(Class<Paymentheader> paymentheader) {
        this.type = paymentheader;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setStatusAndFilterValues(Map<String, String[]> parameters, CVoucherHeader voucherHeader) throws ParseException {
        this.filterConditions = this.getFilterParamaters(parameters, voucherHeader);
        this.setStatusValues();
    }

    public List<ChequeAssignment> getPaymentVoucherNotInInstrument(Map<String, String[]> parameters) throws ApplicationException, ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getPaymentVoucherNotInInstrument...");
        }
        this.finalChequeAssignmentList.addAll(this.getExpenseBillPayments());
        this.finalChequeAssignmentList.addAll(this.getDirectBankPaymentsForChequeAssignment());
        this.finalChequeAssignmentList.addAll(this.getContractorSupplierPaymentsForChequeAssignment(parameters));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getPaymentVoucherNotInInstrument.");
        }
        return this.finalChequeAssignmentList;
    }

    public List<ChequeAssignment> getExpenseBillPayments() throws ParseException, NumberFormatException, ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getExpenseBillPayments...");
        }
        this.getExpenseBillPaymentsHavingNoCheques();
        this.getExpenseBillPaymentsWithNoSurrenderedCheque();
        this.getExpenseBillPaymentsWithSurrenderedCheques();
        if (this.tempExpenseChequeAssignmentList != null && this.tempExpenseChequeAssignmentList.size() != 0) {
            this.prepareChequeList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getExpenseBillPayments.");
        }
        return this.finalCBillChequeAssignmentList;
    }

    public List<ChequeAssignment> getPaymentVouchersConsolidatedMode(Map<String, String[]> parameters, CVoucherHeader voucherHeader) throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getPaymentVouchersConsolidatedMode...");
        }
        String filterConditions = this.getFilterParamaters(parameters, voucherHeader);
        this.setStatusValues();
        this.query = this.getSession().createSQLQuery("select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate,sum(misbill.paidamount) as paidAmount,current_date as chequeDate from Paymentheader ph,voucherheader vh,vouchermis vmis, Miscbilldetail misbill  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + filterConditions + " " + " and vh.id not in (select voucherHeaderId from egf_InstrumentVoucher iv, EGF_INSTRUMENTHEADER ih where iv.INSTRUMENTHEADERID = ih.id and ih.ID_STATUS in (" + this.statusId + ") ) and vh.type='" + "Payment" + "' and vh.name NOT IN ('" + "Remittance Payment" + "' , '" + "Salary Bill Payment" + "') " + " group by vh.id,vh.voucherNumber,vh.voucherDate order by vh.voucherNumber ").addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getPaymentVouchersConsolidatedMode.");
        }
        return this.query.list();
    }

    public List<ChequeAssignment> getContractorSupplierPaymentsForChequeAssignment(Map<String, String[]> parameters) throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getContractorSupplierPaymentsForChequeAssignment...");
        }
        Bankaccount ba = (Bankaccount)this.persistenceService.find(" from Bankaccount where id=?", new Object[]{Long.valueOf(parameters.get("bankaccount")[0])});
        String billCondition = "";
        billCondition = null != parameters.get("voucherName") && null != parameters.get("voucherName")[0] && "Pension Bill Payment".equalsIgnoreCase(parameters.get("voucherName")[0]) ? " in ('Pension') " : " not in ('Expense','Pension')";
        String supplierBillPaymentQuery = "select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate ,0 as detailtypeid ,0 as detailkeyid ,misbill.paidto as paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate  from Paymentheader ph,voucherheader vh,vouchermis vmis, Miscbilldetail misbill ,voucherheader billvh, eg_billregister br, eg_billregistermis billmis, generalledger gl,  egf_instrumentvoucher iv right outer join voucherheader pvh on (pvh.id=iv.VOUCHERHEADERID)  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vh.name='Bill Payment' and  vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + this.filterConditions + " " + " and gl.voucherheaderid =vh.id  and gl.creditamount>0 and gl.glcodeid in (" + ba.getChartofaccounts().getId() + ") and br.id=billmis.billid and billmis.voucherheaderid=billvh.id and br.expendituretype " + billCondition + " and misbill.billvhid=billvh.id " + " and pvh.id=vh.id and iv.id IS NULL group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto  " + " union select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate ,0 as detailtypeid ,0 as detailkeyid ,misbill.paidto as paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate " + " from Paymentheader ph,voucherheader vh,vouchermis vmis, Miscbilldetail misbill ,voucherheader billvh, eg_billregister br, eg_billregistermis billmis, generalledger gl, " + " egf_instrumentvoucher iv right outer join voucherheader pvh on (pvh.id=iv.VOUCHERHEADERID)  left outer join egf_instrumentheader ih on (ih.ID=iv.INSTRUMENTHEADERID) " + " where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vh.name='Bill Payment' and  vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + this.filterConditions + " " + " and gl.voucherheaderid =vh.id  and gl.creditamount>0 and gl.glcodeid in (" + ba.getChartofaccounts().getId() + ") and br.id=billmis.billid and billmis.voucherheaderid=billvh.id and br.expendituretype  " + billCondition + " and misbill.billvhid=billvh.id " + " and pvh.id=vh.id and ih.id IN (SELECT MAX(ih.id) FROM egf_instrumentvoucher iv RIGHT OUTER JOIN voucherheader pvh ON (pvh.id=iv.VOUCHERHEADERID) LEFT OUTER JOIN  " + " egf_instrumentheader ih ON (ih.ID =iv.INSTRUMENTHEADERID) WHERE pvh.id =vh.id AND ih.payto =misbill.paidto) AND ih.ID_STATUS NOT IN (" + this.statusId + ") group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto  " + " union select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate ,0 as detailtypeid ,0 as detailkeyid ,misbill.paidto as paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate " + " from Paymentheader ph,voucherheader vh,vouchermis vmis, Miscbilldetail misbill ,voucherheader billvh, eg_billregister br, eg_billregistermis billmis, generalledger gl " + " where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vh.name='Bill Payment' and  vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + this.filterConditions + " " + " and gl.voucherheaderid =vh.id  and gl.creditamount>0 and gl.glcodeid in (" + ba.getChartofaccounts().getId() + ") and br.id=billmis.billid and billmis.voucherheaderid=billvh.id and br.expendituretype  " + billCondition + " and misbill.billvhid=billvh.id " + " and  misbill.paidto NOT IN (SELECT DISTINCT(ih.payto) FROM egf_instrumentvoucher iv  RIGHT OUTER JOIN voucherheader pvh    " + " ON (pvh.id=iv.VOUCHERHEADERID)  LEFT OUTER JOIN egf_instrumentheader ih  ON (ih.ID=iv.INSTRUMENTHEADERID)  WHERE pvh.id=vh.id AND ih.ID_STATUS IN (" + this.statusId + ")) " + " group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto order by paidto,voucherNumber ";
        this.query = this.getSession().createSQLQuery(supplierBillPaymentQuery).addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("detailtypeid", (Type)BigDecimalType.INSTANCE).addScalar("detailkeyid", (Type)BigDecimalType.INSTANCE).addScalar("paidTo").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("CONTRACTOR/SUPLLIER BILL PAYMENT QUERY - " + supplierBillPaymentQuery));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getContractorSupplierPaymentsForChequeAssignment.");
        }
        return this.query.list();
    }

    public List<ChequeAssignment> getDirectBankPaymentsForChequeAssignment() throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getDirectBankPaymentsForChequeAssignment...");
        }
        String bankPaymentQuery = "select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,0 as detailtypeid ,0 as detailkeyid,vh.voucherDate as voucherDate  ,misbill.paidto as paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate From Paymentheader ph,voucherheader vh,vouchermis vmis, Miscbilldetail misbill,  egf_instrumentvoucher iv right outer join voucherheader pvh on (pvh.id=iv.VOUCHERHEADERID) Where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vh.name in ('Direct Bank Payment','Advance Payment') and vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + this.filterConditions + " " + " and pvh.id=vh.id and  iv.id IS NULL  group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto " + " union select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,0 as detailtypeid ,0 as detailkeyid,vh.voucherDate as voucherDate  ,misbill.paidto as paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate" + " From Paymentheader ph,voucherheader vh,vouchermis vmis, Miscbilldetail misbill, " + " egf_instrumentvoucher iv right outer join voucherheader pvh on (pvh.id=iv.VOUCHERHEADERID)" + " left outer join egf_instrumentheader ih on (ih.ID=iv.INSTRUMENTHEADERID)" + " Where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vh.name in ('Direct Bank Payment','Advance Payment') and vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + this.filterConditions + " " + " and pvh.id=vh.id and ih.id IN (SELECT MAX(ih.id) FROM egf_instrumentvoucher iv RIGHT OUTER JOIN voucherheader pvh ON (pvh.id=iv.VOUCHERHEADERID) LEFT OUTER JOIN " + " egf_instrumentheader ih ON (ih.ID =iv.INSTRUMENTHEADERID) WHERE pvh.id =vh.id AND ih.payto =misbill.paidto) AND ih.ID_STATUS NOT IN (" + this.statusId + ") group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto  " + " union select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,0 as detailtypeid ,0 as detailkeyid,vh.voucherDate as voucherDate  ,misbill.paidto as paidTo,sum(misbill.paidamount) as paidAmount,current_date as chequeDate" + " From Paymentheader ph,voucherheader vh,vouchermis vmis, Miscbilldetail misbill " + " Where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vh.name in ('Direct Bank Payment','Advance Payment') and vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + this.filterConditions + " " + " and misbill.paidto NOT IN (SELECT DISTINCT(ih.payto) FROM egf_instrumentvoucher iv  RIGHT OUTER JOIN voucherheader pvh  " + " ON (pvh.id=iv.VOUCHERHEADERID)  LEFT OUTER JOIN egf_instrumentheader ih  ON (ih.ID=iv.INSTRUMENTHEADERID)  WHERE pvh.id=vh.id AND ih.ID_STATUS IN (" + this.statusId + "))  group by vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto  " + " order by paidto,voucherNumber ";
        this.query = this.getSession().createSQLQuery(bankPaymentQuery).addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("detailtypeid", (Type)BigDecimalType.INSTANCE).addScalar("detailkeyid", (Type)BigDecimalType.INSTANCE).addScalar("voucherDate").addScalar("paidTo").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("DIRECT BANK PAYMENT QUERY - " + bankPaymentQuery));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getDirectBankPaymentsForChequeAssignment.");
        }
        return this.query.list();
    }

    private void getExpenseBillPaymentsHavingNoCheques() throws NumberFormatException, ApplicationException {
        ArrayList detailTypeKeyAmtList;
        ArrayList<Object[]> generalLedgerDetails;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getExpenseBillPaymentsHavingNoCheques... NOT YET ASSIGNED");
        }
        List billChequeAssignmentList = null;
        ArrayList<Long> billVHIds = new ArrayList<Long>();
        ArrayList<Long> billVHIdsForDebtitSideCC = new ArrayList<Long>();
        List<Object> generalLedgerDetailList = new ArrayList();
        List<Object> generalLedgerDetailListForDebtitSideCC = new ArrayList();
        HashMap billVHIdAndgeneralLedgerDetailListMap = new HashMap();
        HashMap billVHIdAndGLDListForDebtitSideCCMap = new HashMap();
        String strQuery = "select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate ,0 as detailtypeid ,0 as detailkeyid , misbill.paidto as paidTo,case when sum(misbill.paidamount) is null then 0 else sum(misbill.paidamount) end   as paidAmount,current_date as chequeDate, misbill.billvhid as billVHId  from Paymentheader ph,egf_instrumentvoucher iv right outer join voucherheader vh on (vh.id=iv.VOUCHERHEADERID) ,vouchermis vmis, Miscbilldetail misbill, generalledger gl ,voucherheader billvh, eg_billregister br,eg_billregistermis billmis  where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + this.filterConditions + "  " + " and gl.voucherheaderid =vh.id and gl.creditamount>0 and misbill.billvhid=billvh.id  and br.id=billmis.billid and billmis.voucherheaderid=billvh.id and br.expendituretype='" + "Expense" + "' and iv.id is null  " + " group by  misbill.billvhid,vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto ";
        this.query = this.getSession().createSQLQuery(strQuery).addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("paidTo").addScalar("billVHId", (Type)BigDecimalType.INSTANCE).addScalar("detailtypeid", (Type)BigDecimalType.INSTANCE).addScalar("detailkeyid", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("NOT YET ASSIGNED No cheques - " + strQuery));
        }
        billChequeAssignmentList = this.query.list();
        for (ChequeAssignment ca : billChequeAssignmentList) {
            billVHIds.add(ca.getBillVHId().longValue());
        }
        if (billVHIds != null && billVHIds.size() > 0) {
            generalLedgerDetailList = this.getDetailTypeKeyAmtForBillVHId(billVHIds);
        }
        for (Object[] gld : generalLedgerDetailList) {
            if (billVHIdAndgeneralLedgerDetailListMap.containsKey(this.getLongValue(gld[3]))) {
                ((List)billVHIdAndgeneralLedgerDetailListMap.get(this.getLongValue(gld[3]))).add(gld);
                continue;
            }
            generalLedgerDetails = new ArrayList<Object[]>();
            generalLedgerDetails.add(gld);
            billVHIdAndgeneralLedgerDetailListMap.put(this.getLongValue(gld[3]), generalLedgerDetails);
        }
        for (ChequeAssignment ca : billChequeAssignmentList) {
            detailTypeKeyAmtList = (ArrayList)billVHIdAndgeneralLedgerDetailListMap.get(ca.getBillVHId().longValue());
            if (detailTypeKeyAmtList != null && detailTypeKeyAmtList.size() != 0) continue;
            billVHIdsForDebtitSideCC.add(ca.getBillVHId().longValue());
        }
        if (billVHIdsForDebtitSideCC != null && billVHIdsForDebtitSideCC.size() > 0) {
            generalLedgerDetailListForDebtitSideCC = this.getDetailTypeKeyAmtForDebtitSideCC(billVHIdsForDebtitSideCC);
        }
        for (Object[] gld : generalLedgerDetailListForDebtitSideCC) {
            if (billVHIdAndGLDListForDebtitSideCCMap.containsKey(this.getLongValue(gld[3]))) {
                ((List)billVHIdAndGLDListForDebtitSideCCMap.get(this.getLongValue(gld[3]))).add(gld);
                continue;
            }
            generalLedgerDetails = new ArrayList();
            generalLedgerDetails.add(gld);
            billVHIdAndGLDListForDebtitSideCCMap.put(this.getLongValue(gld[3]), generalLedgerDetails);
        }
        for (ChequeAssignment chqAssgn : billChequeAssignmentList) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("NOT YET ASSIGNED: Start Checking for Billvhid " + chqAssgn.getBillVHId()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"NOT YET ASSIGNED: checking getDetailTypeKeyAmtForBillVHId for Net payable codes");
            }
            List list = detailTypeKeyAmtList = billVHIdAndgeneralLedgerDetailListMap.get(chqAssgn.getBillVHId().longValue()) != null ? (List)billVHIdAndgeneralLedgerDetailListMap.get(chqAssgn.getBillVHId().longValue()) : new ArrayList();
            if (detailTypeKeyAmtList != null && detailTypeKeyAmtList.size() != 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("NOT YET ASSIGNED: detailTypeKeyAmtList for Billvhid " + chqAssgn.getBillVHId() + " size :" + detailTypeKeyAmtList.size()));
                }
                if (detailTypeKeyAmtList.size() < 2) {
                    this.tempExpenseChequeAssignmentList.add(chqAssgn);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("NOT YET ASSIGNED: adding inside detailTypeKeyAmtList.size()<2 block to Assignment List\n" + chqAssgn));
                    continue;
                }
                for (Object[] detailTypeKeyAmtObj : detailTypeKeyAmtList) {
                    ChequeAssignment ca = new ChequeAssignment();
                    ca.setVoucherid(new BigDecimal(chqAssgn.getVoucherid()));
                    ca.setVoucherNumber(chqAssgn.getVoucherNumber());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("NOT YET ASSIGNED: Voucher Number" + chqAssgn.getVoucherNumber()));
                    }
                    ca.setVoucherDate(chqAssgn.getVoucherDate());
                    ca.setPaidAmount((BigDecimal)detailTypeKeyAmtObj[2]);
                    ca.setChequeDate(chqAssgn.getChequeDate());
                    ca.setPaidTo(this.getEntity(Integer.parseInt(detailTypeKeyAmtObj[0].toString()), (Serializable)detailTypeKeyAmtObj[1]).getName());
                    ca.setDetailtypeid(BigDecimal.valueOf(Integer.valueOf(detailTypeKeyAmtObj[0].toString()).longValue()));
                    ca.setDetailkeyid(BigDecimal.valueOf(Integer.valueOf(detailTypeKeyAmtObj[1].toString()).longValue()));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("NOT YET ASSIGNED: detailTypeKeyAmtList.size()>=2 block to Assignment List\n" + ca));
                    }
                    this.tempExpenseChequeAssignmentList.add(ca);
                }
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("NOT YET ASSIGNED:  checking getDetailTypeKeyAmtForDebtitSideCC for " + chqAssgn.getBillVHId()));
            }
            List list2 = detailTypeKeyAmtList = billVHIdAndGLDListForDebtitSideCCMap.get(chqAssgn.getBillVHId().longValue()) != null ? (List)billVHIdAndGLDListForDebtitSideCCMap.get(chqAssgn.getBillVHId().longValue()) : new ArrayList();
            if (detailTypeKeyAmtList == null || detailTypeKeyAmtList.size() == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("NOT YET ASSIGNED: adding to checkassignlist as detailTypeKeyAmtList is null or zero" + chqAssgn));
                }
                this.tempExpenseChequeAssignmentList.add(chqAssgn);
                continue;
            }
            if (detailTypeKeyAmtList != null && detailTypeKeyAmtList.size() == 1) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("NOT YET ASSIGNED: adding to checkassignlist as detailTypeKeyAmtList is 1" + chqAssgn));
                }
                this.tempExpenseChequeAssignmentList.add(chqAssgn);
                continue;
            }
            BigDecimal deduction = BigDecimal.valueOf(0L);
            if (detailTypeKeyAmtList.size() == 1) {
                deduction = this.getNonSubledgerDeductions(chqAssgn.getBillVHId());
            }
            Map<Object, Object> dedMap = new HashMap();
            dedMap = this.getSubledgerAmtForDeduction(chqAssgn.getBillVHId());
            String key = "";
            for (Object[] obj : detailTypeKeyAmtList) {
                ChequeAssignment c = new ChequeAssignment();
                c.setChequeDate(chqAssgn.getChequeDate());
                c.setVoucherHeaderId(chqAssgn.getVoucherid());
                c.setVoucherNumber(chqAssgn.getVoucherNumber());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("NOT YET ASSIGNED: Voucher Number  :" + chqAssgn.getVoucherNumber()));
                }
                c.setVoucherDate(chqAssgn.getVoucherDate());
                c.setDetailtypeid((BigDecimal)obj[0]);
                c.setDetailkeyid((BigDecimal)obj[1]);
                key = obj[0].toString() + DELIMETER + obj[1].toString();
                if (deduction != null) {
                    obj[2] = ((BigDecimal)obj[2]).subtract(deduction);
                }
                c.setPaidAmount(dedMap.get(key) == null ? (BigDecimal)obj[2] : ((BigDecimal)obj[2]).subtract((BigDecimal)dedMap.get(key)));
                c.setPaidTo(this.getEntity(Integer.valueOf(obj[0].toString()), (Serializable)obj[1]).getName());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("NOT YET ASSIGNED:  detailTypeKeyAmtList.size()>=2 block to Assignment List\n" + c));
                }
                this.tempExpenseChequeAssignmentList.add(c);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getExpenseBillPaymentsHavingNoCheques.");
        }
    }

    private BigDecimal getNonSubledgerDeductions(BigDecimal billVHId) {
        SQLQuery query = this.getSession().createSQLQuery("SELECT SUM(gl.creditamount) FROM generalledger gl WHERE gl.creditamount>0 AND gl.glcodeid NOT IN (:glcodeIdList) AND voucherheaderid  =" + billVHId + " " + "AND gl.glcodeid NOT IN " + "(SELECT glcodeid FROM chartofaccountdetail) order by gl.glcode");
        query.setParameterList("glcodeIdList", this.cBillGlcodeIdList);
        if (query.list() != null && !query.list().isEmpty()) {
            return (BigDecimal)query.list().get(0);
        }
        return BigDecimal.valueOf(0L);
    }

    private void getExpenseBillPaymentsWithNoSurrenderedCheque() throws NumberFormatException, ApplicationException {
        ArrayList detailTypeKeyAmtList;
        ArrayList<Object[]> generalLedgerDetails;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getExpenseBillPaymentsWithNoSurrenderedCheque...ALREADY ASSIGNED: ");
        }
        ArrayList<Long> billVHIds = new ArrayList<Long>();
        ArrayList<Long> billVHIdsForDebtitSideCC = new ArrayList<Long>();
        HashMap billVHIdAndgeneralLedgerDetailListMap = new HashMap();
        HashMap billVHIdAndGLDListForDebtitSideCCMap = new HashMap();
        List<Object> generalLedgerDetailList = new ArrayList();
        List<Object> generalLedgerDetailListForDebtitSideCC = new ArrayList();
        List billChequeAssignmentList = null;
        String strQuery = " select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate ,0 as detailtypeid ,0 as detailkeyid , misbill.paidto as paidTo,case when sum(misbill.paidamount) is null then 0 else sum(misbill.paidamount) end as paidAmount,current_date as chequeDate,misbill.billvhid as billVHId  from Paymentheader ph, voucherheader vh ,vouchermis vmis, Miscbilldetail misbill , generalledger gl,voucherheader billvh, eg_billregister br,eg_billregistermis billmis   where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + this.filterConditions + " " + " and gl.voucherheaderid =vh.id and gl.creditamount>0 and misbill.billvhid=billvh.id  and br.id=billmis.billid and billmis.voucherheaderid=billvh.id and br.expendituretype='" + "Expense" + "' " + " and not exists(select 1 from egf_instrumentvoucher iv, egf_instrumentheader ih where ih.id= iv.instrumentheaderid and iv.voucherheaderid=vh.id and ih.id_status not in (" + this.statusId + ") )   " + " and exists (select 1 from egf_instrumentvoucher iv where  iv.voucherheaderid=vh.id) group by misbill.billvhid,vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto ";
        Query query = this.getSession().createSQLQuery(strQuery).addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("paidTo").addScalar("billVHId", (Type)BigDecimalType.INSTANCE).addScalar("detailtypeid", (Type)BigDecimalType.INSTANCE).addScalar("detailkeyid", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("ALREADY ASSIGNED: No surrendered cheques - " + strQuery));
        }
        billChequeAssignmentList = query.list();
        for (ChequeAssignment ca : billChequeAssignmentList) {
            billVHIds.add(ca.getBillVHId().longValue());
        }
        if (billVHIds != null && billVHIds.size() > 0) {
            generalLedgerDetailList = this.getDetailTypeKeyAmtForBillVHId(billVHIds);
        }
        for (Object[] gld : generalLedgerDetailList) {
            if (billVHIdAndgeneralLedgerDetailListMap.containsKey(this.getLongValue(gld[3]))) {
                ((List)billVHIdAndgeneralLedgerDetailListMap.get(this.getLongValue(gld[3]))).add(gld);
                continue;
            }
            generalLedgerDetails = new ArrayList<Object[]>();
            generalLedgerDetails.add(gld);
            billVHIdAndgeneralLedgerDetailListMap.put(this.getLongValue(gld[3]), generalLedgerDetails);
        }
        for (ChequeAssignment ca : billChequeAssignmentList) {
            detailTypeKeyAmtList = (ArrayList)billVHIdAndgeneralLedgerDetailListMap.get(ca.getBillVHId().longValue());
            if (detailTypeKeyAmtList != null && detailTypeKeyAmtList.size() != 0) continue;
            billVHIdsForDebtitSideCC.add(ca.getBillVHId().longValue());
        }
        if (billVHIdsForDebtitSideCC != null && billVHIdsForDebtitSideCC.size() > 0) {
            generalLedgerDetailListForDebtitSideCC = this.getDetailTypeKeyAmtForDebtitSideCC(billVHIdsForDebtitSideCC);
        }
        for (Object[] gld : generalLedgerDetailListForDebtitSideCC) {
            if (billVHIdAndGLDListForDebtitSideCCMap.containsKey(this.getLongValue(gld[3]))) {
                ((List)billVHIdAndGLDListForDebtitSideCCMap.get(this.getLongValue(gld[3]))).add(gld);
                continue;
            }
            generalLedgerDetails = new ArrayList();
            generalLedgerDetails.add(gld);
            billVHIdAndGLDListForDebtitSideCCMap.put(this.getLongValue(gld[3]), generalLedgerDetails);
        }
        for (ChequeAssignment chqAssgn : billChequeAssignmentList) {
            List payTo;
            Object queryString;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("ALREADY ASSIGNED: Start Checking for Billvhid " + chqAssgn.getBillVHId()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"ALREADY ASSIGNED: checking getDetailTypeKeyAmtForBillVHId for Net payable codes");
            }
            List list = detailTypeKeyAmtList = billVHIdAndgeneralLedgerDetailListMap.get(chqAssgn.getBillVHId().longValue()) != null ? (List)billVHIdAndgeneralLedgerDetailListMap.get(chqAssgn.getBillVHId().longValue()) : new ArrayList();
            if (detailTypeKeyAmtList != null && detailTypeKeyAmtList.size() != 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ALREADY ASSIGNED: detailTypeKeyAmtList for Billvhid " + chqAssgn.getBillVHId() + " size :" + detailTypeKeyAmtList.size()));
                }
                if (detailTypeKeyAmtList.size() < 2) {
                    queryString = " select distinct(ih.payTo) from egf_InstrumentHeader ih, egf_InstrumentVoucher iv where iv.instrumentHeaderId=ih.id and iv.voucherHeaderId=" + chqAssgn.getVoucherid() + " and ih.payTo=:payTo and ih.id_status in (" + this.statusId + ")  ";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("ALREADY ASSIGNED: queryString" + (String)queryString));
                    }
                    if ((payTo = this.getSession().createSQLQuery((String)queryString).setString("payTo", chqAssgn.getPaidTo()).list()) == null || payTo.size() == 0) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(" ALREADY ASSIGNED: adding to chequeAssignlist as payTo s null or size 0" + chqAssgn));
                        }
                        this.tempExpenseChequeAssignmentList.add(chqAssgn);
                        continue;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"ALREADY ASSIGNED: Not adding continuing");
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"ALREADY ASSIGNED:  Entering detailTypeKeyAmtList.size()>2 code");
                }
                for (Object[] detailTypeKeyAmtObj : detailTypeKeyAmtList) {
                    List payTo2;
                    String queryString2 = " select distinct(ih.payTo) from egf_InstrumentHeader ih, egf_InstrumentVoucher iv where iv.instrumentHeaderId=ih.id and iv.voucherHeaderId=" + chqAssgn.getVoucherid() + " " + "and ih.detailTypeId=" + detailTypeKeyAmtObj[0] + " and ih.detailKeyId=" + detailTypeKeyAmtObj[1] + " " + "and ih.id_status in (" + this.statusId + ")  ";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("queryString" + queryString2));
                    }
                    if ((payTo2 = this.getSession().createSQLQuery(queryString2).list()) == null || payTo2.size() == 0) {
                        queryString2 = " select distinct(ih.payTo) from egf_InstrumentHeader ih, egf_InstrumentVoucher iv where iv.instrumentHeaderId=ih.id and iv.voucherHeaderId=" + chqAssgn.getVoucherid() + " and ih.payTo=:payTo and ih.id_status in (" + this.statusId + ")  ";
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("ALREADY ASSIGNED: queryString" + queryString2));
                        }
                        if ((payTo2 = this.getSession().createSQLQuery(queryString2).setString("payTo", chqAssgn.getPaidTo()).list()) != null) continue;
                        ChequeAssignment ca = new ChequeAssignment();
                        ca.setVoucherid(new BigDecimal(chqAssgn.getVoucherid()));
                        ca.setVoucherNumber(chqAssgn.getVoucherNumber());
                        ca.setVoucherDate(chqAssgn.getVoucherDate());
                        ca.setPaidAmount((BigDecimal)detailTypeKeyAmtObj[2]);
                        ca.setChequeDate(chqAssgn.getChequeDate());
                        ca.setPaidTo(this.getEntity(Integer.parseInt(detailTypeKeyAmtObj[0].toString()), (Serializable)detailTypeKeyAmtObj[1]).getName());
                        ca.setDetailtypeid((BigDecimal)detailTypeKeyAmtObj[0]);
                        ca.setDetailkeyid((BigDecimal)detailTypeKeyAmtObj[1]);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(" ALREADY ASSIGNED: adding to chequeAssignlist" + ca));
                        }
                        this.tempExpenseChequeAssignmentList.add(ca);
                        continue;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"ALREADY ASSIGNED: Not adding continuing");
                }
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"ALREADY ASSIGNED:  entering getDetailTypeKeyAmtForDebtitSideCC  ");
            }
            List list2 = detailTypeKeyAmtList = billVHIdAndGLDListForDebtitSideCCMap.get(chqAssgn.getBillVHId().longValue()) != null ? (List)billVHIdAndGLDListForDebtitSideCCMap.get(chqAssgn.getBillVHId().longValue()) : new ArrayList();
            if (detailTypeKeyAmtList == null || detailTypeKeyAmtList.size() == 0) {
                queryString = " select distinct(ih.payTo) from egf_InstrumentHeader ih, egf_InstrumentVoucher iv where iv.instrumentHeaderId=ih.id and iv.voucherHeaderId=" + chqAssgn.getVoucherid() + " and ih.payTo =:payTo and ih.id_status in (" + this.statusId + ")  ";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ALREADY ASSIGNED: queryString" + (String)queryString));
                }
                if ((payTo = this.getSession().createSQLQuery((String)queryString).setString("payTo", chqAssgn.getPaidTo()).list()) != null && payTo.size() != 0) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ALREADY ASSIGNED: adding to chequeAssignlist as payto is null or 0" + chqAssgn));
                }
                this.tempExpenseChequeAssignmentList.add(chqAssgn);
                continue;
            }
            Map<Object, Object> dedMap = new HashMap();
            dedMap = this.getSubledgerAmtForDeduction(chqAssgn.getBillVHId());
            String key = "";
            for (Object[] obj : detailTypeKeyAmtList) {
                List payTo3;
                String queryString3 = " select distinct(ih.payTo) from egf_InstrumentHeader ih, egf_InstrumentVoucher iv where iv.instrumentHeaderId=ih.id and iv.voucherHeaderId=" + chqAssgn.getVoucherid() + " and ih.detailTypeId=" + obj[0] + " and ih.detailKeyId=" + obj[1] + " and ih.id_status in (" + this.statusId + ")  ";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ALREADY ASSIGNED: Querying for " + queryString3));
                }
                if ((payTo3 = this.getSession().createSQLQuery(queryString3).list()) != null && payTo3.size() != 0) continue;
                queryString3 = " select distinct(ih.payTo) from egf_InstrumentHeader ih, egf_InstrumentVoucher iv where iv.instrumentHeaderId=ih.id and iv.voucherHeaderId=" + chqAssgn.getVoucherid() + " and ih.payTo=:payTo and ih.id_status in (" + this.statusId + ")  ";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ALREADY ASSIGNED: queryString" + queryString3));
                }
                if ((payTo3 = this.getSession().createSQLQuery(queryString3).setString("payTo", chqAssgn.getPaidTo()).list()) != null) continue;
                ChequeAssignment c = new ChequeAssignment();
                c.setChequeDate(chqAssgn.getChequeDate());
                c.setVoucherHeaderId(chqAssgn.getVoucherid());
                c.setVoucherNumber(chqAssgn.getVoucherNumber());
                c.setVoucherDate(chqAssgn.getVoucherDate());
                c.setDetailtypeid((BigDecimal)obj[0]);
                c.setDetailkeyid((BigDecimal)obj[1]);
                key = obj[0].toString() + DELIMETER + obj[1].toString();
                c.setPaidAmount(dedMap.get(key) == null ? (BigDecimal)obj[2] : ((BigDecimal)obj[2]).subtract((BigDecimal)dedMap.get(key)));
                c.setPaidTo(this.getEntity(Integer.valueOf(obj[0].toString()), (Serializable)obj[1]).getName());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ALREADY ASSIGNED: adding to chequeAssignlist as from payTo==null || payTo.size()==0 \n" + c));
                }
                this.tempExpenseChequeAssignmentList.add(c);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getExpenseBillPaymentsWithNoSurrenderedCheque.");
        }
    }

    private void getExpenseBillPaymentsWithSurrenderedCheques() throws NumberFormatException, ApplicationException {
        ArrayList detailTypeKeyAmtList;
        ArrayList<Object[]> generalLedgerDetails;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getExpenseBillPaymentsWithSurrenderedCheques...ASSIGNED BUT SURRENDARD: ");
        }
        List billChequeAssignmentList = null;
        ArrayList<Long> billVHIds = new ArrayList<Long>();
        ArrayList<Long> billVHIdsForDebtitSideCC = new ArrayList<Long>();
        HashMap billVHIdAndgeneralLedgerDetailListMap = new HashMap();
        HashMap billVHIdAndGLDListForDebtitSideCCMap = new HashMap();
        List<Object> generalLedgerDetailList = new ArrayList();
        List<Object> generalLedgerDetailListForDebtitSideCC = new ArrayList();
        String strQuery = " select vh.id as voucherid ,vh.voucherNumber as voucherNumber ,vh.voucherDate as voucherDate ,0 as detailtypeid ,0 as detailkeyid , misbill.paidto as paidTo,case when sum(misbill.paidamount)=null then 0 else sum(misbill.paidamount) end as paidAmount,current_date as chequeDate,misbill.billvhid as billVHId   from Paymentheader ph, voucherheader vh ,vouchermis vmis, Miscbilldetail misbill , generalledger gl,voucherheader billvh, eg_billregister br,eg_billregistermis billmis    where ph.voucherheaderid=misbill.payvhid and ph.voucherheaderid=vh.id and vmis.voucherheaderid= vh.id and vh.status =" + this.approvedstatus + " " + this.filterConditions + " " + " and gl.voucherheaderid =vh.id and gl.creditamount>0 and misbill.billvhid=billvh.id  and br.id=billmis.billid and billmis.voucherheaderid=billvh.id and br.expendituretype='" + "Expense" + "' " + " and exists(select 1 from egf_instrumentvoucher iv, egf_instrumentheader ih where ih.id= iv.instrumentheaderid and iv.voucherheaderid=vh.id and ih.id_status not in (" + this.statusId + ") ) " + " group by misbill.billvhid,vh.id,vh.voucherNumber,vh.voucherDate,misbill.paidto ";
        Query query = this.getSession().createSQLQuery(strQuery).addScalar("voucherid", (Type)BigDecimalType.INSTANCE).addScalar("voucherNumber").addScalar("voucherDate").addScalar("paidAmount", (Type)BigDecimalType.INSTANCE).addScalar("chequeDate").addScalar("paidTo").addScalar("billVHId", (Type)BigDecimalType.INSTANCE).addScalar("detailtypeid", (Type)BigDecimalType.INSTANCE).addScalar("detailkeyid", (Type)BigDecimalType.INSTANCE).setResultTransformer(Transformers.aliasToBean(ChequeAssignment.class));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: With surrendered cheques - " + strQuery));
        }
        billChequeAssignmentList = query.list();
        for (ChequeAssignment ca : billChequeAssignmentList) {
            billVHIds.add(ca.getBillVHId().longValue());
        }
        if (billVHIds != null && billVHIds.size() > 0) {
            generalLedgerDetailList = this.getDetailTypeKeyAmtForBillVHId(billVHIds);
        }
        for (Object[] gld : generalLedgerDetailList) {
            if (billVHIdAndgeneralLedgerDetailListMap.containsKey(this.getLongValue(gld[3]))) {
                ((List)billVHIdAndgeneralLedgerDetailListMap.get(this.getLongValue(gld[3]))).add(gld);
                continue;
            }
            generalLedgerDetails = new ArrayList<Object[]>();
            generalLedgerDetails.add(gld);
            billVHIdAndgeneralLedgerDetailListMap.put(this.getLongValue(gld[3]), generalLedgerDetails);
        }
        for (ChequeAssignment ca : billChequeAssignmentList) {
            detailTypeKeyAmtList = (ArrayList)billVHIdAndgeneralLedgerDetailListMap.get(ca.getBillVHId().longValue());
            if (detailTypeKeyAmtList != null && detailTypeKeyAmtList.size() != 0) continue;
            billVHIdsForDebtitSideCC.add(ca.getBillVHId().longValue());
        }
        if (billVHIdsForDebtitSideCC != null && billVHIdsForDebtitSideCC.size() > 0) {
            generalLedgerDetailListForDebtitSideCC = this.getDetailTypeKeyAmtForDebtitSideCC(billVHIdsForDebtitSideCC);
        }
        for (Object[] gld : generalLedgerDetailListForDebtitSideCC) {
            if (billVHIdAndGLDListForDebtitSideCCMap.containsKey(this.getLongValue(gld[3]))) {
                ((List)billVHIdAndGLDListForDebtitSideCCMap.get(this.getLongValue(gld[3]))).add(gld);
                continue;
            }
            generalLedgerDetails = new ArrayList();
            generalLedgerDetails.add(gld);
            billVHIdAndGLDListForDebtitSideCCMap.put(this.getLongValue(gld[3]), generalLedgerDetails);
        }
        for (ChequeAssignment chqAssgn : billChequeAssignmentList) {
            List instrumentStatus;
            Object queryString;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: With surrendered cheques -  for Billvhid" + chqAssgn.getBillVHId()));
            }
            List list = detailTypeKeyAmtList = billVHIdAndgeneralLedgerDetailListMap.get(chqAssgn.getBillVHId().longValue()) != null ? (List)billVHIdAndgeneralLedgerDetailListMap.get(chqAssgn.getBillVHId().longValue()) : new ArrayList();
            if (detailTypeKeyAmtList != null && detailTypeKeyAmtList.size() != 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: With surrendered cheques -  for Billvhid " + chqAssgn.getBillVHId() + " and size " + detailTypeKeyAmtList));
                }
                if (detailTypeKeyAmtList.size() < 2) {
                    queryString = " select iv.id,ih.id_status from egf_instrumentheader ih, egf_instrumentvoucher iv where iv.instrumentheaderid=ih.id and iv.voucherheaderid=" + chqAssgn.getVoucherid() + " and ih.payTo=:payTo order by id desc   ";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("instrumentStatus- " + (String)queryString));
                    }
                    if ((instrumentStatus = this.getSession().createSQLQuery((String)queryString).setString("payTo", chqAssgn.getPaidTo()).list()) == null || instrumentStatus.size() == 0 || !((Object[])instrumentStatus.get(0))[1].toString().equalsIgnoreCase(this.instrumentNewStatus) && !((Object[])instrumentStatus.get(0))[1].toString().equalsIgnoreCase(this.instrumentReconciledStatus)) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: Adding to chequeAssignmentlist as istrumentStatus " + chqAssgn));
                        }
                        this.tempExpenseChequeAssignmentList.add(chqAssgn);
                        continue;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"ASSIGNED BUT SURRENDARD: Continuing not adding");
                    continue;
                }
                for (Object[] detailTypeKeyAmtObj : detailTypeKeyAmtList) {
                    List instrumentStatus2;
                    String queryString2 = " select iv.id,ih.id_status from egf_instrumentheader ih, egf_instrumentvoucher iv where iv.instrumentheaderid=ih.id and iv.voucherheaderid=" + chqAssgn.getVoucherid() + " and ih.detailtypeid=" + detailTypeKeyAmtObj[0] + " and ih.detailkeyid=" + detailTypeKeyAmtObj[1] + " order by id desc ";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: Inside detailTypeKeyAmtList loop- " + queryString2));
                    }
                    if ((instrumentStatus2 = this.getSession().createSQLQuery(queryString2).list()) != null && instrumentStatus2.size() != 0 && (((Object[])instrumentStatus2.get(0))[1].toString().equalsIgnoreCase(this.instrumentNewStatus) || ((Object[])instrumentStatus2.get(0))[1].toString().equalsIgnoreCase(this.instrumentReconciledStatus))) continue;
                    ChequeAssignment ca = new ChequeAssignment();
                    ca.setVoucherid(new BigDecimal(chqAssgn.getVoucherid()));
                    ca.setVoucherNumber(chqAssgn.getVoucherNumber());
                    ca.setVoucherDate(chqAssgn.getVoucherDate());
                    ca.setPaidAmount((BigDecimal)detailTypeKeyAmtObj[2]);
                    ca.setChequeDate(chqAssgn.getChequeDate());
                    ca.setPaidTo(this.getEntity(Integer.parseInt(detailTypeKeyAmtObj[0].toString()), (Serializable)detailTypeKeyAmtObj[1]).getName());
                    ca.setDetailtypeid(BigDecimal.valueOf(((Integer)detailTypeKeyAmtObj[0]).longValue()));
                    ca.setDetailkeyid(BigDecimal.valueOf(((Integer)detailTypeKeyAmtObj[1]).longValue()));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: inside loop adding  " + ca));
                    }
                    this.tempExpenseChequeAssignmentList.add(ca);
                }
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD:  checking getDetailTypeKeyAmtForDebtitSideCC for " + chqAssgn.getBillVHId()));
            }
            List list2 = detailTypeKeyAmtList = billVHIdAndGLDListForDebtitSideCCMap.get(chqAssgn.getBillVHId().longValue()) != null ? (List)billVHIdAndGLDListForDebtitSideCCMap.get(chqAssgn.getBillVHId().longValue()) : new ArrayList();
            if (detailTypeKeyAmtList == null || detailTypeKeyAmtList.size() == 0) {
                queryString = " select iv.id,ih.id_status from egf_instrumentheader ih, egf_instrumentvoucher iv where iv.instrumentheaderid=ih.id and iv.voucherheaderid=" + chqAssgn.getVoucherid() + " and ih.payTo=:payTo order by id desc   ";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: getDetailTypeKeyAmtForDebtitSideCC " + (String)queryString));
                }
                if ((instrumentStatus = this.getSession().createSQLQuery((String)queryString).setString("payTo", chqAssgn.getPaidTo()).list()) != null && instrumentStatus.size() != 0 && (((Object[])instrumentStatus.get(0))[1].toString().equalsIgnoreCase(this.instrumentNewStatus) || ((Object[])instrumentStatus.get(0))[1].toString().equalsIgnoreCase(this.instrumentReconciledStatus))) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: Adding to chequeAssignmentlist in getDetailTypeKeyAmtForDebtitSideCC " + chqAssgn));
                }
                this.tempExpenseChequeAssignmentList.add(chqAssgn);
                continue;
            }
            if (detailTypeKeyAmtList != null && detailTypeKeyAmtList.size() == 1) {
                List instrumentStatusWithsubledgerPaidto;
                queryString = " select iv.id,ih.id_status from egf_instrumentheader ih, egf_instrumentvoucher iv where iv.instrumentheaderid=ih.id and iv.voucherheaderid=" + chqAssgn.getVoucherid() + " and ih.payTo=:payTo order by id desc   ";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: detailTypeKeyAmtList size=1" + (String)queryString));
                }
                if ((instrumentStatus = this.getSession().createSQLQuery((String)queryString).setString("payTo", chqAssgn.getPaidTo()).list()) != null && instrumentStatus.size() != 0 && (((Object[])instrumentStatus.get(0))[1].toString().equalsIgnoreCase(this.instrumentNewStatus) || ((Object[])instrumentStatus.get(0))[1].toString().equalsIgnoreCase(this.instrumentReconciledStatus))) continue;
                String queryString2 = " select iv.id,ih.id_status from egf_instrumentheader ih,  egf_instrumentvoucher iv where iv.instrumentheaderid=ih.id and iv.voucherheaderid=" + chqAssgn.getVoucherid() + " " + " and ih.payTo=:payTo order by id desc   ";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: detailTypeKeyAmtList  again checking " + queryString2));
                }
                if ((instrumentStatusWithsubledgerPaidto = this.getSession().createSQLQuery(queryString2).setString("payTo", this.getEntity(Integer.parseInt(((Object[])detailTypeKeyAmtList.get(0))[0].toString()), (Serializable)((Object[])detailTypeKeyAmtList.get(0))[1]).getName()).list()) != null && instrumentStatusWithsubledgerPaidto.size() != 0 && (((Object[])instrumentStatusWithsubledgerPaidto.get(0))[1].toString().equalsIgnoreCase(this.instrumentNewStatus) || ((Object[])instrumentStatusWithsubledgerPaidto.get(0))[1].toString().equalsIgnoreCase(this.instrumentReconciledStatus))) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: adding inside  again checking" + chqAssgn));
                }
                this.tempExpenseChequeAssignmentList.add(chqAssgn);
                continue;
            }
            Map<Object, Object> dedMap = new HashMap();
            dedMap = this.getSubledgerAmtForDeduction(chqAssgn.getBillVHId());
            String key = "";
            for (Object[] obj : detailTypeKeyAmtList) {
                List instrumentStatus3;
                String queryString3 = " select iv.id,ih.id_status from egf_instrumentheader ih, egf_instrumentvoucher iv where iv.instrumentheaderid=ih.id and iv.voucherheaderid=" + chqAssgn.getVoucherid() + "" + " and ih.detailtypeid=" + obj[0] + " and ih.detailkeyid=" + obj[1] + " order by id desc ";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: detailTypeKeyAmtList  checking " + queryString3));
                }
                if ((instrumentStatus3 = this.getSession().createSQLQuery(queryString3).list()) != null && instrumentStatus3.size() != 0 && (((Object[])instrumentStatus3.get(0))[1].toString().equalsIgnoreCase(this.instrumentNewStatus) || ((Object[])instrumentStatus3.get(0))[1].toString().equalsIgnoreCase(this.instrumentReconciledStatus))) continue;
                ChequeAssignment c = new ChequeAssignment();
                c.setChequeDate(chqAssgn.getChequeDate());
                c.setVoucherHeaderId(chqAssgn.getVoucherid());
                c.setVoucherNumber(chqAssgn.getVoucherNumber());
                c.setVoucherDate(chqAssgn.getVoucherDate());
                c.setDetailtypeid((BigDecimal)obj[0]);
                c.setDetailkeyid((BigDecimal)obj[1]);
                key = obj[0].toString() + DELIMETER + obj[1].toString();
                c.setPaidAmount(dedMap.get(key) == null ? (BigDecimal)obj[2] : ((BigDecimal)obj[2]).subtract((BigDecimal)dedMap.get(key)));
                c.setPaidTo(this.getEntity(Integer.valueOf(obj[0].toString()), (Serializable)obj[1]).getName());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("ASSIGNED BUT SURRENDARD: adding inside  detailTypeKeyAmtList loop" + c));
                }
                this.tempExpenseChequeAssignmentList.add(c);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getExpenseBillPaymentsWithSurrenderedCheques.");
        }
    }

    private String getFilterParamaters(Map<String, String[]> parameters, CVoucherHeader voucherHeader) throws ParseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getFilterParamaters...");
        }
        StringBuffer sql = new StringBuffer();
        if (!"".equals(parameters.get("fromDate")[0])) {
            sql.append(" and vh.voucherDate>='" + this.sdf.format(this.formatter.parse(parameters.get("fromDate")[0])) + "' ");
        }
        if (!"".equals(parameters.get("toDate")[0])) {
            sql.append(" and vh.voucherDate<='" + this.sdf.format(this.formatter.parse(parameters.get("toDate")[0])) + "'");
        }
        if (!StringUtils.isEmpty((String)voucherHeader.getVoucherNumber())) {
            sql.append(" and vh.voucherNumber like '%" + voucherHeader.getVoucherNumber() + "%'");
        }
        if (voucherHeader.getFundId() != null) {
            sql.append(" and vh.fundId=" + voucherHeader.getFundId().getId());
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            sql.append(" and vmis.fundsourceId=" + voucherHeader.getVouchermis().getFundsource().getId());
        }
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql.append(" and vmis.departmentid=" + voucherHeader.getVouchermis().getDepartmentid().getId());
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            sql.append(" and vmis.schemeid=" + voucherHeader.getVouchermis().getSchemeid().getId());
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql.append(" and vmis.subschemeid=" + voucherHeader.getVouchermis().getSubschemeid().getId());
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            sql.append(" and vmis.functionaryid=" + voucherHeader.getVouchermis().getFunctionary().getId());
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            sql.append(" and vmis.divisionid=" + voucherHeader.getVouchermis().getDivisionid().getId());
        }
        sql.append(" and ph.bankaccountnumberid=" + parameters.get("bankaccount")[0]);
        sql.append(" and lower(ph.type)=lower('" + parameters.get("paymentMode")[0] + "')");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getFilterParamaters.");
        }
        return sql.toString();
    }

    private List<Object[]> getDetailTypeKeyAmtForBillVHId(List<Long> billVHIds) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getDetailTypeKeyAmtForBillVHId...");
        }
        ArrayList<Long> cBillGlcodeIdsList = new ArrayList<Long>();
        for (BigDecimal glCodeId : this.cBillGlcodeIdList) {
            cBillGlcodeIdsList.add(glCodeId.longValue());
        }
        List<Object> generalLedgerDetailList = new ArrayList<Object[]>();
        int size = billVHIds.size();
        if (size > 999) {
            Query generalLedgerDetailsQuery;
            List newGLDList;
            int fromIndex = 0;
            int toIndex = 0;
            int step = 1000;
            while (size - 1000 >= 0) {
                newGLDList = new ArrayList();
                generalLedgerDetailsQuery = this.getSession().createQuery(" select gld.detailTypeId.id,gld.detailKeyId.id,gld.amount,gl.voucherHeaderId.id from CGeneralLedger gl, CGeneralLedgerDetail gld  where gl.voucherHeaderId.id in ( :IDS ) and gl.id = gld.generalLedgerId.id and gl.creditAmount>0 and gl.glcodeId.id in (:glcodeIdList)");
                generalLedgerDetailsQuery.setParameterList("IDS", billVHIds.subList(fromIndex, toIndex += 1000));
                generalLedgerDetailsQuery.setParameterList("glcodeIdList", cBillGlcodeIdsList);
                newGLDList = generalLedgerDetailsQuery.list();
                fromIndex = toIndex;
                size -= 1000;
                if (newGLDList == null) continue;
                generalLedgerDetailList.addAll(newGLDList);
            }
            if (size > 0) {
                newGLDList = new ArrayList();
                fromIndex = toIndex;
                toIndex = fromIndex + size;
                generalLedgerDetailsQuery = this.getSession().createQuery(" select gld.detailTypeId.id,gld.detailKeyId,gld.amount,gl.voucherHeaderId.id from CGeneralLedger gl, CGeneralLedgerDetail gld  where gl.voucherHeaderId.id in ( :IDS ) and gl.id = gld.generalLedgerId.id and gl.creditAmount>0 and gl.glcodeId.id in (:glcodeIdList)");
                generalLedgerDetailsQuery.setParameterList("IDS", billVHIds.subList(fromIndex, toIndex));
                generalLedgerDetailsQuery.setParameterList("glcodeIdList", cBillGlcodeIdsList);
                newGLDList = generalLedgerDetailsQuery.list();
                if (newGLDList != null) {
                    generalLedgerDetailList.addAll(newGLDList);
                }
            }
        } else {
            Query generalLedgerDetailsQuery = this.getSession().createQuery(" select gld.detailTypeId.id,gld.detailKeyId,gld.amount,gl.voucherHeaderId.id from CGeneralLedger gl, CGeneralLedgerDetail gld  where gl.voucherHeaderId.id in ( :IDS ) and gl.id = gld.generalLedgerId.id and gl.creditAmount>0 and gl.glcodeId.id in (:glcodeIdList)");
            generalLedgerDetailsQuery.setParameterList("IDS", billVHIds);
            generalLedgerDetailsQuery.setParameterList("glcodeIdList", cBillGlcodeIdsList);
            generalLedgerDetailList = generalLedgerDetailsQuery.list();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getDetailTypeKeyAmtForBillVHId.");
        }
        return generalLedgerDetailList;
    }

    private List<Object[]> getDetailTypeKeyAmtForDebtitSideCC(List<Long> billVHIds) {
        ArrayList<Object[]> generalLedgerDetailList = new ArrayList();
        int size = billVHIds.size();
        if (size > 999) {
            Query generalLedgerDetailsQuery;
            List newGLDList;
            int fromIndex = 0;
            int toIndex = 0;
            int step = 1000;
            while (size - 1000 >= 0) {
                newGLDList = new ArrayList();
                generalLedgerDetailsQuery = this.getSession().createQuery(" select gld.detailTypeId.id,gld.detailKeyId,gld.amount,gl.voucherHeaderId.id from CGeneralLedger gl, CGeneralLedgerDetail gld  where gl.voucherHeaderId.id in ( :IDS ) and gl.id = gld.generalLedgerId.id and  gl.debitAmount>0");
                generalLedgerDetailsQuery.setParameterList("IDS", billVHIds.subList(fromIndex, toIndex += 1000));
                newGLDList = generalLedgerDetailsQuery.list();
                fromIndex = toIndex;
                size -= 1000;
                if (newGLDList == null) continue;
                generalLedgerDetailList.addAll(newGLDList);
            }
            if (size > 0) {
                newGLDList = new ArrayList();
                fromIndex = toIndex;
                toIndex = fromIndex + size;
                generalLedgerDetailsQuery = this.getSession().createQuery(" select gld.detailTypeId.id,gld.detailKeyId,gld.amount,gl.voucherHeaderId.id from CGeneralLedger gl, CGeneralLedgerDetail gld  where gl.voucherHeaderId.id in ( :IDS ) and gl.id = gld.generalLedgerId.id and  gl.debitAmount>0");
                generalLedgerDetailsQuery.setParameterList("IDS", billVHIds.subList(fromIndex, toIndex));
                newGLDList = generalLedgerDetailsQuery.list();
                if (newGLDList != null) {
                    generalLedgerDetailList.addAll(newGLDList);
                }
            }
        } else {
            Query generalLedgerDetailsQuery = this.getSession().createQuery(" select gld.detailTypeId.id,gld.detailKeyId,gld.amount,gl.voucherHeaderId.id from CGeneralLedger gl, CGeneralLedgerDetail gld  where gl.voucherHeaderId.id in ( :IDS ) and gl.id = gld.generalLedgerId.id and  gl.debitAmount>0");
            generalLedgerDetailsQuery.setParameterList("IDS", billVHIds);
            generalLedgerDetailList = generalLedgerDetailsQuery.list();
        }
        return generalLedgerDetailList;
    }

    private void setStatusValues() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting setStatusValues...");
        }
        this.finalChequeAssignmentList = new ArrayList<ChequeAssignment>();
        this.finalCBillChequeAssignmentList = new ArrayList<ChequeAssignment>();
        this.tempExpenseChequeAssignmentList = new ArrayList<ChequeAssignment>();
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "APPROVEDVOUCHERSTATUS");
        this.approvedstatus = ((AppConfigValues)appList.get(0)).getValue();
        ArrayList<String> descriptionList = new ArrayList<String>();
        descriptionList.add("New");
        descriptionList.add("Reconciled");
        List egwStatusList = this.egwStatusDAO.getStatusListByModuleAndCodeList("Instrument", descriptionList);
        this.statusId = "";
        for (EgwStatus egwStatus : egwStatusList) {
            this.statusId = this.statusId + egwStatus.getId() + ",";
        }
        if (egwStatusList.size() == 2) {
            this.instrumentNewStatus = ((EgwStatus)egwStatusList.get(0)).getId().toString();
            this.instrumentReconciledStatus = ((EgwStatus)egwStatusList.get(1)).getId().toString();
        }
        this.statusId = this.statusId.substring(0, this.statusId.length() - 1);
        this.getGlcodeIds();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed setStatusValues.");
        }
    }

    private void prepareChequeList() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting prepareChequeList...");
        }
        ArrayList<Integer> alreadyProcessedIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.tempExpenseChequeAssignmentList.size(); ++i) {
            if (alreadyProcessedIndices.contains(i)) continue;
            ChequeAssignment outerChqAssgn = this.tempExpenseChequeAssignmentList.get(i);
            for (int j = i + 1; j < this.tempExpenseChequeAssignmentList.size(); ++j) {
                ChequeAssignment innerChqAssgn = this.tempExpenseChequeAssignmentList.get(j);
                if (!outerChqAssgn.getVoucherid().equals(innerChqAssgn.getVoucherid()) || !outerChqAssgn.getVoucherDate().equals(innerChqAssgn.getVoucherDate()) || !outerChqAssgn.getVoucherNumber().equals(innerChqAssgn.getVoucherNumber()) || !outerChqAssgn.getPaidTo().equals(innerChqAssgn.getPaidTo()) || !outerChqAssgn.getDetailtypeid().equals(innerChqAssgn.getDetailtypeid()) || !outerChqAssgn.getDetailkeyid().equals(innerChqAssgn.getDetailkeyid())) continue;
                outerChqAssgn.setPaidAmount(outerChqAssgn.getPaidAmount().add(innerChqAssgn.getPaidAmount()));
                alreadyProcessedIndices.add(j);
            }
            this.finalCBillChequeAssignmentList.add(outerChqAssgn);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed prepareChequeList.");
        }
    }

    private Map<String, BigDecimal> getSubledgerAmtForDeduction(BigDecimal billVHId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getSubledgerAmtForDeduction...");
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        SQLQuery query = this.getSession().createSQLQuery("SELECT gld.detailtypeid, gld.detailkeyid, SUM(gld.amount) FROM generalledgerdetail gld, generalledger gl WHERE gl.voucherheaderid=" + billVHId + " AND gl.id =gld.generalledgerid AND gl.creditamount  >0" + " AND gl.glcodeid NOT IN (:glcodeIdList) GROUP BY gld.detailtypeid, gld.detailkeyid");
        query.setParameterList("glcodeIdList", this.cBillGlcodeIdList);
        List list = query.list();
        if (list != null && !list.isEmpty()) {
            for (Object[] ob : list) {
                map.put(ob[0].toString() + DELIMETER + ob[1].toString(), (BigDecimal)ob[2]);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getSubledgerAmtForDeduction.");
        }
        return map;
    }

    public void getGlcodeIds() throws ApplicationRuntimeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getGlcodeIds...");
        }
        try {
            this.worksBillGlcodeList = this.populateGlCodeIds("worksBillPurposeIds");
            this.purchaseBillGlcodeList = this.populateGlCodeIds("purchaseBillPurposeIds");
            this.salaryBillGlcodeList = this.populateGlCodeIds("salaryBillPurposeIds");
            List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "contingencyBillPurposeIds");
            this.cBillGlcodeIdList = new ArrayList<BigDecimal>();
            if (appList != null && appList.size() > 0) {
                Integer[] iPurposeIds = new Integer[appList.size()];
                int z = 0;
                for (AppConfigValues appConfigValues : appList) {
                    iPurposeIds[z] = Integer.parseInt(appConfigValues.getValue());
                    ++z;
                }
                List coaList = this.coaDAO.getAccountCodeByListOfPurposeId(iPurposeIds);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Size contingentBillGlcodeList" + coaList.size()));
                }
                this.contingentBillGlcodeList = coaList;
                for (CChartOfAccounts coa1 : coaList) {
                    this.cBillGlcodeIdList.add(BigDecimal.valueOf(coa1.getId()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getGlcodeIds.");
        }
    }

    private List<CChartOfAccounts> populateGlCodeIds(String appConfigKey) throws ApplicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting populateGlCodeIds...");
        }
        ArrayList<CChartOfAccounts> glCodeList = new ArrayList<CChartOfAccounts>();
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", appConfigKey);
        String purposeids = ((AppConfigValues)appList.get(0)).getValue();
        if (purposeids != null && !purposeids.equals("")) {
            String[] purposeIds;
            for (String purposeId : purposeIds = purposeids.split(",")) {
                List coaList = this.coaDAO.getAccountCodeByPurpose(Integer.valueOf(Integer.parseInt(purposeId)));
                for (CChartOfAccounts coa1 : coaList) {
                    glCodeList.add(coa1);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed populateGlCodeIds.");
        }
        return glCodeList;
    }

    public EntityType getEntity(Integer detailTypeId, Serializable detailKeyId) throws ApplicationException {
        EntityType entity;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Starting getEntity...");
        }
        try {
            Accountdetailtype accountdetailtype = (Accountdetailtype)this.persistenceService.find(" from Accountdetailtype where id=?", new Object[]{detailTypeId});
            Class<?> service = Class.forName(accountdetailtype.getFullQualifiedName());
            String detailTypeName = service.getSimpleName();
            String dataType = "";
            Method method = service.getMethod("getId", new Class[0]);
            dataType = method.getReturnType().getSimpleName();
            entity = dataType.equals("Long") ? (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{Long.valueOf(detailKeyId.toString())}) : (EntityType)this.persistenceService.find("from " + detailTypeName + " where id=? order by name", new Object[]{Integer.valueOf(detailKeyId.toString())});
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception to get EntityType=" + e.getMessage() + "for detailTypeId=" + detailTypeId + "  for Detail key " + detailKeyId));
            throw new ApplicationException("Exception to get EntityType=" + e.getMessage());
        }
        if (entity == null) {
            LOGGER.error((Object)("Exception to get EntityType  for detailTypeId=" + detailTypeId + "  for Detail key " + detailKeyId));
            throw new ApplicationException("Exception to get EntityType");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Completed getEntity.");
        }
        return entity;
    }

    private Long getLongValue(Object object) {
        return object != null ? new Long(object.toString()) : 0L;
    }
}

