/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.budget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.CGeneralLedger;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.utils.BudgetReportEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class BudgetAppropriationService
extends PersistenceService {
    private FinancialYearDAO financialYearDAO;
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    public void setFinancialYearDAO(FinancialYearHibernateDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }

    public List<Object> getBudgetDetailsForBill(EgBillregister bill) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (bill != null && bill.getEgBillregistermis() != null && bill.getEgBillregistermis().getBudgetaryAppnumber() != null && !"".equalsIgnoreCase(bill.getEgBillregistermis().getBudgetaryAppnumber())) {
            CFinancialYear financialYear = this.financialYearDAO.getFinancialYearByDate(bill.getBilldate());
            for (EgBilldetails detail : bill.getEgBilldetailes()) {
                CChartOfAccounts coa = (CChartOfAccounts)this.find("from CChartOfAccounts where id=?", new Object[]{Long.valueOf(detail.getGlcodeid().toString())});
                if (!this.isBudgetCheckNeeded(coa)) continue;
                BudgetReportEntry budgetReportEntry = new BudgetReportEntry();
                this.populateDepartmentForBill(bill, budgetReportEntry);
                this.populateFundForBill(bill, budgetReportEntry);
                this.populateDataForBill(bill, financialYear, detail, budgetReportEntry, coa);
                list.add(budgetReportEntry);
            }
        }
        return list;
    }

    public List<Object> getBudgetDetailsForVoucher(CVoucherHeader voucher) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (voucher != null && voucher.getVouchermis().getBudgetaryAppnumber() != null && voucher.getVouchermis().getBudgetaryAppnumber() != null && !"".equalsIgnoreCase(voucher.getVouchermis().getBudgetaryAppnumber())) {
            CFinancialYear financialYear = this.financialYearDAO.getFinancialYearByDate(voucher.getVoucherDate());
            List ledgerDetails = this.findAllBy("from CGeneralLedger where voucherHeaderId.id=?", new Object[]{voucher.getId()});
            Department dept = this.getDepartmentForVoucher(voucher);
            for (CGeneralLedger detail : ledgerDetails) {
                if (!this.isBudgetCheckNeeded(detail.getGlcodeId())) continue;
                BudgetReportEntry budgetReportEntry = new BudgetReportEntry();
                this.populateDataForVoucher(voucher, financialYear, detail, budgetReportEntry);
                budgetReportEntry.setDepartmentName(dept.getName());
                if (voucher.getFundId() != null) {
                    budgetReportEntry.setFundName(voucher.getFundId().getName());
                }
                list.add(budgetReportEntry);
            }
        }
        return list;
    }

    private boolean isBudgetCheckNeeded(CChartOfAccounts coa) {
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "budgetCheckRequired");
        boolean checkReq = false;
        if ("Y".equalsIgnoreCase(((AppConfigValues)list.get(0)).getValue()) && null != coa && null != coa.getBudgetCheckReq() && coa.getBudgetCheckReq().booleanValue()) {
            checkReq = true;
        }
        return checkReq;
    }

    private void populateDataForBill(EgBillregister bill, CFinancialYear financialYear, EgBilldetails detail, BudgetReportEntry budgetReportEntry, CChartOfAccounts coa) {
        CFunction function = this.getFunction(detail);
        Map<String, Object> budgetDataMap = this.getRequiredBudgetDataForBill(bill, financialYear, function, coa);
        budgetReportEntry.setFunctionName(function.getName());
        budgetReportEntry.setGlCode(coa.getGlcode());
        budgetReportEntry.setFinancialYear(financialYear.getFinYearRange());
        BigDecimal budgetedAmtForYear = BigDecimal.ZERO;
        budgetedAmtForYear = this.budgetDetailsDAO.getBudgetedAmtForYear(budgetDataMap);
        budgetReportEntry.setBudgetedAmtForYear(budgetedAmtForYear);
        this.populateBudgetAppNumber(bill, budgetReportEntry);
        BigDecimal billAmount = this.getBillAmount(detail);
        BigDecimal soFarAppropriated = BigDecimal.ZERO;
        soFarAppropriated = this.getSoFarAppropriated(budgetDataMap, billAmount);
        budgetReportEntry.setAccountCode(coa.getGlcode());
        budgetReportEntry.setSoFarAppropriated(soFarAppropriated);
        BigDecimal balance = budgetReportEntry.getBudgetedAmtForYear().subtract(budgetReportEntry.getSoFarAppropriated());
        budgetReportEntry.setBalance(balance);
        budgetReportEntry.setCumilativeIncludingCurrentBill(soFarAppropriated.add(billAmount));
        budgetReportEntry.setCurrentBalanceAvailable(balance.subtract(billAmount));
        budgetReportEntry.setCurrentBillAmount(billAmount);
    }

    private void populateDataForVoucher(CVoucherHeader voucher, CFinancialYear financialYear, CGeneralLedger detail, BudgetReportEntry budgetReportEntry) {
        CFunction function = this.getFunctionForGl(detail);
        CChartOfAccounts coa = detail.getGlcodeId();
        Map<String, Object> budgetDataMap = this.getRequiredBudgetDataForVoucher(voucher, financialYear, function, coa);
        budgetReportEntry.setFunctionName(function.getName());
        budgetReportEntry.setGlCode(coa.getGlcode());
        budgetReportEntry.setFinancialYear(financialYear.getFinYearRange());
        BigDecimal budgetedAmtForYear = BigDecimal.ZERO;
        budgetedAmtForYear = this.budgetDetailsDAO.getBudgetedAmtForYear(budgetDataMap);
        budgetReportEntry.setBudgetedAmtForYear(budgetedAmtForYear);
        this.populateBudgetAppNumberForVoucher(voucher, budgetReportEntry);
        BigDecimal billAmount = this.getVoucherAmount(detail);
        BigDecimal soFarAppropriated = BigDecimal.ZERO;
        soFarAppropriated = this.getSoFarAppropriated(budgetDataMap, billAmount);
        budgetReportEntry.setAccountCode(coa.getGlcode());
        budgetReportEntry.setSoFarAppropriated(soFarAppropriated);
        BigDecimal balance = budgetReportEntry.getBudgetedAmtForYear().subtract(budgetReportEntry.getSoFarAppropriated());
        budgetReportEntry.setBalance(balance);
        budgetReportEntry.setCumilativeIncludingCurrentBill(soFarAppropriated.add(billAmount));
        budgetReportEntry.setCurrentBalanceAvailable(balance.subtract(billAmount));
        budgetReportEntry.setCurrentBillAmount(billAmount);
    }

    private BigDecimal getBillAmount(EgBilldetails billDetail) {
        BigDecimal currentBillAmount = BigDecimal.ZERO;
        currentBillAmount = billDetail.getDebitamount() != null && billDetail.getDebitamount().compareTo(BigDecimal.ZERO) != 0 ? billDetail.getDebitamount() : billDetail.getCreditamount();
        return currentBillAmount;
    }

    private BigDecimal getVoucherAmount(CGeneralLedger detail) {
        BigDecimal currentBillAmount = BigDecimal.ZERO;
        currentBillAmount = detail.getDebitAmount() != null && detail.getDebitAmount() != 0.0 ? new BigDecimal(detail.getDebitAmount()) : new BigDecimal(detail.getCreditAmount());
        return currentBillAmount;
    }

    private void populateFundForBill(EgBillregister bill, BudgetReportEntry budgetReportEntry) {
        if (bill.getEgBillregistermis().getFund() != null) {
            budgetReportEntry.setFundName(bill.getEgBillregistermis().getFund().getName());
        }
    }

    private void populateDepartmentForBill(EgBillregister bill, BudgetReportEntry budgetReportEntry) {
        if (bill.getEgBillregistermis().getEgDepartment() != null) {
            budgetReportEntry.setDepartmentName(bill.getEgBillregistermis().getEgDepartment().getName());
        }
    }

    private Department getDepartmentForVoucher(CVoucherHeader voucher) {
        if (voucher != null && voucher.getVouchermis().getDepartmentid() != null) {
            return (Department)this.find("from Department where id=?", new Object[]{voucher.getVouchermis().getDepartmentid().getId()});
        }
        return null;
    }

    private CFunction getFunction(EgBilldetails detail) {
        return (CFunction)this.find("from CFunction where id=?", new Object[]{Long.valueOf(detail.getFunctionid().toString())});
    }

    private CFunction getFunctionForGl(CGeneralLedger detail) {
        if (detail.getFunctionId() != null) {
            return (CFunction)this.find("from CFunction where id=?", new Object[]{Long.valueOf(detail.getFunctionId().toString())});
        }
        return null;
    }

    private void populateBudgetAppNumber(EgBillregister bill, BudgetReportEntry budgetReportEntry) {
        if (!StringUtils.isBlank((String)bill.getEgBillregistermis().getBudgetaryAppnumber())) {
            budgetReportEntry.setBudgetApprNumber(bill.getEgBillregistermis().getBudgetaryAppnumber());
        } else if (bill.getEgBillregistermis().getVoucherHeader() != null && !StringUtils.isBlank((String)bill.getEgBillregistermis().getVoucherHeader().getVouchermis().getBudgetaryAppnumber())) {
            budgetReportEntry.setBudgetApprNumber(bill.getEgBillregistermis().getVoucherHeader().getVouchermis().getBudgetaryAppnumber());
        }
    }

    private void populateBudgetAppNumberForVoucher(CVoucherHeader voucher, BudgetReportEntry budgetReportEntry) {
        if (!StringUtils.isBlank((String)voucher.getVouchermis().getBudgetaryAppnumber())) {
            budgetReportEntry.setBudgetApprNumber(voucher.getVouchermis().getBudgetaryAppnumber());
        }
    }

    private Map<String, Object> getRequiredBudgetDataForBill(EgBillregister cbill, CFinancialYear financialYear, CFunction function, CChartOfAccounts coa) {
        HashMap<String, Object> budgetDataMap = new HashMap<String, Object>();
        budgetDataMap.put("financialyearid", financialYear.getId());
        budgetDataMap.put("deptid", cbill.getEgBillregistermis().getEgDepartment().getId());
        if (cbill.getEgBillregistermis().getFunctionaryid() != null) {
            budgetDataMap.put("functionaryid", cbill.getEgBillregistermis().getFunctionaryid().getId());
        }
        if (cbill.getEgBillregistermis().getScheme() != null) {
            budgetDataMap.put("schemeid", cbill.getEgBillregistermis().getScheme().getId());
        }
        if (cbill.getEgBillregistermis().getSubScheme() != null) {
            budgetDataMap.put("subschemeid", cbill.getEgBillregistermis().getSubScheme().getId());
        }
        budgetDataMap.put("fundid", cbill.getEgBillregistermis().getFund().getId());
        budgetDataMap.put("boundaryid", cbill.getDivision());
        budgetDataMap.put("asondate", cbill.getBilldate());
        budgetDataMap.put("functionid", function.getId());
        budgetDataMap.put("fromdate", financialYear.getStartingDate());
        budgetDataMap.put("glcode", coa.getGlcode());
        budgetDataMap.put("glcodeid", coa.getId());
        budgetDataMap.put("budgetheadid", this.budgetDetailsDAO.getBudgetHeadByGlcode(coa));
        return budgetDataMap;
    }

    private Map<String, Object> getRequiredBudgetDataForVoucher(CVoucherHeader voucher, CFinancialYear financialYear, CFunction function, CChartOfAccounts coa) {
        HashMap<String, Object> budgetDataMap = new HashMap<String, Object>();
        budgetDataMap.put("financialyearid", financialYear.getId());
        if (voucher.getVouchermis().getDepartmentid() != null) {
            budgetDataMap.put("deptid", voucher.getVouchermis().getDepartmentid().getId());
        }
        if (voucher.getVouchermis().getFunctionary() != null) {
            budgetDataMap.put("functionaryid", voucher.getVouchermis().getFunctionary().getId());
        }
        if (voucher.getVouchermis().getSchemeid() != null) {
            budgetDataMap.put("schemeid", voucher.getVouchermis().getSchemeid().getId());
        }
        if (voucher.getVouchermis().getSubschemeid() != null) {
            budgetDataMap.put("subschemeid", voucher.getVouchermis().getSubschemeid().getId());
        }
        budgetDataMap.put("fundid", voucher.getFundId().getId());
        if (voucher.getVouchermis().getDivisionid() != null) {
            budgetDataMap.put("boundaryid", voucher.getVouchermis().getDivisionid().getBndryId());
        }
        budgetDataMap.put("asondate", voucher.getVoucherDate());
        if (function != null) {
            budgetDataMap.put("functionid", function.getId());
        }
        budgetDataMap.put("fromdate", financialYear.getStartingDate());
        budgetDataMap.put("glcode", coa.getGlcode());
        budgetDataMap.put("glcodeid", coa.getId());
        budgetDataMap.put("budgetheadid", this.budgetDetailsDAO.getBudgetHeadByGlcode(coa));
        return budgetDataMap;
    }

    private BigDecimal getSoFarAppropriated(Map<String, Object> budgetDataMap, BigDecimal billAmount) {
        BigDecimal soFarAppropriated = BigDecimal.ZERO;
        BigDecimal actualAmtFromVoucher = this.budgetDetailsDAO.getActualBudgetUtilizedForBudgetaryCheck(budgetDataMap);
        BigDecimal actualAmtFromBill = this.budgetDetailsDAO.getBillAmountForBudgetCheck(budgetDataMap);
        if (actualAmtFromVoucher != null) {
            actualAmtFromVoucher = actualAmtFromVoucher == null ? BigDecimal.ZERO : actualAmtFromVoucher;
            soFarAppropriated = soFarAppropriated.add(actualAmtFromVoucher);
        }
        if (actualAmtFromBill != null) {
            actualAmtFromBill = actualAmtFromBill == null ? BigDecimal.ZERO : actualAmtFromBill;
            soFarAppropriated = soFarAppropriated.add(actualAmtFromBill).subtract(billAmount);
        }
        return soFarAppropriated;
    }
}

