/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.budget;

import java.util.Date;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.hibernate.validator.constraints.Length;

@Unique(fields={"name"}, id="id", columnName={"NAME"}, tableName="EGF_BUDGET", message="budget.name.isunique")
public class Budget
extends StateAware {
    private static final long serialVersionUID = 3592259793739732756L;
    private Long id;
    private String name;
    private String isbere;
    private CFinancialYear financialYear;
    private Budget parent;
    @Length(max=250, message="Max 250 characters are allowed for description")
    private String description;
    private Date asOnDate;
    private boolean isActiveBudget;
    private boolean isPrimaryBudget;
    private String materializedPath;
    private Budget referenceBudget;
    private Long documentNumber;
    private EgwStatus status;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Budget getParent() {
        return this.parent;
    }

    public void setParent(Budget parent) {
        this.parent = parent;
    }

    public Date getAsOnDate() {
        return this.asOnDate;
    }

    public void setAsOnDate(Date asOnDate) {
        this.asOnDate = asOnDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    @Required(message="Financial Year is required")
    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setFinancialYear(CFinancialYear finYear) {
        this.financialYear = finYear;
    }

    @Required(message="Name should not be empty")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Required(message="BE/RE is required")
    public String getIsbere() {
        if (this.isbere == null) {
            this.isbere = "BE";
        }
        return this.isbere;
    }

    public void setIsbere(String isbere) {
        this.isbere = isbere;
    }

    public boolean getIsActiveBudget() {
        return this.isActiveBudget;
    }

    public void setIsActiveBudget(boolean isActiveBudget) {
        this.isActiveBudget = isActiveBudget;
    }

    public boolean getIsPrimaryBudget() {
        return this.isPrimaryBudget;
    }

    public void setIsPrimaryBudget(boolean isPrimaryBudget) {
        this.isPrimaryBudget = isPrimaryBudget;
    }

    public String getStateDetails() {
        return this.name;
    }

    public String getMaterializedPath() {
        return this.materializedPath;
    }

    public void setMaterializedPath(String materializedPath) {
        this.materializedPath = materializedPath;
    }

    public void setReferenceBudget(Budget reference) {
        this.referenceBudget = reference;
    }

    public Budget getReferenceBudget() {
        return this.referenceBudget;
    }

    public void setDocumentNumber(Long documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getDocumentNumber() {
        return this.documentNumber;
    }

    public String myLinkId() {
        return this.getId().toString();
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public void setWfState(State state) {
        this.setState(state);
    }
}

