/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.brs;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.commons.Bankaccount;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CVoucherHeader;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.model.brs.BrsEntrieMis;
import org.egov.model.instrument.InstrumentHeader;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="BANKENTRIES")
@SequenceGenerator(name="SEQ_BANKENTRIES", sequenceName="SEQ_BANKENTRIES", allocationSize=1)
public class BrsEntries
extends AbstractPersistable<Long> {
    private static final long serialVersionUID = 8924403787977830824L;
    public static final String SEQ_BANKENTRIES = "SEQ_BANKENTRIES";
    @Id
    @GeneratedValue(generator="SEQ_BANKENTRIES", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(max=20)
    private String refNo;
    @Length(max=20)
    private String type;
    private Date txnDate;
    private BigDecimal txnAmount;
    @Length(max=100)
    private String remarks;
    @ManyToOne
    @JoinColumn(name="glcodeid")
    private CChartOfAccounts glCodeId;
    @ManyToOne
    @JoinColumn(name="instrumentheaderid")
    private InstrumentHeader instrumentHeaderId;
    @ManyToOne
    @JoinColumn(name="voucherheaderid")
    private CVoucherHeader voucherHeaderId;
    @ManyToOne
    @JoinColumn(name="bankaccountid")
    private Bankaccount bankaccountId;
    private Integer isreversed;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="bankentries", targetEntity=BrsEntrieMis.class)
    private Set<BrsEntrieMis> bankentriesMis = new HashSet<BrsEntrieMis>(0);
    @Transient
    private String voucherNumber = "";
    @Transient
    private String cgnum = "";
    @Transient
    private String payinSlipVHeaderId = "";
    @Transient
    private String fundId = "";
    @Transient
    private String fundSourceId = "";
    @Transient
    private String chequeNumber = "";
    @Transient
    private String chequeDate = "";
    @Transient
    private String amount = "";
    @Transient
    private String lotNumber = "";
    @Transient
    private String lotType = "";
    @Transient
    private String field = "";
    @Transient
    private String voucherType = "";
    @Transient
    private String bankName = "";
    @Transient
    private String accNumber = "";
    @Transient
    private String accIdParam = "";
    @Transient
    private String payTo = "";
    @Transient
    private String payCheque = "";
    @Transient
    private String departmentId;
    @Transient
    private String functionaryId;
    @Transient
    private String functionId = "";

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRefNo() {
        return this.refNo;
    }

    public void setRefNo(String refNo) {
        this.refNo = refNo;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getTxnDate() {
        return this.txnDate;
    }

    public void setTxnDate(Date txnDate) {
        this.txnDate = txnDate;
    }

    public BigDecimal getTxnAmount() {
        return this.txnAmount;
    }

    public void setTxnAmount(BigDecimal txnAmount) {
        this.txnAmount = txnAmount;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public CChartOfAccounts getGlCodeId() {
        return this.glCodeId;
    }

    public void setGlCodeId(CChartOfAccounts glCodeId) {
        this.glCodeId = glCodeId;
    }

    public InstrumentHeader getInstrumentHeaderId() {
        return this.instrumentHeaderId;
    }

    public void setInstrumentHeaderId(InstrumentHeader instrumentHeaderId) {
        this.instrumentHeaderId = instrumentHeaderId;
    }

    public CVoucherHeader getVoucherHeaderId() {
        return this.voucherHeaderId;
    }

    public void setVoucherHeaderId(CVoucherHeader voucherHeaderId) {
        this.voucherHeaderId = voucherHeaderId;
    }

    public String getVoucherNumber() {
        return this.voucherNumber;
    }

    public void setVoucherNumber(String voucherNumber) {
        this.voucherNumber = voucherNumber;
    }

    public String getCgnum() {
        return this.cgnum;
    }

    public void setCgnum(String cgnum) {
        this.cgnum = cgnum;
    }

    public String getPayinSlipVHeaderId() {
        return this.payinSlipVHeaderId;
    }

    public void setPayinSlipVHeaderId(String payinSlipVHeaderId) {
        this.payinSlipVHeaderId = payinSlipVHeaderId;
    }

    public String getFundId() {
        return this.fundId;
    }

    public void setFundId(String fundId) {
        this.fundId = fundId;
    }

    public String getFundSourceId() {
        return this.fundSourceId;
    }

    public void setFundSourceId(String fundSourceId) {
        this.fundSourceId = fundSourceId;
    }

    public String getChequeNumber() {
        return this.chequeNumber;
    }

    public void setChequeNumber(String chequeNumber) {
        this.chequeNumber = chequeNumber;
    }

    public String getChequeDate() {
        return this.chequeDate;
    }

    public void setChequeDate(String chequeDate) {
        this.chequeDate = chequeDate;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getLotNumber() {
        return this.lotNumber;
    }

    public void setLotNumber(String lotNumber) {
        this.lotNumber = lotNumber;
    }

    public String getLotType() {
        return this.lotType;
    }

    public void setLotType(String lotType) {
        this.lotType = lotType;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getVoucherType() {
        return this.voucherType;
    }

    public void setVoucherType(String voucherType) {
        this.voucherType = voucherType;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getAccNumber() {
        return this.accNumber;
    }

    public void setAccNumber(String accNumber) {
        this.accNumber = accNumber;
    }

    public String getAccIdParam() {
        return this.accIdParam;
    }

    public void setAccIdParam(String accIdParam) {
        this.accIdParam = accIdParam;
    }

    public String getPayTo() {
        return this.payTo;
    }

    public void setPayTo(String payTo) {
        this.payTo = payTo;
    }

    public String getPayCheque() {
        return this.payCheque;
    }

    public void setPayCheque(String payCheque) {
        this.payCheque = payCheque;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public String getFunctionaryId() {
        return this.functionaryId;
    }

    public void setFunctionaryId(String functionaryId) {
        this.functionaryId = functionaryId;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public Bankaccount getBankaccountId() {
        return this.bankaccountId;
    }

    public void setBankaccountId(Bankaccount bankaccountId) {
        this.bankaccountId = bankaccountId;
    }

    public Integer getIsreversed() {
        return this.isreversed;
    }

    public void setIsreversed(Integer isreversed) {
        this.isreversed = isreversed;
    }

    public Set<BrsEntrieMis> getBankentriesMis() {
        return this.bankentriesMis;
    }

    public void setBankentriesMis(Set<BrsEntrieMis> bankentriesMis) {
        this.bankentriesMis = bankentriesMis;
    }
}

