/*
 * Decompiled with CFR 0.152.
 */
package org.egov.model.bills;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBillregister;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EG_BILLDETAILS")
@SequenceGenerator(name="SEQ_EG_BILLDETAILS", sequenceName="SEQ_EG_BILLDETAILS", allocationSize=1)
public class EgBilldetails
extends AbstractPersistable<Integer>
implements Serializable {
    private static final long serialVersionUID = -6045669915919744421L;
    public static final String SEQ_EG_BILLDETAILS = "SEQ_EG_BILLDETAILS";
    @Id
    @GeneratedValue(generator="SEQ_EG_BILLDETAILS", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @ManyToOne
    @JoinColumn(name="billid")
    private EgBillregister egBillregister;
    private BigDecimal functionid;
    private BigDecimal glcodeid;
    private BigDecimal debitamount;
    private BigDecimal creditamount;
    private Date lastupdatedtime;
    @Length(max=250)
    private String narration;
    @OrderBy(value="id")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="egBilldetailsId", targetEntity=EgBillPayeedetails.class)
    private Set<EgBillPayeedetails> egBillPaydetailes = new HashSet<EgBillPayeedetails>(0);

    public EgBilldetails() {
    }

    public EgBilldetails(Integer id, EgBillregister egBillregister, BigDecimal glcodeid, Date lastupdatedtime) {
        this.id = id;
        this.egBillregister = egBillregister;
        this.glcodeid = glcodeid;
        this.lastupdatedtime = lastupdatedtime;
    }

    public EgBilldetails(Integer id, EgBillregister egBillregister, BigDecimal functionid, BigDecimal glcodeid, BigDecimal debitamount, BigDecimal creditamount, Date lastupdatedtime, Set<EgBillPayeedetails> egBillPaydetailes, String narration) {
        this.id = id;
        this.egBillregister = egBillregister;
        this.functionid = functionid;
        this.glcodeid = glcodeid;
        this.debitamount = debitamount;
        this.creditamount = creditamount;
        this.lastupdatedtime = lastupdatedtime;
        this.egBillPaydetailes = egBillPaydetailes;
        this.narration = narration;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public EgBillregister getEgBillregister() {
        return this.egBillregister;
    }

    public void setEgBillregister(EgBillregister egBillregister) {
        this.egBillregister = egBillregister;
    }

    public BigDecimal getFunctionid() {
        return this.functionid;
    }

    public void setFunctionid(BigDecimal functionid) {
        this.functionid = functionid;
    }

    public BigDecimal getGlcodeid() {
        return this.glcodeid;
    }

    public void setGlcodeid(BigDecimal glcodeid) {
        this.glcodeid = glcodeid;
    }

    public BigDecimal getDebitamount() {
        return this.debitamount;
    }

    public void setDebitamount(BigDecimal debitamount) {
        this.debitamount = debitamount;
    }

    public BigDecimal getCreditamount() {
        return this.creditamount;
    }

    public void setCreditamount(BigDecimal creditamount) {
        this.creditamount = creditamount;
    }

    public Date getLastupdatedtime() {
        return this.lastupdatedtime;
    }

    public void setLastupdatedtime(Date lastupdatedtime) {
        this.lastupdatedtime = lastupdatedtime;
    }

    public Set<EgBillPayeedetails> getEgBillPaydetailes() {
        return this.egBillPaydetailes;
    }

    public void setEgBillPaydetailes(Set<EgBillPayeedetails> egBillPaydetailes) {
        this.egBillPaydetailes = egBillPaydetailes;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public void addEgBillPayeedetail(EgBillPayeedetails egbillpayee) {
        if (egbillpayee != null) {
            this.getEgBillPaydetailes().add(egbillpayee);
        }
    }

    public void removeEgBillPayeedetail(EgBillPayeedetails egbillpayee) {
        if (egbillpayee != null) {
            this.getEgBillPaydetailes().remove(egbillpayee);
        }
    }
}

