/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.model;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Fund;
import org.egov.egf.model.DepartmentwiseExpenditureResult;

public class DepartmentwiseExpenditureReport {
    private String departmentName;
    private Integer fundId;
    private String month;
    private Fund fund;
    private Date concurrenceDate;
    private Date fromDate;
    private Date toDate;
    private Long financialYearId;
    private CFinancialYear finyearObj = null;
    private String reportType;
    private String period;
    private String assetCode;
    private Date previousYearConcurrenceGivenUptoDate;
    private Date currentYearConcurrenceGivenUptoDate;
    private Date previousYearConcurrenceGivenTillDate;
    Set<String> concurrenceDateSet = new LinkedHashSet<String>();
    Set<String> previousConcurrenceDateSet = new LinkedHashSet<String>();
    Map<String, Boolean> rowToBeRemoved = new HashMap<String, Boolean>();
    private String exportType;
    private List<DepartmentwiseExpenditureResult> currentyearDepartmentList = new LinkedList<DepartmentwiseExpenditureResult>();
    private List<DepartmentwiseExpenditureResult> previousyearDepartmentList = new LinkedList<DepartmentwiseExpenditureResult>();
    private BigDecimal concurrenceAmount;

    public void reset() {
        this.departmentName = null;
        this.fundId = null;
        this.month = null;
        this.fromDate = null;
        this.toDate = null;
        this.reportType = null;
        this.period = null;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public String getMonth() {
        return this.month;
    }

    public Date getConcurrenceDate() {
        return this.concurrenceDate;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public String getReportType() {
        return this.reportType;
    }

    public BigDecimal getConcurrenceAmount() {
        return this.concurrenceAmount;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public void setConcurrenceDate(Date concurrenceDate) {
        this.concurrenceDate = concurrenceDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public void setConcurrenceAmount(BigDecimal concurrenceAmount) {
        this.concurrenceAmount = concurrenceAmount;
    }

    public List<DepartmentwiseExpenditureResult> getCurrentyearDepartmentList() {
        return this.currentyearDepartmentList;
    }

    public void setCurrentyearDepartmentList(List<DepartmentwiseExpenditureResult> currentyearDepartmentList) {
        this.currentyearDepartmentList = currentyearDepartmentList;
    }

    public Set<String> getConcurrenceDateSet() {
        return this.concurrenceDateSet;
    }

    public void setConcurrenceDateSet(Set<String> concurrenceDateSet) {
        this.concurrenceDateSet = concurrenceDateSet;
    }

    public boolean containsDepartmentInResultList(String department, List<DepartmentwiseExpenditureResult> resList) {
        if (department == null) {
            return false;
        }
        for (DepartmentwiseExpenditureResult entry : resList) {
            if (!department.equalsIgnoreCase(entry.getDepartmentNm())) continue;
            return true;
        }
        return false;
    }

    public Integer getFundId() {
        return this.fundId;
    }

    public Long getFinancialYearId() {
        return this.financialYearId;
    }

    public void setFundId(Integer fundId) {
        this.fundId = fundId;
    }

    public void setFinancialYearId(Long financialYearId) {
        this.financialYearId = financialYearId;
    }

    public CFinancialYear getFinyearObj() {
        return this.finyearObj;
    }

    public void setFinyearObj(CFinancialYear finyearObj) {
        this.finyearObj = finyearObj;
    }

    public String getExportType() {
        return this.exportType;
    }

    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    public void addDepartmentToResultSet(DepartmentwiseExpenditureResult entry) {
        if (this.getPeriod().equalsIgnoreCase("current")) {
            this.getCurrentyearDepartmentList().add(entry);
        } else if (this.getPeriod().equalsIgnoreCase("previous")) {
            this.getPreviousyearDepartmentList().add(entry);
        }
    }

    public Date getRestrictedDepartmentDate() {
        Calendar date = Calendar.getInstance();
        date.set(1, 2013);
        date.set(2, 2);
        date.set(5, 31);
        return date.getTime();
    }

    public Date getPreviousDateFor(Date date) {
        GregorianCalendar previousDate = new GregorianCalendar();
        previousDate.setTime(date);
        int prevDt = previousDate.get(5) - 1;
        previousDate.set(5, prevDt);
        return previousDate.getTime();
    }

    public void addDepartmentwiseExistingEntry(DepartmentwiseExpenditureResult entry) {
        for (DepartmentwiseExpenditureResult obj : this.getCurrentyearDepartmentList()) {
            if (!obj.getDepartmentNm().equals(entry.getDepartmentNm())) continue;
        }
    }

    public List<DepartmentwiseExpenditureResult> getPreviousyearDepartmentList() {
        return this.previousyearDepartmentList;
    }

    public void setPreviousyearDepartmentList(List<DepartmentwiseExpenditureResult> previousyearDepartmentList) {
        this.previousyearDepartmentList = previousyearDepartmentList;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public Set<String> getPreviousConcurrenceDateSet() {
        return this.previousConcurrenceDateSet;
    }

    public void setPreviousConcurrenceDateSet(Set<String> previousConcurrenceDateSet) {
        this.previousConcurrenceDateSet = previousConcurrenceDateSet;
    }

    public Date getStartOfMonth() {
        String year = "";
        Calendar date = Calendar.getInstance();
        year = this.month.equals("01") || this.month.equals("02") || this.month.equals("03") ? this.getFinyearObj().getEndingDate().toString().substring(0, 4) : this.getFinyearObj().getStartingDate().toString().substring(0, 4);
        date.set(1, Integer.parseInt(year));
        date.set(2, Integer.parseInt(this.month));
        date.set(5, 1);
        date.set(5, date.getActualMaximum(5));
        return date.getTime();
    }

    public Date getEndMonth() {
        String year = "";
        Calendar date = Calendar.getInstance();
        year = this.month.equals("01") || this.month.equals("02") || this.month.equals("03") ? this.getFinyearObj().getEndingDate().toString().substring(0, 4) : this.getFinyearObj().getStartingDate().toString().substring(0, 4);
        date.set(1, Integer.parseInt(year));
        date.set(2, Integer.parseInt(this.month));
        date.set(5, 1);
        date.set(5, date.getActualMaximum(5));
        return date.getTime();
    }

    public Date getPreviousYearConcurrenceGivenUptoDate() {
        return this.previousYearConcurrenceGivenUptoDate;
    }

    public Date getPreviousYearConcurrenceGivenTillDate() {
        return this.previousYearConcurrenceGivenTillDate;
    }

    public void setPreviousYearConcurrenceGivenUptoDate(Date previousYearConcurrenceGivenUptoDate) {
        this.previousYearConcurrenceGivenUptoDate = previousYearConcurrenceGivenUptoDate;
    }

    public void setPreviousYearConcurrenceGivenTillDate(Date previousYearConcurrenceGivenTillDate) {
        this.previousYearConcurrenceGivenTillDate = previousYearConcurrenceGivenTillDate;
    }

    public Date getCurrentYearConcurrenceGivenUptoDate() {
        return this.currentYearConcurrenceGivenUptoDate;
    }

    public void setCurrentYearConcurrenceGivenUptoDate(Date currentYearConcurrenceGivenUptoDate) {
        this.currentYearConcurrenceGivenUptoDate = currentYearConcurrenceGivenUptoDate;
    }

    public String getAssetCode() {
        return this.assetCode;
    }

    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public Map<String, Boolean> getRowToBeRemoved() {
        return this.rowToBeRemoved;
    }

    public void setRowToBeRemoved(Map<String, Boolean> rowToBeRemoved) {
        this.rowToBeRemoved = rowToBeRemoved;
    }
}

