/*
 * Decompiled with CFR 0.152.
 */
package org.egov.egf.commons;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.utils.Constants;
import org.egov.utils.FinancialConstants;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class VoucherSearchUtil {
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private static final Logger LOGGER = Logger.getLogger(VoucherSearchUtil.class);
    private FinancialYearDAO financialYearDAO;

    public List<CVoucherHeader> search(CVoucherHeader voucherHeader, Date fromDate, Date toDate, String mode) throws ApplicationException, ParseException {
        boolean modeIsNotBlank;
        System.out.println("Inside search ----- in voucher util");
        String sql = "";
        ArrayList<CVoucherHeader> voucherList = new ArrayList();
        sql = sql + this.voucherFilterQuery(voucherHeader, fromDate, toDate, mode);
        String statusExclude = this.excludeVoucherStatus();
        boolean bl = modeIsNotBlank = null != mode && !StringUtils.isBlank((String)mode);
        if (modeIsNotBlank) {
            if ("edit".equalsIgnoreCase(mode)) {
                sql = sql + " and (vh.isConfirmed is null or vh.isConfirmed != 1)";
            } else if ("reverse".equalsIgnoreCase(mode)) {
                sql = sql + " and vh.isConfirmed = 1";
            }
            statusExclude = statusExclude + "," + FinancialConstants.REVERSEDVOUCHERSTATUS.toString() + "," + FinancialConstants.REVERSALVOUCHERSTATUS;
        }
        if (modeIsNotBlank && "edit".equalsIgnoreCase(mode) && voucherHeader.getType().equalsIgnoreCase("Journal Voucher")) {
            String jvModifyCondition = " and vh.status in (" + FinancialConstants.CREATEDVOUCHERSTATUS + ") and vh.moduleId is null ";
            String editModeQuery1 = " from CVoucherHeader vh where vh not in ( select billVoucherHeader from Miscbilldetail) " + jvModifyCondition;
            String editModeQuery2 = " select distinct(vh) from  Miscbilldetail misc left join misc.billVoucherHeader vh where misc.billVoucherHeader is not null" + jvModifyCondition + sql;
            voucherList.addAll(this.persistenceService.findAllBy(editModeQuery1 + sql, new Object[0]));
            if (LOGGER.isDebugEnabled()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"---NO Associated Payment");
                }
                for (CVoucherHeader vh : voucherList) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("-----" + vh.getId()));
                }
            }
            voucherList.addAll(this.persistenceService.findAllBy(editModeQuery2, new Object[0]));
            if (LOGGER.isDebugEnabled()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"---Associated Payment");
                }
                for (CVoucherHeader vh : voucherList) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("-----" + vh.getId()));
                }
            }
            String editModeQuery3 = " select misc.billVoucherHeader.id from CVoucherHeader ph, Miscbilldetail misc,CVoucherHeader vh  where misc.payVoucherHeader=ph and   misc.billVoucherHeader is not null and misc.billVoucherHeader=vh and ph.status  in (" + FinancialConstants.CREATEDVOUCHERSTATUS + "," + FinancialConstants.PREAPPROVEDVOUCHERSTATUS + ") " + jvModifyCondition + sql;
            List vouchersHavingActivePayments = this.persistenceService.findAllBy(editModeQuery3, new Object[0]);
            ArrayList<CVoucherHeader> vchList = voucherList;
            String uncancelledRemittances = " SELECT distinct(vh.id) FROM EgRemittanceDetail r, EgRemittanceGldtl rgd, Generalledgerdetail gld, CGeneralLedger gl, EgRemittance rd, CVoucherHeader vh ,Vouchermis billmis, CVoucherHeader remittedvh  WHERE r.egRemittanceGldtl=rgd AND rgd.generalledgerdetail=gld AND gld.generalledger=gl AND r.egRemittance=rd AND rd.voucherheader=remittedvh AND gl.voucherHeaderId =vh AND remittedvh =billmis.voucherheaderid and remittedvh.status!=" + FinancialConstants.CANCELLEDVOUCHERSTATUS + " ";
            List remittanceBillVhIdList = this.persistenceService.findAllBy(uncancelledRemittances + sql, new Object[0]);
            if (LOGGER.isDebugEnabled()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"---Active Bill  Remittance Payments");
                }
                for (Long vh : remittanceBillVhIdList) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("-----" + vh));
                }
            }
            remittanceBillVhIdList.addAll(vouchersHavingActivePayments);
            ArrayList toBeRemovedList = new ArrayList();
            if (vchList != null && vchList.size() != 0 && remittanceBillVhIdList != null && remittanceBillVhIdList.size() != 0) {
                for (int i = 0; i < vchList.size(); ++i) {
                    if (!remittanceBillVhIdList.contains(((CVoucherHeader)vchList.get(i)).getId())) continue;
                    toBeRemovedList.add(voucherList.get(i));
                }
                for (CVoucherHeader vh : toBeRemovedList) {
                    voucherList.remove(vh);
                }
            }
            return voucherList;
        }
        voucherList = this.persistenceService.findAllBy(" from CVoucherHeader vh where vh.status not in (" + statusExclude + ") " + sql + " order by vh.voucherNumber ", new Object[0]);
        return voucherList;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public List<CVoucherHeader> searchNonBillVouchers(CVoucherHeader voucherHeader, Date fromDate, Date toDate, String mode) {
        String sql = "";
        ArrayList<CVoucherHeader> voucherList = new ArrayList();
        if (!voucherHeader.getType().equals("-1")) {
            sql = sql + " and vh.type='" + voucherHeader.getType() + "'";
        }
        sql = voucherHeader.getName() != null && !voucherHeader.getName().equalsIgnoreCase("-1") ? sql + " and vh.name='" + voucherHeader.getName() + "'" : sql + " and vh.name in ('" + "Contractor Journal" + "','" + "Supplier Journal" + "','" + "Salary Journal" + "')";
        if (voucherHeader.getVoucherNumber() != null && !voucherHeader.getVoucherNumber().equals("")) {
            sql = sql + " and vh.voucherNumber like '%" + voucherHeader.getVoucherNumber() + "%'";
        }
        if (fromDate != null) {
            sql = sql + " and vh.voucherDate>='" + Constants.DDMMYYYYFORMAT1.format(fromDate) + "'";
        }
        if (toDate != null) {
            sql = sql + " and vh.voucherDate<='" + Constants.DDMMYYYYFORMAT1.format(toDate) + "'";
        }
        if (voucherHeader.getFundId() != null) {
            sql = sql + " and vh.fundId=" + voucherHeader.getFundId().getId();
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            sql = sql + " and vh.fundsourceId=" + voucherHeader.getVouchermis().getFundsource().getId();
        }
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql = sql + " and vh.vouchermis.departmentid=" + voucherHeader.getVouchermis().getDepartmentid().getId();
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            sql = sql + " and vh.vouchermis.schemeid=" + voucherHeader.getVouchermis().getSchemeid().getId();
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql = sql + " and vh.vouchermis.subschemeid=" + voucherHeader.getVouchermis().getSubschemeid().getId();
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            sql = sql + " and vh.vouchermis.functionary=" + voucherHeader.getVouchermis().getFunctionary().getId();
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            sql = sql + " and vh.vouchermis.divisionid=" + voucherHeader.getVouchermis().getDivisionid().getId();
        }
        String sql1 = sql + " and  (vh.id  in (select voucherHeader.id from EgBillregistermis) and vh.id not in (select billVoucherHeader.id from Miscbilldetail where billVoucherHeader is not null and  payVoucherHeader  in (select id from CVoucherHeader where status not in (4,1) and type='Payment')) )";
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("finance", "statusexcludeReport");
        String statusExclude = ((AppConfigValues)appList.get(0)).getValue();
        statusExclude = statusExclude + "," + FinancialConstants.REVERSEDVOUCHERSTATUS.toString() + "," + FinancialConstants.REVERSALVOUCHERSTATUS;
        String finalQuery = " from CVoucherHeader vh where vh.status not in (" + statusExclude + ") " + sql1 + "  ";
        voucherList = this.persistenceService.findAllBy(finalQuery, new Object[0]);
        return voucherList;
    }

    public String voucherFilterQuery(CVoucherHeader voucherHeader, Date fromDate, Date toDate, String mode) {
        String sql = "";
        if (!voucherHeader.getType().equals("-1")) {
            sql = sql + " and vh.type='" + voucherHeader.getType() + "'";
        }
        if (voucherHeader.getName() != null && !voucherHeader.getName().equalsIgnoreCase("0") && !voucherHeader.getName().equalsIgnoreCase("-1")) {
            sql = sql + " and vh.name='" + voucherHeader.getName() + "'";
        }
        if (voucherHeader.getVoucherNumber() != null && !voucherHeader.getVoucherNumber().equals("")) {
            sql = sql + " and vh.voucherNumber like '%" + voucherHeader.getVoucherNumber() + "%'";
        }
        if (fromDate != null) {
            sql = sql + " and vh.voucherDate>='" + Constants.DDMMYYYYFORMAT1.format(fromDate) + "'";
        }
        if (toDate != null) {
            sql = sql + " and vh.voucherDate<='" + Constants.DDMMYYYYFORMAT1.format(toDate) + "'";
        }
        if (voucherHeader.getFundId() != null) {
            sql = sql + " and vh.fundId=" + voucherHeader.getFundId().getId();
        }
        if (voucherHeader.getVouchermis().getFundsource() != null) {
            sql = sql + " and vh.fundsourceId=" + voucherHeader.getVouchermis().getFundsource().getId();
        }
        if (voucherHeader.getVouchermis().getDepartmentid() != null) {
            sql = sql + " and vh.vouchermis.departmentid=" + voucherHeader.getVouchermis().getDepartmentid().getId();
        }
        if (voucherHeader.getVouchermis().getSchemeid() != null) {
            sql = sql + " and vh.vouchermis.schemeid=" + voucherHeader.getVouchermis().getSchemeid().getId();
        }
        if (voucherHeader.getVouchermis().getSubschemeid() != null) {
            sql = sql + " and vh.vouchermis.subschemeid=" + voucherHeader.getVouchermis().getSubschemeid().getId();
        }
        if (voucherHeader.getVouchermis().getFunctionary() != null) {
            sql = sql + " and vh.vouchermis.functionary=" + voucherHeader.getVouchermis().getFunctionary().getId();
        }
        if (voucherHeader.getVouchermis().getDivisionid() != null) {
            sql = sql + " and vh.vouchermis.divisionid=" + voucherHeader.getVouchermis().getDivisionid().getId();
        }
        if (voucherHeader.getModuleId() != null) {
            sql = voucherHeader.getModuleId() == -2 ? sql + " and vh.moduleId is null " : sql + " and vh.moduleId=" + voucherHeader.getModuleId();
        }
        return sql;
    }

    public String excludeVoucherStatus() {
        List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", "statusexcludeReport");
        return ((AppConfigValues)appList.get(0)).getValue();
    }

    public List<Query> voucherSearchQuery(CVoucherHeader voucherHeader, Date fromDate, Date toDate, String mode) {
        ArrayList<Query> queryList = new ArrayList<Query>();
        String statusExclude = this.excludeVoucherStatus();
        String sql = this.voucherFilterQuery(voucherHeader, fromDate, toDate, mode);
        String sqlQuery = "from CVoucherHeader vh where vh.status not in (" + statusExclude + ") " + sql + " order by vh.voucherNumber ,vh.voucherDate,vh.name ";
        Query query1 = this.persistenceService.getSession().createQuery(sqlQuery);
        queryList.add(query1);
        Query query2 = this.persistenceService.getSession().createQuery("select count(*) from CVoucherHeader vh where vh.status not in (" + statusExclude + ") " + sql);
        queryList.add(query2);
        return queryList;
    }

    public boolean validateFinancialYearForPosting(Date fromDate, Date toDate) {
        return this.financialYearDAO.isFinancialYearActiveForPosting(fromDate, toDate);
    }

    public void setFinancialYearDAO(FinancialYearDAO financialYearDAO) {
        this.financialYearDAO = financialYearDAO;
    }
}

