/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dao.budget;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FunctionDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.bills.EgBillregister;
import org.egov.model.budget.BudgetDetail;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.budget.BudgetUsage;
import org.egov.services.budget.BudgetDetailService;
import org.egov.services.budget.BudgetGroupService;
import org.egov.services.budget.BudgetService;
import org.egov.services.budget.BudgetUsageService;
import org.egov.utils.BudgetAccountType;
import org.egov.utils.Constants;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class BudgetDetailsHibernateDAO
implements BudgetDetailsDAO {
    @PersistenceContext
    private EntityManager entityManager;
    private static final String EGF = "EGF";
    private static final String BUDGETHEADID = "budgetheadid";
    private static final String GLCODEID = "glcodeid";
    private static final String BUDGETARY_CHECK_GROUPBY_VALUES = "budgetaryCheck_groupby_values";
    private Session session;
    private static final Logger LOGGER = Logger.getLogger(BudgetDetailsHibernateDAO.class);
    private static final String EMPTY_STRING = "";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    protected ScriptService scriptService;
    @Autowired
    protected ApplicationSequenceNumberGenerator sequenceGenerator;
    @Autowired
    @Qualifier(value="budgetService")
    private BudgetService budgetService;
    @Autowired
    @Qualifier(value="budgetDetailService")
    private BudgetDetailService budgetDetailService;
    @Autowired
    @Qualifier(value="budgetGroupService")
    private BudgetGroupService budgetGroupService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    @Qualifier(value="financialYearDAO")
    private FinancialYearHibernateDAO financialYearHibDAO;
    @Autowired
    private FunctionDAO functionDAO;
    @Autowired
    @Qualifier(value="budgetUsageService")
    private BudgetUsageService budgetUsageService;

    @Override
    @Transactional
    public BudgetDetail update(BudgetDetail entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public BudgetDetail create(BudgetDetail entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public void delete(BudgetDetail entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    @Override
    public List<BudgetDetail> findAll() {
        return this.getCurrentSession().createCriteria(BudgetDetail.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public boolean consumeEncumbranceBudget(Map<String, Object> detailsMap) {
        if (detailsMap == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("required input is null", "required input is null")));
        }
        detailsMap.put("consume or release", true);
        BigDecimal bd = this.getDetails(detailsMap);
        return bd.intValue() == 1;
    }

    @Override
    public boolean consumeEncumbranceBudget(Long financialyearid, Integer moduleid, String referencenumber, Integer departmentid, Long functionid, Integer functionaryid, Integer schemeid, Integer subschemeid, Integer boundaryid, List<Long> budgetheadid, Integer fundid, double amount, String appropriationnumber) throws ValidationException {
        BigDecimal bd = this.getDetails(financialyearid, moduleid, referencenumber, departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, budgetheadid, fundid, amount, true, appropriationnumber);
        return bd.intValue() == 1;
    }

    @Override
    @Deprecated
    public BudgetUsage consumeEncumbranceBudget(String appropriationnumber, Long financialyearid, Integer moduleid, String referencenumber, Integer departmentid, Long functionid, Integer functionaryid, Integer schemeid, Integer subschemeid, Integer boundaryid, List<Long> budgetheadid, Integer fundid, double amount) throws ValidationException {
        return this.getBudgetUsageDetails(financialyearid, moduleid, referencenumber, departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, budgetheadid, fundid, amount, true, appropriationnumber);
    }

    public boolean releaseEncumbranceBudget(Map<String, Object> detailsMap) {
        if (detailsMap == null) {
            throw new ValidationException(Arrays.asList(new ValidationError("required input is null", "required input is null")));
        }
        detailsMap.put("consume or release", false);
        BigDecimal bd = this.getDetails(detailsMap);
        return bd.intValue() == 1;
    }

    @Override
    @Deprecated
    public void releaseEncumbranceBudget(Long financialyearid, Integer moduleid, String referencenumber, Integer departmentid, Long functionid, Integer functionaryid, Integer schemeid, Integer subschemeid, Integer boundaryid, List<Long> budgetheadid, Integer fundid, double amount, String appropriationnumber) throws ValidationException {
        this.getDetails(financialyearid, moduleid, referencenumber, departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, budgetheadid, fundid, amount, false, appropriationnumber);
    }

    @Override
    @Transactional
    public BudgetUsage releaseEncumbranceBudget(String appropriationnumber, Long financialyearid, Integer moduleid, String referencenumber, Integer departmentid, Long functionid, Integer functionaryid, Integer schemeid, Integer subschemeid, Integer boundaryid, List<Long> budgetheadid, Integer fundid, double amount) throws ValidationException {
        return this.getBudgetUsageDetails(financialyearid, moduleid, referencenumber, departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, budgetheadid, fundid, amount, false, appropriationnumber);
    }

    private BigDecimal getDetails(Map<String, Object> detailsMap) throws ValidationException {
        Long financialyearid = null;
        Integer moduleid = null;
        String referencenumber = null;
        Integer departmentid = null;
        Long functionid = null;
        Integer functionaryid = null;
        Integer schemeid = null;
        Integer subschemeid = null;
        Integer boundaryid = null;
        List budgetheadid = null;
        Integer fundid = null;
        double amount = 0.0;
        String appropriationnumber = null;
        Boolean consumeOrRelease = null;
        if (detailsMap.containsKey("financialyearid")) {
            financialyearid = (Long)detailsMap.get("financialyearid");
        }
        if (detailsMap.containsKey("module id")) {
            moduleid = (Integer)detailsMap.get("module id");
        }
        if (detailsMap.containsKey("reference number")) {
            referencenumber = (String)detailsMap.get("reference number");
        }
        if (detailsMap.containsKey("departmentId")) {
            departmentid = (Integer)detailsMap.get("departmentId");
        }
        if (detailsMap.containsKey("functionid")) {
            functionid = (Long)detailsMap.get("functionid");
        }
        if (detailsMap.containsKey("functionaryid")) {
            functionaryid = (Integer)detailsMap.get("functionaryid");
        }
        if (detailsMap.containsKey("schemeid")) {
            schemeid = (Integer)detailsMap.get("schemeid");
        }
        if (detailsMap.containsKey("subschemeid")) {
            subschemeid = (Integer)detailsMap.get("subschemeid");
        }
        if (detailsMap.containsKey("boundaryid")) {
            boundaryid = (Integer)detailsMap.get("boundaryid");
        }
        if (detailsMap.containsKey("budget heed")) {
            budgetheadid = (List)detailsMap.get("budget heed");
        }
        if (detailsMap.containsKey("fundid")) {
            fundid = (Integer)detailsMap.get("fundid");
        }
        if (detailsMap.containsKey("amount")) {
            amount = (Double)detailsMap.get("amount");
        }
        if (detailsMap.containsKey("budget appr number")) {
            appropriationnumber = (String)detailsMap.get("budget appr number");
        }
        if (detailsMap.containsKey("consume or release")) {
            consumeOrRelease = (Boolean)detailsMap.get("consume or release");
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("financialyearid==" + financialyearid + ",moduleid==" + moduleid + ",referencenumber==" + referencenumber + ",departmentid==" + departmentid + ",functionid==" + functionid + ",functionaryid==" + functionaryid + ",schemeid==" + schemeid + ",subschemeid==" + subschemeid + ",boundaryid==" + boundaryid + ",budgetheadid==" + budgetheadid + ",amount==" + amount));
            }
            this.validateMandatoryParameters(moduleid, referencenumber);
            BigDecimal amtavailable = this.getPlanningBudgetAvailable(financialyearid, departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, budgetheadid, fundid);
            amtavailable = consumeOrRelease != false ? amtavailable.subtract(BigDecimal.valueOf(amount)) : amtavailable.add(BigDecimal.valueOf(amount));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("budget available after consuming/releasing=" + amtavailable));
            }
            if (amtavailable != null && amtavailable.compareTo(BigDecimal.ZERO) >= 0) {
                String query = this.prepareQuery(departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, fundid);
                Query q = this.getCurrentSession().createQuery(" from BudgetDetail bd where  bd.budget.financialYear.id=:finYearId and bd.budget.isbere=:type and bd.budgetGroup.id in (:bgId)" + query);
                if (this.budgetService.hasApprovedReForYear(financialyearid)) {
                    q.setParameter("type", (Object)"RE");
                } else {
                    q.setParameter("type", (Object)"BE");
                }
                q.setParameter("finYearId", (Object)financialyearid);
                q.setParameterList("bgId", (Collection)budgetheadid);
                List bdList = q.list();
                if (bdList == null || bdList.size() == 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"IN consumeEncumbranceBudget()-getDetail() - No budget detail item defined for RE or BE for this combination!!");
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("financial year id - " + financialyearid.toString() + " Budget Group -  " + budgetheadid.toString() + " Query - " + query));
                    }
                    throw new ValidationException(EMPTY_STRING, "Budgetary Check Failed", new String[0]);
                }
                BudgetDetail bd = (BudgetDetail)((Object)bdList.get(0));
                bd.setBudgetAvailable(amtavailable);
                this.update(bd);
                BudgetUsage budgetUsage = new BudgetUsage();
                budgetUsage.setFinancialYearId(financialyearid.intValue());
                budgetUsage.setModuleId(moduleid);
                budgetUsage.setReferenceNumber(referencenumber);
                budgetUsage.setBudgetDetail(bd);
                budgetUsage.setAppropriationnumber(appropriationnumber);
                if (consumeOrRelease.booleanValue()) {
                    budgetUsage.setConsumedAmount(amount);
                    budgetUsage.setReleasedAmount(0.0);
                } else {
                    budgetUsage.setConsumedAmount(0.0);
                    budgetUsage.setReleasedAmount(amount);
                }
                budgetUsage.setCreatedby(ApplicationThreadLocals.getUserId().intValue());
                this.budgetUsageService.create(budgetUsage);
                return BigDecimal.ONE;
            }
            return BigDecimal.ZERO;
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in consumeEncumbranceBudget API()===" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in consumeEncumbranceBudget API()=" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
    }

    @Deprecated
    private BigDecimal getDetails(Long financialyearid, Integer moduleid, String referencenumber, Integer departmentid, Long functionid, Integer functionaryid, Integer schemeid, Integer subschemeid, Integer boundaryid, List<Long> budgetheadid, Integer fundid, double amount, boolean consumeOrRelease, String appropriationnumber) throws ValidationException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("financialyearid==" + financialyearid + ",moduleid==" + moduleid + ",referencenumber==" + referencenumber + ",departmentid==" + departmentid + ",functionid==" + functionid + ",functionaryid==" + functionaryid + ",schemeid==" + schemeid + ",subschemeid==" + subschemeid + ",boundaryid==" + boundaryid + ",budgetheadid==" + budgetheadid + ",amount==" + amount));
            }
            this.validateMandatoryParameters(moduleid, referencenumber);
            BigDecimal amtavailable = this.getPlanningBudgetAvailable(financialyearid, departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, budgetheadid, fundid);
            amtavailable = consumeOrRelease ? amtavailable.subtract(BigDecimal.valueOf(amount)) : amtavailable.add(BigDecimal.valueOf(amount));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("budget available after consuming/releasing=" + amtavailable));
            }
            if (amtavailable != null && amtavailable.compareTo(BigDecimal.ZERO) >= 0) {
                String query = this.prepareQuery(departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, fundid);
                Query q = this.persistenceService.getSession().createQuery(" from BudgetDetail bd where  bd.budget.financialYear.id=:finYearId  and  bd.budget.isbere=:type and bd.budgetGroup.id in (:bgId)" + query);
                if (this.budgetService.hasApprovedReForYear(financialyearid)) {
                    q.setParameter("type", (Object)"RE");
                } else {
                    q.setParameter("type", (Object)"BE");
                }
                q.setParameter("finYearId", (Object)financialyearid);
                q.setParameterList("bgId", budgetheadid);
                List bdList = q.list();
                if (bdList == null || bdList.size() == 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"IN consumeEncumbranceBudget()-getDetail() - No budget detail item defined for RE or BE for this combination!!");
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("financial year id - " + financialyearid.toString() + " Budget Group -  " + budgetheadid.toString() + " Query - " + query));
                    }
                    throw new ValidationException(EMPTY_STRING, "Budgetary Check Failed", new String[0]);
                }
                BudgetDetail bd = (BudgetDetail)((Object)bdList.get(0));
                bd.setBudgetAvailable(amtavailable);
                this.update(bd);
                BudgetUsage budgetUsage = new BudgetUsage();
                budgetUsage.setFinancialYearId(financialyearid.intValue());
                budgetUsage.setModuleId(moduleid);
                budgetUsage.setReferenceNumber(referencenumber);
                budgetUsage.setBudgetDetail(bd);
                budgetUsage.setAppropriationnumber(appropriationnumber);
                if (consumeOrRelease) {
                    budgetUsage.setConsumedAmount(amount);
                    budgetUsage.setReleasedAmount(0.0);
                } else {
                    budgetUsage.setConsumedAmount(0.0);
                    budgetUsage.setReleasedAmount(amount);
                }
                budgetUsage.setCreatedby(ApplicationThreadLocals.getUserId().intValue());
                this.budgetUsageService.create(budgetUsage);
                return BigDecimal.ONE;
            }
            return BigDecimal.ZERO;
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in consumeEncumbranceBudget API()===" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in consumeEncumbranceBudget API()=" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
    }

    @Deprecated
    @Transactional
    private BudgetUsage getBudgetUsageDetails(Long financialyearid, Integer moduleid, String referencenumber, Integer departmentid, Long functionid, Integer functionaryid, Integer schemeid, Integer subschemeid, Integer boundaryid, List<Long> budgetheadid, Integer fundid, double amount, boolean consumeOrRelease, String appropriationnumber) throws ValidationException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("financialyearid==" + financialyearid + ",moduleid==" + moduleid + ",referencenumber==" + referencenumber + ",departmentid==" + departmentid + ",functionid==" + functionid + ",functionaryid==" + functionaryid + ",schemeid==" + schemeid + ",subschemeid==" + subschemeid + ",boundaryid==" + boundaryid + ",budgetheadid==" + budgetheadid + ",amount==" + amount));
            }
            this.validateMandatoryParameters(moduleid, referencenumber);
            BigDecimal amtavailable = this.getPlanningBudgetAvailable(financialyearid, departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, budgetheadid, fundid);
            amtavailable = consumeOrRelease ? amtavailable.subtract(BigDecimal.valueOf(amount)) : amtavailable.add(BigDecimal.valueOf(amount));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("budget available after consuming/releasing=" + amtavailable));
            }
            if (amtavailable != null && amtavailable.compareTo(BigDecimal.ZERO) >= 0) {
                String query = this.prepareQuery(departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, fundid);
                Query q = this.persistenceService.getSession().createQuery(" from BudgetDetail bd where  bd.budget.financialYear.id=:finYearId  and  bd.budget.isbere=:type and bd.budgetGroup.id in (:bgId)" + query);
                if (this.budgetService.hasApprovedReForYear(financialyearid)) {
                    q.setParameter("type", (Object)"RE");
                } else {
                    q.setParameter("type", (Object)"BE");
                }
                q.setParameter("finYearId", (Object)financialyearid);
                q.setParameterList("bgId", budgetheadid);
                List bdList = q.list();
                if (bdList == null || bdList.size() == 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"IN consumeEncumbranceBudget()-getDetail() - No budget detail item defined for RE or BE for this combination!!");
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("financial year id - " + financialyearid.toString() + " Budget Group -  " + budgetheadid.toString() + " Query - " + query));
                    }
                    throw new ValidationException(EMPTY_STRING, "Budgetary Check Failed", new String[0]);
                }
                BudgetDetail bd = (BudgetDetail)((Object)bdList.get(0));
                bd.setBudgetAvailable(amtavailable);
                this.budgetDetailService.update((Object)bd);
                BudgetUsage budgetUsage = new BudgetUsage();
                budgetUsage.setFinancialYearId(financialyearid.intValue());
                budgetUsage.setModuleId(moduleid);
                budgetUsage.setReferenceNumber(referencenumber);
                budgetUsage.setBudgetDetail(bd);
                budgetUsage.setAppropriationnumber(appropriationnumber);
                if (consumeOrRelease) {
                    budgetUsage.setConsumedAmount(amount);
                    budgetUsage.setReleasedAmount(0.0);
                } else {
                    budgetUsage.setConsumedAmount(0.0);
                    budgetUsage.setReleasedAmount(amount);
                }
                budgetUsage.setCreatedby(ApplicationThreadLocals.getUserId().intValue());
                this.budgetUsageService.create(budgetUsage);
                return budgetUsage;
            }
            return null;
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in consumeEncumbranceBudget API()===" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in consumeEncumbranceBudget API()=" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
    }

    private void validateParameters(Long financialyearid, Long functionid, List<Long> budgetheadid) throws ValidationException {
        if (financialyearid == null) {
            throw new ValidationException(EMPTY_STRING, "Financial year id is null or empty", new String[0]);
        }
        if (functionid == null) {
            throw new ValidationException(EMPTY_STRING, "Function id is null or empty", new String[0]);
        }
        if (budgetheadid == null || budgetheadid.size() == 0) {
            throw new ValidationException(EMPTY_STRING, "Budget head id is null or empty", new String[0]);
        }
        this.session = this.getCurrentSession();
        CFinancialYear financialyear = this.financialYearHibDAO.findById((Number)financialyearid, false);
        if (financialyear == null) {
            throw new ValidationException(EMPTY_STRING, "Financial year is null or empty", new String[0]);
        }
        CFunction function = this.functionDAO.findById((Number)functionid, false);
        if (function == null) {
            throw new ValidationException(EMPTY_STRING, "Function is null or empty", new String[0]);
        }
        for (Long bgId : budgetheadid) {
            BudgetGroup budgetGroup = (BudgetGroup)((Object)this.budgetGroupService.findById(bgId, false));
            if (budgetGroup != null) continue;
            throw new ValidationException(EMPTY_STRING, "Budget head is null or empty", new String[0]);
        }
    }

    private String prepareAgregateQuery(Integer departmentid, Long functionid, Integer functionaryid, Integer schemeid, Integer subschemeid, Integer boundaryid, Integer fundid) throws ValidationException {
        String query = EMPTY_STRING;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Inside the prepareAgregateQuery... " + departmentid + " >>>" + fundid));
        }
        if (departmentid != null && departmentid != 0) {
            query = query + this.getQuery(Department.class, departmentid, " and bd.executingDepartment=");
        }
        if (functionid != null && functionid != 0L) {
            query = query + this.getQuery(CFunction.class, functionid, " and bd.function=");
        }
        if (functionaryid != null && functionaryid != 0) {
            query = query + this.getQuery(Functionary.class, functionaryid, " and bd.functionary=");
        }
        if (fundid != null && fundid != 0) {
            query = query + this.getQuery(Fund.class, fundid, " and bd.fund=");
        }
        if (schemeid != null && schemeid != 0) {
            query = query + this.getQuery(Scheme.class, schemeid, " and bd.scheme=");
        }
        if (subschemeid != null && subschemeid != 0) {
            query = query + this.getQuery(SubScheme.class, subschemeid, " and bd.subScheme=");
        }
        if (boundaryid != null && boundaryid != 0) {
            query = query + this.getQuery(Boundary.class, boundaryid, " and bd.boundary=");
        }
        return " and bd.budget.status.code = 'Approved' " + query;
    }

    private String prepareQuery(Integer departmentid, Long functionid, Integer functionaryid, Integer schemeid, Integer subschemeid, Integer boundaryid, Integer fundid) throws ValidationException {
        String[] values;
        String query = EMPTY_STRING;
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, BUDGETARY_CHECK_GROUPBY_VALUES);
        if (list.isEmpty()) {
            throw new ValidationException(EMPTY_STRING, "budgetaryCheck_groupby_values is not defined in AppConfig", new String[0]);
        }
        AppConfigValues appConfigValues = (AppConfigValues)list.get(0);
        for (String value : values = StringUtils.split((String)appConfigValues.getValue(), (String)",")) {
            if (value.equals("department")) {
                if (departmentid == null || departmentid == 0) {
                    throw new ValidationException(EMPTY_STRING, "Department is required", new String[0]);
                }
                query = query + this.getQuery(Department.class, Long.valueOf(departmentid.longValue()), " and bd.executingDepartment=");
                continue;
            }
            if (value.equals("function")) {
                if (functionid == null || functionid == 0L) {
                    throw new ValidationException(EMPTY_STRING, "Function is required", new String[0]);
                }
                query = query + this.getQuery(CFunction.class, functionid, " and bd.function=");
                continue;
            }
            if (value.equals("functionary")) {
                if (functionaryid == null || functionaryid == 0) {
                    throw new ValidationException(EMPTY_STRING, "Functionary is required", new String[0]);
                }
                query = query + this.getQuery(Functionary.class, functionaryid, " and bd.functionary=");
                continue;
            }
            if (value.equals("fund")) {
                if (fundid == null || fundid == 0) {
                    throw new ValidationException(EMPTY_STRING, "Fund is required", new String[0]);
                }
                query = query + this.getQuery(Fund.class, fundid, " and bd.fund=");
                continue;
            }
            if (value.equals("scheme")) {
                if (schemeid == null || schemeid == 0) {
                    throw new ValidationException(EMPTY_STRING, "Scheme is required", new String[0]);
                }
                query = query + this.getQuery(Scheme.class, schemeid, " and bd.scheme=");
                continue;
            }
            if (value.equals("subscheme")) {
                if (subschemeid == null || subschemeid == 0) {
                    throw new ValidationException(EMPTY_STRING, "Subscheme is required", new String[0]);
                }
                query = query + this.getQuery(SubScheme.class, subschemeid, " and bd.subScheme=");
                continue;
            }
            if (value.equals("boundary")) {
                if (boundaryid == null || boundaryid == 0) {
                    throw new ValidationException(EMPTY_STRING, "Boundary is required", new String[0]);
                }
                query = query + this.getQuery(Boundary.class, Long.valueOf(boundaryid.longValue()), " and bd.boundary=");
                continue;
            }
            throw new ValidationException(EMPTY_STRING, "budgetaryCheck_groupby_values is not matching=" + value, new String[0]);
        }
        return " and bd.budget.status.description='Approved' and bd.status.description='Approved'  " + query;
    }

    private Object findById(Class clazz, Serializable id) throws ValidationException {
        if (id == null) {
            throw new ValidationException(EMPTY_STRING, clazz.getSimpleName() + " id is null or empty", new String[0]);
        }
        Object object = this.session.get(clazz, id);
        if (object == null) {
            throw new ValidationException(EMPTY_STRING, clazz.getSimpleName() + " is not defined for this id [ " + id.toString() + " ]", new String[0]);
        }
        return object;
    }

    protected List<String> getFieldConfigValues() {
        List appconfigFieldlist = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, BUDGETARY_CHECK_GROUPBY_VALUES);
        return Arrays.asList(((AppConfigValues)appconfigFieldlist.get(0)).getValue().split(","));
    }

    private void validateMandatoryParameters(Integer moduleid, String referencenumber) throws ValidationException {
        this.validateMandatoryParameter(moduleid, "Module id");
        if (StringUtils.isBlank((String)referencenumber)) {
            throw new ValidationException(EMPTY_STRING, "Reference number is null or empty", new String[0]);
        }
    }

    private void validateMandatoryParameter(Object value, String description) throws ValidationException {
        if (value == null) {
            throw new ValidationException(EMPTY_STRING, description + " is null or empty", new String[0]);
        }
    }

    @Override
    public BigDecimal getPlanningBudgetAvailable(Long financialyearid, Integer departmentid, Long functionid, Integer functionaryid, Integer schemeid, Integer subschemeid, Integer boundaryid, List<Long> budgetheadid, Integer fundid) throws ValidationException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("financialyearid===" + financialyearid + ",departmentid===" + departmentid + ",functionid===" + functionid + ",functionaryid===" + functionaryid + ",schemeid===" + schemeid + ",subschemeid===" + subschemeid + ",boundaryid===" + boundaryid + ",budgetheadid===" + budgetheadid));
            }
            this.validateParameters(financialyearid, functionid, budgetheadid);
            String query = this.prepareQuery(departmentid, functionid, functionaryid, schemeid, subschemeid, boundaryid, fundid);
            this.session = this.getCurrentSession();
            CFinancialYear financialyear = this.financialYearHibDAO.findById((Number)financialyearid, false);
            String finalquery = "select sum (budgetAvailable) from BudgetDetail bd where bd.budget.isbere=:type and bd.budget.financialYear.id=:financialyearid and bd.budgetGroup.id in (:budgetheadid) " + query;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Final query=" + finalquery));
            }
            Query q = this.getCurrentSession().createQuery(finalquery);
            if (this.budgetService.hasApprovedReForYear(financialyearid)) {
                q.setParameter("type", (Object)"RE");
            } else {
                q.setParameter("type", (Object)"BE");
            }
            q.setParameter("financialyearid", (Object)financialyearid);
            q.setParameterList(BUDGETHEADID, budgetheadid);
            Object obj = q.uniqueResult();
            if (obj == null) {
                throw new ValidationException("no.budget.defined.for.given.parameters", "No Budget is defined for the parameters for this year->" + financialyear.getFinYearRange(), new String[0]);
            }
            return (BigDecimal)obj;
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getPlanningBudgetAvailable API()===" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getPlanningBudgetAvailable API()=" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
    }

    @Override
    public BigDecimal getActualBudgetUtilized(Map<String, Object> paramMap) throws ValidationException {
        Long deptid = null;
        Long functionid = null;
        Integer functionaryid = null;
        Integer schemeid = null;
        Integer subschemeid = null;
        Integer boundaryid = null;
        Integer fundid = null;
        Long budgetheadid = null;
        Date fromdate = null;
        Date asondate = null;
        String query = EMPTY_STRING;
        String select = EMPTY_STRING;
        BudgetGroup budgetgroup = null;
        try {
            Object ob;
            if (paramMap.get("deptid") != null) {
                deptid = (Long)paramMap.get("deptid");
            }
            if (paramMap.get("functionid") != null) {
                functionid = (Long)paramMap.get("functionid");
            }
            if (paramMap.get("functionaryid") != null) {
                functionaryid = (Integer)paramMap.get("functionaryid");
            }
            if (paramMap.get("schemeid") != null) {
                schemeid = (Integer)paramMap.get("schemeid");
            }
            if (paramMap.get("fundid") != null) {
                fundid = (Integer)paramMap.get("fundid");
            }
            if (paramMap.get("subschemeid") != null) {
                subschemeid = (Integer)paramMap.get("subschemeid");
            }
            if (paramMap.get("boundaryid") != null) {
                boundaryid = (Integer)paramMap.get("boundaryid");
            }
            if (paramMap.get(BUDGETHEADID) != null) {
                budgetheadid = (Long)paramMap.get(BUDGETHEADID);
            }
            if (paramMap.get("asondate") != null) {
                asondate = (Date)paramMap.get("asondate");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("deptid=" + deptid + ",functionid=" + functionid + ",functionaryid=" + functionaryid + ",schemeid=" + schemeid + ",subschemeid=" + subschemeid + ",boundaryid=" + boundaryid + ",budgetheadid=" + budgetheadid + ",asondate=" + asondate));
            }
            if (asondate == null) {
                throw new ValidationException(EMPTY_STRING, "As On Date is null", new String[0]);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
            CFinancialYear finyear = this.financialYearHibDAO.getFinancialYearByDate(asondate);
            if (finyear == null) {
                throw new ValidationException(EMPTY_STRING, "Financial year is not fefined for this date [" + sdf.format(asondate) + "]", new String[0]);
            }
            fromdate = finyear.getStartingDate();
            query = query + this.getQuery(CFunction.class, functionid, " and gl.functionId=");
            query = query + this.getQuery(Department.class, deptid, " and vmis.departmentid=");
            query = query + this.getQuery(Functionary.class, functionaryid, " and vmis.functionary=");
            query = query + this.getQuery(Scheme.class, schemeid, " and vmis.schemeid=");
            query = query + this.getQuery(SubScheme.class, subschemeid, " and vmis.subschemeid=");
            query = query + this.getQuery(Fund.class, fundid, " and vh.fundId=");
            query = query + this.getQuery(Boundary.class, boundaryid, " and vmis.divisionid=");
            if (budgetheadid == null || budgetheadid.equals(EMPTY_STRING)) {
                throw new ValidationException(EMPTY_STRING, "Budget head id is null or empty", new String[0]);
            }
            budgetgroup = (BudgetGroup)((Object)this.budgetGroupService.findById(budgetheadid, false));
            if (budgetgroup == null || budgetgroup.getId() == null) {
                throw new ValidationException(EMPTY_STRING, "Budget Head is not defined for this id [ " + budgetheadid + " ]", new String[0]);
            }
            List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "coa_majorcode_length");
            if (appList.isEmpty()) {
                throw new ValidationException(EMPTY_STRING, "coa_majorcode_length is not defined in AppConfig", new String[0]);
            }
            int majorcodelength = Integer.valueOf(((AppConfigValues)appList.get(0)).getValue());
            if (budgetgroup.getMinCode() != null) {
                query = query + " and substr(gl.glcode,1," + budgetgroup.getMinCode().getGlcode().length() + ")<='" + budgetgroup.getMinCode().getGlcode() + "' ";
                query = budgetgroup.getMaxCode() == null ? query + " and substr(gl.glcode,1," + budgetgroup.getMinCode().getGlcode().length() + ")>='" + budgetgroup.getMinCode().getGlcode() + "' " : query + " and substr(gl.glcode,1," + budgetgroup.getMinCode().getGlcode().length() + ")>='" + budgetgroup.getMaxCode().getGlcode() + "' ";
            } else if (budgetgroup.getMajorCode() != null) {
                query = query + " and substr(gl.glcode,1," + majorcodelength + ")='" + budgetgroup.getMajorCode().getGlcode() + "'";
            }
            select = BudgetAccountType.REVENUE_RECEIPTS.equals((Object)budgetgroup.getAccountType()) || BudgetAccountType.CAPITAL_RECEIPTS.equals((Object)budgetgroup.getAccountType()) ? " SELECT SUM(gl.creditAmount)-SUM(gl.debitAmount) " : (BudgetAccountType.REVENUE_EXPENDITURE.equals((Object)budgetgroup.getAccountType()) || BudgetAccountType.CAPITAL_EXPENDITURE.equals((Object)budgetgroup.getAccountType()) ? " SELECT SUM(gl.debitAmount)-SUM(gl.creditAmount) " : " SELECT SUM(gl.debitAmount)-SUM(gl.creditAmount) ");
            List list = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "exclude_status_forbudget_actual");
            if (list.isEmpty()) {
                throw new ValidationException(EMPTY_STRING, "exclude_status_forbudget_actual is not defined in AppConfig", new String[0]);
            }
            String voucherstatusExclude = ((AppConfigValues)list.get(0)).getValue();
            query = select + " FROM CGeneralLedger gl,CVoucherHeader vh,Vouchermis vmis where  " + " vh.id = gl.voucherHeaderId.id AND vh.id=vmis.voucherheaderid and (vmis.budgetCheckReq is null or  vmis.budgetCheckReq=true) and vh.status not in (" + voucherstatusExclude + ") and vh.voucherDate>=? and vh.voucherDate <=? " + query;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("loadActualBudget query============" + query));
            }
            if ((ob = this.persistenceService.find(query, new Object[]{fromdate, asondate})) == null) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal(ob.toString());
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getActualBudgetUtilized API()####" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getActualBudgetUtilized API()===" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, "Exp in getActualBudgetUtilized API()===" + e.getMessage(), new String[0]);
        }
    }

    @Override
    public BigDecimal getActualBudgetUtilizedForBudgetaryCheck(Map<String, Object> paramMap) throws ValidationException {
        Long deptid = null;
        Long functionid = null;
        Integer functionaryid = null;
        Integer schemeid = null;
        Integer subschemeid = null;
        Long boundaryid = null;
        Integer fundid = null;
        Object budgetheadid = null;
        Date fromdate = null;
        Date asondate = null;
        String query = EMPTY_STRING;
        String select = EMPTY_STRING;
        try {
            Object ob;
            String[] values;
            if (paramMap.get("deptid") != null) {
                deptid = (Long)paramMap.get("deptid");
            }
            if (paramMap.get("functionid") != null) {
                functionid = (Long)paramMap.get("functionid");
            }
            if (paramMap.get("functionaryid") != null) {
                functionaryid = (Integer)paramMap.get("functionaryid");
            }
            if (paramMap.get("schemeid") != null) {
                schemeid = (Integer)paramMap.get("schemeid");
            }
            if (paramMap.get("fundid") != null) {
                fundid = (Integer)paramMap.get("fundid");
            }
            if (paramMap.get("subschemeid") != null) {
                subschemeid = (Integer)paramMap.get("subschemeid");
            }
            if (paramMap.get("boundaryid") != null) {
                boundaryid = (Long)paramMap.get("boundaryid");
            }
            if (paramMap.get("asondate") != null) {
                asondate = (Date)paramMap.get("asondate");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("deptid=" + deptid + ",functionid=" + functionid + ",functionaryid=" + functionaryid + ",schemeid=" + schemeid + ",subschemeid=" + subschemeid + ",boundaryid=" + boundaryid + ",budgetheadid=" + budgetheadid + ",asondate=" + asondate));
            }
            if (asondate == null) {
                throw new ValidationException(EMPTY_STRING, "As On Date is null", new String[0]);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
            CFinancialYear finyear = this.financialYearHibDAO.getFinancialYearByDate(asondate);
            if (finyear == null) {
                throw new ValidationException(EMPTY_STRING, "Financial year is not fefined for this date [" + sdf.format(asondate) + "]", new String[0]);
            }
            fromdate = finyear.getStartingDate();
            List budgetGrouplist = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, BUDGETARY_CHECK_GROUPBY_VALUES);
            if (budgetGrouplist.isEmpty()) {
                throw new ValidationException(EMPTY_STRING, "budgetaryCheck_groupby_values is not defined in AppConfig", new String[0]);
            }
            AppConfigValues appConfigValues = (AppConfigValues)budgetGrouplist.get(0);
            for (String value : values = StringUtils.split((String)appConfigValues.getValue(), (String)",")) {
                if (value.equals("department")) {
                    query = query + this.getQuery(Department.class, deptid, " and vmis.departmentid=");
                    continue;
                }
                if (value.equals("function")) {
                    query = query + this.getQuery(CFunction.class, functionid, " and gl.functionId=");
                    continue;
                }
                if (value.equals("functionary")) {
                    query = query + this.getQuery(Functionary.class, functionaryid, " and vmis.functionary=");
                    continue;
                }
                if (value.equals("fund")) {
                    query = query + this.getQuery(Fund.class, fundid, " and vh.fundId=");
                    continue;
                }
                if (value.equals("scheme")) {
                    query = query + this.getQuery(Scheme.class, schemeid, " and vmis.schemeid=");
                    continue;
                }
                if (value.equals("subscheme")) {
                    query = query + this.getQuery(SubScheme.class, subschemeid, " and vmis.subschemeid=");
                    continue;
                }
                if (value.equals("boundary")) {
                    query = query + this.getQuery(Boundary.class, boundaryid, " and vmis.divisionid=");
                    continue;
                }
                throw new ValidationException(EMPTY_STRING, "budgetaryCheck_groupby_values is not matching=" + value, new String[0]);
            }
            String glcode = EMPTY_STRING;
            if (paramMap.get("glcode") != null) {
                glcode = paramMap.get("glcode").toString();
            }
            if (EMPTY_STRING.equals(glcode)) {
                throw new ValidationException(EMPTY_STRING, "Glcode is null", new String[0]);
            }
            query = query + " and gl.glcode='" + glcode + "'";
            CChartOfAccounts coa = this.chartOfAccountsHibernateDAO.getCChartOfAccountsByGlCode(glcode);
            if (coa == null) {
                throw new ValidationException(EMPTY_STRING, "Chartofaccounts is null for this glcode:" + glcode, new String[0]);
            }
            select = "I".equalsIgnoreCase(coa.getType().toString()) || "L".equalsIgnoreCase(coa.getType().toString()) ? " SELECT SUM(gl.creditAmount)-SUM(gl.debitAmount) " : " SELECT SUM(gl.debitAmount)-SUM(gl.creditAmount) ";
            List list = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "exclude_status_forbudget_actual");
            if (list.isEmpty()) {
                throw new ValidationException(EMPTY_STRING, "exclude_status_forbudget_actual is not defined in AppConfig", new String[0]);
            }
            ((AppConfigValues)list.get(0)).getValue();
            query = select + " FROM CGeneralLedger gl,CVoucherHeader vh,Vouchermis vmis where  " + " vh.id = gl.voucherHeaderId.id AND vh.id=vmis.voucherheaderid and (vmis.budgetCheckReq=null or vmis.budgetCheckReq=true) and vh.status !=4 and vh.voucherDate>=? and vh.voucherDate <=? " + query;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("loadActualBudget query============" + query));
            }
            if ((ob = this.persistenceService.find(query, new Object[]{fromdate, asondate})) == null) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal(ob.toString());
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getActualBudgetUtilizedForBudgetaryCheck API()===" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getActualBudgetUtilizedForBudgetaryCheck API()===" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, "Exp in getActualBudgetUtilizedForBudgetaryCheck API()===" + e.getMessage(), new String[0]);
        }
    }

    @Override
    public BigDecimal getPlanningBudgetUsage(BudgetDetail bd) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Budget Detail id passed=" + bd.getId()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Budget Detail =" + bd.getUniqueNo() + " budget= " + bd.getBudget().getId() + " FinYear=" + bd.getBudget().getFinancialYear().getId()));
        }
        List budgetDetailIds = this.persistenceService.findAllBy("select id from BudgetDetail bd where uniqueNo=? and bd.budget.financialYear.id=? and bd.status.code='Approved' ", new Object[]{bd.getUniqueNo(), bd.getBudget().getFinancialYear().getId()});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("ids returned if be then 1 id should return else 2 ids should return =" + budgetDetailIds));
        }
        if (budgetDetailIds == null || budgetDetailIds.size() == 0) {
            return BigDecimal.ZERO;
        }
        Query sumQuery = this.getCurrentSession().createQuery("select sum(consumedAmount)-sum(releasedAmount) from BudgetUsage WHERE budgetDetail.id  in ( :IDS )");
        sumQuery.setParameterList("IDS", (Collection)budgetDetailIds);
        Double planningbudgetusage = (Double)sumQuery.list().get(0);
        if (planningbudgetusage == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"NO Consumed Amount");
            }
            return BigDecimal.ZERO;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Consumed Amount =" + BigDecimal.valueOf(planningbudgetusage)));
        }
        return BigDecimal.valueOf(planningbudgetusage);
    }

    @Override
    public BigDecimal getBudgetedAmtForYear(Map<String, Object> paramMap) throws ValidationException {
        Long deptid = null;
        Long functionid = null;
        Integer functionaryid = null;
        Integer schemeid = null;
        Integer subschemeid = null;
        Long boundaryid = null;
        Integer fundid = null;
        List budgetHeadList = null;
        Long financialyearid = null;
        String query = EMPTY_STRING;
        try {
            if (paramMap.get("deptid") != null) {
                deptid = (Long)paramMap.get("deptid");
            }
            if (paramMap.get("functionid") != null) {
                functionid = (Long)paramMap.get("functionid");
            }
            if (paramMap.get("functionaryid") != null) {
                functionaryid = (Integer)paramMap.get("functionaryid");
            }
            if (paramMap.get("schemeid") != null) {
                schemeid = (Integer)paramMap.get("schemeid");
            }
            if (paramMap.get("subschemeid") != null) {
                subschemeid = (Integer)paramMap.get("subschemeid");
            }
            if (paramMap.get("fundid") != null) {
                fundid = (Integer)paramMap.get("fundid");
            }
            if (paramMap.get("boundaryid") != null) {
                boundaryid = (Long)paramMap.get("boundaryid");
            }
            if (paramMap.get(BUDGETHEADID) != null) {
                budgetHeadList = (List)paramMap.get(BUDGETHEADID);
            }
            if (paramMap.get("financialyearid") != null) {
                financialyearid = (Long)paramMap.get("financialyearid");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("deptid " + deptid + ",functionid " + functionid + ",functionaryid " + functionaryid + ",schemeid " + schemeid + ",subschemeid " + subschemeid + ",boundaryid " + boundaryid + ",budgetheadids " + budgetHeadList + ",financialyearid " + financialyearid));
            }
            query = this.prepareQuery(deptid.intValue(), functionid, functionaryid, schemeid, subschemeid, boundaryid != null ? Integer.valueOf(boundaryid.intValue()) : null, fundid);
            if (financialyearid == null) {
                throw new ValidationException(EMPTY_STRING, "Financial Year id is null", new String[0]);
            }
            query = query + this.getQuery(CFinancialYear.class, financialyearid, " and bd.budget.financialYear=");
            if (budgetHeadList == null || budgetHeadList.size() == 0) {
                throw new ValidationException(EMPTY_STRING, "Budget head id is null or empty", new String[0]);
            }
            query = query + " and bd.budgetGroup in ( :budgetHeadList )";
            String finalquery = this.budgetService.hasApprovedReForYear(financialyearid) ? " from BudgetDetail bd where bd.budget.isbere='RE' " + query : " from BudgetDetail bd where bd.budget.isbere='BE' " + query;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Final query=" + finalquery));
            }
            Query hibQuery = this.getCurrentSession().createQuery(finalquery);
            hibQuery.setParameterList("budgetHeadList", (Collection)budgetHeadList);
            List bdList = hibQuery.list();
            if (bdList == null || bdList.size() == 0) {
                return BigDecimal.ZERO;
            }
            return this.getApprovedAmt(bdList);
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getBudgetedAmtForYear==" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getBudgetedAmtForYear==" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, "Exp in getBudgetedAmtForYear==" + e.getMessage(), new String[0]);
        }
    }

    @Override
    public BigDecimal getBudgetedAmtForYearAsOnDate(Map<String, Object> paramMap, Date asOnDate) throws ValidationException {
        Integer deptid = null;
        Long functionid = null;
        Integer functionaryid = null;
        Integer schemeid = null;
        Integer subschemeid = null;
        Integer boundaryid = null;
        Integer fundid = null;
        List budgetHeadList = null;
        Long financialyearid = null;
        String query = EMPTY_STRING;
        try {
            if (paramMap.get("deptid") != null) {
                deptid = (Integer)paramMap.get("deptid");
            }
            if (paramMap.get("functionid") != null) {
                functionid = (Long)paramMap.get("functionid");
            }
            if (paramMap.get("functionaryid") != null) {
                functionaryid = (Integer)paramMap.get("functionaryid");
            }
            if (paramMap.get("schemeid") != null) {
                schemeid = (Integer)paramMap.get("schemeid");
            }
            if (paramMap.get("subschemeid") != null) {
                subschemeid = (Integer)paramMap.get("subschemeid");
            }
            if (paramMap.get("fundid") != null) {
                fundid = (Integer)paramMap.get("fundid");
            }
            if (paramMap.get("boundaryid") != null) {
                boundaryid = (Integer)paramMap.get("boundaryid");
            }
            if (paramMap.get(BUDGETHEADID) != null) {
                budgetHeadList = (List)paramMap.get(BUDGETHEADID);
            }
            if (paramMap.get("financialyearid") != null) {
                financialyearid = (Long)paramMap.get("financialyearid");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("deptid " + deptid + ",functionid " + functionid + ",functionaryid " + functionaryid + ",schemeid " + schemeid + ",subschemeid " + subschemeid + ",boundaryid " + boundaryid + ",budgetheadids " + budgetHeadList + ",financialyearid " + financialyearid));
            }
            query = this.prepareQuery(deptid, functionid, functionaryid, schemeid, subschemeid, boundaryid, fundid);
            if (financialyearid == null) {
                throw new ValidationException(EMPTY_STRING, "Financial Year id is null", new String[0]);
            }
            query = query + this.getQuery(CFinancialYear.class, financialyearid, " and bd.budget.financialYear=");
            if (budgetHeadList == null || budgetHeadList.size() == 0) {
                throw new ValidationException(EMPTY_STRING, "Budget head id is null or empty", new String[0]);
            }
            query = query + " and bd.budgetGroup in ( :budgetHeadList )";
            String finalquery = this.budgetService.hasApprovedReForYear(financialyearid) ? " from BudgetDetail bd where bd.budget.isbere='RE' " + query : " from BudgetDetail bd where bd.budget.isbere='BE' " + query;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Final query=" + finalquery));
            }
            Query hibQuery = this.getCurrentSession().createQuery(finalquery);
            hibQuery.setParameterList("budgetHeadList", (Collection)budgetHeadList);
            List bdList = hibQuery.list();
            if (bdList == null || bdList.size() == 0) {
                return BigDecimal.ZERO;
            }
            return this.getApprovedAmtAsOnDate(bdList, asOnDate);
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getBudgetedAmtForYear==" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getBudgetedAmtForYear==" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, "Exp in getBudgetedAmtForYear==" + e.getMessage(), new String[0]);
        }
    }

    @Override
    public BigDecimal getPlanningPercentForYear(Map<String, Object> paramMap) throws ValidationException {
        Integer deptid = null;
        Long functionid = null;
        Integer functionaryid = null;
        Integer schemeid = null;
        Integer subschemeid = null;
        Integer boundaryid = null;
        Integer fundid = null;
        List budgetHeadList = null;
        Long financialyearid = null;
        String query = EMPTY_STRING;
        try {
            if (paramMap.get("deptid") != null) {
                deptid = (Integer)paramMap.get("deptid");
            }
            if (paramMap.get("functionid") != null) {
                functionid = (Long)paramMap.get("functionid");
            }
            if (paramMap.get("functionaryid") != null) {
                functionaryid = (Integer)paramMap.get("functionaryid");
            }
            if (paramMap.get("schemeid") != null) {
                schemeid = (Integer)paramMap.get("schemeid");
            }
            if (paramMap.get("subschemeid") != null) {
                subschemeid = (Integer)paramMap.get("subschemeid");
            }
            if (paramMap.get("fundid") != null) {
                fundid = (Integer)paramMap.get("fundid");
            }
            if (paramMap.get("boundaryid") != null) {
                boundaryid = (Integer)paramMap.get("boundaryid");
            }
            if (paramMap.get(BUDGETHEADID) != null) {
                budgetHeadList = (List)paramMap.get(BUDGETHEADID);
            }
            if (paramMap.get("financialyearid") != null) {
                financialyearid = (Long)paramMap.get("financialyearid");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("deptid " + deptid + ",functionid " + functionid + ",functionaryid " + functionaryid + ",schemeid " + schemeid + ",subschemeid " + subschemeid + ",boundaryid " + boundaryid + ",budgetheadids " + budgetHeadList + ",financialyearid " + financialyearid));
            }
            query = this.prepareQuery(deptid, functionid, functionaryid, schemeid, subschemeid, boundaryid, fundid);
            if (financialyearid == null) {
                throw new ValidationException(EMPTY_STRING, "Financial Year id is null", new String[0]);
            }
            query = query + this.getQuery(CFinancialYear.class, financialyearid, " and bd.budget.financialYear=");
            if (budgetHeadList == null || budgetHeadList.size() == 0) {
                throw new ValidationException(EMPTY_STRING, "Budget head id is null or empty", new String[0]);
            }
            query = query + " and bd.budgetGroup in ( :budgetHeadList )";
            String finalquery = this.budgetService.hasApprovedReForYear(financialyearid) ? " from BudgetDetail bd where bd.budget.isbere='RE' " + query : " from BudgetDetail bd where bd.budget.isbere='BE' " + query;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Final query=" + finalquery));
            }
            Query hibQuery = this.getCurrentSession().createQuery(finalquery);
            hibQuery.setParameterList("budgetHeadList", (Collection)budgetHeadList);
            List bdList = hibQuery.list();
            if (bdList == null || bdList.size() == 0) {
                return BigDecimal.ZERO;
            }
            if (bdList.size() > 1) {
                LOGGER.error((Object)"returned multiple rows");
                return BigDecimal.ZERO;
            }
            return ((BudgetDetail)((Object)bdList.get(0))).getPlanningPercent();
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getBudgetedAmtForYear==" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getBudgetedAmtForYear==" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, "Exp in getBudgetedAmtForYear==" + e.getMessage(), new String[0]);
        }
    }

    @Override
    public Map<String, BigDecimal> getAggregateBudgetedAmtForYear(Map<String, Object> paramMap) throws ValidationException {
        Integer deptid = null;
        Long functionid = null;
        Integer functionaryid = null;
        Integer schemeid = null;
        Integer subschemeid = null;
        Integer boundaryid = null;
        Integer fundid = null;
        List budgetHeadList = null;
        Long financialyearid = null;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        String query = EMPTY_STRING;
        try {
            List bdList;
            if (paramMap.get("deptid") != null) {
                deptid = (Integer)paramMap.get("deptid");
            }
            if (paramMap.get("functionid") != null) {
                functionid = (Long)paramMap.get("functionid");
            }
            if (paramMap.get("functionaryid") != null) {
                functionaryid = (Integer)paramMap.get("functionaryid");
            }
            if (paramMap.get("schemeid") != null) {
                schemeid = (Integer)paramMap.get("schemeid");
            }
            if (paramMap.get("subschemeid") != null) {
                subschemeid = (Integer)paramMap.get("subschemeid");
            }
            if (paramMap.get("fundid") != null) {
                fundid = (Integer)paramMap.get("fundid");
            }
            if (paramMap.get("boundaryid") != null) {
                boundaryid = (Integer)paramMap.get("boundaryid");
            }
            if (paramMap.get(BUDGETHEADID) != null) {
                budgetHeadList = (List)paramMap.get(BUDGETHEADID);
            }
            if (paramMap.get("financialyearid") != null) {
                financialyearid = (Long)paramMap.get("financialyearid");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Inside getAggregateBudgetedAmtForYear---> deptid " + deptid + ",functionid " + functionid + ",functionaryid " + functionaryid + ",schemeid " + schemeid + ",subschemeid " + subschemeid + ",boundaryid " + boundaryid + ",budgetheadids " + budgetHeadList + ",financialyearid " + financialyearid));
            }
            query = this.prepareAgregateQuery(deptid, functionid, functionaryid, schemeid, subschemeid, boundaryid, fundid);
            if (financialyearid == null) {
                throw new ValidationException(EMPTY_STRING, "Financial Year id is null", new String[0]);
            }
            query = query + this.getQuery(CFinancialYear.class, financialyearid, " and bd.budget.financialYear=");
            if (budgetHeadList != null && budgetHeadList.size() != 0) {
                query = query + " and bd.budgetGroup.id in ( :budgetHeadList )";
            }
            String finalquery = this.budgetService.hasApprovedReForYear(financialyearid) ? " from BudgetDetail bd where bd.budget.isbere='RE' " + query + " order by bd.executingDepartment " : " from BudgetDetail bd where bd.budget.isbere='BE' " + query + " order by bd.executingDepartment ";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Final query=" + finalquery));
            }
            Query hibQuery = this.getCurrentSession().createQuery(finalquery);
            if (budgetHeadList != null && budgetHeadList.size() != 0) {
                hibQuery.setParameterList("budgetHeadList", (Collection)budgetHeadList);
            }
            if ((bdList = hibQuery.list()) == null || bdList.size() == 0) {
                return retMap;
            }
            return this.getApprovedAmtDeptwise(bdList);
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getAggregateBudgetedAmtForYear ==" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getAggregateBudgetedAmtForYear ...==" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, "Exception in getAggregateBudgetedAmtForYear==" + e.getMessage(), new String[0]);
        }
    }

    private BigDecimal getApprovedAmt(List<BudgetDetail> bdList) throws ValidationException {
        BigDecimal approvedAmt = BigDecimal.ZERO;
        for (BudgetDetail bd : bdList) {
            if (bd.getApprovedAmount() != null) {
                approvedAmt = approvedAmt.add(bd.getApprovedAmount());
            }
            approvedAmt = approvedAmt.add(bd.getApprovedReAppropriationsTotal());
        }
        return approvedAmt;
    }

    private BigDecimal getApprovedAmtAsOnDate(List<BudgetDetail> bdList, Date asOnDate) throws ValidationException {
        BigDecimal approvedAmt = BigDecimal.ZERO;
        for (BudgetDetail bd : bdList) {
            if (bd.getApprovedAmount() != null) {
                approvedAmt = approvedAmt.add(bd.getApprovedAmount());
            }
            approvedAmt = approvedAmt.add(bd.getApprovedReAppropriationsTotalAsOnDate(asOnDate));
        }
        return approvedAmt;
    }

    private Map<String, BigDecimal> getApprovedAmtDeptwise(List<BudgetDetail> bdList) throws ValidationException {
        BigDecimal approvedAmt = BigDecimal.ZERO;
        String deptName = null;
        HashMap<String, BigDecimal> deptBudget = new HashMap<String, BigDecimal>();
        for (BudgetDetail bd : bdList) {
            approvedAmt = BigDecimal.ZERO;
            deptName = bd.getExecutingDepartment().getName();
            if (bd.getApprovedAmount() != null) {
                approvedAmt = bd.getApprovedAmount();
            }
            approvedAmt = approvedAmt.add(bd.getApprovedReAppropriationsTotal());
            if (null != deptBudget && deptBudget.containsKey(deptName)) {
                approvedAmt = ((BigDecimal)deptBudget.get(deptName)).add(approvedAmt);
                deptBudget.put(deptName, approvedAmt);
                continue;
            }
            deptBudget.put(deptName, approvedAmt);
        }
        return deptBudget;
    }

    @Override
    public boolean budgetaryCheck(Map<String, Object> paramMap) throws ValidationException {
        block16: {
            String cashbasedbudgetType = EMPTY_STRING;
            String txnType = EMPTY_STRING;
            BigDecimal debitAmt = null;
            BigDecimal creditAmt = null;
            BigDecimal txnAmt = null;
            try {
                List list = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "budgetCheckRequired");
                if (list.isEmpty()) {
                    throw new ValidationException(EMPTY_STRING, "budgetCheckRequired is not defined in AppConfig", new String[0]);
                }
                if ("N".equalsIgnoreCase(((AppConfigValues)list.get(0)).getValue())) {
                    return true;
                }
                if (paramMap.get("mis.budgetcheckreq") != null && ((Boolean)paramMap.get("mis.budgetcheckreq")).equals(false)) {
                    return true;
                }
                if (paramMap.get("debitAmt") != null) {
                    debitAmt = (BigDecimal)paramMap.get("debitAmt");
                }
                if (paramMap.get("creditAmt") != null) {
                    creditAmt = (BigDecimal)paramMap.get("creditAmt");
                }
                if (debitAmt == null && creditAmt == null) {
                    throw new ValidationException(EMPTY_STRING, "Both Debit and Credit amount is null", new String[0]);
                }
                if (debitAmt != null && debitAmt.compareTo(BigDecimal.ZERO) == 0 && creditAmt != null && creditAmt.compareTo(BigDecimal.ZERO) == 0) {
                    throw new ValidationException(EMPTY_STRING, "Both Debit and Credit amount is zero", new String[0]);
                }
                if (debitAmt != null && debitAmt.compareTo(BigDecimal.ZERO) > 0 && creditAmt != null && creditAmt.compareTo(BigDecimal.ZERO) > 0) {
                    throw new ValidationException(EMPTY_STRING, "Both Debit and Credit amount is greater than zero", new String[0]);
                }
                list = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "budgetaryCheck_budgettype_cashbased");
                if (list.isEmpty()) {
                    throw new ValidationException(EMPTY_STRING, "budgetaryCheck_budgettype_cashbased is not defined in AppConfig", new String[0]);
                }
                cashbasedbudgetType = ((AppConfigValues)list.get(0)).getValue();
                if (cashbasedbudgetType.equalsIgnoreCase("Y")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("cashbasedbudgetType==" + cashbasedbudgetType));
                    }
                    break block16;
                }
                if (debitAmt != null && debitAmt.compareTo(BigDecimal.ZERO) > 0) {
                    txnType = "debit";
                    txnAmt = debitAmt;
                } else {
                    txnType = "credit";
                    txnAmt = creditAmt;
                }
                paramMap.put("txnAmt", txnAmt);
                paramMap.put("txnType", txnType);
                return this.checkCondition(paramMap);
            }
            catch (ValidationException v) {
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                errors.add(new ValidationError("exp", ((ValidationError)v.getErrors().get(0)).getMessage()));
                throw new ValidationException(errors);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exp in budgetary check API()=" + e.getMessage()));
                throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
            }
        }
        return true;
    }

    private boolean checkCondition(Map<String, Object> paramMap) throws ValidationException {
        String txnType = null;
        String glCode = null;
        BigDecimal txnAmt = null;
        Date asondate = null;
        Date fromdate = null;
        try {
            if (paramMap.get("txnAmt") != null) {
                txnAmt = (BigDecimal)paramMap.get("txnAmt");
            }
            if (paramMap.get("txnType") != null) {
                txnType = paramMap.get("txnType").toString();
            }
            if (paramMap.get("glcode") != null) {
                glCode = paramMap.get("glcode").toString();
            }
            if (paramMap.get("asondate") != null) {
                asondate = (Date)paramMap.get("asondate");
            }
            if (glCode == null) {
                throw new ValidationException(EMPTY_STRING, "glcode is null", new String[0]);
            }
            if (txnAmt == null) {
                throw new ValidationException(EMPTY_STRING, "txnAmt is null", new String[0]);
            }
            if (txnType == null) {
                throw new ValidationException(EMPTY_STRING, "txnType is null", new String[0]);
            }
            if (asondate == null) {
                throw new ValidationException(EMPTY_STRING, "As On Date is null", new String[0]);
            }
            CChartOfAccounts coa = this.chartOfAccountsHibernateDAO.getCChartOfAccountsByGlCode(glCode);
            if (coa.getBudgetCheckReq() != null && coa.getBudgetCheckReq().booleanValue()) {
                List<BudgetGroup> budgetHeadListByGlcode = this.getBudgetHeadByGlcode(coa);
                if (budgetHeadListByGlcode == null || budgetHeadListByGlcode.size() == 0) {
                    throw new ValidationException(EMPTY_STRING, "Budget Group is not defined for this glcode/No Budget details for this glcode : " + coa.getGlcode(), new String[0]);
                }
                if (!this.isBudgetCheckingRequiredForType(txnType, budgetHeadListByGlcode.get(0).getBudgetingType().toString())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("No need to check budget for :" + glCode + " as the transaction type is " + txnType));
                    }
                    return true;
                }
                paramMap.put(GLCODEID, coa.getId());
                CFinancialYear finyear = this.financialYearHibDAO.getFinancialYearByDate(asondate);
                if (finyear == null) {
                    throw new ValidationException(EMPTY_STRING, "Financial Year is not defined for-" + asondate, new String[0]);
                }
                new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
                fromdate = finyear.getStartingDate();
                paramMap.put("fromdate", fromdate);
                paramMap.put("asondate", finyear.getEndingDate());
                paramMap.put("financialyearid", (long)finyear.getId());
                paramMap.put(BUDGETHEADID, budgetHeadListByGlcode);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"************ BudgetCheck Details *********************");
                }
                BigDecimal budgetedAmt = this.getBudgetedAmtForYear(paramMap);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(".............Budgeted Amount For the year............" + budgetedAmt));
                }
                if (budgetedAmt.compareTo(BigDecimal.ZERO) == 0) {
                    return false;
                }
                BigDecimal actualAmt = this.getActualBudgetUtilizedForBudgetaryCheck(paramMap);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(".............Voucher Actual amount............" + actualAmt));
                }
                BigDecimal billAmt = this.getBillAmountForBudgetCheck(paramMap);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(".............Bill Actual amount............" + billAmt));
                }
                EgBillregister bill = null;
                if (paramMap.get("bill") != null) {
                    bill = (EgBillregister)this.persistenceService.find("from EgBillregister where id=? ", new Object[]{(Long)paramMap.get("bill")});
                }
                if (bill != null && bill.getEgBillregistermis().getBudgetaryAppnumber() != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(".............Found BillId so subtracting txn amount......................" + txnAmt));
                    }
                    billAmt = billAmt.subtract(txnAmt);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(".......Recalculated Bill Actual amount............" + billAmt));
                }
                BigDecimal diff = budgetedAmt.subtract(actualAmt).subtract(billAmt);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(".................diff amount..........................." + diff));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"************ BudgetCheck Details End****************");
                }
                if (txnAmt.compareTo(diff) <= 0) {
                    if ((bill == null || bill.getEgBillregistermis().getBudgetaryAppnumber() == null) && paramMap.get("voucherHeader") != null && ((CVoucherHeader)paramMap.get("voucherHeader")).getVouchermis().getBudgetaryAppnumber() == null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)"Bill level budget app no not generated so generating voucher level");
                        }
                        if (bill != null) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("bill Number..........." + bill.getBillnumber()));
                            }
                        } else if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)"Bill not present");
                        }
                        ((CVoucherHeader)paramMap.get("voucherHeader")).getVouchermis().setBudgetaryAppnumber(this.getBudgetApprNumber(paramMap));
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (ValidationException v) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)v.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in checkCondition API==" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
    }

    public String getBudgetApprNumber(Map<String, Object> paramMap) {
        CFinancialYear financialyear = (CFinancialYear)this.persistenceService.find("from CFinancialYear where id=?", new Object[]{(Long)paramMap.get("financialyearid")});
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"wfItem", financialyear, "sequenceGenerator", this.sequenceGenerator});
        String budgetApprNumber = (String)this.scriptService.executeScript("egf.reappropriation.sequence.generator", scriptContext);
        return budgetApprNumber;
    }

    private boolean isBudgetCheckingRequiredForType(String txnType, String budgetingType) {
        if ("debit".equalsIgnoreCase(budgetingType) && "debit".equals(txnType)) {
            return true;
        }
        if ("credit".equalsIgnoreCase(budgetingType) && "credit".equals(txnType)) {
            return true;
        }
        return "all".equalsIgnoreCase(budgetingType);
    }

    @Override
    public List<BudgetGroup> getBudgetHeadByGlcode(CChartOfAccounts coa) throws ValidationException {
        try {
            List bgList;
            List appList = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "coa_majorcode_length");
            if (appList.isEmpty()) {
                throw new ValidationException(EMPTY_STRING, "coa_majorcode_length is not defined", new String[0]);
            }
            int majorcodelength = Integer.valueOf(((AppConfigValues)appList.get(0)).getValue());
            appList = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "coa_minorcode_length");
            if (appList.isEmpty()) {
                throw new ValidationException(EMPTY_STRING, "coa_minorcode_length is not defined", new String[0]);
            }
            int minorcodelength = Integer.valueOf(((AppConfigValues)appList.get(0)).getValue());
            String query = " from BudgetGroup bg where bg.minCode.glcode<='" + coa.getGlcode() + "' and bg.maxCode.glcode>='" + coa.getGlcode() + "'  and bg in (select budgetGroup from BudgetDetail) and bg.isActive=true";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("getBudgetHeadByGlcode detailcode query=====" + query));
            }
            if ((bgList = this.persistenceService.findAllBy(query, new Object[0])).isEmpty()) {
                query = " from BudgetGroup bg where bg.minCode.glcode<='" + coa.getGlcode().substring(0, minorcodelength) + "' and bg.maxCode.glcode>='" + coa.getGlcode().substring(0, minorcodelength) + "' and bg in (select budgetGroup from BudgetDetail) and bg.isActive=true";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("getBudgetHeadByGlcode minorcode query=====" + query));
                }
                if ((bgList = this.persistenceService.findAllBy(query, new Object[0])).isEmpty()) {
                    query = " from BudgetGroup bg where bg.majorCode.glcode='" + coa.getGlcode().substring(0, majorcodelength) + "' and bg in (select budgetGroup from BudgetDetail) and bg.isActive=true ";
                    bgList = this.persistenceService.findAllBy(query, new Object[0]);
                    if (bgList.isEmpty()) {
                        throw new ValidationException(EMPTY_STRING, "Budget Group is not defined for this glcode/No Budget details for this glcode : " + coa.getGlcode(), new String[0]);
                    }
                    return bgList;
                }
                return bgList;
            }
            return bgList;
        }
        catch (ValidationException v) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", ((ValidationError)v.getErrors().get(0)).getMessage()));
            throw new ValidationException(errors);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getBudgetHeadByGlcode API=" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
    }

    @Override
    public List<BudgetGroup> getBudgetHeadForGlcodeList(List<CChartOfAccounts> coa) throws ValidationException {
        try {
            String coaQry = "bg.minCode.glcode in(";
            if (coa.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"No COA is been passed");
                }
                throw new ValidationException(EMPTY_STRING, "No Chartofaccount code is been passed for getting the budget heads", new String[0]);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("COA list size passed " + coa.size()));
            }
            Integer i = 0;
            while (i < coa.size()) {
                coaQry = i != coa.size() - 1 ? coaQry + coa.get(i).getGlcode() + "," : coaQry + coa.get(i).getGlcode() + ")";
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            String query = " from BudgetGroup bg where " + coaQry + " and bg in (select budgetGroup from BudgetDetail) and bg.isActive=true order by bg.name";
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("getBudgetHeadForGlcodeList detailcode query=====" + query));
            }
            List bgList = this.persistenceService.findAllBy(query, new Object[0]);
            return bgList;
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getBudgetHeadForGlcodeList API()=" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getBudgetHeadForGlcodeList API=" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
    }

    public String getQuery(Class clazz, Serializable id, String queryString) throws ValidationException {
        this.session = this.getCurrentSession();
        String query = EMPTY_STRING;
        if (id == null) {
            return query;
        }
        try {
            Object o = this.findById(clazz, id);
            if (o != null) {
                query = queryString + id;
            }
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getQuery==" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.equals("Exp in getQuery==" + e.getMessage());
            throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
        }
        return query;
    }

    @Override
    public boolean budgetaryCheckForBill(Map<String, Object> paramMap) throws ValidationException {
        block42: {
            String cashbasedbudgetType = EMPTY_STRING;
            String txnType = EMPTY_STRING;
            BigDecimal debitAmt = null;
            BigDecimal creditAmt = null;
            BigDecimal txnAmt = null;
            String glCode = EMPTY_STRING;
            Date asondate = null;
            Date fromdate = null;
            try {
                List list = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "budgetCheckRequired");
                if (list.isEmpty()) {
                    throw new ValidationException(EMPTY_STRING, "budgetCheckRequired is not defined in AppConfig", new String[0]);
                }
                if ("N".equalsIgnoreCase(((AppConfigValues)list.get(0)).getValue())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Application Level budget check disabled skipping budget check.");
                    }
                    return true;
                }
                if (paramMap.get("mis.budgetcheckreq") != null && ((Boolean)paramMap.get("mis.budgetcheckreq")).equals(false)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"voucher Level budget check disabled  so skipping budget check.");
                    }
                    return true;
                }
                if (paramMap.get("debitAmt") != null) {
                    debitAmt = (BigDecimal)paramMap.get("debitAmt");
                }
                if (paramMap.get("creditAmt") != null) {
                    creditAmt = (BigDecimal)paramMap.get("creditAmt");
                }
                if (debitAmt == null && creditAmt == null) {
                    throw new ValidationException(EMPTY_STRING, "Both Debit and Credit amount is null", new String[0]);
                }
                if (debitAmt != null && debitAmt.compareTo(BigDecimal.ZERO) == 0 && creditAmt != null && creditAmt.compareTo(BigDecimal.ZERO) == 0) {
                    throw new ValidationException(EMPTY_STRING, "Both Debit and Credit amount is zero", new String[0]);
                }
                if (debitAmt != null && debitAmt.compareTo(BigDecimal.ZERO) > 0 && creditAmt != null && creditAmt.compareTo(BigDecimal.ZERO) > 0) {
                    throw new ValidationException(EMPTY_STRING, "Both Debit and Credit amount is greater than zero", new String[0]);
                }
                list = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, "budgetaryCheck_budgettype_cashbased");
                if (list.isEmpty()) {
                    throw new ValidationException(EMPTY_STRING, "budgetaryCheck_budgettype_cashbased is not defined in AppConfig", new String[0]);
                }
                cashbasedbudgetType = ((AppConfigValues)list.get(0)).getValue();
                if (cashbasedbudgetType.equalsIgnoreCase("Y")) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("cashbasedbudgetType==" + cashbasedbudgetType));
                    }
                    break block42;
                }
                if (debitAmt != null && debitAmt.compareTo(BigDecimal.ZERO) > 0) {
                    txnType = "debit";
                    txnAmt = debitAmt;
                } else {
                    txnType = "credit";
                    txnAmt = creditAmt;
                }
                if (paramMap.get("glcode") != null) {
                    glCode = paramMap.get("glcode").toString();
                }
                if (paramMap.get("asondate") != null) {
                    asondate = (Date)paramMap.get("asondate");
                }
                if (glCode == null) {
                    throw new ValidationException(EMPTY_STRING, "glcode is null", new String[0]);
                }
                if (txnAmt == null) {
                    throw new ValidationException(EMPTY_STRING, "txnAmt is null", new String[0]);
                }
                if (txnType == null) {
                    throw new ValidationException(EMPTY_STRING, "txnType is null", new String[0]);
                }
                if (asondate == null) {
                    throw new ValidationException(EMPTY_STRING, "As On Date is null", new String[0]);
                }
                CChartOfAccounts coa = this.chartOfAccountsHibernateDAO.getCChartOfAccountsByGlCode(glCode);
                if (coa.getBudgetCheckReq() != null && coa.getBudgetCheckReq().booleanValue()) {
                    List<BudgetGroup> budgetHeadListByGlcode = this.getBudgetHeadByGlcode(coa);
                    if (!this.isBudgetCheckingRequiredForType(txnType, budgetHeadListByGlcode.get(0).getBudgetingType().toString())) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("No need to check budget for :" + glCode + " as the transaction type is " + txnType + "so skipping budget check"));
                        }
                        return true;
                    }
                    CFinancialYear finyear = this.financialYearHibDAO.getFinancialYearByDate(asondate);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
                    if (finyear == null) {
                        throw new ValidationException(EMPTY_STRING, "Financial year is not defined for this date [" + sdf.format(asondate) + "]", new String[0]);
                    }
                    fromdate = finyear.getStartingDate();
                    paramMap.put("financialyearid", (long)finyear.getId());
                    paramMap.put(BUDGETHEADID, budgetHeadListByGlcode);
                    paramMap.put("fromdate", fromdate);
                    paramMap.put("asondate", finyear.getEndingDate());
                    paramMap.put(GLCODEID, coa.getId());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"************ BudgetCheck Details For bill *********************");
                    }
                    BigDecimal budgetedAmt = this.getBudgetedAmtForYear(paramMap);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(".................Budgeted amount......................" + budgetedAmt));
                    }
                    if (budgetedAmt.compareTo(BigDecimal.ZERO) == 0) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)"Budget check failed Because of  Budgeted not allocated for the combination");
                        }
                        return false;
                    }
                    BigDecimal actualAmt = this.getActualBudgetUtilizedForBudgetaryCheck(paramMap);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("..................Voucher Actual amount......................." + actualAmt));
                    }
                    BigDecimal billAmt = this.getBillAmountForBudgetCheck(paramMap);
                    EgBillregister bill = null;
                    if (paramMap.get("bill") != null) {
                        bill = (EgBillregister)paramMap.get("bill");
                    }
                    if (bill != null && bill.getEgBillregistermis().getBudgetaryAppnumber() != null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(".............Found BillId so subtracting txn amount......................" + txnAmt));
                        }
                        billAmt = billAmt.subtract(txnAmt);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("........................Bill Actual amount ........................" + billAmt));
                    }
                    BigDecimal diff = budgetedAmt.subtract(actualAmt).subtract(billAmt);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("......................diff amount......................" + diff));
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"************ BudgetCheck Details For bill End *********************");
                    }
                    if (txnAmt.compareTo(diff) <= 0) {
                        if (paramMap.get("bill") != null && ((EgBillregister)paramMap.get("bill")).getEgBillregistermis().getBudgetaryAppnumber() == null) {
                            String budgetApprNumber = this.getBudgetApprNumber(paramMap);
                            ((EgBillregister)paramMap.get("bill")).getEgBillregistermis().setBudgetaryAppnumber(budgetApprNumber);
                        }
                        return true;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Budget check failed Because of  non availability of enough amount");
                    }
                    return false;
                }
                return true;
            }
            catch (ValidationException v) {
                LOGGER.error((Object)("Exp in budgetary check API()=" + v.getErrors()));
                throw new ValidationException(v.getErrors());
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exp in budgetary check API()=" + e.getMessage()));
                throw new ValidationException(EMPTY_STRING, e.getMessage(), new String[0]);
            }
        }
        return true;
    }

    @Override
    public BigDecimal getBillAmountForBudgetCheck(Map<String, Object> paramMap) throws ValidationException {
        Long deptid = null;
        Long functionid = null;
        Integer functionaryid = null;
        Integer schemeid = null;
        Integer subschemeid = null;
        Long boundaryid = null;
        Integer fundid = null;
        Long glcodeid = null;
        Date fromdate = null;
        Date asondate = null;
        BigDecimal totalBillUtilized = new BigDecimal(0);
        String query = EMPTY_STRING;
        String query1 = EMPTY_STRING;
        try {
            String[] values;
            if (paramMap.get("deptid") != null) {
                deptid = (Long)paramMap.get("deptid");
            }
            if (paramMap.get("functionid") != null) {
                functionid = (Long)paramMap.get("functionid");
            }
            if (paramMap.get("functionaryid") != null) {
                functionaryid = (Integer)paramMap.get("functionaryid");
            }
            if (paramMap.get("schemeid") != null) {
                schemeid = (Integer)paramMap.get("schemeid");
            }
            if (paramMap.get("fundid") != null) {
                fundid = (Integer)paramMap.get("fundid");
            }
            if (paramMap.get("subschemeid") != null) {
                subschemeid = (Integer)paramMap.get("subschemeid");
            }
            if (paramMap.get("boundaryid") != null) {
                boundaryid = (Long)paramMap.get("boundaryid");
            }
            if (paramMap.get(GLCODEID) != null) {
                glcodeid = (Long)paramMap.get(GLCODEID);
            }
            if (paramMap.get("asondate") != null) {
                asondate = (Date)paramMap.get("asondate");
            }
            if (paramMap.get("fromdate") != null) {
                fromdate = (Date)paramMap.get("fromdate");
            }
            CFinancialYear finyear = this.financialYearHibDAO.getFinancialYearByDate(asondate);
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Constants.LOCALE);
            if (finyear == null) {
                throw new ValidationException(EMPTY_STRING, "Financial year is not defined for this date [" + sdf.format(asondate) + "]", new String[0]);
            }
            fromdate = finyear.getStartingDate();
            paramMap.put("financialyearid", (long)finyear.getId());
            paramMap.put("fromdate", fromdate);
            paramMap.put("asondate", finyear.getEndingDate());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("deptid=" + deptid + ",functionid=" + functionid + ",functionaryid=" + functionaryid + ",schemeid=" + schemeid + ",subschemeid=" + subschemeid + ",boundaryid=" + boundaryid + ",glcodeid=" + glcodeid + ",asondate=" + asondate));
            }
            if (asondate == null) {
                throw new ValidationException(EMPTY_STRING, "As On Date is null", new String[0]);
            }
            List budgetGrouplist = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, BUDGETARY_CHECK_GROUPBY_VALUES);
            if (budgetGrouplist.isEmpty()) {
                throw new ValidationException(EMPTY_STRING, "budgetaryCheck_groupby_values is not defined in AppConfig", new String[0]);
            }
            AppConfigValues appConfigValues = (AppConfigValues)budgetGrouplist.get(0);
            for (String value : values = StringUtils.split((String)appConfigValues.getValue(), (String)",")) {
                if (value.equals("department")) {
                    if (deptid == null || deptid == 0L) {
                        throw new ValidationException(EMPTY_STRING, "Department is required", new String[0]);
                    }
                    query = query + this.getQuery(Department.class, deptid, " and bmis.egDepartment.id=");
                    continue;
                }
                if (value.equals("function")) {
                    if (functionid == null || functionid == 0L) {
                        throw new ValidationException(EMPTY_STRING, "Function is required", new String[0]);
                    }
                    query = query + this.getQuery(CFunction.class, functionid, " and bd.functionid=");
                    continue;
                }
                if (value.equals("functionary")) {
                    if (functionaryid == null || functionaryid == 0) {
                        throw new ValidationException(EMPTY_STRING, "Functionary is required", new String[0]);
                    }
                    query = query + this.getQuery(Functionary.class, functionaryid, " and bmis.functionaryid.id=");
                    continue;
                }
                if (value.equals("fund")) {
                    if (fundid == null || fundid == 0) {
                        throw new ValidationException(EMPTY_STRING, "Fund is required", new String[0]);
                    }
                    query = query + this.getQuery(Fund.class, fundid, " and bmis.fund.id=");
                    continue;
                }
                if (value.equals("scheme")) {
                    if (schemeid == null || schemeid == 0) {
                        throw new ValidationException(EMPTY_STRING, "Scheme is required", new String[0]);
                    }
                    query = query + this.getQuery(Scheme.class, schemeid, " and bmis.scheme.id=");
                    continue;
                }
                if (value.equals("subscheme")) {
                    if (subschemeid == null || subschemeid == 0) {
                        throw new ValidationException(EMPTY_STRING, "Sub scheme is required", new String[0]);
                    }
                    query = query + this.getQuery(SubScheme.class, subschemeid, " and bmis.subScheme.id=");
                    continue;
                }
                if (value.equals("boundary")) {
                    if (boundaryid == null || boundaryid == 0L) {
                        throw new ValidationException(EMPTY_STRING, "Boundary is required", new String[0]);
                    }
                    query = query + this.getQuery(Boundary.class, boundaryid, " and bmis.fieldid.id=");
                    continue;
                }
                throw new ValidationException(EMPTY_STRING, "budgetaryCheck_groupby_values is not matching=" + value, new String[0]);
            }
            if (asondate != null) {
                query = query + " and br.billdate <=? ";
            }
            if (fromdate != null) {
                query = query + " and  br.billdate>=? ";
            }
            query = query + " and bd.glcodeid='" + glcodeid + "'";
            query1 = "select sum(case when bd.debitamount is null then 0 ELSE bd.debitamount end -case when bd.creditamount is null then 0 else bd.creditamount end)   from EgBillregister br, EgBilldetails bd, EgBillregistermis bmis   where br.id=bd.egBillregister.id and br.id=bmis.egBillregister.id and (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true)  and bmis.voucherHeader is null and upper(br.status.description) not in ('CANCELLED')     " + query;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("getBillAmountForBudgetCheck query============" + query1));
            }
            Object ob = null;
            ob = fromdate != null ? this.persistenceService.find(query1, new Object[]{asondate, fromdate}) : this.persistenceService.find(query1, new Object[]{asondate});
            BigDecimal billAmountWhereCancelledVouchers = this.getBillAmountWhereCancelledVouchers(query, fromdate, asondate);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Total Amount from all bills where vouchers are cancelled is : " + billAmountWhereCancelledVouchers));
            }
            totalBillUtilized = ob == null ? billAmountWhereCancelledVouchers : new BigDecimal(ob.toString()).add(billAmountWhereCancelledVouchers);
            return totalBillUtilized;
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getBillAmountForBudgetCheck API()===" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getBillAmountForBudgetCheck API()===" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, "Exp in getBillAmountForBudgetCheck API()===" + e.getMessage(), new String[0]);
        }
    }

    private BigDecimal getBillAmountWhereCancelledVouchers(String query, Date fromdate, Date asondate) throws ValidationException {
        String newQuery = "select sum(case when bd.debitamount is null then 0 else bd.debitamount end - case when bd.creditamount is null then 0 else bd.creditamount end )   from EgBillregister br, EgBilldetails bd, EgBillregistermis bmis,CVoucherHeader vh   where br.id=bd.egBillregister.id and br.id=bmis.egBillregister.id and (bmis.budgetCheckReq is null or bmis.budgetCheckReq=true)  and bmis.voucherHeader=vh.id and upper(br.status.description) not in ('CANCELLED')   and vh.status=4  " + query;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getBillAmountWhereCancelledVouchers query============" + newQuery));
        }
        Object ob = null;
        ob = fromdate != null ? this.persistenceService.find(newQuery, new Object[]{asondate, fromdate}) : this.persistenceService.find(newQuery, new Object[]{asondate});
        if (ob == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(ob.toString());
    }

    @Override
    public BigDecimal getBudgetedAmtForYearRegardingBEorRE(Map<String, Object> paramMap, String typeBeRe) throws ValidationException {
        Integer deptid = null;
        Long functionid = null;
        Integer functionaryid = null;
        Integer schemeid = null;
        Integer subschemeid = null;
        Integer boundaryid = null;
        Integer fundid = null;
        Long budgetheadid = null;
        Long financialyearid = null;
        String query = EMPTY_STRING;
        try {
            List bdList;
            if (paramMap.get("deptid") != null) {
                deptid = (Integer)paramMap.get("deptid");
            }
            if (paramMap.get("functionid") != null) {
                functionid = (Long)paramMap.get("functionid");
            }
            if (paramMap.get("functionaryid") != null) {
                functionaryid = (Integer)paramMap.get("functionaryid");
            }
            if (paramMap.get("schemeid") != null) {
                schemeid = (Integer)paramMap.get("schemeid");
            }
            if (paramMap.get("subschemeid") != null) {
                subschemeid = (Integer)paramMap.get("subschemeid");
            }
            if (paramMap.get("fundid") != null) {
                fundid = (Integer)paramMap.get("fundid");
            }
            if (paramMap.get("boundaryid") != null) {
                boundaryid = (Integer)paramMap.get("boundaryid");
            }
            if (paramMap.get(BUDGETHEADID) != null) {
                budgetheadid = (Long)paramMap.get(BUDGETHEADID);
            }
            if (paramMap.get("financialyearid") != null) {
                financialyearid = (Long)paramMap.get("financialyearid");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("deptid " + deptid + ",functionid " + functionid + ",functionaryid " + functionaryid + ",schemeid " + schemeid + ",subschemeid " + subschemeid + ",boundaryid " + boundaryid + ",budgetheadid " + budgetheadid + ",financialyearid " + financialyearid));
            }
            query = this.prepareQuery(deptid, functionid, functionaryid, schemeid, subschemeid, boundaryid, fundid);
            if (budgetheadid == null) {
                throw new ValidationException(EMPTY_STRING, "Budget head id is null or empty", new String[0]);
            }
            query = query + this.getQuery(BudgetGroup.class, budgetheadid, " and bd.budgetGroup=");
            if (financialyearid == null) {
                throw new ValidationException(EMPTY_STRING, "Financial Year id is null", new String[0]);
            }
            query = query + this.getQuery(CFinancialYear.class, financialyearid, " and bd.budget.financialYear=");
            String finalquery = " from BudgetDetail bd where bd.budget.isbere= '" + typeBeRe + "' " + query;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("finalquery  =" + finalquery));
            }
            if ((bdList = this.persistenceService.findAllBy(finalquery, new Object[0])) == null || bdList.size() == 0) {
                return BigDecimal.ZERO;
            }
            return this.getApprovedAmt(bdList);
        }
        catch (ValidationException v) {
            LOGGER.error((Object)("Exp in getBudgetedAmtForYear==" + v.getErrors()));
            throw new ValidationException(v.getErrors());
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exp in getBudgetedAmtForYear==" + e.getMessage()));
            throw new ValidationException(EMPTY_STRING, "Exp in getBudgetedAmtForYear==" + e.getMessage(), new String[0]);
        }
    }

    @Override
    public BigDecimal getSanctionedPlanningBudget(Map<String, Object> paramMap) {
        BigDecimal multiplicationFactor = new BigDecimal(Double.parseDouble(this.getAppConfigFor(EGF, "planning_budget_multiplication_factor")));
        BigDecimal budgetedAmtForYear = this.zeroOrValue(this.getBudgetedAmtForYear(paramMap));
        return budgetedAmtForYear.multiply(multiplicationFactor);
    }

    private BigDecimal zeroOrValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    private String getAppConfigFor(String module, String key) {
        try {
            List list = this.appConfigValuesService.getConfigValuesByModuleAndKey(module, key);
            return ((AppConfigValues)list.get(0)).getValue().toString();
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(key + " not defined in appconfig", key + " not defined in appconfig")));
        }
    }

    @Override
    public List<BudgetUsage> getListBudgetUsage(Map<String, Object> queryParamMap) throws ValidationException {
        StringBuffer query = new StringBuffer();
        HashMap<String, String> grpByVls = new HashMap<String, String>();
        List listBudgetUsage = null;
        query.append("select bu from BudgetUsage bu,BudgetDetail bd where  bu.budgetDetail.id=bd.id");
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey(EGF, BUDGETARY_CHECK_GROUPBY_VALUES);
        if (list.isEmpty()) {
            throw new ValidationException(EMPTY_STRING, "budgetaryCheck_groupby_values is not defined in AppConfig", new String[0]);
        }
        AppConfigValues appConfigValues = (AppConfigValues)list.get(0);
        if (appConfigValues.getValue().indexOf(",") != 1) {
            String[] values;
            for (String value : values = StringUtils.split((String)appConfigValues.getValue(), (String)",")) {
                grpByVls.put(value, value);
            }
        } else {
            grpByVls.put(appConfigValues.getValue(), appConfigValues.getValue());
        }
        if (!this.isNull(grpByVls.get("fund"))) {
            if (this.isNull(queryParamMap.get("fundId"))) {
                throw new ValidationException(EMPTY_STRING, "Fund is required", new String[0]);
            }
            query.append(" and bd.fund.id=").append(Integer.valueOf(queryParamMap.get("fundId").toString()));
        }
        if (!this.isNull(grpByVls.get("department"))) {
            if (this.isNull(queryParamMap.get("ExecutionDepartmentId"))) {
                throw new ValidationException(EMPTY_STRING, "Department is required", new String[0]);
            }
            query.append(" and bd.executingDepartment.id=").append(Integer.valueOf(queryParamMap.get("ExecutionDepartmentId").toString()));
        }
        if (!this.isNull(grpByVls.get("function"))) {
            if (this.isNull(queryParamMap.get("functionId"))) {
                throw new ValidationException(EMPTY_STRING, "Function is required", new String[0]);
            }
            query.append(" and bd.function.id=").append(Long.valueOf(queryParamMap.get("functionId").toString()));
        }
        if (!this.isNull(grpByVls.get("scheme"))) {
            if (this.isNull(queryParamMap.get("schemeId"))) {
                throw new ValidationException(EMPTY_STRING, "Scheme is required", new String[0]);
            }
            query.append(" and bd.scheme.id=").append(Integer.valueOf(queryParamMap.get("schemeId").toString()));
        }
        if (!this.isNull(grpByVls.get("subscheme"))) {
            if (this.isNull(queryParamMap.get("subschemeId"))) {
                throw new ValidationException(EMPTY_STRING, "SubScheme is required", new String[0]);
            }
            query.append(" and bd.subScheme.id=").append(Integer.valueOf(queryParamMap.get("subschemeId").toString()));
        }
        if (!this.isNull(grpByVls.get("functionary"))) {
            if (this.isNull(queryParamMap.get("functionaryId"))) {
                throw new ValidationException(EMPTY_STRING, "Functionary is required", new String[0]);
            }
            query.append(" and bd.functionary.id=").append(Integer.valueOf(queryParamMap.get("functionaryId").toString()));
        }
        if (!this.isNull(grpByVls.get("boundary"))) {
            if (this.isNull(queryParamMap.get("boundaryId"))) {
                throw new ValidationException(EMPTY_STRING, "Boundary is required", new String[0]);
            }
            query.append(" and bd.boundary.id=").append(Integer.valueOf(queryParamMap.get("boundaryId").toString()));
        }
        if (!this.isNull(queryParamMap.get("moduleId"))) {
            query.append(" and bu.moduleId=").append(Integer.valueOf(queryParamMap.get("moduleId").toString()));
        }
        if (!this.isNull(queryParamMap.get("financialYearId"))) {
            query.append(" and bu.financialYearId=").append(Integer.valueOf(queryParamMap.get("financialYearId").toString()));
        }
        if (!this.isNull(queryParamMap.get("budgetgroupId"))) {
            query.append(" and bd.budgetGroup.id=").append(Long.valueOf(queryParamMap.get("budgetgroupId").toString()));
        }
        if (!this.isNull(queryParamMap.get("fromDate"))) {
            query.append(" and bu.updatedTime >=:from");
        }
        if (!this.isNull(queryParamMap.get("toDate"))) {
            query.append(" and bu.updatedTime <=:to");
        }
        if (!this.isNull(queryParamMap.get("Order By"))) {
            if (queryParamMap.get("Order By").toString().indexOf("appropriationnumber") == -1 && queryParamMap.get("Order By").toString().indexOf("referenceNumber") == -1) {
                throw new ValidationException(EMPTY_STRING, "order by value can be only Budgetary appropriation number or Reference number or both", new String[0]);
            }
            query.append(" Order By ").append(queryParamMap.get("Order By"));
        } else {
            query.append(" Order By bu.updatedTime");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Budget Usage Query >>>>>>>> " + query.toString()));
        }
        Query query1 = this.getCurrentSession().createQuery(query.toString());
        if (!this.isNull(queryParamMap.get("fromDate"))) {
            query1.setTimestamp("from", (Date)queryParamMap.get("fromDate"));
        }
        if (!this.isNull(queryParamMap.get("toDate"))) {
            Date date = (Date)queryParamMap.get("toDate");
            date.setMinutes(59);
            date.setHours(23);
            date.setSeconds(59);
            query1.setTimestamp("to", date);
        }
        listBudgetUsage = query1.list();
        return listBudgetUsage;
    }

    @Override
    public BigDecimal getPlannigBudgetBy(Integer fundId, Integer deptId, Date asOnDate) {
        if (fundId == null || fundId == -1) {
            throw new IllegalArgumentException("fundId");
        }
        if (deptId == null || deptId == -1) {
            throw new IllegalArgumentException("deptId");
        }
        if (asOnDate == null) {
            asOnDate = new Date();
        }
        BigDecimal amount = BigDecimal.ZERO;
        String isbere = EMPTY_STRING;
        CFinancialYear finYear = this.financialYearHibDAO.getFinYearByDate(asOnDate);
        boolean hasApprovedReForYear = this.budgetService.hasApprovedReAsonDate(finYear.getId(), asOnDate);
        isbere = hasApprovedReForYear ? "RE" : "BE";
        amount = (BigDecimal)this.persistenceService.find("select sum(approvedAmount) from BudgetDetail bd where  bd.executingDepartment.id=? and bd.fund.id=? and bd.budget.financialYear=? and bd.budget.isbere=? ", new Object[]{deptId, fundId, finYear, isbere});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Approved " + isbere + " Amount" + amount));
        }
        amount = amount == null ? BigDecimal.ZERO : amount;
        BigDecimal reappAmount = (BigDecimal)this.persistenceService.find("select sum(additionAmount-deductionAmount) from BudgetReAppropriation br where  br.budgetDetail.executingDepartment.id=? and br.budgetDetail.fund.id=? and br.budgetDetail.budget.financialYear=? and br.budgetDetail.budget.isbere=? and br.status.description='Approved' and to_date(br.modifiedDate)<=? ", new Object[]{deptId, fundId, finYear, isbere, asOnDate});
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Approved Reappropriation Amount" + reappAmount));
        }
        reappAmount = reappAmount == null ? BigDecimal.ZERO : reappAmount;
        BigDecimal multiplicationFactor = new BigDecimal(Double.parseDouble(this.getAppConfigFor(EGF, "planning_budget_multiplication_factor")));
        amount = amount.add(reappAmount);
        amount = amount.multiply(multiplicationFactor);
        return amount;
    }

    private boolean isNull(Object ob) {
        return ob == null;
    }

    public ApplicationSequenceNumberGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public void setSequenceGenerator(ApplicationSequenceNumberGenerator sequenceGenerator) {
        this.sequenceGenerator = sequenceGenerator;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }

    @Override
    public BudgetDetail findById(Number id, boolean lock) {
        return null;
    }
}

