/*
 * Decompiled with CFR 0.152.
 */
package com.exilant.exility.dataservice;

import com.exilant.exility.common.AbstractTask;
import com.exilant.exility.common.DataCollection;
import com.exilant.exility.common.TaskFailedException;
import com.exilant.exility.common.XMLLoader;
import com.exilant.exility.dataservice.SQLTemplate;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import org.egov.infstr.utils.EGovConfig;

public class SQLTask
extends AbstractTask {
    private static SQLTask singletonInstance;
    protected SQLTemplate sqlTemplate;
    public HashMap sqlTemplates;

    public static SQLTask getTask() {
        if (singletonInstance == null) {
            singletonInstance = new SQLTask();
        }
        return singletonInstance;
    }

    private SQLTask() {
        XMLLoader xmlLoader = new XMLLoader();
        URL url = EGovConfig.class.getClassLoader().getResource("config/resource/sqlTemplates.xml");
        xmlLoader.load(url.toString(), this);
    }

    public String getSQL(String serviceID, DataCollection dc, Connection con) throws TaskFailedException {
        SQLTemplate template = (SQLTemplate)this.sqlTemplates.get(serviceID);
        if (template == null) {
            dc.addMessage("exilNoSQLTemplate", serviceID);
            throw new TaskFailedException();
        }
        return template.getSQL(dc);
    }

    @Override
    public void execute(String serviceID, String gridName, DataCollection dc, Connection con, boolean erronNoData, boolean gridHasColumnHeading, String prefix) throws TaskFailedException {
        SQLTemplate template = (SQLTemplate)this.sqlTemplates.get(serviceID);
        if (template == null) {
            dc.addMessage("exilNoSQLTemplate", serviceID);
            throw new TaskFailedException();
        }
        String sql = this.getSQL(serviceID, dc, con);
        this.extractData(sql, gridName, dc, con, erronNoData, gridHasColumnHeading, prefix);
    }
}

