/*
 * eGov suite of products aim to improve the internal efficiency,transparency,
 *    accountability and the service delivery of the government  organizations.
 *
 *     Copyright (C) <2015>  eGovernments Foundation
 *
 *     The updated version of eGov suite of products as by eGovernments Foundation
 *     is available at http://www.egovernments.org
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see http://www.gnu.org/licenses/ or
 *     http://www.gnu.org/licenses/gpl.html .
 *
 *     In addition to the terms of the GPL license to be adhered to in using this
 *     program, the following additional terms are to be complied with:
 *
 *         1) All versions of this program, verbatim or modified must carry this
 *            Legal Notice.
 *
 *         2) Any misrepresentation of the origin of the material is prohibited. It
 *            is required that all modified versions of this material be marked in
 *            reasonable ways as different from the original version.
 *
 *         3) This license does not grant any rights to any user of the program
 *            with regards to rights under trademark law for use of the trade names
 *            or trademarks of eGovernments Foundation.
 *
 *   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */
package org.egov.services.instrument;

import org.apache.log4j.Logger;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.DishonorCheque;
import org.egov.pims.commons.Position;
import org.egov.pims.service.EisUtilService;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Transactional(readOnly = true)
public class DishonorChequeService extends PersistenceService<DishonorCheque, Long> {

    private static final Logger LOGGER = Logger.getLogger("DishonorChequeService.class");
    private SimpleWorkflowService<DishonorCheque> dishonorChqWorkflowService;

    private EisUtilService eisService;
    private FinancialIntegrationService financialIntegrationService;

    public DishonorCheque approve(final DishonorCheque dishonorChq, final String workFlowAction, final String approverComments)
    {
        startWorkflow(dishonorChq, workFlowAction, approverComments);
        return dishonorChq;
    }

    public void startWorkflow(final DishonorCheque dishonorCheque, final String workFlowAction, final String approverComments)
    {
        // Get cheque creator details

        if (null == dishonorCheque.getState()) {
            final Position pos = eisService.getPrimaryPositionForUser(dishonorCheque.getPayinSlipCreator().longValue(),
                    new Date());
            if (LOGGER.isDebugEnabled())
                LOGGER.error(pos.getName() + "" + pos.getId());
            // TODO call the updateSourceInstrumentVoucher here
            if (null != financialIntegrationService)
                financialIntegrationService.updateSourceInstrumentVoucher(
                        FinancialIntegrationService.EVENT_INSTRUMENT_DISHONOR_INITIATED, dishonorCheque.getInstrumentHeader()
                                .getId());
            dishonorCheque.start().withOwner(pos).withComments("DishonorCheque Work flow started");
            if (LOGGER.isDebugEnabled())
                LOGGER.debug("---------" + dishonorCheque);
            dishonorChqWorkflowService.transition("forward", dishonorCheque, "Created by SM");
        }

        if (null != workFlowAction && !"".equals(workFlowAction)) {
            final String comments = null == approverComments || "".equals(approverComments.trim()) ? "" : approverComments;
            dishonorChqWorkflowService.transition(workFlowAction.toLowerCase(), dishonorCheque, comments);
        }
        if (LOGGER.isDebugEnabled())
            LOGGER.error("---------" + dishonorCheque.getState().getId());

    }

    /*
     * public void startChequeWorkflow(DishonorCheque dishonorCheque,String workFlowAction,String approverComments) { // Get
     * cheque creator details if(null == dishonorCheque.getState()){ Position pos =
     * eisService.getPrimaryPositionForUser(dishonorCheque.getApproverPositionId(),new Date()); dishonorCheque =
     * (DishonorCheque)dishonorCheque.start().pos, "DishonorCheque Work flow started");
     * dishonorChequeWorkflowService.transition("forward", dishonorCheque, "Created by SM"); } if((null != workFlowAction) &&
     * !"".equals(workFlowAction) ){ String comments= ((null == approverComments) ||
     * "".equals(approverComments.trim()))?"":approverComments;
     * dishonorChequeWorkflowService.transition(workFlowAction.toLowerCase(),dishonorCheque, comments); } }
     */

    public SimpleWorkflowService<DishonorCheque> getDishonorChqWorkflowService() {
        return dishonorChqWorkflowService;
    }

    public void setDishonorChqWorkflowService(
            final SimpleWorkflowService<DishonorCheque> dishonorChqWorkflowService) {
        this.dishonorChqWorkflowService = dishonorChqWorkflowService;
    }

    public EisUtilService getEisService() {
        return eisService;
    }

    public void setEisService(final EisUtilService eisService) {
        this.eisService = eisService;
    }

    public FinancialIntegrationService getFinancialIntegrationService() {
        return financialIntegrationService;
    }

    public void setFinancialIntegrationService(
            final FinancialIntegrationService financialIntegrationService) {
        this.financialIntegrationService = financialIntegrationService;
    }

}
