/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.web.controller.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.egov.common.entity.dcr.helper.ErrorDetail;
import org.egov.common.entity.edcr.Plan;
import org.egov.commons.mdms.BpaMdmsUtil;
import org.egov.commons.mdms.config.MdmsConfiguration;
import org.egov.commons.mdms.validator.MDMSValidator;
import org.egov.edcr.contract.ComparisonDetail;
import org.egov.edcr.contract.ComparisonRequest;
import org.egov.edcr.contract.ComparisonResponse;
import org.egov.edcr.contract.EdcrDetail;
import org.egov.edcr.contract.EdcrRequest;
import org.egov.edcr.contract.EdcrResponse;
import org.egov.edcr.contract.PlanResponse;
import org.egov.edcr.entity.ApplicationType;
import org.egov.edcr.service.EdcrRestService;
import org.egov.edcr.service.OcComparisonService;
import org.egov.edcr.service.PlanService;
import org.egov.infra.microservice.contract.RequestInfoWrapper;
import org.egov.infra.microservice.contract.ResponseInfo;
import org.egov.infra.microservice.models.RequestInfo;
import org.egov.infra.utils.FileStoreUtils;
import org.egov.infra.web.rest.error.ErrorResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/dcr"})
public class RestEdcrApplicationController {
    private static final String INCORRECT_REQUEST = "INCORRECT_REQUEST";
    private static final Logger LOGGER = Logger.getLogger(RestEdcrApplicationController.class);
    private static final String DIGIT_DCR = "Digit DCR";
    @Autowired
    private EdcrRestService edcrRestService;
    @Autowired
    private PlanService planService;
    @Autowired
    protected FileStoreUtils fileStoreUtils;
    @Autowired
    private MdmsConfiguration mdmsConfiguration;
    @Autowired
    private MDMSValidator mDMSValidator;
    @Autowired
    private BpaMdmsUtil bpaMdmsUtil;
    @Autowired
    private OcComparisonService ocComparisonService;

    @PostMapping(value={"/scrutinizeplan"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> scrutinizePlan(@RequestBody MultipartFile planFile, @RequestParam String edcrRequest) {
        EdcrDetail edcrDetail = new EdcrDetail();
        EdcrRequest edcr = new EdcrRequest();
        try {
            edcr = (EdcrRequest)new ObjectMapper().readValue(edcrRequest, EdcrRequest.class);
            ErrorDetail errorResponses = this.edcrRestService.validateEdcrRequest(edcr, planFile);
            if (errorResponses != null) {
                return new ResponseEntity((Object)errorResponses, HttpStatus.BAD_REQUEST);
            }
            edcrDetail = this.edcrRestService.createEdcr(edcr, planFile, new HashMap());
        }
        catch (IOException e) {
            ErrorResponse error = new ErrorResponse(INCORRECT_REQUEST, e.getLocalizedMessage(), HttpStatus.BAD_REQUEST);
            return new ResponseEntity((Object)error, HttpStatus.BAD_REQUEST);
        }
        return this.getSuccessResponse(Arrays.asList(edcrDetail), edcr.getRequestInfo());
    }

    @PostMapping(value={"/scrutinizeocplan"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> scrutinizeOccupancyPlan(@RequestBody MultipartFile planFile, @RequestParam String edcrRequest) {
        EdcrDetail edcrDetail = new EdcrDetail();
        EdcrRequest edcr = new EdcrRequest();
        try {
            edcr = (EdcrRequest)new ObjectMapper().readValue(edcrRequest, EdcrRequest.class);
            ErrorDetail errorResponses = this.edcrRestService.validateEdcrOcRequest(edcr, planFile);
            if (errorResponses != null) {
                return new ResponseEntity((Object)errorResponses, HttpStatus.BAD_REQUEST);
            }
            edcr.setAppliactionType(ApplicationType.OCCUPANCY_CERTIFICATE.toString());
            edcrDetail = this.edcrRestService.createEdcr(edcr, planFile, new HashMap());
        }
        catch (IOException e) {
            ErrorResponse error = new ErrorResponse(INCORRECT_REQUEST, e.getLocalizedMessage(), HttpStatus.BAD_REQUEST);
            return new ResponseEntity((Object)error, HttpStatus.BAD_REQUEST);
        }
        return this.getSuccessResponse(Arrays.asList(edcrDetail), edcr.getRequestInfo());
    }

    @PostMapping(value={"/scrutinize"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> scrutinize(@RequestBody MultipartFile planFile, @RequestParam String edcrRequest) {
        EdcrDetail edcrDetail = new EdcrDetail();
        EdcrRequest edcr = new EdcrRequest();
        try {
            List<Object> errorResponses = new ArrayList();
            edcr = (EdcrRequest)new ObjectMapper().readValue(edcrRequest, EdcrRequest.class);
            List errors = this.edcrRestService.validateEdcrMandatoryFields(edcr);
            if (!errors.isEmpty()) {
                return new ResponseEntity((Object)errors, HttpStatus.BAD_REQUEST);
            }
            String applicationType = edcr.getAppliactionType();
            String serviceType = edcr.getApplicationSubType();
            Map masterData = new HashMap();
            Boolean mdmsEnabled = this.mdmsConfiguration.getMdmsEnabled();
            if (mdmsEnabled != null && mdmsEnabled.booleanValue()) {
                Object mdmsData = this.bpaMdmsUtil.mDMSCall(new RequestInfo(), edcr.getTenantId());
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("applicationType", applicationType);
                data.put("serviceType", serviceType);
                masterData = this.mDMSValidator.getAttributeValues(mdmsData);
                List mdmsErrors = this.mDMSValidator.validateMdmsData(masterData, data);
                if (!mdmsErrors.isEmpty()) {
                    return new ResponseEntity((Object)mdmsErrors, HttpStatus.BAD_REQUEST);
                }
                if ("BUILDING_OC_PLAN_SCRUTINY".equalsIgnoreCase(applicationType)) {
                    edcr.setAppliactionType(ApplicationType.OCCUPANCY_CERTIFICATE.toString());
                    errorResponses = this.edcrRestService.validateScrutinizeOcRequest(edcr, planFile);
                } else if ("BUILDING_PLAN_SCRUTINY".equalsIgnoreCase(applicationType)) {
                    ErrorDetail validateEdcrRequest = this.edcrRestService.validateEdcrRequest(edcr, planFile);
                    if (validateEdcrRequest != null) {
                        errorResponses = Arrays.asList(validateEdcrRequest);
                    }
                    edcr.setAppliactionType(ApplicationType.PERMIT.toString());
                }
            } else if ("BUILDING_OC_PLAN_SCRUTINY".equalsIgnoreCase(applicationType)) {
                edcr.setAppliactionType(ApplicationType.OCCUPANCY_CERTIFICATE.toString());
                errorResponses = this.edcrRestService.validateScrutinizeOcRequest(edcr, planFile);
            } else if ("BUILDING_PLAN_SCRUTINY".equalsIgnoreCase(applicationType)) {
                ErrorDetail validateEdcrRequest = this.edcrRestService.validateEdcrRequest(edcr, planFile);
                if (validateEdcrRequest != null) {
                    errorResponses = Arrays.asList(validateEdcrRequest);
                }
                edcr.setAppliactionType(ApplicationType.PERMIT.toString());
            }
            if (!errorResponses.isEmpty()) {
                return new ResponseEntity(errorResponses, HttpStatus.BAD_REQUEST);
            }
            edcrDetail = this.edcrRestService.createEdcr(edcr, planFile, masterData);
        }
        catch (IOException e) {
            ErrorResponse error = new ErrorResponse(INCORRECT_REQUEST, e.getLocalizedMessage(), HttpStatus.BAD_REQUEST);
            return new ResponseEntity((Object)error, HttpStatus.BAD_REQUEST);
        }
        return this.getSuccessResponse(Arrays.asList(edcrDetail), edcr.getRequestInfo());
    }

    @PostMapping(value={"/scrutinydetails"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> scrutinyDetails(@ModelAttribute EdcrRequest edcrRequest, @RequestBody @Valid RequestInfoWrapper requestInfoWrapper) {
        List edcrDetail = this.edcrRestService.fetchEdcr(edcrRequest, requestInfoWrapper);
        if (!edcrDetail.isEmpty() && ((EdcrDetail)edcrDetail.get(0)).getErrors() != null) {
            return new ResponseEntity((Object)((EdcrDetail)edcrDetail.get(0)).getErrors(), HttpStatus.NOT_FOUND);
        }
        return this.getSuccessResponse(edcrDetail, requestInfoWrapper.getRequestInfo());
    }

    @PostMapping(value={"/extractplan"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> planDetails(@RequestBody MultipartFile planFile, @RequestParam String edcrRequest) {
        Plan plan = new Plan();
        EdcrRequest edcr = new EdcrRequest();
        try {
            edcr = (EdcrRequest)new ObjectMapper().readValue(edcrRequest, EdcrRequest.class);
            ErrorDetail errorResponses = this.edcrRestService.validatePlanFile(planFile);
            if (errorResponses != null) {
                return new ResponseEntity((Object)errorResponses, HttpStatus.BAD_REQUEST);
            }
            plan = this.planService.extractPlan(edcr, planFile);
        }
        catch (IOException e) {
            ErrorResponse error = new ErrorResponse(INCORRECT_REQUEST, e.getLocalizedMessage(), HttpStatus.BAD_REQUEST);
            return new ResponseEntity((Object)error, HttpStatus.BAD_REQUEST);
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        String jsonRes = "";
        try {
            jsonRes = mapper.writeValueAsString((Object)plan);
        }
        catch (JsonProcessingException e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        return this.getPlanSuccessResponse(jsonRes, edcr.getRequestInfo());
    }

    @GetMapping(value={"/downloadfile/{fileStoreId}"})
    public ResponseEntity<InputStreamResource> download(@PathVariable String fileStoreId) {
        return this.fileStoreUtils.fileAsResponseEntity(fileStoreId, DIGIT_DCR, true);
    }

    private ResponseEntity<?> getSuccessResponse(List<EdcrDetail> edcrDetails, RequestInfo requestInfo) {
        EdcrResponse edcrRes = new EdcrResponse();
        edcrRes.setEdcrDetail(edcrDetails);
        ResponseInfo responseInfo = this.edcrRestService.createResponseInfoFromRequestInfo(requestInfo, Boolean.valueOf(true));
        edcrRes.setResponseInfo(responseInfo);
        return new ResponseEntity((Object)edcrRes, HttpStatus.OK);
    }

    private ResponseEntity<?> getPlanSuccessResponse(String jsonRes, RequestInfo requestInfo) {
        Plan plan;
        PlanResponse planRes = new PlanResponse();
        try {
            plan = (Plan)new ObjectMapper().readValue(jsonRes, Plan.class);
        }
        catch (IOException e) {
            return new ResponseEntity((Object)e, HttpStatus.BAD_REQUEST);
        }
        planRes.setPlan(plan);
        ResponseInfo responseInfo = this.edcrRestService.createResponseInfoFromRequestInfo(requestInfo, Boolean.valueOf(true));
        planRes.setResponseInfo(responseInfo);
        return new ResponseEntity((Object)planRes, HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class})
    public final ResponseEntity<ErrorResponse> handleGenericException(Exception ex) {
        String errorDesc = ex.getLocalizedMessage() == null ? (String.valueOf(ex).length() <= 200 ? String.valueOf(ex).substring(0, String.valueOf(ex).length()) : String.valueOf(ex).substring(1, 200)) : ex.getMessage();
        ErrorResponse error = new ErrorResponse("Internal Server Error", errorDesc, HttpStatus.INTERNAL_SERVER_ERROR);
        return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @PostMapping(value={"/occomparison"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> ocComparisonReport(@ModelAttribute ComparisonRequest comparisonRequest, @RequestBody @Valid RequestInfoWrapper requestInfoWrapper) {
        List errors = this.ocComparisonService.validateEdcrMandatoryFields(comparisonRequest);
        if (!errors.isEmpty()) {
            return new ResponseEntity((Object)errors, HttpStatus.BAD_REQUEST);
        }
        ComparisonDetail comparisonDetail = this.ocComparisonService.process(comparisonRequest);
        if (comparisonDetail.getErrors() != null && !comparisonDetail.getErrors().isEmpty()) {
            return new ResponseEntity((Object)comparisonDetail.getErrors(), HttpStatus.BAD_REQUEST);
        }
        return this.getComparisonSuccessResponse(comparisonDetail, requestInfoWrapper.getRequestInfo());
    }

    private ResponseEntity<?> getComparisonSuccessResponse(ComparisonDetail comparisonDetail, RequestInfo requestInfo) {
        ComparisonResponse comparisonResponse = new ComparisonResponse();
        comparisonResponse.setComparisonDetail(comparisonDetail);
        ResponseInfo responseInfo = this.edcrRestService.createResponseInfoFromRequestInfo(requestInfo, Boolean.valueOf(true));
        comparisonResponse.setResponseInfo(responseInfo);
        return new ResponseEntity((Object)comparisonResponse, HttpStatus.OK);
    }
}

