/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.web.controller.rest;

import java.util.Date;
import org.egov.common.entity.dcr.helper.EdcrApplicationInfo;
import org.egov.common.entity.dcr.helper.ErrorDetail;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.service.EdcrApplicationDetailService;
import org.egov.edcr.service.EdcrExternalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public"})
public class EdcrRestController {
    @Autowired
    private EdcrExternalService edcrExternalService;
    @Autowired
    private EdcrApplicationDetailService edcrApplicationDetailService;

    @GetMapping(value={"/approved-plan-details/by-edcr-number/{dcrNumber}"}, produces={"application/json"})
    public EdcrApplicationInfo validateEdcrPlanFile(@PathVariable String dcrNumber) {
        EdcrApplicationDetail applicationDetail = this.edcrApplicationDetailService.findByDcrNumber(dcrNumber);
        if (applicationDetail == null) {
            ErrorDetail errorDetail = new ErrorDetail();
            errorDetail.setErrorCode("EDCR - 01");
            errorDetail.setErrorMessage("Dear applicant with entered E-DCR number there is no application detail found, please make sure you are using approved plan E-DCR number.");
            EdcrApplicationInfo applicationInfo = new EdcrApplicationInfo();
            applicationInfo.setErrorDetail(errorDetail);
            return applicationInfo;
        }
        return this.edcrExternalService.loadEdcrApplicationDetails(dcrNumber);
    }

    @GetMapping(value={"/approved-report-ouput/by-edcr-number/{dcrNumber}"})
    @ResponseBody
    public String getDcrReport(@PathVariable String dcrNumber) {
        EdcrApplicationDetail applicationDetail = this.edcrApplicationDetailService.findByDcrNumber(dcrNumber);
        return applicationDetail.getReportOutputId().getFileStoreId();
    }

    @GetMapping(value={"/converted-pdf/by-edcr-number/{dcrNumber}"})
    @ResponseBody
    public String getConvertedPdfs(@PathVariable String dcrNumber) {
        return null;
    }

    @GetMapping(value={"/created-date/of-edcr-number/{dcrNumber}"})
    @ResponseBody
    public Date getCreatedDateOfDCR(@PathVariable String dcrNumber) {
        EdcrApplicationDetail applicationDetail = this.edcrApplicationDetailService.findByDcrNumber(dcrNumber);
        if (applicationDetail != null && applicationDetail.getCreatedDate() != null) {
            return applicationDetail.getCreatedDate();
        }
        return null;
    }

    @GetMapping(value={"/plan-permission-no/by-edcr-number/{dcrNumber}"})
    @ResponseBody
    public String getEdcrPlanPermissionNo(@PathVariable String dcrNumber) {
        EdcrApplicationDetail applicationDetail = this.edcrApplicationDetailService.findByDcrNumber(dcrNumber);
        if (applicationDetail != null) {
            return applicationDetail.getApplication().getPlanPermitNumber();
        }
        return null;
    }
}

