/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.web.controller.report;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.edcr.entity.SearchBuildingPlanScrutinyForm;
import org.egov.edcr.service.EdcrApplicationService;
import org.egov.edcr.web.adaptor.SearchBuildingPlanScrutinyAdaptor;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.infra.web.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

@Controller
@RequestMapping(value={"/reports"})
public class EdcrReportsController {
    private static final String SCR_SRCH_RPRT = "search-building-plan-scrutiny-report";
    private static final String BPA_REST_URL = "%s/bpa/rest/stakeholder/type";
    @Autowired
    private EdcrApplicationService edcrApplicationService;

    @GetMapping(value={"/buildingplan-scrutinyreport"})
    public String searchBuildingPlanScrutinyForm(Model model, HttpServletRequest request) {
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("Accepted");
        statusList.add("Not Accepted");
        statusList.add("Aborted");
        model.addAttribute("searchBuildingPlanScrutinyForm", (Object)new SearchBuildingPlanScrutinyForm());
        model.addAttribute("buildingLicenseeTypeList", (Object)this.getStakeHolderTypes(request));
        model.addAttribute("statusList", statusList);
        return SCR_SRCH_RPRT;
    }

    @PostMapping(value={"/buildingplan-scrutinyreport"}, produces={"text/plain"})
    @ResponseBody
    public String searchBuildingPlanScrutiny(SearchBuildingPlanScrutinyForm srchPlnScrtny) {
        return new DataTable(this.edcrApplicationService.planScrutinyPagedSearch(srchPlnScrtny), (long)srchPlnScrtny.draw()).toJson(SearchBuildingPlanScrutinyAdaptor.class);
    }

    public List<String> getStakeHolderTypes(HttpServletRequest request) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(BPA_REST_URL, WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false));
        return (List)restTemplate.getForObject(url, List.class, new Object[0]);
    }
}

