/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.web.controller;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.common.entity.dcr.helper.ErrorDetail;
import org.egov.commons.service.OccupancyService;
import org.egov.edcr.entity.ApplicationType;
import org.egov.edcr.entity.EdcrApplication;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.entity.EdcrPdfDetail;
import org.egov.edcr.service.EdcrApplicationService;
import org.egov.edcr.service.EdcrBpaRestService;
import org.egov.edcr.service.EdcrPdfDetailService;
import org.egov.edcr.web.adaptor.EdcrApplicationJsonAdaptor;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class EdcrApplicationController {
    private static final String USER_ID = "userId";
    private static final String FEE_PENDING = "Fee Pending";
    private static final String EDCR_APPLICATION = "edcrApplication";
    private static final String MSG_EDCRAPPLICATION_SUCCESS = "msg.edcrapplication.success";
    private static final String REDIRECT_APPLICATION_RESULT = "redirect:/edcrapplication/result/";
    private static final String EDCRAPPLICATION_NEW = "edcrapplication-new";
    private static final String EDCRAPPLICATION_RESULT = "edcrapplication-result";
    private static final String EDCRAPPLICATION_EDIT = "edcrapplication-edit";
    private static final String EDCRAPPLICATION_VIEW = "edcrapplication-view";
    private static final String EDCRAPPLICATION_SEARCH = "edcrapplication-search";
    private static final String EDCRAPPLICATION_RE_UPLOAD = "edcr-reupload-form";
    private static final String EDCRAPPLICATION_CONVERTED_PDF = "view-edcr-pdf";
    private static final String DCR_ACKNOWLEDGEMENT = "dcr-acknowledgement";
    private static final String OC_PLAN_SCRUTINY_NEW = "oc-plan-scrutiny-new";
    private static final String OC_PLAN_SCRUTINY_RESUBMIT = "oc-resubmit-plan-scrutiny-form";
    private static final String OC_PLAN_SCRUTINY_RESULT = "oc-plan-scrutiny-result";
    private static final String REDIRECT_OC_APPLICATION_RESULT = "redirect:/occupancy-certificate/plan/result/";
    private static final String MESSAGE = "message";
    @Autowired
    private EdcrApplicationService edcrApplicationService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private OccupancyService occupancyService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EdcrBpaRestService edcrBpaRestService;
    @Autowired
    private EdcrPdfDetailService edcrPdfDetailService;
    @Autowired
    protected AppConfigValueService appConfigValueService;

    private void prepareNewForm(Model model, HttpServletRequest request) {
        model.addAttribute("serviceTypeList", (Object)this.edcrBpaRestService.getEdcrIntegratedServices(request));
        model.addAttribute("occupancyList", (Object)this.occupancyService.findAllOrderByOrderNumber());
    }

    @GetMapping(value={"/edcrapplication/new"})
    public String newForm(Model model, HttpServletRequest request) {
        this.prepareNewForm(model, request);
        User loginUser = this.securityUtils.getCurrentUser();
        ErrorDetail errorDetail = this.edcrBpaRestService.validateStakeholder(loginUser.getId(), request);
        if (errorDetail != null && StringUtils.isNotBlank((CharSequence)errorDetail.getErrorMessage())) {
            if (FEE_PENDING.equalsIgnoreCase(errorDetail.getErrorMessage())) {
                model.addAttribute(USER_ID, (Object)loginUser.getId());
            } else {
                model.addAttribute(MESSAGE, (Object)errorDetail.getErrorMessage());
            }
            return DCR_ACKNOWLEDGEMENT;
        }
        EdcrApplication edcrApplication = new EdcrApplication();
        edcrApplication.setArchitectInformation(loginUser.getName());
        model.addAttribute(EDCR_APPLICATION, (Object)edcrApplication);
        return EDCRAPPLICATION_NEW;
    }

    @PostMapping(value={"/edcrapplication/create"})
    public String create(@ModelAttribute EdcrApplication edcrApplication, BindingResult errors, Model model, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model, request);
            return EDCRAPPLICATION_NEW;
        }
        EdcrApplicationDetail edcrApplicationDetail = new EdcrApplicationDetail();
        ArrayList<EdcrApplicationDetail> edcrApplicationDetails = new ArrayList<EdcrApplicationDetail>();
        edcrApplicationDetails.add(edcrApplicationDetail);
        edcrApplication.setEdcrApplicationDetails(edcrApplicationDetails);
        this.edcrApplicationService.create(edcrApplication);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage(MSG_EDCRAPPLICATION_SUCCESS, null, null));
        return REDIRECT_APPLICATION_RESULT + edcrApplication.getApplicationNumber();
    }

    @GetMapping(value={"/edcrapplication/edit/{applicationNumber}"})
    public String edit(@PathVariable(value="id") String applicationNumber, Model model, HttpServletRequest request) {
        EdcrApplication edcrApplication = this.edcrApplicationService.findByApplicationNo(applicationNumber);
        this.prepareNewForm(model, request);
        model.addAttribute(EDCR_APPLICATION, (Object)edcrApplication);
        return EDCRAPPLICATION_EDIT;
    }

    @GetMapping(value={"/edcrapplication/resubmit"})
    public String uploadAgain(Model model, HttpServletRequest request) {
        User loginUser = this.securityUtils.getCurrentUser();
        ErrorDetail errorDetail = this.edcrBpaRestService.validateStakeholder(loginUser.getId(), request);
        if (errorDetail != null && StringUtils.isNotBlank((CharSequence)errorDetail.getErrorMessage())) {
            if (FEE_PENDING.equalsIgnoreCase(errorDetail.getErrorMessage())) {
                model.addAttribute(USER_ID, (Object)loginUser.getId());
            } else {
                model.addAttribute(MESSAGE, (Object)errorDetail.getErrorMessage());
            }
            return DCR_ACKNOWLEDGEMENT;
        }
        this.prepareNewForm(model, request);
        EdcrApplication edcrApplication = new EdcrApplication();
        edcrApplication.setApplicationType(ApplicationType.PERMIT);
        model.addAttribute(EDCR_APPLICATION, (Object)edcrApplication);
        return EDCRAPPLICATION_RE_UPLOAD;
    }

    @PostMapping(value={"/edcrapplication/update"})
    public String update(@ModelAttribute EdcrApplication edcrApplication, BindingResult errors, Model model, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model, request);
            return EDCRAPPLICATION_EDIT;
        }
        EdcrApplicationDetail edcrApplicationDetail = new EdcrApplicationDetail();
        ArrayList<EdcrApplicationDetail> edcrApplicationDetails = new ArrayList<EdcrApplicationDetail>();
        edcrApplicationDetails.add(edcrApplicationDetail);
        edcrApplication.setEdcrApplicationDetails(edcrApplicationDetails);
        this.edcrApplicationService.update(edcrApplication);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage(MSG_EDCRAPPLICATION_SUCCESS, null, null));
        return REDIRECT_APPLICATION_RESULT + edcrApplication.getApplicationNumber();
    }

    @GetMapping(value={"/edcrapplication/view/{applicationNumber}"})
    public String view(@PathVariable String applicationNumber, Model model, HttpServletRequest request) {
        EdcrApplication edcrApplication = this.edcrApplicationService.findByApplicationNo(applicationNumber);
        this.prepareNewForm(model, request);
        this.setFailedLayersCount(edcrApplication);
        model.addAttribute(EDCR_APPLICATION, (Object)edcrApplication);
        return EDCRAPPLICATION_VIEW;
    }

    @GetMapping(value={"/edcrapplication/result/{applicationNumber}"})
    public String result(@PathVariable String applicationNumber, Model model) {
        EdcrApplication edcrApplication = this.edcrApplicationService.findByApplicationNo(applicationNumber);
        this.setFailedLayersCount(edcrApplication);
        model.addAttribute(EDCR_APPLICATION, (Object)edcrApplication);
        return EDCRAPPLICATION_RESULT;
    }

    @GetMapping(value={"/occupancy-certificate/plan/submit"})
    public String ocNewPlanScrutinyForm(Model model, HttpServletRequest request) {
        this.prepareNewForm(model, request);
        User loginUser = this.securityUtils.getCurrentUser();
        ErrorDetail errorDetail = this.edcrBpaRestService.validateStakeholder(loginUser.getId(), request);
        if (errorDetail != null && StringUtils.isNotBlank((CharSequence)errorDetail.getErrorMessage())) {
            if (FEE_PENDING.equalsIgnoreCase(errorDetail.getErrorMessage())) {
                model.addAttribute(USER_ID, (Object)loginUser.getId());
            } else {
                model.addAttribute(MESSAGE, (Object)errorDetail.getErrorMessage());
            }
            return DCR_ACKNOWLEDGEMENT;
        }
        EdcrApplication edcrApplication = new EdcrApplication();
        edcrApplication.setApplicationType(ApplicationType.OCCUPANCY_CERTIFICATE);
        edcrApplication.setArchitectInformation(loginUser.getName());
        model.addAttribute("isCitizen", (Object)this.securityUtils.getCurrentUser().getType().equals((Object)UserType.CITIZEN));
        model.addAttribute(EDCR_APPLICATION, (Object)edcrApplication);
        return OC_PLAN_SCRUTINY_NEW;
    }

    @PostMapping(value={"/occupancy-certificate/plan/submit"})
    public String submitPlanForOccupancyCertificate(@ModelAttribute EdcrApplication edcrApplication, BindingResult errors, Model model, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model, request);
            return OC_PLAN_SCRUTINY_NEW;
        }
        EdcrApplicationDetail edcrApplicationDetail = new EdcrApplicationDetail();
        ArrayList<EdcrApplicationDetail> edcrApplicationDetails = new ArrayList<EdcrApplicationDetail>();
        edcrApplicationDetails.add(edcrApplicationDetail);
        edcrApplication.setEdcrApplicationDetails(edcrApplicationDetails);
        edcrApplication.setPermitApplicationDate(DateUtils.toDateUsingDefaultPattern((String)edcrApplication.getPermitDateTemp()));
        this.edcrApplicationService.create(edcrApplication);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage(MSG_EDCRAPPLICATION_SUCCESS, null, null));
        return REDIRECT_OC_APPLICATION_RESULT + edcrApplication.getApplicationNumber();
    }

    @GetMapping(value={"/occupancy-certificate/plan/resubmit"})
    public String resubmitPlanForOccupancyCertificate(Model model, HttpServletRequest request) {
        User loginUser = this.securityUtils.getCurrentUser();
        ErrorDetail errorDetail = this.edcrBpaRestService.validateStakeholder(loginUser.getId(), request);
        if (errorDetail != null && StringUtils.isNotBlank((CharSequence)errorDetail.getErrorMessage())) {
            if (FEE_PENDING.equalsIgnoreCase(errorDetail.getErrorMessage())) {
                model.addAttribute(USER_ID, (Object)loginUser.getId());
            } else {
                model.addAttribute(MESSAGE, (Object)errorDetail.getErrorMessage());
            }
            return DCR_ACKNOWLEDGEMENT;
        }
        this.prepareNewForm(model, request);
        EdcrApplication edcrApplication = new EdcrApplication();
        edcrApplication.setApplicationType(ApplicationType.OCCUPANCY_CERTIFICATE);
        model.addAttribute(EDCR_APPLICATION, (Object)edcrApplication);
        return OC_PLAN_SCRUTINY_RESUBMIT;
    }

    @PostMapping(value={"/occupancy-certificate/plan/resubmit"})
    public String resubmitPlanForOccupancyCertificate(@ModelAttribute EdcrApplication edcrApplication, BindingResult errors, Model model, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model, request);
            return OC_PLAN_SCRUTINY_RESUBMIT;
        }
        EdcrApplicationDetail edcrApplicationDetail = new EdcrApplicationDetail();
        ArrayList<EdcrApplicationDetail> edcrApplicationDetails = new ArrayList<EdcrApplicationDetail>();
        edcrApplicationDetails.add(edcrApplicationDetail);
        edcrApplication.setEdcrApplicationDetails(edcrApplicationDetails);
        this.edcrApplicationService.update(edcrApplication);
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)this.messageSource.getMessage(MSG_EDCRAPPLICATION_SUCCESS, null, null));
        return REDIRECT_OC_APPLICATION_RESULT + edcrApplication.getApplicationNumber();
    }

    @GetMapping(value={"/occupancy-certificate/plan/result/{applicationNumber}"})
    public String planScrutinyResultForOccupancyCertificate(@PathVariable String applicationNumber, Model model) {
        EdcrApplication edcrApplication = this.edcrApplicationService.findByApplicationNo(applicationNumber);
        this.setFailedLayersCount(edcrApplication);
        model.addAttribute(EDCR_APPLICATION, (Object)edcrApplication);
        return OC_PLAN_SCRUTINY_RESULT;
    }

    @GetMapping(value={"/edcrapplication/search/{mode}"})
    public String search(@PathVariable(value="mode") String mode, Model model, HttpServletRequest request) {
        EdcrApplication edcrApplication = new EdcrApplication();
        this.prepareNewForm(model, request);
        model.addAttribute(EDCR_APPLICATION, (Object)edcrApplication);
        return EDCRAPPLICATION_SEARCH;
    }

    @GetMapping(value={"/edcrapplication/get-information/{applicationNumber}/{applicationType}"}, produces={"application/json"})
    @ResponseBody
    public EdcrApplication getEdcrApplicationDetailsByApplnNumber(@PathVariable String applicationNumber, @PathVariable ApplicationType applicationType, Model model) {
        return this.edcrApplicationService.findByApplicationNoAndType(applicationNumber, applicationType);
    }

    @PostMapping(value={"/edcrapplication/ajaxsearch/{mode}"}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute EdcrApplication edcrApplication) {
        List searchResultList = this.edcrApplicationService.search(edcrApplication);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, EdcrApplication.class, EdcrApplicationJsonAdaptor.class) + "}";
    }

    @GetMapping(value={"/edcrapplication/get-convertedpdf/{applicationDetailId}"})
    public String getConvertedPdfByApplicationDetailId(@PathVariable String applicationDetailId, Model model) {
        List pdfDetails = this.edcrPdfDetailService.findByDcrApplicationId(Long.valueOf(applicationDetailId));
        if (pdfDetails != null && !pdfDetails.isEmpty()) {
            for (EdcrPdfDetail edcrPdfDetail : pdfDetails) {
                if (!StringUtils.isNotBlank((CharSequence)edcrPdfDetail.getStandardViolations())) continue;
                String[] split = edcrPdfDetail.getStandardViolations().split("\\|");
                List<String> violations = Arrays.asList(split);
                edcrPdfDetail.setViolations(violations);
            }
        }
        model.addAttribute("pdfDetails", (Object)pdfDetails);
        return EDCRAPPLICATION_CONVERTED_PDF;
    }

    @GetMapping(value={"/scrutinized-plan/findby-permitnumber/{permitNumber}"}, produces={"application/json"})
    @ResponseBody
    public void getEdcrApplicationDetailsByPermitNumber(@PathVariable String permitNumber, HttpServletResponse response) throws IOException {
        EdcrApplication application = this.edcrApplicationService.findByPlanPermitNumber(permitNumber);
        JsonObject jsonObj = new JsonObject();
        if (application != null) {
            jsonObj.addProperty("applicationNumber", application.getApplicationNumber());
        }
        IOUtils.write((String)jsonObj.toString(), (Writer)response.getWriter());
    }

    private void setFailedLayersCount(EdcrApplication edcrApplication) {
    }
}

