/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service.es;

import org.egov.commons.entity.Source;
import org.egov.edcr.entity.EdcrApplication;
import org.egov.edcr.entity.es.EdcrIndex;
import org.egov.edcr.repository.es.EdcrIndexRepository;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EdcrIndexService {
    private static final String url = "/edcr/edcrapplication/view/%s";
    @Autowired
    private CityService cityService;
    @Autowired
    private EdcrIndexRepository edcrIndexRepository;
    @Value(value="${elasticsearch.enable}")
    private Boolean enable;
    @Autowired
    private ApplicationIndexService applicationIndexService;

    public EdcrIndex createEdcrIndex(EdcrApplication edcrApp) {
        if (this.enable.booleanValue()) {
            City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
            EdcrIndex edcrIndex = new EdcrIndex();
            edcrIndex.setId(cityWebsite.getCode() + "-" + edcrApp.getApplicationNumber());
            this.buildUlbDetails(cityWebsite, edcrIndex);
            this.buildApplicationData(edcrApp, edcrIndex);
            edcrIndex.setOccupancy(edcrApp.getOccupancy() == null ? "" : edcrApp.getOccupancy());
            edcrIndex.setApplicantName(edcrApp.getApplicantName() == null ? "" : edcrApp.getApplicantName());
            edcrIndex.setServiceType(edcrApp.getServiceType() == null ? "" : edcrApp.getServiceType());
            edcrIndex.setAmenities(edcrApp.getAmenities() == null ? "" : edcrApp.getAmenities());
            if (!edcrApp.getEdcrApplicationDetails().isEmpty()) {
                Integer noOfAppDtls = edcrApp.getEdcrApplicationDetails().size();
                edcrIndex.setDcrNumber(edcrApp.getEdcrApplicationDetails().get(noOfAppDtls - 1).getDcrNumber() == null ? "" : edcrApp.getEdcrApplicationDetails().get(noOfAppDtls - 1).getDcrNumber());
            }
            if (edcrApp.getCreatedBy() != null) {
                edcrIndex.setStakeHolderId(edcrApp.getCreatedBy().getId() == null ? "" : String.valueOf(edcrApp.getCreatedBy().getId()));
            }
            this.edcrIndexRepository.save(edcrIndex);
            return edcrIndex;
        }
        return null;
    }

    private void buildApplicationData(EdcrApplication edcrApp, EdcrIndex edcrIndex) {
        edcrIndex.setApplicationDate(edcrApp.getApplicationDate());
        edcrIndex.setApplicationNumber(edcrApp.getApplicationNumber() == null ? "" : edcrApp.getApplicationNumber());
        edcrIndex.setStatus(edcrApp.getStatus() == null ? "" : edcrApp.getStatus());
    }

    private void buildUlbDetails(City cityWebsite, EdcrIndex edcrIndex) {
        edcrIndex.setUlbName(cityWebsite.getName());
        edcrIndex.setDistrictName(cityWebsite.getDistrictName());
        edcrIndex.setRegionName(cityWebsite.getRegionName());
        edcrIndex.setUlbGrade(cityWebsite.getGrade());
        edcrIndex.setUlbCode(cityWebsite.getCode());
    }

    public void updateIndexes(EdcrApplication edcrApplication, String applctnType) {
        if (this.enable.booleanValue()) {
            ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(edcrApplication.getApplicationNumber());
            if (applicationIndex != null && edcrApplication.getId() != null) {
                ApprovalStatus status = null;
                if (edcrApplication.getStatus().equals("Accepted")) {
                    status = ApprovalStatus.APPROVED;
                } else if (edcrApplication.getStatus().equals("Not Accepted") || edcrApplication.getStatus().equals("Aborted")) {
                    status = ApprovalStatus.REJECTED;
                }
                applicationIndex.setStatus(edcrApplication.getStatus());
                applicationIndex.setApproved(status);
                applicationIndex.setApplicationType(applctnType);
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
                this.createEdcrIndex(edcrApplication);
            } else {
                ApprovalStatus status = null;
                if (edcrApplication.getStatus().equals("Accepted")) {
                    status = ApprovalStatus.APPROVED;
                } else if (edcrApplication.getStatus().equals("Not Accepted") || edcrApplication.getStatus().equals("Aborted")) {
                    status = ApprovalStatus.REJECTED;
                }
                applicationIndex = ApplicationIndex.builder().withModuleName("Digit DCR").withApplicationNumber(edcrApplication.getApplicationNumber()).withApplicationDate(edcrApplication.getApplicationDate()).withApplicantName(edcrApplication.getApplicantName()).withStatus(edcrApplication.getStatus()).withConsumerCode(edcrApplication.getApplicationNumber()).withClosed(ClosureStatus.YES).withApproved(status).withUrl(String.format(url, edcrApplication.getApplicationNumber())).withChannel(Source.CITIZENPORTAL.name()).withApplicationType(applctnType).build();
                this.applicationIndexService.createApplicationIndex(applicationIndex);
                this.createEdcrIndex(edcrApplication);
            }
        }
    }

    public void updateEdcrRestIndexes(EdcrApplication edcrApplication, String applctnType) {
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(edcrApplication.getApplicationNumber());
        if (applicationIndex != null && edcrApplication.getId() != null) {
            ApprovalStatus status = null;
            if (edcrApplication.getStatus().equals("Accepted")) {
                status = ApprovalStatus.APPROVED;
            } else if (edcrApplication.getStatus().equals("Not Accepted") || edcrApplication.getStatus().equals("Aborted")) {
                status = ApprovalStatus.REJECTED;
            }
            applicationIndex.setStatus(edcrApplication.getStatus());
            applicationIndex.setApproved(status);
            applicationIndex.setApplicationType(applctnType);
            this.applicationIndexService.updateApplicationIndex(applicationIndex);
            this.createEdcrIndex(edcrApplication);
        } else {
            ApprovalStatus status = null;
            if (edcrApplication.getStatus().equals("Accepted")) {
                status = ApprovalStatus.APPROVED;
            } else if (edcrApplication.getStatus().equals("Not Accepted") || edcrApplication.getStatus().equals("Aborted")) {
                status = ApprovalStatus.REJECTED;
            }
            applicationIndex = ApplicationIndex.builder().withModuleName("Digit DCR").withApplicationNumber(edcrApplication.getApplicationNumber()).withApplicationDate(edcrApplication.getApplicationDate()).withApplicantName(edcrApplication.getApplicantName()).withStatus(edcrApplication.getStatus()).withConsumerCode(edcrApplication.getApplicationNumber()).withClosed(ClosureStatus.YES).withApproved(status).withUrl(String.format(url, edcrApplication.getApplicationNumber())).withChannel(Source.THIRDPARTY.name()).withApplicationType(applctnType).build();
            this.applicationIndexService.createApplicationIndex(applicationIndex);
            this.createEdcrIndex(edcrApplication);
        }
    }
}

