/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.OccupancyType;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Plot;
import org.egov.common.entity.edcr.TypicalFloor;

public class ProcessHelper {
    private static final BigDecimal ONEHUNDREDFIFTY = BigDecimal.valueOf(150L);
    private static final BigDecimal FIFTY = BigDecimal.valueOf(50L);
    private static final BigDecimal THREEHUNDRED = BigDecimal.valueOf(300L);

    public static OccupancyType getOccupancyAsPerFloorArea(OccupancyType occupancy, BigDecimal floorArea) {
        if (OccupancyType.OCCUPANCY_B1.equals((Object)occupancy) || OccupancyType.OCCUPANCY_B2.equals((Object)occupancy) || OccupancyType.OCCUPANCY_B3.equals((Object)occupancy)) {
            occupancy = floorArea != null && floorArea.compareTo(ONEHUNDREDFIFTY) <= 0 ? OccupancyType.OCCUPANCY_A2 : OccupancyType.OCCUPANCY_B1;
        } else if (OccupancyType.OCCUPANCY_C.equals((Object)occupancy) || OccupancyType.OCCUPANCY_C1.equals((Object)occupancy) || OccupancyType.OCCUPANCY_C2.equals((Object)occupancy) || OccupancyType.OCCUPANCY_C3.equals((Object)occupancy)) {
            occupancy = floorArea != null && floorArea.compareTo(ONEHUNDREDFIFTY) <= 0 ? OccupancyType.OCCUPANCY_F : OccupancyType.OCCUPANCY_C;
        } else if (floorArea != null && floorArea.compareTo(ONEHUNDREDFIFTY) <= 0 && OccupancyType.OCCUPANCY_D.equals((Object)occupancy)) {
            occupancy = OccupancyType.OCCUPANCY_F;
        } else if (OccupancyType.OCCUPANCY_D1.equals((Object)occupancy) || OccupancyType.OCCUPANCY_D2.equals((Object)occupancy)) {
            occupancy = OccupancyType.OCCUPANCY_D;
        } else if (OccupancyType.OCCUPANCY_E.equals((Object)occupancy)) {
            occupancy = floorArea != null && floorArea.compareTo(THREEHUNDRED) <= 0 ? OccupancyType.OCCUPANCY_F : OccupancyType.OCCUPANCY_E;
        } else if (OccupancyType.OCCUPANCY_H.equals((Object)occupancy)) {
            occupancy = floorArea != null && floorArea.compareTo(THREEHUNDRED) <= 0 ? OccupancyType.OCCUPANCY_F : OccupancyType.OCCUPANCY_H;
        } else if (OccupancyType.OCCUPANCY_A5.equals((Object)occupancy)) {
            occupancy = floorArea != null && floorArea.compareTo(FIFTY) <= 0 ? OccupancyType.OCCUPANCY_A1 : OccupancyType.OCCUPANCY_F;
        }
        return occupancy;
    }

    public static OccupancyType getMostRestrictiveOccupancy(List<OccupancyType> distinctOccupancyTypes) {
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_I2)) {
            return OccupancyType.OCCUPANCY_I2;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_I1)) {
            return OccupancyType.OCCUPANCY_I1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_G1)) {
            return OccupancyType.OCCUPANCY_G1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_D)) {
            return OccupancyType.OCCUPANCY_D;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_B1)) {
            return OccupancyType.OCCUPANCY_B1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_B2)) {
            return OccupancyType.OCCUPANCY_B2;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_B3)) {
            return OccupancyType.OCCUPANCY_B3;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_C)) {
            return OccupancyType.OCCUPANCY_C;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_D1)) {
            return OccupancyType.OCCUPANCY_D1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_E)) {
            return OccupancyType.OCCUPANCY_E;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_F)) {
            return OccupancyType.OCCUPANCY_F;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_A1)) {
            return OccupancyType.OCCUPANCY_A1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_A2)) {
            return OccupancyType.OCCUPANCY_A2;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_A4)) {
            return OccupancyType.OCCUPANCY_A4;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_G2)) {
            return OccupancyType.OCCUPANCY_G2;
        }
        return null;
    }

    public static Map<String, Object> getTypicalFloorValues(Block block, Floor floor, Boolean isTypicalRepititiveFloor) {
        HashMap<String, Object> mapOfTypicalFloorValues = new HashMap<String, Object>();
        ArrayList<Integer> typicalFlrs = new ArrayList<Integer>();
        String typicalFloors = null;
        if (block.getTypicalFloor() != null) {
            for (TypicalFloor typicalFloor : block.getTypicalFloor()) {
                if (typicalFloor.getRepetitiveFloorNos().contains(floor.getNumber())) {
                    isTypicalRepititiveFloor = true;
                }
                if (typicalFloor.getModelFloorNo() != floor.getNumber()) continue;
                typicalFlrs.add(floor.getNumber());
                typicalFlrs.addAll(typicalFloor.getRepetitiveFloorNos());
                if (typicalFlrs.isEmpty()) continue;
                Integer maxTypicalFloors = (Integer)typicalFlrs.get(0);
                Integer minTypicalFloors = (Integer)typicalFlrs.get(0);
                for (Integer typical : typicalFlrs) {
                    if (typical > maxTypicalFloors) {
                        maxTypicalFloors = typical;
                    }
                    if (typical >= minTypicalFloors) continue;
                    minTypicalFloors = typical;
                }
                typicalFloors = "Typical Floor " + minTypicalFloors + " to " + maxTypicalFloors;
            }
        }
        mapOfTypicalFloorValues.put("isTypicalRepititiveFloor", isTypicalRepititiveFloor);
        mapOfTypicalFloorValues.put("typicalFloors", typicalFloors);
        return mapOfTypicalFloorValues;
    }

    public static boolean checkExemptionConditionForBuildingParts(Block blk) {
        return blk.getBuilding() != null && blk.getBuilding().getFloorsAboveGround() != null && blk.getResidentialBuilding() != false && blk.getBuilding().getFloorsAboveGround().intValue() <= 3;
    }

    public static boolean checkExemptionConditionForSmallPlotAtBlkLevel(Plot plot, Block blk) {
        return plot != null && blk.getBuilding() != null && blk.getBuilding().getFloorsAboveGround() != null && blk.getResidentialOrCommercialBuilding() != false && plot.getSmallPlot() != false && blk.getBuilding().getFloorsAboveGround().intValue() <= 3;
    }

    public static boolean isSmallPlot(Plan pl) {
        return pl != null && !pl.getBlocks().isEmpty() && pl.getPlot() != null && pl.getVirtualBuilding() != null && !ProcessHelper.checkAnyBlockHasFloorsGreaterThanThree(pl.getBlocks()) && pl.getVirtualBuilding().getResidentialOrCommercialBuilding().equals(Boolean.TRUE) && pl.getPlot().getSmallPlot().equals(Boolean.TRUE);
    }

    public static boolean checkAnyBlockHasFloorsGreaterThanThree(List<Block> blockList) {
        boolean isBlockFloorsGreaterThanThree = false;
        if (!blockList.isEmpty()) {
            for (Block blk : blockList) {
                if (blk.getBuilding() == null || blk.getBuilding().getFloorsAboveGround() == null || blk.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(3L)) <= 0) continue;
                isBlockFloorsGreaterThanThree = true;
                break;
            }
        }
        return isBlockFloorsGreaterThanThree;
    }
}

