/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.PlanFeature;
import org.egov.common.entity.edcr.PlanInformation;
import org.egov.edcr.contract.ComparisonRequest;
import org.egov.edcr.contract.EdcrRequest;
import org.egov.edcr.entity.Amendment;
import org.egov.edcr.entity.AmendmentDetails;
import org.egov.edcr.entity.ApplicationType;
import org.egov.edcr.entity.EdcrApplication;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.entity.EdcrPdfDetail;
import org.egov.edcr.entity.OcComparisonDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.service.AmendmentService;
import org.egov.edcr.service.EdcrApplicationDetailService;
import org.egov.edcr.service.EdcrApplicationService;
import org.egov.edcr.service.EdcrPdfDetailService;
import org.egov.edcr.service.ExtractService;
import org.egov.edcr.service.OcComparisonDetailService;
import org.egov.edcr.service.OcComparisonService;
import org.egov.edcr.service.PlanFeatureService;
import org.egov.edcr.service.PlanReportService;
import org.egov.infra.custom.CustomImplProvider;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.PdfUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PlanService {
    private static final Logger LOG = Logger.getLogger(PlanService.class);
    @Autowired
    private PlanFeatureService featureService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private CustomImplProvider specificRuleService;
    @Autowired
    private EdcrApplicationDetailService edcrApplicationDetailService;
    @Autowired
    private EdcrPdfDetailService edcrPdfDetailService;
    @Autowired
    private ExtractService extractService;
    @Autowired
    private EdcrApplicationService edcrApplicationService;
    @Autowired
    private OcComparisonService ocComparisonService;
    @Autowired
    private OcComparisonDetailService ocComparisonDetailService;

    public Plan process(EdcrApplication dcrApplication, String applicationType) {
        Map cityDetails = this.specificRuleService.getCityDetails();
        Date asOnDate = null;
        asOnDate = dcrApplication.getPermitApplicationDate() != null ? dcrApplication.getPermitApplicationDate() : (dcrApplication.getApplicationDate() != null ? dcrApplication.getApplicationDate() : new Date());
        AmendmentService repo = (AmendmentService)this.specificRuleService.find("amendmentService");
        Amendment amd = repo.getAmendments();
        Plan plan = this.extractService.extract(dcrApplication.getSavedDxfFile(), amd, asOnDate, this.featureService.getFeatures());
        plan.setMdmsMasterData(dcrApplication.getMdmsMasterData());
        plan = this.applyRules(plan, amd, cityDetails);
        String comparisonDcrNumber = dcrApplication.getEdcrApplicationDetails().get(0).getComparisonDcrNumber();
        if (ApplicationType.PERMIT.getApplicationTypeVal().equalsIgnoreCase(dcrApplication.getApplicationType().getApplicationType()) || ApplicationType.OCCUPANCY_CERTIFICATE.getApplicationTypeVal().equalsIgnoreCase(dcrApplication.getApplicationType().getApplicationType()) && StringUtils.isBlank((CharSequence)comparisonDcrNumber)) {
            InputStream reportStream = this.generateReport(plan, amd, dcrApplication);
            this.saveOutputReport(dcrApplication, reportStream, plan);
        } else if (ApplicationType.OCCUPANCY_CERTIFICATE.getApplicationTypeVal().equalsIgnoreCase(dcrApplication.getApplicationType().getApplicationType()) && StringUtils.isNotBlank((CharSequence)comparisonDcrNumber)) {
            ComparisonRequest comparisonRequest = new ComparisonRequest();
            EdcrApplicationDetail edcrApplicationDetail = dcrApplication.getEdcrApplicationDetails().get(0);
            comparisonRequest.setEdcrNumber(edcrApplicationDetail.getComparisonDcrNumber());
            comparisonRequest.setTenantId(edcrApplicationDetail.getApplication().getThirdPartyUserTenant());
            edcrApplicationDetail.setPlan(plan);
            OcComparisonDetail processCombinedStatus = this.ocComparisonService.processCombinedStatus(comparisonRequest, edcrApplicationDetail);
            dcrApplication.setDeviationStatus(processCombinedStatus.getStatus());
            InputStream reportStream = this.generateReport(plan, amd, dcrApplication);
            this.saveOutputReport(dcrApplication, reportStream, plan);
            ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
            Path path = this.fileStoreService.fetchAsPath(dcrApplication.getEdcrApplicationDetails().get(0).getReportOutputId().getFileStoreId(), "Digit DCR");
            byte[] convertedDigitDcr = null;
            try {
                convertedDigitDcr = Files.readAllBytes(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ByteArrayInputStream dcrReport = new ByteArrayInputStream(convertedDigitDcr);
            pdfs.add(dcrReport);
            if (plan.getMainDcrPassed().booleanValue()) {
                OcComparisonDetail ocComparisonE = this.ocComparisonService.processCombined(processCombinedStatus, edcrApplicationDetail);
                String fileName = ocComparisonE.getOcdcrNumber() + "-" + ocComparisonE.getDcrNumber() + "-comparison.pdf";
                FileStoreMapper fileStoreMapper = this.fileStoreService.store(ocComparisonE.getOutput(), fileName, "application/pdf", "Digit DCR");
                ocComparisonE.setOcComparisonReport(fileStoreMapper);
                if (StringUtils.isNotBlank((CharSequence)dcrApplication.getEdcrApplicationDetails().get(0).getDcrNumber())) {
                    ocComparisonE.setOcdcrNumber(dcrApplication.getEdcrApplicationDetails().get(0).getDcrNumber());
                }
                this.ocComparisonDetailService.saveAndFlush(ocComparisonE);
                Path ocPath = this.fileStoreService.fetchAsPath(ocComparisonE.getOcComparisonReport().getFileStoreId(), "Digit DCR");
                byte[] convertedComparison = null;
                try {
                    convertedComparison = Files.readAllBytes(ocPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ByteArrayInputStream comparisonReport = new ByteArrayInputStream(convertedComparison);
                pdfs.add(comparisonReport);
            }
            byte[] data = PdfUtils.appendFiles(pdfs);
            ByteArrayInputStream targetStream = new ByteArrayInputStream(data);
            this.saveOutputReport(dcrApplication, targetStream, plan);
            this.updateFinalReport(dcrApplication.getEdcrApplicationDetails().get(0).getReportOutputId());
        }
        return plan;
    }

    public void savePlanDetail(Plan plan, EdcrApplicationDetail detail) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"*************Before serialization******************");
        }
        File f = new File("plandetail.txt");
        try (FileOutputStream fos = new FileOutputStream(f);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            mapper.writeValue(f, (Object)plan);
            detail.setPlanDetailFileStore(this.fileStoreService.store(f, f.getName(), "text/plain", "Digit DCR"));
            oos.flush();
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to serialize!!!!!!", (Throwable)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"*************Completed serialization******************");
        }
    }

    private Plan applyRules(Plan plan, Amendment amd, Map<String, String> cityDetails) {
        int index = -1;
        AmendmentDetails[] a = null;
        int length = amd.getDetails().size();
        if (!amd.getDetails().isEmpty()) {
            index = amd.getIndex(plan.getApplicationDate());
            a = new AmendmentDetails[amd.getDetails().size()];
            amd.getDetails().toArray(a);
        }
        for (PlanFeature ruleClass : this.featureService.getFeatures()) {
            FeatureProcess rule = null;
            String str = ruleClass.getRuleClass().getSimpleName();
            str = str.substring(0, 1).toLowerCase() + str.substring(1);
            LOG.info((Object)("Looking for bean " + str));
            if (amd.getDetails().isEmpty() || index == -1) {
                rule = (FeatureProcess)this.specificRuleService.find(ruleClass.getRuleClass().getSimpleName());
            } else if (index >= 0) {
                String strNew;
                for (int i = index; !(i >= length || a[i].getChanges().keySet().contains(ruleClass.getRuleClass().getSimpleName()) && (rule = (FeatureProcess)this.specificRuleService.find(strNew = str + "_" + a[i].getDateOfBylawString())) != null); ++i) {
                }
                if (rule == null) {
                    rule = (FeatureProcess)this.specificRuleService.find(ruleClass.getRuleClass().getSimpleName());
                }
            }
            if (rule != null) {
                LOG.info((Object)("Looking for bean resulted in " + rule.getClass().getSimpleName()));
                rule.process(plan);
                LOG.info((Object)("Completed Process " + rule.getClass().getSimpleName() + "  " + new Date()));
            }
            if (!plan.getErrors().containsKey("occupancy_allowed") && !plan.getErrors().containsKey("units not in meters") && !plan.getErrors().containsKey("occupancy_po_not_allowed")) continue;
            return plan;
        }
        return plan;
    }

    private InputStream generateReport(Plan plan, Amendment amd, EdcrApplication dcrApplication) {
        String beanName = "PlanReportService";
        PlanReportService service = null;
        int index = -1;
        AmendmentDetails[] amdArray = null;
        InputStream reportStream = null;
        int length = amd.getDetails().size();
        if (!amd.getDetails().isEmpty()) {
            index = amd.getIndex(plan.getApplicationDate());
            amdArray = new AmendmentDetails[amd.getDetails().size()];
            amd.getDetails().toArray(amdArray);
        }
        try {
            beanName = beanName.substring(0, 1).toLowerCase() + beanName.substring(1);
            if (amd.getDetails().isEmpty() || index == -1) {
                service = (PlanReportService)this.specificRuleService.find(beanName);
            } else if (index >= 0) {
                for (int i = index; i < length && (service = (PlanReportService)this.specificRuleService.find(beanName + "_" + amdArray[i].getDateOfBylawString())) == null; ++i) {
                }
            }
            if (service == null) {
                service = (PlanReportService)this.specificRuleService.find(beanName);
            }
            reportStream = service.generateReport(plan, dcrApplication);
        }
        catch (BeansException e) {
            LOG.error((Object)("No Bean Defined for the Rule " + beanName));
        }
        return reportStream;
    }

    @Transactional
    public void saveOutputReport(EdcrApplication edcrApplication, InputStream reportOutputStream, Plan plan) {
        List<EdcrApplicationDetail> edcrApplicationDetails = this.edcrApplicationDetailService.fingByDcrApplicationId(edcrApplication.getId());
        String fileName = edcrApplication.getApplicationNumber() + "-v" + edcrApplicationDetails.size() + ".pdf";
        FileStoreMapper fileStoreMapper = this.fileStoreService.store(reportOutputStream, fileName, "application/pdf", "Digit DCR");
        this.buildDocuments(edcrApplication, null, fileStoreMapper, plan);
        PlanInformation planInformation = plan.getPlanInformation();
        edcrApplication.getEdcrApplicationDetails().get(0).setPlanInformation(planInformation);
        this.edcrApplicationDetailService.saveAll(edcrApplication.getEdcrApplicationDetails());
    }

    public void buildDocuments(EdcrApplication edcrApplication, FileStoreMapper dxfFile, FileStoreMapper reportOutput, Plan plan) {
        ArrayList<EdcrApplicationDetail> edcrApplicationDetails;
        EdcrApplicationDetail edcrApplicationDetail;
        if (dxfFile != null) {
            edcrApplicationDetail = new EdcrApplicationDetail();
            edcrApplicationDetail.setDxfFileId(dxfFile);
            edcrApplicationDetail.setApplication(edcrApplication);
            for (EdcrApplicationDetail edcrApplicationDetail1 : edcrApplication.getEdcrApplicationDetails()) {
                edcrApplicationDetail.setPlan(edcrApplicationDetail1.getPlan());
            }
            edcrApplicationDetails = new ArrayList<EdcrApplicationDetail>();
            edcrApplicationDetails.add(edcrApplicationDetail);
            edcrApplication.setSavedEdcrApplicationDetail(edcrApplicationDetail);
            edcrApplication.setEdcrApplicationDetails(edcrApplicationDetails);
        }
        if (reportOutput != null) {
            edcrApplicationDetail = edcrApplication.getEdcrApplicationDetails().get(0);
            if (plan.getEdcrPassed().booleanValue()) {
                edcrApplicationDetail.setStatus("Accepted");
                edcrApplication.setStatus("Accepted");
            } else {
                edcrApplicationDetail.setStatus("Not Accepted");
                edcrApplication.setStatus("Not Accepted");
            }
            edcrApplicationDetail.setCreatedDate(new Date());
            edcrApplicationDetail.setReportOutputId(reportOutput);
            edcrApplicationDetails = new ArrayList();
            edcrApplicationDetails.add(edcrApplicationDetail);
            this.savePlanDetail(plan, edcrApplicationDetail);
            ArrayList<EdcrPdfDetail> edcrPdfDetails = new ArrayList<EdcrPdfDetail>();
            if (plan.getEdcrPdfDetails() != null && !plan.getEdcrPdfDetails().isEmpty()) {
                for (EdcrPdfDetail edcrPdfDetail : plan.getEdcrPdfDetails()) {
                    EdcrPdfDetail pdfDetail = new EdcrPdfDetail();
                    pdfDetail.setLayer(edcrPdfDetail.getLayer());
                    pdfDetail.setFailureReasons(edcrPdfDetail.getFailureReasons());
                    pdfDetail.setStandardViolations(edcrPdfDetail.getStandardViolations());
                    File convertedPdf = edcrPdfDetail.getConvertedPdf();
                    if (convertedPdf == null) continue;
                    FileStoreMapper fileStoreMapper = this.fileStoreService.store(convertedPdf, convertedPdf.getName(), "application/pdf", "Digit DCR");
                    pdfDetail.setConvertedPdf(fileStoreMapper);
                }
            }
            if (!edcrPdfDetails.isEmpty()) {
                for (EdcrPdfDetail edcrPdfDetail : edcrPdfDetails) {
                    edcrPdfDetail.setEdcrApplicationDetail(edcrApplicationDetail);
                }
                this.edcrPdfDetailService.saveAll(edcrPdfDetails);
            }
            edcrApplication.setEdcrApplicationDetails(edcrApplicationDetails);
        }
    }

    public Plan extractPlan(EdcrRequest edcrRequest, MultipartFile dxfFile) {
        File planFile = this.edcrApplicationService.savePlanDXF(dxfFile);
        Date asOnDate = new Date();
        AmendmentService repo = (AmendmentService)this.specificRuleService.find(AmendmentService.class.getSimpleName());
        Amendment amd = repo.getAmendments();
        Plan plan = this.extractService.extract(planFile, amd, asOnDate, this.featureService.getFeatures());
        if (StringUtils.isNotBlank((CharSequence)edcrRequest.getApplicantName())) {
            plan.getPlanInformation().setApplicantName(edcrRequest.getApplicantName());
        } else {
            plan.getPlanInformation().setApplicantName("ANONYMOUS");
        }
        return plan;
    }

    private void updateFinalReport(FileStoreMapper fileStoreMapper) {
        try {
            Path path = this.fileStoreService.fetchAsPath(fileStoreMapper.getFileStoreId(), "Digit DCR");
            PDDocument doc = PDDocument.load((File)new File(path.toString()));
            for (int i = 0; i < doc.getNumberOfPages(); ++i) {
                PDPage page = doc.getPage(i);
                PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true);
                contentStream.setNonStrokingColor(Color.white);
                contentStream.addRect(230.0f, 20.0f, 80.0f, 40.0f);
                contentStream.fill();
                contentStream.setNonStrokingColor(Color.black);
                contentStream.beginText();
                contentStream.newLineAtOffset(248.0f, 23.0f);
                contentStream.setFont((PDFont)PDType1Font.TIMES_ROMAN, 10.0f);
                String text = i + 1 + " of " + doc.getNumberOfPages();
                contentStream.showText(text);
                contentStream.endText();
                contentStream.close();
            }
            doc.save(new File(path.toString()));
            doc.close();
        }
        catch (IOException e) {
            throw new ValidationException(Arrays.asList(new ValidationError("error", e.getMessage())));
        }
    }
}

