/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.HorizontalBandAlignment;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJDataSource;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Stretching;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionStyleExpression;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Building;
import org.egov.common.entity.edcr.DcrReportBlockDetail;
import org.egov.common.entity.edcr.DcrReportFloorDetail;
import org.egov.common.entity.edcr.DcrReportOutput;
import org.egov.common.entity.edcr.DcrReportPlanDetail;
import org.egov.common.entity.edcr.ElectricLine;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.common.entity.edcr.VirtualBuilding;
import org.egov.common.entity.edcr.VirtualBuildingReport;
import org.egov.edcr.autonumber.DcrApplicationNumberGenerator;
import org.egov.edcr.autonumber.OCPlanScrutinyNumberGenerator;
import org.egov.edcr.entity.ApplicationType;
import org.egov.edcr.entity.EdcrApplication;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.service.FetchCondition;
import org.egov.edcr.service.JasperReportService;
import org.egov.edcr.utility.DcrConstants;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.security.utils.SecureCodeUtils;
import org.egov.infra.utils.DateUtils;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PlanReportService {
    private static final String TOTAL = "Total";
    private static final String DESCRIPTION = "description";
    private static final String RULE_NO = "RuleNo";
    private static final Logger LOG = Logger.getLogger(PlanReportService.class);
    public static final String BLOCK = "Block";
    public static final String STATUS = "Status";
    @Value(value="${edcr.client.subreport}")
    private boolean clientSpecificSubReport;
    @Autowired
    private CityService cityService;
    @Autowired
    private DcrApplicationNumberGenerator dcrApplicationNumberGenerator;
    @Autowired
    private OCPlanScrutinyNumberGenerator ocPlanScrutinyNumberGenerator;
    @Autowired
    private JasperReportService reportService;
    public static final String FRONT_YARD_DESC = "Front Setback";
    public static final String REAR_YARD_DESC = "Rear Setback";
    public static final String SIDE_YARD1_DESC = "Side Setback 1";
    public static final String SIDE_YARD2_DESC = "Side Setback 2";
    public static final String BSMT_FRONT_YARD_DESC = "Basement Front Setback";
    public static final String BSMT_REAR_YARD_DESC = "Basement Rear Setback";
    public static final String BSMT_SIDE_YARD1_DESC = "Basement Side Setback 1";
    public static final String BSMT_SIDE_YARD2_DESC = "Basement Side Setback 2";
    public static final String BSMT_SIDE_YARD_DESC = "Basement Side Setback";
    public static final String SIDE_YARD_DESC = "Side Setback";
    private static final String SIDENUMBER = "Side Number";
    private static final String SIDENUMBER_NAME = "Setback";
    private static final String LEVEL = "Level";
    private static final String COMBINED_BLOCKS_SUMMARY_DETAILS = "Overall Summary";
    private static final String BLOCK_WISE_SUMMARY = "Block Wise Summary";

    public InputStream generateDynamicReport(Plan plan, EdcrApplication dcrApplication) {
        FastReportBuilder drb = new FastReportBuilder();
        ArrayList inputData = new ArrayList();
        try {
            List scrutinyDetails = plan.getReportOutput().getScrutinyDetails();
            TreeSet<Object> common = new TreeSet<Object>();
            HashMap<Object, ScrutinyDetail> allMap = new HashMap<Object, ScrutinyDetail>();
            TreeMap blocks = new TreeMap();
            for (ScrutinyDetail sd : scrutinyDetails) {
                String[] split = sd.getKey().split("_");
                if (split.length == 2) {
                    common.add(split[1]);
                    allMap.put(split[1], sd);
                    continue;
                }
                if (split.length != 3) continue;
                if (blocks.get(split[1]) == null) {
                    TreeSet<Object> treeSet = new TreeSet<Object>();
                    treeSet.add(split[2]);
                    blocks.put(split[1], treeSet);
                } else {
                    ((Set)blocks.get(split[1])).add(split[2]);
                }
                allMap.put((String)split[1] + (String)split[2], sd);
            }
            HashMap<String, List> paramMap = new HashMap<String, List>();
            int i = 0;
            for (String string : common) {
                drb.addConcatenatedReport(this.getSub((ScrutinyDetail)allMap.get(string), ++i, i + "." + string, ((ScrutinyDetail)allMap.get(string)).getHeading(), ((ScrutinyDetail)allMap.get(string)).getSubHeading(), string));
                paramMap.put(string, ((ScrutinyDetail)allMap.get(string)).getDetail());
            }
            for (String string : blocks.keySet()) {
                ArrayList<String> blkHeading = new ArrayList<String>();
                blkHeading.add(BLOCK + string);
                drb.addConcatenatedReport(this.createHeaderSubreport("Block " + string, BLOCK + string));
                paramMap.put(BLOCK + string, blkHeading);
                int j = 0;
                for (String blkFeature : (Set)blocks.get(string)) {
                    drb.addConcatenatedReport(this.getSub((ScrutinyDetail)allMap.get(string + blkFeature), ++j, j + "." + blkFeature, ((ScrutinyDetail)allMap.get(string + blkFeature)).getHeading(), ((ScrutinyDetail)allMap.get(string + blkFeature)).getSubHeading(), string + blkFeature));
                    paramMap.put(string + blkFeature, ((ScrutinyDetail)allMap.get(string + blkFeature)).getDetail());
                    ArrayList<String> featureFooter = new ArrayList<String>();
                    if (((ScrutinyDetail)allMap.get(string + blkFeature)).getRemarks() == null) continue;
                    drb.addConcatenatedReport(this.createFooterSubreport("Remarks :  " + ((ScrutinyDetail)allMap.get(string + blkFeature)).getRemarks(), "Remarks_" + string + blkFeature));
                    featureFooter.add(((ScrutinyDetail)allMap.get(string + blkFeature)).getRemarks());
                    paramMap.put("Remarks_" + string + blkFeature, featureFooter);
                }
            }
            drb.addColumn(RULE_NO, RULE_NO, String.class.getName(), 100).addColumn(DESCRIPTION, DESCRIPTION, String.class.getName(), 100);
            drb.setTitle("FAR");
            HashMap<String, String> details = new HashMap<String, String>();
            details.put(RULE_NO, "31-1");
            details.put(DESCRIPTION, "far");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(RULE_NO, "4444");
            hashMap.put(DESCRIPTION, "fffff");
            inputData.add(details);
            inputData.add(hashMap);
            JasperPrint generateJasperPrint = DynamicJasperHelper.generateJasperPrint((DynamicReport)drb.build(), (LayoutManager)new ClassicLayoutManager(), (JRDataSource)new JRBeanCollectionDataSource(inputData), paramMap);
            ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
            JasperExportManager.exportReportToPdfStream((JasperPrint)generateJasperPrint, (OutputStream)outputBytes);
            return new ByteArrayInputStream(outputBytes.toByteArray());
        }
        catch (ColumnBuilderException | ClassNotFoundException | JRException e) {
            LOG.error((Object)e.getMessage(), e);
            return null;
        }
    }

    private Subreport getSub(ScrutinyDetail detail, int j, String title, String heading, String subheading, String dataSourceName) {
        try {
            List<ConditionalStyle> listCondStyle = this.getConditonalStyles();
            FastReportBuilder frb = new FastReportBuilder();
            int size = detail.getColumnHeading().keySet().size();
            Double byeLawColumnSize = 40.0;
            Double statusColumnSize = 60.0;
            Double columnSize = (595.0 - (byeLawColumnSize + statusColumnSize)) / (double)(size - 2);
            for (Object s : detail.getColumnHeading().keySet()) {
                ScrutinyDetail.ColumnHeadingDetail columnHeading = (ScrutinyDetail.ColumnHeadingDetail)detail.getColumnHeading().get(s);
                int columnWidth = columnSize.intValue();
                if ("Byelaw".equalsIgnoreCase(columnHeading.name)) {
                    columnWidth = byeLawColumnSize.intValue();
                }
                if (STATUS.equalsIgnoreCase(columnHeading.name)) {
                    columnWidth = statusColumnSize.intValue();
                }
                frb.addColumn(columnHeading.name, columnHeading.name, String.class.getName(), columnWidth);
            }
            frb.setMargins(0, 0, 0, 0);
            frb.setUseFullPageWidth(true);
            List columns = frb.getColumns();
            for (AbstractColumn col : columns) {
                if (!STATUS.equalsIgnoreCase(col.getTitle())) continue;
                col.setConditionalStyles(listCondStyle);
            }
            if (heading != null) {
                frb.setTitle(j + "." + heading);
            } else {
                frb.setTitle(title);
            }
            if (subheading != null) {
                frb.setSubtitle("\t" + subheading);
            }
            frb.setTitleStyle(this.reportService.getTitleStyle());
            frb.setHeaderHeight(5);
            frb.setDefaultStyles(this.reportService.getTitleStyle(), this.reportService.getSubTitleStyle(), this.reportService.getColumnHeaderStyle(), this.reportService.getDetailStyle());
            frb.setAllowDetailSplit(false);
            frb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            DynamicReport build = frb.build();
            Subreport sub = new Subreport();
            sub.setDynamicReport(build);
            Style style = new Style();
            style.setStretchWithOverflow(true);
            style.setStreching(Stretching.RELATIVE_TO_BAND_HEIGHT);
            sub.setStyle(style);
            sub.setDatasource(new DJDataSource(dataSourceName, 0, 0));
            sub.setLayoutManager((LayoutManager)new ClassicLayoutManager());
            return sub;
        }
        catch (ColumnBuilderException | ClassNotFoundException e) {
            LOG.error((Object)e.getMessage(), e);
            return null;
        }
    }

    private Subreport getBlkDetails(DcrReportBlockDetail dcrReportBlockDetail, boolean isProposed) {
        try {
            FastReportBuilder frb = new FastReportBuilder();
            AbstractColumn floor = ColumnBuilder.getNew().setColumnProperty("floorNo", String.class.getName()).setTitle("Floor").setWidth(45).setHeaderStyle(this.reportService.getBldgDetlsHeaderStyle()).build();
            AbstractColumn occupancy = ColumnBuilder.getNew().setColumnProperty("occupancy", String.class.getName()).setTitle("Occupancy/Sub Occupancy").setWidth(125).setHeaderStyle(this.reportService.getBldgDetlsHeaderStyle()).build();
            AbstractColumn builtUpArea = ColumnBuilder.getNew().setColumnProperty("builtUpArea", BigDecimal.class.getName()).setTitle("Built Up Area in m\u00b2").setWidth(120).setStyle(this.reportService.getNumberStyle()).build();
            frb.addGlobalFooterVariable(builtUpArea, DJCalculation.SUM, this.reportService.getTotalNumberStyle());
            AbstractColumn floorArea = ColumnBuilder.getNew().setColumnProperty("floorArea", BigDecimal.class.getName()).setTitle("Floor Area in m\u00b2").setWidth(120).setStyle(this.reportService.getNumberStyle()).build();
            frb.addGlobalFooterVariable(floorArea, DJCalculation.SUM, this.reportService.getTotalNumberStyle());
            AbstractColumn carpetArea = ColumnBuilder.getNew().setColumnProperty("carpetArea", BigDecimal.class.getName()).setTitle("Carpet Area in m\u00b2").setWidth(120).setStyle(this.reportService.getNumberStyle()).build();
            frb.addGlobalFooterVariable(carpetArea, DJCalculation.SUM, this.reportService.getTotalNumberStyle());
            frb.addColumn(floor);
            frb.addColumn(occupancy);
            frb.addColumn(builtUpArea);
            frb.addColumn(floorArea);
            frb.addColumn(carpetArea);
            if (dcrReportBlockDetail.getBlockNo() != null) {
                if (isProposed) {
                    frb.setTitle("Block No " + dcrReportBlockDetail.getBlockNo() + " - Proposed Details");
                    StringBuilder text = new StringBuilder();
                    String coveredAreaText = "1. Covered Area is " + (dcrReportBlockDetail.getCoverageArea() != null ? dcrReportBlockDetail.getCoverageArea().setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS) : BigDecimal.ZERO) + " m\u00b2";
                    String blgHgtText = "2. Height of building is " + (dcrReportBlockDetail.getBuildingHeight() != null ? dcrReportBlockDetail.getBuildingHeight().setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS) : BigDecimal.ZERO) + " m";
                    text = text.append(coveredAreaText).append("\\n").append(blgHgtText);
                    if (dcrReportBlockDetail.getConstructedArea().compareTo(BigDecimal.ZERO) > 0) {
                        String constructedAreaText = "3. Already constructed area is " + (dcrReportBlockDetail.getConstructedArea() != null ? dcrReportBlockDetail.getConstructedArea().setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS) : BigDecimal.ZERO) + " m\u00b2";
                        text = text.append("\\n").append(constructedAreaText);
                    }
                    AutoText autoText = new AutoText(text.toString(), 0, HorizontalBandAlignment.LEFT, Integer.valueOf(530));
                    autoText.setHeight(Integer.valueOf(40));
                    autoText.setStyle(this.reportService.getTotalNumberStyle());
                    frb.addAutoText(autoText);
                } else {
                    frb.setTitle("Block No " + dcrReportBlockDetail.getBlockNo() + " - Existing Details");
                }
            }
            frb.setTitleStyle(this.reportService.getTitleStyle());
            frb.setHeaderHeight(5);
            frb.setTopMargin(10);
            frb.setBottomMargin(0);
            frb.setDefaultStyles(this.reportService.getTitleStyle(), this.reportService.getSubTitleStyle(), this.reportService.getColumnHeaderStyle(), this.reportService.getDetailStyle());
            frb.setAllowDetailSplit(false);
            frb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            frb.setGrandTotalLegend(TOTAL);
            frb.setGrandTotalLegendStyle(this.reportService.getNumberStyle());
            DynamicReport build = frb.build();
            Subreport sub = new Subreport();
            sub.setDynamicReport(build);
            Style style = new Style();
            style.setStretchWithOverflow(true);
            style.setStreching(Stretching.RELATIVE_TO_BAND_HEIGHT);
            sub.setStyle(style);
            if (isProposed) {
                sub.setDatasource(new DJDataSource("Block No " + dcrReportBlockDetail.getBlockNo(), 0, 0));
            } else {
                sub.setDatasource(new DJDataSource("Existing Block No " + dcrReportBlockDetail.getBlockNo(), 0, 0));
            }
            sub.setLayoutManager((LayoutManager)new ClassicLayoutManager());
            return sub;
        }
        catch (ColumnBuilderException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Subreport getAreaDetails(boolean isProposed) {
        try {
            FastReportBuilder frb = new FastReportBuilder();
            AbstractColumn builtUpArea = ColumnBuilder.getNew().setColumnProperty(isProposed ? "proposedBuitUpArea" : "totalExistingBuiltUpArea", BigDecimal.class.getName()).setTitle("Built Up Area in m\u00b2").setWidth(120).setStyle(this.reportService.getTotalNumberStyle()).build();
            AbstractColumn floorArea = ColumnBuilder.getNew().setColumnProperty(isProposed ? "proposedFloorArea" : "totalExistingFloorArea", BigDecimal.class.getName()).setTitle("Floor Area in m\u00b2").setWidth(120).setStyle(this.reportService.getTotalNumberStyle()).build();
            AbstractColumn carpetArea = ColumnBuilder.getNew().setColumnProperty(isProposed ? "proposedCarpetArea" : "totalExistingCarpetArea", BigDecimal.class.getName()).setTitle("Carpet Area in m\u00b2").setWidth(120).setStyle(this.reportService.getTotalNumberStyle()).build();
            frb.addColumn(builtUpArea);
            frb.addColumn(floorArea);
            frb.addColumn(carpetArea);
            if (isProposed) {
                frb.setTitle("Total Proposed Areas");
            } else {
                frb.setTitle("Total Existing Areas");
            }
            frb.setTitleStyle(this.reportService.getTitleStyle());
            frb.setHeaderHeight(5);
            frb.setTopMargin(5);
            frb.setDefaultStyles(this.reportService.getTitleStyle(), this.reportService.getSubTitleStyle(), this.reportService.getColumnHeaderStyle(), this.reportService.getDetailStyle());
            frb.setAllowDetailSplit(false);
            frb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            frb.setGrandTotalLegend(TOTAL);
            frb.setGrandTotalLegendStyle(this.reportService.getNumberStyle());
            DynamicReport build = frb.build();
            Subreport sub = new Subreport();
            sub.setDynamicReport(build);
            Style style = new Style();
            style.setStretchWithOverflow(true);
            style.setStreching(Stretching.RELATIVE_TO_BAND_HEIGHT);
            sub.setStyle(style);
            if (isProposed) {
                sub.setDatasource(new DJDataSource("Total Proposed Details", 0, 0));
            } else {
                sub.setDatasource(new DJDataSource("Total Existing Details", 0, 0));
            }
            sub.setLayoutManager((LayoutManager)new ClassicLayoutManager());
            return sub;
        }
        catch (ColumnBuilderException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Subreport getTotalAreaDetails(VirtualBuildingReport virtualBuildingReport) {
        try {
            AbstractColumn carpetArea;
            AbstractColumn floorArea;
            AbstractColumn builtUpArea;
            FastReportBuilder frb = new FastReportBuilder();
            if (virtualBuildingReport.getTotalConstructedArea() != null && virtualBuildingReport.getTotalConstructedArea().compareTo(BigDecimal.ZERO) > 0) {
                builtUpArea = ColumnBuilder.getNew().setColumnProperty("totalBuitUpArea", BigDecimal.class.getName()).setTitle("Built Up Area in m\u00b2").setWidth(100).setStyle(this.reportService.getTotalNumberStyle()).build();
                floorArea = ColumnBuilder.getNew().setColumnProperty("totalFloorArea", BigDecimal.class.getName()).setTitle("Floor Area in m\u00b2").setWidth(100).setStyle(this.reportService.getTotalNumberStyle()).build();
                carpetArea = ColumnBuilder.getNew().setColumnProperty("totalCarpetArea", BigDecimal.class.getName()).setTitle("Carpet Area in m\u00b2").setWidth(100).setStyle(this.reportService.getTotalNumberStyle()).build();
                AbstractColumn coverageArea = ColumnBuilder.getNew().setColumnProperty("totalCoverageArea", BigDecimal.class.getName()).setTitle("Covered Area in m\u00b2").setWidth(100).setStyle(this.reportService.getTotalNumberStyle()).build();
                AbstractColumn constructedArea = ColumnBuilder.getNew().setColumnProperty("totalConstructedArea", BigDecimal.class.getName()).setTitle("Already Constructed Area in m\u00b2").setWidth(100).setStyle(this.reportService.getTotalNumberStyle()).build();
                frb.addColumn(builtUpArea);
                frb.addColumn(floorArea);
                frb.addColumn(carpetArea);
                frb.addColumn(coverageArea);
                frb.addColumn(constructedArea);
            } else {
                builtUpArea = ColumnBuilder.getNew().setColumnProperty("totalBuitUpArea", BigDecimal.class.getName()).setTitle("Built Up Area in m\u00b2").setWidth(120).setStyle(this.reportService.getTotalNumberStyle()).build();
                floorArea = ColumnBuilder.getNew().setColumnProperty("totalFloorArea", BigDecimal.class.getName()).setTitle("Floor Area in m\u00b2").setWidth(120).setStyle(this.reportService.getTotalNumberStyle()).build();
                carpetArea = ColumnBuilder.getNew().setColumnProperty("totalCarpetArea", BigDecimal.class.getName()).setTitle("Carpet Area in m\u00b2").setWidth(120).setStyle(this.reportService.getTotalNumberStyle()).build();
                AbstractColumn coverageArea = ColumnBuilder.getNew().setColumnProperty("totalCoverageArea", BigDecimal.class.getName()).setTitle("Covered Area in m\u00b2").setWidth(120).setStyle(this.reportService.getTotalNumberStyle()).build();
                frb.addColumn(builtUpArea);
                frb.addColumn(floorArea);
                frb.addColumn(carpetArea);
                frb.addColumn(coverageArea);
            }
            frb.setTitle("Total Area");
            frb.setTitleStyle(this.reportService.getTitleStyle());
            frb.setHeaderHeight(5);
            frb.setTopMargin(5);
            frb.setDefaultStyles(this.reportService.getTitleStyle(), this.reportService.getSubTitleStyle(), this.reportService.getColumnHeaderStyle(), this.reportService.getDetailStyle());
            frb.setAllowDetailSplit(false);
            frb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            frb.setGrandTotalLegend(TOTAL);
            frb.setGrandTotalLegendStyle(this.reportService.getNumberStyle());
            DynamicReport build = frb.build();
            Subreport sub = new Subreport();
            sub.setDynamicReport(build);
            Style style = new Style();
            style.setStretchWithOverflow(true);
            style.setStreching(Stretching.RELATIVE_TO_BAND_HEIGHT);
            sub.setStyle(style);
            sub.setDatasource(new DJDataSource("Total Area Details", 0, 0));
            sub.setLayoutManager((LayoutManager)new ClassicLayoutManager());
            return sub;
        }
        catch (ColumnBuilderException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Subreport createHeaderSubreport(String title, String dataSourceName) {
        try {
            FastReportBuilder frb = new FastReportBuilder();
            frb.setUseFullPageWidth(true);
            frb.setTitle(title);
            frb.setShowDetailBand(false);
            frb.setMargins(0, 0, 0, 0);
            frb.setTitleStyle(this.reportService.getSubReportTitleStyle());
            frb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            DynamicReport build = frb.build();
            Subreport sub = new Subreport();
            sub.setDynamicReport(build);
            sub.setDatasource(new DJDataSource(dataSourceName, 0, 0));
            sub.setLayoutManager((LayoutManager)new ClassicLayoutManager());
            return sub;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Subreport createFooterSubreport(String title, String dataSourceName) {
        try {
            FastReportBuilder frb = new FastReportBuilder();
            frb.setUseFullPageWidth(true);
            frb.setTitleHeight(Integer.valueOf(5));
            frb.setTitle(title);
            frb.setMargins(0, 0, 0, 0);
            frb.setTitleStyle(this.reportService.getTitleStyle());
            frb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            DynamicReport build = frb.build();
            Subreport sub = new Subreport();
            sub.setDynamicReport(build);
            sub.setDatasource(new DJDataSource(dataSourceName, 0, 0));
            sub.setLayoutManager((LayoutManager)new ClassicLayoutManager());
            return sub;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void closeStream(InputStream stream) {
        block3: {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("Error" + e.getMessage()));
                }
            }
        }
    }

    public InputStream generateReport(Plan plan, EdcrApplication dcrApplication) {
        String serviceType;
        int i;
        FastReportBuilder drb = new FastReportBuilder();
        StringBuilder reportBuilder = new StringBuilder();
        Style titleStyle = new Style("titleStyle");
        titleStyle.setFont(new Font(50, "Times New Roman", true));
        titleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        titleStyle.setFont(new Font(2, "Times New Roman", false));
        String applicationNumber = StringUtils.isNotBlank((CharSequence)dcrApplication.getApplicationNumber()) ? dcrApplication.getApplicationNumber() : "NA";
        String applicationDate = DateUtils.toDefaultDateFormat((Date)dcrApplication.getApplicationDate());
        if (plan.getVirtualBuilding() != null && !plan.getVirtualBuilding().getOccupancyTypes().isEmpty()) {
            ArrayList occupancies = new ArrayList();
            plan.getVirtualBuilding().getOccupancyTypes().forEach(occ -> {
                if (occ.getType() != null) {
                    occupancies.add(occ.getType().getName());
                }
            });
            HashSet distinctOccupancies = new HashSet(occupancies);
            plan.getPlanInformation().setOccupancy(distinctOccupancies.stream().map(String::new).collect(Collectors.joining(",")));
        }
        boolean reportStatus = false;
        boolean finalReportStatus = true;
        StringBuilder errors = new StringBuilder();
        StringBuilder nocs = new StringBuilder();
        if (plan.getNoObjectionCertificates() != null && plan.getNoObjectionCertificates().size() > 0) {
            i = 1;
            for (Map.Entry entry : plan.getNoObjectionCertificates().entrySet()) {
                nocs.append(String.valueOf(i)).append(". ");
                nocs.append((String)entry.getValue());
                nocs.append("\n");
                ++i;
            }
        }
        if (plan.getErrors() != null && plan.getErrors().size() > 0) {
            i = 1;
            for (Map.Entry entry : plan.getErrors().entrySet()) {
                errors.append(String.valueOf(i)).append(". ");
                errors.append((String)entry.getValue());
                errors.append("\n");
                ++i;
                finalReportStatus = false;
            }
        }
        drb.setPageSizeAndOrientation(new Page(842, 595, true));
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(Collections.singletonList(plan));
        String voltages = "";
        StringBuilder voltageString = new StringBuilder();
        if (!plan.getElectricLine().isEmpty()) {
            for (ElectricLine electricLine : plan.getElectricLine()) {
                voltageString.append(String.valueOf(electricLine.getVoltage() == null ? Integer.valueOf(0) : electricLine.getVoltage())).append(",");
            }
            if (voltageString.length() > 1) {
                voltages = voltageString.deleteCharAt(voltageString.length() - 1).toString() + " KV";
            }
        }
        if (StringUtils.isBlank((CharSequence)voltages)) {
            voltages = String.valueOf(BigDecimal.ZERO) + " KV";
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("ulbName", ApplicationThreadLocals.getMunicipalityName());
        valuesMap.put("applicantName", dcrApplication.getApplicantName());
        valuesMap.put("licensee", dcrApplication.getArchitectInformation());
        valuesMap.put("applicationNumber", applicationNumber);
        valuesMap.put("applicationDate", applicationDate);
        valuesMap.put("errors", plan.getErrors());
        valuesMap.put("errorString", errors.toString());
        valuesMap.put("nocString", nocs.toString());
        valuesMap.put("nocs", plan.getNoObjectionCertificates());
        valuesMap.put("reportGeneratedDate", DateUtils.toDefaultDateTimeFormat((Date)new Date()));
        valuesMap.put("currentYear", new LocalDate().getYear());
        valuesMap.put("far", plan.getFarDetails() != null ? plan.getFarDetails().getProvidedFar() : "");
        valuesMap.put("coverage", plan.getCoverage());
        valuesMap.put("totalFloorArea", plan.getVirtualBuilding() != null ? plan.getVirtualBuilding().getTotalFloorArea() : BigDecimal.valueOf(0L));
        valuesMap.put("totalBuiltUpArea", plan.getVirtualBuilding() != null ? plan.getVirtualBuilding().getTotalBuitUpArea() : BigDecimal.valueOf(0L));
        valuesMap.put("electricLineVoltage", voltages);
        valuesMap.put("blockCount", plan.getBlocks() != null && !plan.getBlocks().isEmpty() ? plan.getBlocks().size() : 0);
        valuesMap.put("surrenderRoadArea", plan.getTotalSurrenderRoadArea());
        String imageURL = ReportUtil.getImageURL((String)"/egi/resources/global/images/digit-logo-black.png");
        valuesMap.put("egovLogo", imageURL);
        valuesMap.put("cityLogo", this.cityService.getCityLogoURLByCurrentTenant());
        if (this.clientSpecificSubReport) {
            ArrayList<DcrReportBlockDetail> blockDetails = new ArrayList<DcrReportBlockDetail>();
            List<DcrReportBlockDetail> existingBlockDetails = this.buildBlockWiseExistingInfo(plan);
            VirtualBuildingReport virtualBuildingReport = this.buildVirtualBuilding(plan.getVirtualBuilding());
            ArrayList<String> combinedSummary = new ArrayList<String>();
            combinedSummary.add(COMBINED_BLOCKS_SUMMARY_DETAILS);
            drb.addConcatenatedReport(this.createHeaderSubreport(COMBINED_BLOCKS_SUMMARY_DETAILS, COMBINED_BLOCKS_SUMMARY_DETAILS));
            valuesMap.put(COMBINED_BLOCKS_SUMMARY_DETAILS, combinedSummary);
            drb.addConcatenatedReport(this.getTotalAreaDetails(virtualBuildingReport));
            valuesMap.put("Total Area Details", Arrays.asList(virtualBuildingReport));
            ArrayList<String> blockSummary = new ArrayList<String>();
            blockSummary.add(BLOCK_WISE_SUMMARY);
            drb.addConcatenatedReport(this.createHeaderSubreport(BLOCK_WISE_SUMMARY, BLOCK_WISE_SUMMARY));
            valuesMap.put(BLOCK_WISE_SUMMARY, blockSummary);
            if (existingBlockDetails != null && !existingBlockDetails.isEmpty()) {
                for (DcrReportBlockDetail existingBlockDetail : existingBlockDetails) {
                    blockDetails.add(existingBlockDetail);
                    drb.addConcatenatedReport(this.getBlkDetails(existingBlockDetail, false));
                    valuesMap.put("Existing Block No " + existingBlockDetail.getBlockNo(), existingBlockDetail.getDcrReportFloorDetails());
                }
                drb.addConcatenatedReport(this.getAreaDetails(false));
                valuesMap.put("Total Existing Details", Arrays.asList(virtualBuildingReport));
            }
            List<DcrReportBlockDetail> proposedBlockDetails = this.buildBlockWiseProposedInfo(plan);
            for (DcrReportBlockDetail dcrReportBlockDetail : proposedBlockDetails) {
                blockDetails.add(dcrReportBlockDetail);
                drb.addConcatenatedReport(this.getBlkDetails(dcrReportBlockDetail, true));
                valuesMap.put("Block No " + dcrReportBlockDetail.getBlockNo(), dcrReportBlockDetail.getDcrReportFloorDetails());
            }
            if (existingBlockDetails != null && !existingBlockDetails.isEmpty()) {
                drb.addConcatenatedReport(this.getAreaDetails(true));
                valuesMap.put("Total Proposed Details", Arrays.asList(virtualBuildingReport));
            }
            DcrReportPlanDetail dcrReportPlanDetail = new DcrReportPlanDetail();
            dcrReportPlanDetail.setVirtualBuildingReport(virtualBuildingReport);
            dcrReportPlanDetail.setDcrReportBlockDetailList(blockDetails);
            List scrutinyDetails = plan.getReportOutput().getScrutinyDetails();
            TreeSet<String> common = new TreeSet<String>();
            HashMap<String, ScrutinyDetail> allMap = new HashMap<String, ScrutinyDetail>();
            TreeMap blocks = new TreeMap();
            LOG.info((Object)"Generate Report.......");
            for (ScrutinyDetail sd : scrutinyDetails) {
                LOG.info((Object)sd.getKey());
                LOG.info((Object)sd.getHeading());
                String[] split = new String[]{};
                if (sd.getKey() != null) {
                    split = sd.getKey().split("_");
                }
                if (split.length == 2) {
                    common.add(split[1]);
                    allMap.put(split[1], sd);
                    continue;
                }
                if (split.length != 3) continue;
                if (blocks.get(split[1]) == null) {
                    TreeSet<String> features = new TreeSet<String>();
                    features.add(split[2]);
                    blocks.put(split[1], features);
                } else {
                    ((Set)blocks.get(split[1])).add(split[2]);
                }
                allMap.put(split[1] + split[2], sd);
            }
            int i2 = 0;
            ArrayList<String> cmnHeading = new ArrayList<String>();
            cmnHeading.add("Common");
            drb.addConcatenatedReport(this.createHeaderSubreport("Common - Scrutiny Details", "Common"));
            valuesMap.put("Common", cmnHeading);
            for (String cmnFeature : common) {
                drb.addConcatenatedReport(this.getSub((ScrutinyDetail)allMap.get(cmnFeature), ++i2, i2 + "." + cmnFeature, ((ScrutinyDetail)allMap.get(cmnFeature)).getHeading(), ((ScrutinyDetail)allMap.get(cmnFeature)).getSubHeading(), cmnFeature));
                valuesMap.put(cmnFeature, ((ScrutinyDetail)allMap.get(cmnFeature)).getDetail());
            }
            for (String blkName : blocks.keySet()) {
                ArrayList<String> blkHeading = new ArrayList<String>();
                blkHeading.add(BLOCK + blkName);
                drb.addConcatenatedReport(this.createHeaderSubreport("Block " + blkName + " - Scrutiny Details", BLOCK + blkName));
                valuesMap.put(BLOCK + blkName, blkHeading);
                int j = 0;
                ScrutinyDetail front = null;
                ScrutinyDetail rear = null;
                ScrutinyDetail side = null;
                for (String blkFeature : (Set)blocks.get(blkName)) {
                    if (!blkFeature.equals(FRONT_YARD_DESC) && !blkFeature.equals(REAR_YARD_DESC) && !blkFeature.equals(SIDE_YARD_DESC)) continue;
                    if (blkFeature.equals(FRONT_YARD_DESC)) {
                        front = (ScrutinyDetail)allMap.get(blkName + blkFeature);
                        ((Map)front.getDetail().get(0)).put(SIDENUMBER_NAME, "Front");
                        continue;
                    }
                    if (blkFeature.equals(REAR_YARD_DESC)) {
                        rear = (ScrutinyDetail)allMap.get(blkName + blkFeature);
                        ((Map)rear.getDetail().get(0)).put(SIDENUMBER_NAME, "Rear");
                        continue;
                    }
                    side = (ScrutinyDetail)allMap.get(blkName + blkFeature);
                    List detail = side.getDetail();
                    if (front != null) {
                        detail.add(0, front.getDetail().get(0));
                    }
                    if (rear != null) {
                        detail.add(1, rear.getDetail().get(0));
                    }
                    for (Map d : detail) {
                        String sideNumber = (String)d.get(SIDENUMBER);
                        if (!StringUtils.isNotBlank((CharSequence)sideNumber)) continue;
                        d.remove(SIDENUMBER);
                        d.put(SIDENUMBER_NAME, sideNumber);
                    }
                    side.addColumnHeading(Integer.valueOf(2), SIDENUMBER_NAME);
                    side.addColumnHeading(Integer.valueOf(4), LEVEL);
                    drb.addConcatenatedReport(this.getSub((ScrutinyDetail)allMap.get(blkName + blkFeature), ++j, j + "." + blkFeature, SIDENUMBER_NAME, ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getSubHeading(), blkName + blkFeature));
                    valuesMap.put(blkName + blkFeature, ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getDetail());
                    ArrayList<String> featureFooter = new ArrayList<String>();
                    if (((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks() == null) continue;
                    drb.addConcatenatedReport(this.createFooterSubreport("Remarks :  " + ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks(), "Remarks_" + blkName + blkFeature));
                    featureFooter.add(((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks());
                    valuesMap.put("Remarks_" + blkName + blkFeature, featureFooter);
                }
                for (String blkFeature : (Set)blocks.get(blkName)) {
                    if (blkFeature.equals(FRONT_YARD_DESC) || blkFeature.equals(REAR_YARD_DESC) || blkFeature.equals(SIDE_YARD_DESC)) continue;
                    drb.addConcatenatedReport(this.getSub((ScrutinyDetail)allMap.get(blkName + blkFeature), ++j, j + "." + blkFeature, ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getHeading(), ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getSubHeading(), blkName + blkFeature));
                    valuesMap.put(blkName + blkFeature, ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getDetail());
                    ArrayList<String> featureFooter = new ArrayList<String>();
                    if (((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks() == null) continue;
                    drb.addConcatenatedReport(this.createFooterSubreport("Remarks :  " + ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks(), "Remarks_" + blkName + blkFeature));
                    featureFooter.add(((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks());
                    valuesMap.put("Remarks_" + blkName + blkFeature, featureFooter);
                }
            }
            if (finalReportStatus) {
                for (String cmnFeature : common) {
                    for (Map commonStatus : ((ScrutinyDetail)allMap.get(cmnFeature)).getDetail()) {
                        if (!((String)commonStatus.get(STATUS)).equalsIgnoreCase(Result.Not_Accepted.getResultVal())) continue;
                        finalReportStatus = false;
                    }
                }
            }
            if (finalReportStatus) {
                for (String blkName : blocks.keySet()) {
                    for (String blkFeature : (Set)blocks.get(blkName)) {
                        for (Map blkStatus : ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getDetail()) {
                            if (!((String)blkStatus.get(STATUS)).equalsIgnoreCase(Result.Not_Accepted.getResultVal())) continue;
                            finalReportStatus = false;
                        }
                    }
                }
            }
        }
        if (ApplicationType.OCCUPANCY_CERTIFICATE.equals((Object)dcrApplication.getApplicationType()) && StringUtils.isNotBlank((CharSequence)dcrApplication.getEdcrApplicationDetails().get(0).getComparisonDcrNumber())) {
            plan.setMainDcrPassed(Boolean.valueOf(finalReportStatus));
            finalReportStatus = finalReportStatus && dcrApplication.getDeviationStatus().equalsIgnoreCase("Accepted");
        }
        reportBuilder.append("Report Status : " + (finalReportStatus ? "Accepted" : "Not Accepted")).append("\\n").append("\\n");
        reportBuilder.append("Rules Verified : ").append("\\n");
        valuesMap.put("reportStatus", finalReportStatus ? "Accepted" : "Not Accepted");
        drb.setTemplateFile("/reports/templates/edcr_report.jrxml");
        drb.setMargins(5, 0, 33, 20);
        if (ApplicationType.OCCUPANCY_CERTIFICATE.equals((Object)dcrApplication.getApplicationType())) {
            valuesMap.put("planPermissionNumber", dcrApplication.getPlanPermitNumber());
            valuesMap.put("bpaApplicationDate", DateUtils.toDefaultDateFormat((Date)dcrApplication.getPermitApplicationDate()));
        }
        if (finalReportStatus) {
            String dcrApplicationNumber = "";
            dcrApplicationNumber = ApplicationType.OCCUPANCY_CERTIFICATE.equals((Object)dcrApplication.getApplicationType()) ? this.ocPlanScrutinyNumberGenerator.generateEdcrApplicationNumber() : this.dcrApplicationNumberGenerator.generateEdcrApplicationNumber(dcrApplication);
            EdcrApplicationDetail edcrApplicationDetail = dcrApplication.getEdcrApplicationDetails().get(0);
            edcrApplicationDetail.setDcrNumber(dcrApplicationNumber);
            valuesMap.put("dcrNo", dcrApplicationNumber);
        }
        if (finalReportStatus) {
            valuesMap.put("qrCode", SecureCodeUtils.generatePDF417Code((String)this.buildQRCodeDetails(dcrApplication, finalReportStatus)));
        }
        valuesMap.put("applicationType", dcrApplication.getApplicationType().getApplicationTypeVal());
        ConcurrentHashMap<String, String> serviceTypeList = new ConcurrentHashMap<String, String>();
        serviceTypeList.put("NEW_CONSTRUCTION", "New Construction");
        if (StringUtils.isNotBlank((CharSequence)dcrApplication.getServiceType())) {
            serviceType = (String)serviceTypeList.get(dcrApplication.getServiceType());
            valuesMap.put("serviceType", serviceType);
        }
        if (StringUtils.isNotBlank((CharSequence)dcrApplication.getServiceType())) {
            serviceType = (String)serviceTypeList.get(dcrApplication.getServiceType());
            valuesMap.put("serviceType", serviceType);
        }
        DynamicReport dr = drb.build();
        plan.setEdcrPassed(Boolean.valueOf(finalReportStatus));
        InputStream exportPdf = null;
        try {
            JasperPrint generateJasperPrint = DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds, valuesMap);
            exportPdf = this.reportService.exportPdf(generateJasperPrint);
        }
        catch (IOException | JRException e) {
            LOG.error((Object)"Error occurred when generating Jasper report", e);
        }
        return exportPdf;
    }

    public Subreport generateDcrSubReport(List<DcrReportOutput> dcrReportOutputs) {
        FastReportBuilder drb = new FastReportBuilder();
        Style titleStyle = new Style("titleStyle");
        titleStyle.setFont(Font.ARIAL_MEDIUM_BOLD);
        titleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        titleStyle.setVerticalAlign(VerticalAlign.BOTTOM);
        Style columnStyle = this.reportService.getColumnStyle();
        Style columnHeaderStyle = this.reportService.getColumnHeaderStyle();
        drb.setTitle("Building\u00a0Rule\u00a0Scrutiny");
        drb.setTitleStyle(titleStyle);
        try {
            drb.addColumn("KMBR\u00a0Rule\u00a0No.", "key", String.class.getName(), 50, columnStyle, columnHeaderStyle);
            drb.addColumn("Rule\u00a0description", DESCRIPTION, String.class.getName(), 120, columnStyle, columnHeaderStyle);
            drb.addColumn("Required\u00a0by\u00a0Rule", "expectedResult", String.class.getName(), 120, columnStyle, columnHeaderStyle);
            drb.addColumn("Provided\u00a0as\u00a0per\u00a0drawings", "actualResult", String.class.getName(), 120, columnStyle, columnHeaderStyle);
            drb.addColumn("Accepted /\u00a0Not\u00a0Accepted ", "status", String.class.getName(), 50, columnStyle, columnHeaderStyle);
        }
        catch (ColumnBuilderException | ClassNotFoundException e) {
            LOG.error((Object)e.getMessage(), e);
        }
        drb.setUseFullPageWidth(true);
        drb.setPageSizeAndOrientation(Page.Page_Legal_Landscape());
        if (LOG.isDebugEnabled()) {
            for (DcrReportOutput dcrReportOutput : dcrReportOutputs) {
                LOG.debug((Object)("********* Key " + dcrReportOutput.getKey()));
                LOG.debug((Object)("********* Description " + dcrReportOutput.getDescription()));
                LOG.debug((Object)("********* Expected result " + dcrReportOutput.getExpectedResult()));
                LOG.debug((Object)("********* Actual result " + dcrReportOutput.getActualResult()));
                LOG.debug((Object)("********* Status " + dcrReportOutput.getStatus()));
            }
        }
        new JRBeanCollectionDataSource(dcrReportOutputs);
        DJDataSource djds = new DJDataSource("subreportds", 0, 10);
        Subreport subRep = new Subreport();
        subRep.setLayoutManager((LayoutManager)new ClassicLayoutManager());
        subRep.setDynamicReport(drb.build());
        subRep.setDatasource(djds);
        subRep.setUseParentReportParameters(true);
        return subRep;
    }

    private String buildQRCodeDetails(EdcrApplication dcrApplication, boolean reportStatus) {
        StringBuilder qrCodeValue = new StringBuilder();
        qrCodeValue = !StringUtils.isEmpty((CharSequence)dcrApplication.getEdcrApplicationDetails().get(0).getDcrNumber()) ? qrCodeValue.append("DCR Number : ").append(dcrApplication.getEdcrApplicationDetails().get(0).getDcrNumber()).append("\n") : qrCodeValue.append("DCR Number : ").append("N/A").append("\n");
        qrCodeValue = !StringUtils.isEmpty((CharSequence)dcrApplication.getApplicationNumber()) ? qrCodeValue.append("Application Number : ").append(dcrApplication.getApplicationNumber()).append("\n") : qrCodeValue.append("Application Number : ").append("N/A").append("\n");
        qrCodeValue = dcrApplication.getApplicationDate() != null ? qrCodeValue.append("Application Date : ").append(dcrApplication.getApplicationDate()).append("\n") : qrCodeValue.append("Application Date : ").append("N/A").append("\n");
        qrCodeValue = qrCodeValue.append("Report Status :").append(reportStatus ? "Accepted" : "Not Accepted").append("\n");
        return qrCodeValue.toString();
    }

    private List<DcrReportBlockDetail> buildBlockWiseProposedInfo(Plan plan) {
        ArrayList<DcrReportBlockDetail> dcrReportBlockDetails = new ArrayList<DcrReportBlockDetail>();
        List blocks = plan.getBlocks();
        if (!blocks.isEmpty()) {
            for (Block block : blocks) {
                Building building = block.getBuilding();
                if (building == null) continue;
                DcrReportBlockDetail dcrReportBlockDetail = new DcrReportBlockDetail();
                dcrReportBlockDetail.setBlockNo(block.getNumber());
                dcrReportBlockDetail.setCoverageArea(building.getCoverageArea());
                dcrReportBlockDetail.setBuildingHeight(building.getBuildingHeight());
                dcrReportBlockDetail.setConstructedArea(building.getTotalConstructedArea());
                List floors = building.getFloors();
                if (!floors.isEmpty()) {
                    List<Object> dcrReportFloorDetails = new ArrayList();
                    for (Floor floor : floors) {
                        List occupancies = floor.getOccupancies();
                        if (occupancies.isEmpty()) continue;
                        for (Occupancy occupancy : occupancies) {
                            String occupancyName = "";
                            if (occupancy.getTypeHelper() != null) {
                                if (occupancy.getTypeHelper().getSubtype() != null) {
                                    occupancyName = occupancy.getTypeHelper().getSubtype().getName();
                                } else if (occupancy.getTypeHelper().getType() != null) {
                                    occupancyName = occupancy.getTypeHelper().getType().getName();
                                }
                            }
                            DcrReportFloorDetail dcrReportFloorDetail = new DcrReportFloorDetail();
                            String floorNo = floor.getTerrace() != false ? "Terrace" : (occupancy.getIsMezzanine() != false ? floor.getNumber() + " (Mezzanine " + floor.getNumber() + ")" : String.valueOf(floor.getNumber()));
                            dcrReportFloorDetail.setFloorNo(floorNo);
                            dcrReportFloorDetail.setOccupancy(occupancyName);
                            dcrReportFloorDetail.setBuiltUpArea(occupancy.getExistingBuiltUpArea().compareTo(BigDecimal.ZERO) > 0 ? occupancy.getBuiltUpArea().subtract(occupancy.getExistingBuiltUpArea()) : occupancy.getBuiltUpArea());
                            dcrReportFloorDetail.setFloorArea(occupancy.getExistingFloorArea().compareTo(BigDecimal.ZERO) > 0 ? occupancy.getFloorArea().subtract(occupancy.getExistingFloorArea()) : occupancy.getFloorArea());
                            dcrReportFloorDetail.setCarpetArea(occupancy.getExistingCarpetArea().compareTo(BigDecimal.ZERO) > 0 ? occupancy.getCarpetArea().subtract(occupancy.getExistingCarpetArea()) : occupancy.getCarpetArea());
                            if (dcrReportFloorDetail.getBuiltUpArea().compareTo(BigDecimal.ZERO) <= 0) continue;
                            dcrReportFloorDetails.add(dcrReportFloorDetail);
                        }
                    }
                    dcrReportFloorDetails = dcrReportFloorDetails.stream().sorted(Comparator.comparing(DcrReportFloorDetail::getFloorNo)).collect(Collectors.toList());
                    dcrReportBlockDetail.setDcrReportFloorDetails(dcrReportFloorDetails);
                }
                dcrReportBlockDetails.add(dcrReportBlockDetail);
            }
        }
        return dcrReportBlockDetails;
    }

    private List<DcrReportBlockDetail> buildBlockWiseExistingInfo(Plan plan) {
        ArrayList<DcrReportBlockDetail> dcrReportBlockDetails = new ArrayList<DcrReportBlockDetail>();
        List blocks = plan.getBlocks();
        if (!blocks.isEmpty()) {
            for (Block block : blocks) {
                Building building = block.getBuilding();
                if (building == null || building.getTotalExistingBuiltUpArea() == null || building.getTotalExistingBuiltUpArea().compareTo(BigDecimal.ZERO) <= 0 || building.getTotalExistingFloorArea().compareTo(BigDecimal.ZERO) <= 0) continue;
                DcrReportBlockDetail dcrReportBlockDetail = new DcrReportBlockDetail();
                dcrReportBlockDetail.setBlockNo(block.getNumber());
                List floors = building.getFloors();
                if (!floors.isEmpty()) {
                    List<Object> dcrReportFloorDetails = new ArrayList();
                    for (Floor floor : floors) {
                        List occupancies = floor.getOccupancies();
                        if (occupancies.isEmpty()) continue;
                        for (Occupancy occupancy : occupancies) {
                            String occupancyName = "";
                            if (occupancy.getTypeHelper() != null) {
                                if (occupancy.getTypeHelper().getSubtype() != null) {
                                    occupancyName = occupancy.getTypeHelper().getSubtype().getName();
                                } else if (occupancy.getTypeHelper().getType() != null) {
                                    occupancyName = occupancy.getTypeHelper().getType().getName();
                                }
                            }
                            if (occupancy == null || occupancy.getExistingBuiltUpArea().compareTo(BigDecimal.ZERO) <= 0) continue;
                            DcrReportFloorDetail dcrReportFloorDetail = new DcrReportFloorDetail();
                            dcrReportFloorDetail.setFloorNo(floor.getTerrace() != false ? "Terrace" : floor.getNumber().toString());
                            dcrReportFloorDetail.setOccupancy(occupancyName);
                            dcrReportFloorDetail.setBuiltUpArea(occupancy.getExistingBuiltUpArea());
                            dcrReportFloorDetail.setFloorArea(occupancy.getExistingFloorArea());
                            dcrReportFloorDetail.setCarpetArea(occupancy.getExistingCarpetArea());
                            dcrReportFloorDetails.add(dcrReportFloorDetail);
                        }
                    }
                    dcrReportFloorDetails = dcrReportFloorDetails.stream().sorted(Comparator.comparing(DcrReportFloorDetail::getFloorNo)).collect(Collectors.toList());
                    dcrReportBlockDetail.setDcrReportFloorDetails(dcrReportFloorDetails);
                }
                dcrReportBlockDetails.add(dcrReportBlockDetail);
            }
        }
        return dcrReportBlockDetails;
    }

    private VirtualBuildingReport buildVirtualBuilding(VirtualBuilding virtualBuilding) {
        VirtualBuildingReport virtualBuildingReport = new VirtualBuildingReport();
        if (virtualBuilding != null) {
            if (virtualBuilding.getTotalExistingBuiltUpArea() != null) {
                virtualBuildingReport.setProposedBuitUpArea(virtualBuilding.getTotalBuitUpArea().subtract(virtualBuilding.getTotalExistingBuiltUpArea()));
                virtualBuildingReport.setProposedFloorArea(virtualBuilding.getTotalFloorArea().subtract(virtualBuilding.getTotalExistingFloorArea()));
                virtualBuildingReport.setProposedCarpetArea(virtualBuilding.getTotalCarpetArea().subtract(virtualBuilding.getTotalExistingCarpetArea()));
            }
            virtualBuildingReport.setTotalExistingBuiltUpArea(virtualBuilding.getTotalExistingBuiltUpArea());
            virtualBuildingReport.setTotalExistingFloorArea(virtualBuilding.getTotalExistingFloorArea());
            virtualBuildingReport.setTotalExistingCarpetArea(virtualBuilding.getTotalExistingCarpetArea());
            virtualBuildingReport.setTotalCoverageArea(virtualBuilding.getTotalCoverageArea());
            virtualBuildingReport.setTotalBuitUpArea(virtualBuilding.getTotalBuitUpArea());
            virtualBuildingReport.setTotalFloorArea(virtualBuilding.getTotalFloorArea());
            virtualBuildingReport.setTotalCarpetArea(virtualBuilding.getTotalCarpetArea());
            virtualBuildingReport.setTotalConstructedArea(virtualBuilding.getTotalConstructedArea());
        }
        return virtualBuildingReport;
    }

    private List<ConditionalStyle> getConditonalStyles() {
        ArrayList<ConditionalStyle> conditionalStyles = new ArrayList<ConditionalStyle>();
        FetchCondition fc = new FetchCondition(STATUS, "Not Accepted");
        ConditionalStyle cs = new ConditionalStyle((ConditionStyleExpression)fc, this.reportService.getDetailStyle(Color.RED));
        conditionalStyles.add(cs);
        fc = new FetchCondition(STATUS, "Accepted");
        cs = new ConditionalStyle((ConditionStyleExpression)fc, this.reportService.getDetailStyle(new Color(0, 128, 0)));
        conditionalStyles.add(cs);
        fc = new FetchCondition(STATUS, "Verify");
        cs = new ConditionalStyle((ConditionStyleExpression)fc, this.reportService.getDetailStyle(new Color(30, 144, 255)));
        conditionalStyles.add(cs);
        return conditionalStyles;
    }
}

