/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.common.entity.dcr.helper.ErrorDetail;
import org.egov.edcr.contract.ComparisonDetail;
import org.egov.edcr.contract.ComparisonRequest;
import org.egov.edcr.entity.Amendment;
import org.egov.edcr.entity.AmendmentDetails;
import org.egov.edcr.entity.EdcrApplication;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.entity.OcComparisonDetail;
import org.egov.edcr.service.AmendmentService;
import org.egov.edcr.service.EdcrApplicationDetailService;
import org.egov.edcr.service.OcComparisonDetailService;
import org.egov.edcr.service.OcComparisonReportService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.custom.CustomImplProvider;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OcComparisonService {
    private static final Logger LOG = Logger.getLogger(OcComparisonService.class);
    @Autowired
    private CustomImplProvider specificRuleService;
    @Autowired
    private EdcrApplicationDetailService applicationDetailService;
    @Autowired
    private OcComparisonDetailService ocComparisonDetailService;
    @Autowired
    private FileStoreService fileStoreService;

    public List<ErrorDetail> validateEdcrMandatoryFields(ComparisonRequest comparisonRequest) {
        ArrayList<ErrorDetail> errors = new ArrayList<ErrorDetail>();
        if (StringUtils.isBlank((CharSequence)comparisonRequest.getEdcrNumber())) {
            errors.add(new ErrorDetail("BPA-21", "eDcr number is missing"));
        }
        if (StringUtils.isBlank((CharSequence)comparisonRequest.getOcdcrNumber())) {
            errors.add(new ErrorDetail("BPA-22", "OcDcr number is missing"));
        }
        if (StringUtils.isBlank((CharSequence)comparisonRequest.getTenantId())) {
            errors.add(new ErrorDetail("BPA-29", "tenantId is missing"));
        }
        return errors;
    }

    public ComparisonDetail process(ComparisonRequest comparisonRequest) {
        String ocdcrNo = comparisonRequest.getOcdcrNumber();
        String dcrNo = comparisonRequest.getEdcrNumber();
        String tenantId = comparisonRequest.getTenantId();
        ComparisonDetail comparisonDetail = new ComparisonDetail();
        OcComparisonDetail ocComparisonDetail = this.ocComparisonDetailService.findByOcDcrNoAndDcrNumberAndTenant(ocdcrNo, dcrNo, tenantId);
        if (ocComparisonDetail != null) {
            comparisonDetail.setEdcrNumber(ocComparisonDetail.getDcrNumber());
            comparisonDetail.setOcdcrNumber(ocComparisonDetail.getOcdcrNumber());
            comparisonDetail.setComparisonReport(String.format(this.getFileDownloadUrl(ocComparisonDetail.getOcComparisonReport().getFileStoreId(), ApplicationThreadLocals.getTenantID()), new Object[0]));
            comparisonDetail.setTenantId(ocComparisonDetail.getTenantId());
            comparisonDetail.setStatus(ocComparisonDetail.getStatus());
        } else {
            EdcrApplicationDetail permitDcr;
            EdcrApplicationDetail ocDcr = this.applicationDetailService.findByDcrNumberAndTPUserTenant(ocdcrNo, tenantId);
            List<ErrorDetail> errors = this.validate(ocdcrNo, dcrNo, ocDcr, permitDcr = this.applicationDetailService.findByDcrNumberAndTPUserTenant(dcrNo, tenantId));
            if (!errors.isEmpty()) {
                comparisonDetail.setErrors(errors);
                return comparisonDetail;
            }
            EdcrApplication dcrApplication = ocDcr.getApplication();
            AmendmentService repo = (AmendmentService)this.specificRuleService.find("amendmentService");
            Amendment amd = repo.getAmendments();
            Date applicationDate = dcrApplication.getApplicationDate();
            OcComparisonDetail ocComparisonDetailE = new OcComparisonDetail();
            ocComparisonDetailE.setOcdcrNumber(ocdcrNo);
            ocComparisonDetailE.setDcrNumber(dcrNo);
            ocComparisonDetailE.setTenantId(tenantId);
            InputStream ocreportStream = this.generateOcComparisonReport(applicationDate, amd, ocDcr, permitDcr, ocComparisonDetailE);
            this.saveComparisonReport(ocComparisonDetailE, ocreportStream);
            comparisonDetail.setEdcrNumber(ocComparisonDetailE.getDcrNumber());
            comparisonDetail.setOcdcrNumber(ocComparisonDetailE.getOcdcrNumber());
            comparisonDetail.setComparisonReport(String.format(this.getFileDownloadUrl(ocComparisonDetailE.getOcComparisonReport().getFileStoreId(), ApplicationThreadLocals.getTenantID()), new Object[0]));
            comparisonDetail.setStatus(ocComparisonDetailE.getStatus());
            comparisonDetail.setTenantId(ocComparisonDetailE.getTenantId());
        }
        return comparisonDetail;
    }

    public OcComparisonDetail processCombined(OcComparisonDetail comparisonDetail, EdcrApplicationDetail ocDcr) {
        EdcrApplication dcrApplication = ocDcr.getApplication();
        AmendmentService repo = (AmendmentService)this.specificRuleService.find("amendmentService");
        Amendment amd = repo.getAmendments();
        Date applicationDate = dcrApplication.getApplicationDate();
        InputStream ocreportStream = this.generatePreOcComparisonReport(applicationDate, amd, ocDcr, comparisonDetail.getPermitDcr(), comparisonDetail);
        comparisonDetail.setOutput(ocreportStream);
        return comparisonDetail;
    }

    public OcComparisonDetail processCombinedStatus(ComparisonRequest comparisonRequest, EdcrApplicationDetail ocDcr) {
        String ocdcrNo = comparisonRequest.getOcdcrNumber();
        String dcrNo = comparisonRequest.getEdcrNumber();
        String tenantId = comparisonRequest.getTenantId();
        EdcrApplicationDetail permitDcr = this.applicationDetailService.findByDcrNumberAndTPUserTenant(dcrNo, tenantId);
        EdcrApplication dcrApplication = ocDcr.getApplication();
        AmendmentService repo = (AmendmentService)this.specificRuleService.find("amendmentService");
        Amendment amd = repo.getAmendments();
        Date applicationDate = dcrApplication.getApplicationDate();
        OcComparisonDetail ocComparisonDetailE = new OcComparisonDetail();
        ocComparisonDetailE.setOcdcrNumber(ocdcrNo);
        ocComparisonDetailE.setDcrNumber(dcrNo);
        ocComparisonDetailE.setTenantId(tenantId);
        ocComparisonDetailE.setPermitDcr(permitDcr);
        this.getComparisonReportStatus(applicationDate, amd, ocDcr, permitDcr, ocComparisonDetailE);
        return ocComparisonDetailE;
    }

    private List<ErrorDetail> validate(String ocdrNo, String dcrNo, EdcrApplicationDetail ocDcr, EdcrApplicationDetail permitDcr) {
        ArrayList<ErrorDetail> errors = new ArrayList<ErrorDetail>();
        if (ocDcr == null) {
            errors.add(new ErrorDetail("BPA-23", "No record found with ocdcr number " + ocdrNo));
        }
        if (permitDcr == null) {
            errors.add(new ErrorDetail("BPA-24", "No record found with dcr number " + dcrNo));
        }
        if (ocDcr != null && ocDcr.getApplication() != null && StringUtils.isBlank((CharSequence)ocDcr.getApplication().getServiceType())) {
            errors.add(new ErrorDetail("BPA-25", "No service type found for ocdcr number " + ocdrNo));
        }
        if (permitDcr != null && permitDcr.getApplication() != null && StringUtils.isBlank((CharSequence)permitDcr.getApplication().getServiceType())) {
            errors.add(new ErrorDetail("BPA-26", "No service type found for dcr number " + dcrNo));
        }
        if (ocDcr != null && ocDcr.getApplication() != null && permitDcr != null && permitDcr.getApplication() != null && ocDcr.getApplication().getApplicationType().getApplicationType().equalsIgnoreCase(permitDcr.getApplication().getApplicationType().getApplicationTypeVal())) {
            errors.add(new ErrorDetail("BPA-27", "Application types are same"));
        }
        if (ocDcr != null && ocDcr.getApplication() != null && permitDcr != null && permitDcr.getApplication() != null && !ocDcr.getApplication().getServiceType().equalsIgnoreCase(permitDcr.getApplication().getServiceType())) {
            errors.add(new ErrorDetail("BPA-28", "Service types are not mathing"));
        }
        return errors;
    }

    private InputStream generateOcComparisonReport(Date applicationDate, Amendment amd, EdcrApplicationDetail ocDcr, EdcrApplicationDetail permitDcr, OcComparisonDetail detail) {
        String beanName = "OcComparisonReportService";
        OcComparisonReportService service = null;
        int index = -1;
        AmendmentDetails[] amdArray = null;
        InputStream reportStream = null;
        int length = amd.getDetails().size();
        if (!amd.getDetails().isEmpty()) {
            index = amd.getIndex(applicationDate);
            amdArray = new AmendmentDetails[amd.getDetails().size()];
            amd.getDetails().toArray(amdArray);
        }
        try {
            beanName = beanName.substring(0, 1).toLowerCase() + beanName.substring(1);
            if (amd.getDetails().isEmpty() || index == -1) {
                service = (OcComparisonReportService)this.specificRuleService.find(beanName);
            } else if (index >= 0) {
                for (int i = index; i < length && (service = (OcComparisonReportService)this.specificRuleService.find(beanName + "_" + amdArray[i].getDateOfBylawString())) == null; ++i) {
                }
            }
            if (service == null) {
                service = (OcComparisonReportService)this.specificRuleService.find(beanName);
            }
            reportStream = service.generateOcComparisonReport(ocDcr, permitDcr, detail);
        }
        catch (BeansException e) {
            LOG.error((Object)("No Bean Defined for the Rule " + beanName));
        }
        return reportStream;
    }

    private InputStream generatePreOcComparisonReport(Date applicationDate, Amendment amd, EdcrApplicationDetail ocDcr, EdcrApplicationDetail permitDcr, OcComparisonDetail detail) {
        String beanName = "OcComparisonReportService";
        OcComparisonReportService service = null;
        int index = -1;
        AmendmentDetails[] amdArray = null;
        InputStream reportStream = null;
        int length = amd.getDetails().size();
        if (!amd.getDetails().isEmpty()) {
            index = amd.getIndex(applicationDate);
            amdArray = new AmendmentDetails[amd.getDetails().size()];
            amd.getDetails().toArray(amdArray);
        }
        try {
            beanName = beanName.substring(0, 1).toLowerCase() + beanName.substring(1);
            if (amd.getDetails().isEmpty() || index == -1) {
                service = (OcComparisonReportService)this.specificRuleService.find(beanName);
            } else if (index >= 0) {
                for (int i = index; i < length && (service = (OcComparisonReportService)this.specificRuleService.find(beanName + "_" + amdArray[i].getDateOfBylawString())) == null; ++i) {
                }
            }
            if (service == null) {
                service = (OcComparisonReportService)this.specificRuleService.find(beanName);
            }
            reportStream = service.generatePreOcComparisonReport(ocDcr, permitDcr, detail);
        }
        catch (BeansException e) {
            LOG.error((Object)("No Bean Defined for the Rule " + beanName));
        }
        return reportStream;
    }

    private OcComparisonDetail getComparisonReportStatus(Date applicationDate, Amendment amd, EdcrApplicationDetail ocDcr, EdcrApplicationDetail permitDcr, OcComparisonDetail detail) {
        String beanName = "OcComparisonReportService";
        OcComparisonReportService service = null;
        int index = -1;
        AmendmentDetails[] amdArray = null;
        Object comparisonReportStatus = null;
        int length = amd.getDetails().size();
        if (!amd.getDetails().isEmpty()) {
            index = amd.getIndex(applicationDate);
            amdArray = new AmendmentDetails[amd.getDetails().size()];
            amd.getDetails().toArray(amdArray);
        }
        try {
            beanName = beanName.substring(0, 1).toLowerCase() + beanName.substring(1);
            if (amd.getDetails().isEmpty() || index == -1) {
                service = (OcComparisonReportService)this.specificRuleService.find(beanName);
            } else if (index >= 0) {
                for (int i = index; i < length && (service = (OcComparisonReportService)this.specificRuleService.find(beanName + "_" + amdArray[i].getDateOfBylawString())) == null; ++i) {
                }
            }
            if (service == null) {
                service = (OcComparisonReportService)this.specificRuleService.find(beanName);
            }
            service.getComparisonReportStatus(ocDcr, permitDcr, detail);
        }
        catch (BeansException e) {
            LOG.error((Object)("No Bean Defined for the Rule " + beanName));
        }
        return detail;
    }

    @Transactional
    public void saveComparisonReport(OcComparisonDetail detail, InputStream reportOutputStream) {
        String fileName = detail.getOcdcrNumber() + "-" + detail.getDcrNumber() + "-comparison.pdf";
        FileStoreMapper fileStoreMapper = this.fileStoreService.store(reportOutputStream, fileName, "application/pdf", "Digit DCR");
        detail.setOcComparisonReport(fileStoreMapper);
        this.ocComparisonDetailService.saveAndFlush(detail);
    }

    public String getFileDownloadUrl(String fileStoreId, String tenantId) {
        return String.format("%s/edcr/rest/dcr/downloadfile/", ApplicationThreadLocals.getDomainURL()) + fileStoreId + "?tenantId=" + tenantId;
    }
}

