/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DJDataSource;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Stretching;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionStyleExpression;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Building;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.OcComparisonBlockDetail;
import org.egov.common.entity.edcr.OcComparisonReportFloorDetail;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.entity.ApplicationType;
import org.egov.edcr.entity.EdcrApplication;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.entity.OcComparisonDetail;
import org.egov.edcr.service.FetchCondition;
import org.egov.edcr.service.JasperReportService;
import org.egov.edcr.utility.DcrConstants;
import org.egov.edcr.utility.Util;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.security.utils.SecureCodeUtils;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OcComparisonReportService {
    private static final Logger LOG = Logger.getLogger(OcComparisonReportService.class);
    public static final String STATUS = "Status";
    public static final String BLOCK = "Block";
    public static final BigDecimal DEVIATION_VALUE = BigDecimal.valueOf(5L);
    @Autowired
    private CityService cityService;
    @Autowired
    private JasperReportService reportService;
    @Autowired
    private FileStoreService fileStoreService;

    public InputStream generateOcComparisonReport(EdcrApplicationDetail ocDcr, EdcrApplicationDetail permitDcr, OcComparisonDetail comparisonDetail) {
        FileStoreMapper ocPlanFileMapper = ocDcr.getPlanDetailFileStore();
        File ocFile = ocPlanFileMapper != null ? this.fileStoreService.fetch(ocPlanFileMapper.getFileStoreId(), "Digit DCR") : null;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Plan ocPlan = null;
        try {
            ocPlan = (Plan)mapper.readValue(ocFile, Plan.class);
        }
        catch (IOException e) {
            LOG.log((Priority)Level.ERROR, (Object)e);
        }
        FileStoreMapper permitFileMapper = permitDcr.getPlanDetailFileStore();
        File permitFile = permitFileMapper != null ? this.fileStoreService.fetch(permitFileMapper.getFileStoreId(), "Digit DCR") : null;
        ObjectMapper permitMapper = new ObjectMapper();
        permitMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Plan permitPlan = null;
        try {
            permitPlan = (Plan)permitMapper.readValue(permitFile, Plan.class);
        }
        catch (IOException e) {
            LOG.log((Priority)Level.ERROR, (Object)e);
        }
        List<OcComparisonBlockDetail> ocComparison = this.buildOcComparison(permitPlan, ocPlan);
        List<ScrutinyDetail> scrutinyDetails = this.buildReportObject(ocComparison);
        boolean finalReportStatus = true;
        FastReportBuilder drb = new FastReportBuilder();
        Style titleStyle = new Style("titleStyle");
        titleStyle.setFont(new Font(50, "Times New Roman", true));
        titleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        titleStyle.setFont(new Font(2, "Times New Roman", false));
        String applicationNumber = StringUtils.isNotBlank((CharSequence)ocDcr.getApplication().getApplicationNumber()) ? ocDcr.getApplication().getApplicationNumber() : "NA";
        String applicationDate = DateUtils.toDefaultDateFormat((Date)ocDcr.getApplication().getApplicationDate());
        drb.setPageSizeAndOrientation(new Page(842, 595, true));
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(scrutinyDetails);
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("ulbName", ApplicationThreadLocals.getMunicipalityName());
        valuesMap.put("applicationNumber", applicationNumber);
        valuesMap.put("ocdcrNo", ocDcr.getDcrNumber());
        valuesMap.put("dcrNo", permitDcr.getDcrNumber());
        valuesMap.put("applicationDate", applicationDate);
        valuesMap.put("applicantName", ocDcr.getApplication().getApplicantName());
        valuesMap.put("reportGeneratedDate", DateUtils.toDefaultDateTimeFormat((Date)new Date()));
        String imageURL = ReportUtil.getImageURL((String)"/egi/resources/global/images/digit-logo-black.png");
        valuesMap.put("egovLogo", imageURL);
        valuesMap.put("cityLogo", this.cityService.getCityLogoURLByCurrentTenant());
        TreeSet<String> common = new TreeSet<String>();
        HashMap<String, ScrutinyDetail> allMap = new HashMap<String, ScrutinyDetail>();
        TreeMap blocks = new TreeMap();
        LOG.info((Object)"Generate Report.......");
        for (ScrutinyDetail sd : scrutinyDetails) {
            LOG.info((Object)sd.getKey());
            LOG.info((Object)sd.getHeading());
            String[] split = new String[]{};
            if (sd.getKey() != null) {
                split = sd.getKey().split("_");
            }
            if (split.length == 2) {
                common.add(split[1]);
                allMap.put(split[1], sd);
                continue;
            }
            if (split.length != 3) continue;
            if (blocks.get(split[1]) == null) {
                TreeSet<String> features = new TreeSet<String>();
                features.add(split[2]);
                blocks.put(split[1], features);
            } else {
                ((Set)blocks.get(split[1])).add(split[2]);
            }
            allMap.put(split[1] + split[2], sd);
        }
        for (String blkName : blocks.keySet()) {
            Iterator blkHeading = new ArrayList<String>();
            blkHeading.add(BLOCK + blkName);
            drb.addConcatenatedReport(this.createHeaderSubreport("Block " + blkName, BLOCK + blkName));
            valuesMap.put(BLOCK + blkName, blkHeading);
            int j = 0;
            for (String blkFeature : (Set)blocks.get(blkName)) {
                drb.addConcatenatedReport(this.getSub((ScrutinyDetail)allMap.get(blkName + blkFeature), ++j, j + "." + blkFeature, ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getHeading(), ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getSubHeading(), blkName + blkFeature));
                valuesMap.put(blkName + blkFeature, ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getDetail());
                ArrayList<String> featureFooter = new ArrayList<String>();
                if (((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks() == null) continue;
                drb.addConcatenatedReport(this.createFooterSubreport("Remarks :  " + ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks(), "Remarks_" + blkName + blkFeature));
                featureFooter.add(((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks());
                valuesMap.put("Remarks_" + blkName + blkFeature, featureFooter);
            }
        }
        if (finalReportStatus) {
            for (String cmnFeature : common) {
                for (Map commonStatus : ((ScrutinyDetail)allMap.get(cmnFeature)).getDetail()) {
                    if (!((String)commonStatus.get(STATUS)).equalsIgnoreCase(Result.Not_Accepted.getResultVal())) continue;
                    finalReportStatus = false;
                }
            }
        }
        if (finalReportStatus) {
            for (String blkName : blocks.keySet()) {
                for (String blkFeature : (Set)blocks.get(blkName)) {
                    for (Map blkStatus : ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getDetail()) {
                        if (!((String)blkStatus.get(STATUS)).equalsIgnoreCase(Result.Not_Accepted.getResultVal())) continue;
                        finalReportStatus = false;
                    }
                }
            }
        }
        drb.setTemplateFile("/reports/templates/oc_comparison_report.jrxml");
        drb.setMargins(5, 0, 33, 20);
        String endStatus = finalReportStatus ? "Accepted" : "Not Accepted";
        valuesMap.put("reportStatus", endStatus);
        comparisonDetail.setStatus(endStatus);
        valuesMap.put("qrCode", SecureCodeUtils.generatePDF417Code((String)this.buildQRCodeDetails(ocDcr.getApplication(), finalReportStatus)));
        DynamicReport dr = drb.build();
        InputStream exportPdf = null;
        try {
            JasperPrint generateJasperPrint = DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds, valuesMap);
            exportPdf = this.reportService.exportPdf(generateJasperPrint);
        }
        catch (IOException | JRException e) {
            LOG.error((Object)"Error occurred when generating Jasper report", e);
        }
        return exportPdf;
    }

    public InputStream generatePreOcComparisonReport(EdcrApplicationDetail ocDcr, EdcrApplicationDetail permitDcr, OcComparisonDetail comparisonDetail) {
        Plan ocPlan = ocDcr.getPlan();
        FileStoreMapper permitFileMapper = permitDcr.getPlanDetailFileStore();
        File permitFile = permitFileMapper != null ? this.fileStoreService.fetch(permitFileMapper.getFileStoreId(), "Digit DCR") : null;
        ObjectMapper permitMapper = new ObjectMapper();
        permitMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Plan permitPlan = null;
        try {
            permitPlan = (Plan)permitMapper.readValue(permitFile, Plan.class);
        }
        catch (IOException e) {
            LOG.log((Priority)Level.ERROR, (Object)e);
        }
        List<ScrutinyDetail> scrutinyDetails = comparisonDetail.getScrutinyDetails();
        boolean finalReportStatus = true;
        FastReportBuilder drb = new FastReportBuilder();
        Style titleStyle = new Style("titleStyle");
        titleStyle.setFont(new Font(50, "Times New Roman", true));
        titleStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        titleStyle.setFont(new Font(2, "Times New Roman", false));
        String applicationNumber = StringUtils.isNotBlank((CharSequence)ocDcr.getApplication().getApplicationNumber()) ? ocDcr.getApplication().getApplicationNumber() : "NA";
        String applicationDate = DateUtils.toDefaultDateFormat((Date)ocDcr.getApplication().getApplicationDate());
        drb.setPageSizeAndOrientation(new Page(842, 595, true));
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(scrutinyDetails);
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("ulbName", ApplicationThreadLocals.getMunicipalityName());
        valuesMap.put("applicationNumber", applicationNumber);
        valuesMap.put("ocdcrNo", ocDcr.getDcrNumber());
        valuesMap.put("dcrNo", permitDcr.getDcrNumber());
        valuesMap.put("applicationDate", applicationDate);
        valuesMap.put("applicantName", ocDcr.getApplication().getApplicantName());
        valuesMap.put("reportGeneratedDate", DateUtils.toDefaultDateTimeFormat((Date)new Date()));
        String imageURL = ReportUtil.getImageURL((String)"/egi/resources/global/images/digit-logo-black.png");
        valuesMap.put("egovLogo", imageURL);
        valuesMap.put("cityLogo", this.cityService.getCityLogoURLByCurrentTenant());
        TreeSet<String> common = new TreeSet<String>();
        HashMap<String, ScrutinyDetail> allMap = new HashMap<String, ScrutinyDetail>();
        TreeMap blocks = new TreeMap();
        LOG.info((Object)"Generate Report.......");
        for (ScrutinyDetail sd : scrutinyDetails) {
            LOG.info((Object)sd.getKey());
            LOG.info((Object)sd.getHeading());
            String[] split = new String[]{};
            if (sd.getKey() != null) {
                split = sd.getKey().split("_");
            }
            if (split.length == 2) {
                common.add(split[1]);
                allMap.put(split[1], sd);
                continue;
            }
            if (split.length != 3) continue;
            if (blocks.get(split[1]) == null) {
                TreeSet<String> features = new TreeSet<String>();
                features.add(split[2]);
                blocks.put(split[1], features);
            } else {
                ((Set)blocks.get(split[1])).add(split[2]);
            }
            allMap.put(split[1] + split[2], sd);
        }
        for (String blkName : blocks.keySet()) {
            Iterator blkHeading = new ArrayList<String>();
            blkHeading.add(BLOCK + blkName);
            drb.addConcatenatedReport(this.createHeaderSubreport("Block " + blkName, BLOCK + blkName));
            valuesMap.put(BLOCK + blkName, blkHeading);
            int j = 0;
            for (String blkFeature : (Set)blocks.get(blkName)) {
                drb.addConcatenatedReport(this.getSub((ScrutinyDetail)allMap.get(blkName + blkFeature), ++j, j + "." + blkFeature, ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getHeading(), ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getSubHeading(), blkName + blkFeature));
                valuesMap.put(blkName + blkFeature, ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getDetail());
                ArrayList<String> featureFooter = new ArrayList<String>();
                if (((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks() == null) continue;
                drb.addConcatenatedReport(this.createFooterSubreport("Remarks :  " + ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks(), "Remarks_" + blkName + blkFeature));
                featureFooter.add(((ScrutinyDetail)allMap.get(blkName + blkFeature)).getRemarks());
                valuesMap.put("Remarks_" + blkName + blkFeature, featureFooter);
            }
        }
        if (finalReportStatus) {
            for (String cmnFeature : common) {
                for (Map commonStatus : ((ScrutinyDetail)allMap.get(cmnFeature)).getDetail()) {
                    if (!((String)commonStatus.get(STATUS)).equalsIgnoreCase(Result.Not_Accepted.getResultVal())) continue;
                    finalReportStatus = false;
                }
            }
        }
        if (finalReportStatus) {
            for (String blkName : blocks.keySet()) {
                for (String blkFeature : (Set)blocks.get(blkName)) {
                    for (Map blkStatus : ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getDetail()) {
                        if (!((String)blkStatus.get(STATUS)).equalsIgnoreCase(Result.Not_Accepted.getResultVal())) continue;
                        finalReportStatus = false;
                    }
                }
            }
        }
        drb.setTemplateFile("/reports/templates/oc_comparison_report.jrxml");
        drb.setMargins(5, 0, 33, 20);
        String endStatus = finalReportStatus ? "Accepted" : "Not Accepted";
        valuesMap.put("reportStatus", endStatus);
        comparisonDetail.setStatus(endStatus);
        valuesMap.put("qrCode", SecureCodeUtils.generatePDF417Code((String)this.buildQRCodeDetails(ocDcr.getApplication(), finalReportStatus)));
        DynamicReport dr = drb.build();
        InputStream exportPdf = null;
        try {
            JasperPrint generateJasperPrint = DynamicJasperHelper.generateJasperPrint((DynamicReport)dr, (LayoutManager)new ClassicLayoutManager(), (JRDataSource)ds, valuesMap);
            exportPdf = this.reportService.exportPdf(generateJasperPrint);
        }
        catch (IOException | JRException e) {
            LOG.error((Object)"Error occurred when generating Jasper report", e);
        }
        return exportPdf;
    }

    public OcComparisonDetail getComparisonReportStatus(EdcrApplicationDetail ocDcr, EdcrApplicationDetail permitDcr, OcComparisonDetail comparisonDetail) {
        Plan ocPlan = ocDcr.getPlan();
        FileStoreMapper permitFileMapper = permitDcr.getPlanDetailFileStore();
        File permitFile = permitFileMapper != null ? this.fileStoreService.fetch(permitFileMapper.getFileStoreId(), "Digit DCR") : null;
        ObjectMapper permitMapper = new ObjectMapper();
        permitMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Plan permitPlan = null;
        try {
            permitPlan = (Plan)permitMapper.readValue(permitFile, Plan.class);
        }
        catch (IOException e) {
            LOG.log((Priority)Level.ERROR, (Object)e);
        }
        List<OcComparisonBlockDetail> ocComparison = this.buildOcComparison(permitPlan, ocPlan);
        List<ScrutinyDetail> scrutinyDetails = this.buildReportObject(ocComparison);
        boolean finalReportStatus = true;
        TreeSet<String> common = new TreeSet<String>();
        HashMap<String, ScrutinyDetail> allMap = new HashMap<String, ScrutinyDetail>();
        TreeMap blocks = new TreeMap();
        LOG.info((Object)"Generate Report.......");
        for (ScrutinyDetail sd : scrutinyDetails) {
            LOG.info((Object)sd.getKey());
            LOG.info((Object)sd.getHeading());
            String[] split = new String[]{};
            if (sd.getKey() != null) {
                split = sd.getKey().split("_");
            }
            if (split.length == 2) {
                common.add(split[1]);
                allMap.put(split[1], sd);
                continue;
            }
            if (split.length != 3) continue;
            if (blocks.get(split[1]) == null) {
                TreeSet<String> features = new TreeSet<String>();
                features.add(split[2]);
                blocks.put(split[1], features);
            } else {
                ((Set)blocks.get(split[1])).add(split[2]);
            }
            allMap.put(split[1] + split[2], sd);
        }
        if (finalReportStatus) {
            for (String cmnFeature : common) {
                for (Map commonStatus : ((ScrutinyDetail)allMap.get(cmnFeature)).getDetail()) {
                    if (!((String)commonStatus.get(STATUS)).equalsIgnoreCase(Result.Not_Accepted.getResultVal())) continue;
                    finalReportStatus = false;
                }
            }
        }
        if (finalReportStatus) {
            for (String blkName : blocks.keySet()) {
                for (String blkFeature : (Set)blocks.get(blkName)) {
                    for (Map blkStatus : ((ScrutinyDetail)allMap.get(blkName + blkFeature)).getDetail()) {
                        if (!((String)blkStatus.get(STATUS)).equalsIgnoreCase(Result.Not_Accepted.getResultVal())) continue;
                        finalReportStatus = false;
                    }
                }
            }
        }
        comparisonDetail.setScrutinyDetails(scrutinyDetails);
        comparisonDetail.setStatus(finalReportStatus ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
        return comparisonDetail;
    }

    private Subreport createHeaderSubreport(String title, String dataSourceName) {
        try {
            FastReportBuilder frb = new FastReportBuilder();
            frb.setUseFullPageWidth(true);
            frb.setTitle(title);
            frb.setShowDetailBand(false);
            frb.setMargins(0, 0, 0, 0);
            frb.setTitleStyle(this.reportService.getSubReportTitleStyle());
            frb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            DynamicReport build = frb.build();
            Subreport sub = new Subreport();
            sub.setDynamicReport(build);
            sub.setDatasource(new DJDataSource(dataSourceName, 0, 0));
            sub.setLayoutManager((LayoutManager)new ClassicLayoutManager());
            return sub;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Subreport createFooterSubreport(String title, String dataSourceName) {
        try {
            FastReportBuilder frb = new FastReportBuilder();
            frb.setUseFullPageWidth(true);
            frb.setTitleHeight(Integer.valueOf(5));
            frb.setTitle(title);
            frb.setMargins(0, 0, 0, 0);
            frb.setTitleStyle(this.reportService.getTitleStyle());
            frb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            DynamicReport build = frb.build();
            Subreport sub = new Subreport();
            sub.setDynamicReport(build);
            sub.setDatasource(new DJDataSource(dataSourceName, 0, 0));
            sub.setLayoutManager((LayoutManager)new ClassicLayoutManager());
            return sub;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Subreport getSub(ScrutinyDetail detail, int j, String title, String heading, String subheading, String dataSourceName) {
        try {
            List<ConditionalStyle> listCondStyle = this.getConditonalStyles();
            FastReportBuilder frb = new FastReportBuilder();
            int size = detail.getColumnHeading().keySet().size();
            Double byeLawColumnSize = 40.0;
            Double statusColumnSize = 60.0;
            Double columnSize = (595.0 - (byeLawColumnSize + statusColumnSize)) / (double)(size - 2);
            for (Object s : detail.getColumnHeading().keySet()) {
                ScrutinyDetail.ColumnHeadingDetail columnHeading = (ScrutinyDetail.ColumnHeadingDetail)detail.getColumnHeading().get(s);
                int columnWidth = columnSize.intValue();
                if ("Byelaw".equalsIgnoreCase(columnHeading.name)) {
                    columnWidth = byeLawColumnSize.intValue();
                }
                if (STATUS.equalsIgnoreCase(columnHeading.name)) {
                    columnWidth = size == 3 ? 100 : statusColumnSize.intValue();
                }
                frb.addColumn(columnHeading.name, columnHeading.name, String.class.getName(), columnWidth);
            }
            frb.setMargins(0, 0, 0, 0);
            frb.setUseFullPageWidth(true);
            List columns = frb.getColumns();
            for (AbstractColumn col : columns) {
                if (!STATUS.equalsIgnoreCase(col.getTitle())) continue;
                col.setConditionalStyles(listCondStyle);
            }
            if (heading != null) {
                frb.setTitle(j + "." + heading);
            } else {
                frb.setTitle(title);
            }
            if (subheading != null) {
                frb.setSubtitle("\t" + subheading);
            }
            frb.setTitleStyle(this.reportService.getTitleStyle());
            frb.setHeaderHeight(5);
            frb.setDefaultStyles(this.reportService.getTitleStyle(), this.reportService.getSubTitleStyle(), this.reportService.getColumnHeaderStyle(), this.reportService.getDetailStyle());
            frb.setAllowDetailSplit(false);
            frb.setPageSizeAndOrientation(Page.Page_A4_Portrait());
            DynamicReport build = frb.build();
            Subreport sub = new Subreport();
            sub.setDynamicReport(build);
            Style style = new Style();
            style.setStretchWithOverflow(true);
            style.setStreching(Stretching.RELATIVE_TO_BAND_HEIGHT);
            sub.setStyle(style);
            sub.setDatasource(new DJDataSource(dataSourceName, 0, 0));
            sub.setLayoutManager((LayoutManager)new ClassicLayoutManager());
            return sub;
        }
        catch (ColumnBuilderException | ClassNotFoundException e) {
            LOG.error((Object)e.getMessage(), e);
            return null;
        }
    }

    private List<OcComparisonBlockDetail> buildOcComparison(Plan permit, Plan oc) {
        ArrayList<OcComparisonBlockDetail> blockDetails = new ArrayList<OcComparisonBlockDetail>();
        List permitBlks = permit.getBlocks();
        List ocBlks = oc.getBlocks();
        if (!permitBlks.isEmpty()) {
            for (Block permitBlk : permitBlks) {
                Block currentOcBlk = null;
                for (Block ocBlk : ocBlks) {
                    if (!ocBlk.getNumber().equalsIgnoreCase(permitBlk.getNumber())) continue;
                    currentOcBlk = ocBlk;
                }
                OcComparisonBlockDetail blockDetail = new OcComparisonBlockDetail();
                blockDetail.setNumber(Long.valueOf(permitBlk.getNumber()));
                Building permitBuilding = permitBlk.getBuilding();
                Building ocBuilding = null;
                if (currentOcBlk != null) {
                    ocBuilding = currentOcBlk.getBuilding();
                }
                if (permitBuilding != null) {
                    Object buildingHeight;
                    List permitFloors = permitBuilding.getFloors();
                    List ocFloors = new ArrayList();
                    if (ocBuilding != null) {
                        ocFloors = ocBuilding.getFloors();
                        BigDecimal noOfFloorsOc = ocBuilding.getFloorsAboveGround();
                        buildingHeight = ocBuilding.getBuildingHeight();
                        blockDetail.setNoOfFloorsOc(Long.valueOf(noOfFloorsOc.toString()));
                        blockDetail.setHghtFromGroundOc((BigDecimal)buildingHeight);
                    }
                    if (permitFloors != null && !permitFloors.isEmpty()) {
                        ArrayList<OcComparisonReportFloorDetail> comparisonReportFloorDetails = new ArrayList<OcComparisonReportFloorDetail>();
                        for (Floor permitFloor : permitFloors) {
                            Floor ocFloor = null;
                            if (ocFloors != null && !ocFloors.isEmpty()) {
                                for (Floor floor : ocFloors) {
                                    if (floor.getNumber() != permitFloor.getNumber()) continue;
                                    ocFloor = floor;
                                }
                            }
                            OcComparisonReportFloorDetail comparisonReportFloorDetail = new OcComparisonReportFloorDetail();
                            List permitOccupancies = permitFloor.getOccupancies();
                            BigDecimal permitBltUpArea = BigDecimal.ZERO;
                            BigDecimal permitCarpetArea = BigDecimal.ZERO;
                            BigDecimal permitFloorArea = BigDecimal.ZERO;
                            if (!permitOccupancies.isEmpty()) {
                                for (Occupancy occupancy : permitOccupancies) {
                                    permitBltUpArea = permitBltUpArea.add(occupancy.getBuiltUpArea());
                                    permitCarpetArea = permitCarpetArea.add(occupancy.getCarpetArea());
                                    permitFloorArea = permitFloorArea.add(occupancy.getFloorArea());
                                }
                            }
                            comparisonReportFloorDetail.setPermitBltUpArea(Util.roundOffTwoDecimal((BigDecimal)permitBltUpArea));
                            comparisonReportFloorDetail.setPermitCarpetArea(Util.roundOffTwoDecimal((BigDecimal)permitCarpetArea));
                            comparisonReportFloorDetail.setPermitFloorArea(Util.roundOffTwoDecimal((BigDecimal)permitFloorArea));
                            if (ocFloor != null) {
                                List ocOccupancies = ocFloor.getOccupancies();
                                BigDecimal ocBltUpArea = BigDecimal.ZERO;
                                BigDecimal ocCarpetArea = BigDecimal.ZERO;
                                BigDecimal ocFloorArea = BigDecimal.ZERO;
                                if (!ocOccupancies.isEmpty()) {
                                    for (Occupancy ocOccupancy : ocOccupancies) {
                                        ocBltUpArea = ocBltUpArea.add(Util.roundOffTwoDecimal((BigDecimal)ocOccupancy.getBuiltUpArea()));
                                        ocCarpetArea = ocCarpetArea.add(Util.roundOffTwoDecimal((BigDecimal)ocOccupancy.getCarpetArea()));
                                        ocFloorArea = ocFloorArea.add(Util.roundOffTwoDecimal((BigDecimal)ocOccupancy.getFloorArea()));
                                    }
                                }
                                comparisonReportFloorDetail.setOcBltUpArea(ocBltUpArea);
                                comparisonReportFloorDetail.setOcCarpetArea(ocCarpetArea);
                                comparisonReportFloorDetail.setOcFloorArea(ocFloorArea);
                            }
                            BigDecimal bltUpAreaDeviation = this.getDeviation(comparisonReportFloorDetail.getOcBltUpArea(), comparisonReportFloorDetail.getPermitBltUpArea());
                            BigDecimal carpetAreaDeviation = this.getDeviation(comparisonReportFloorDetail.getOcCarpetArea(), comparisonReportFloorDetail.getPermitCarpetArea());
                            BigDecimal floorAreaDeviation = this.getDeviation(comparisonReportFloorDetail.getOcFloorArea(), comparisonReportFloorDetail.getPermitFloorArea());
                            comparisonReportFloorDetail.setBltUpAreaDeviation(bltUpAreaDeviation);
                            comparisonReportFloorDetail.setCarpetAreaDeviation(carpetAreaDeviation);
                            comparisonReportFloorDetail.setFloorAreaDeviation(floorAreaDeviation);
                            comparisonReportFloorDetail.setNumber(Long.valueOf(permitFloor.getNumber().intValue()));
                            comparisonReportFloorDetails.add(comparisonReportFloorDetail);
                        }
                        blockDetail.setComparisonReportFloorDetails(comparisonReportFloorDetails);
                    }
                    BigDecimal noOfFloorsPermit = permitBuilding.getFloorsAboveGround();
                    buildingHeight = permitBuilding.getBuildingHeight();
                    blockDetail.setNoOfFloorsPermit(Long.valueOf(noOfFloorsPermit.toString()));
                    blockDetail.setHgtFromGroundPermit((BigDecimal)buildingHeight);
                }
                blockDetails.add(blockDetail);
            }
        }
        return blockDetails;
    }

    private BigDecimal getDeviation(BigDecimal ocValue, BigDecimal permitValue) {
        BigDecimal numerator = ocValue.subtract(permitValue).multiply(BigDecimal.valueOf(100L));
        BigDecimal finalValue = permitValue.compareTo(BigDecimal.ZERO) > 0 ? numerator.divide(permitValue, 2, DcrConstants.ROUNDMODE_MEASUREMENTS) : numerator;
        return finalValue;
    }

    private List<ScrutinyDetail> buildReportObject(List<OcComparisonBlockDetail> ocComparison) {
        ArrayList<ScrutinyDetail> scrutinyDetails = new ArrayList<ScrutinyDetail>();
        for (OcComparisonBlockDetail blockDetail : ocComparison) {
            HashMap<String, String> floorNos = new HashMap<String, String>();
            HashMap<String, String> bldngHgts = new HashMap<String, String>();
            ScrutinyDetail bltUpAreaSd = new ScrutinyDetail();
            bltUpAreaSd.setKey("Block_" + blockDetail.getNumber() + "_BuiltUp Area");
            bltUpAreaSd.addColumnHeading(Integer.valueOf(1), "Floor");
            bltUpAreaSd.addColumnHeading(Integer.valueOf(2), "Oc built up area");
            bltUpAreaSd.addColumnHeading(Integer.valueOf(3), "Permit built up area");
            bltUpAreaSd.addColumnHeading(Integer.valueOf(4), "Deviation in %");
            bltUpAreaSd.addColumnHeading(Integer.valueOf(5), STATUS);
            ScrutinyDetail floorAreaSd = new ScrutinyDetail();
            floorAreaSd.setKey("Block_" + blockDetail.getNumber() + "_Floor Area");
            floorAreaSd.addColumnHeading(Integer.valueOf(1), "Floor");
            floorAreaSd.addColumnHeading(Integer.valueOf(2), "Oc floor area");
            floorAreaSd.addColumnHeading(Integer.valueOf(3), "Permit floor area");
            floorAreaSd.addColumnHeading(Integer.valueOf(4), "Deviation in %");
            floorAreaSd.addColumnHeading(Integer.valueOf(5), STATUS);
            ScrutinyDetail crptAreaSd = new ScrutinyDetail();
            crptAreaSd.setKey("Block_" + blockDetail.getNumber() + "_Carpet Area");
            crptAreaSd.addColumnHeading(Integer.valueOf(1), "Floor");
            crptAreaSd.addColumnHeading(Integer.valueOf(2), "Oc carpet area");
            crptAreaSd.addColumnHeading(Integer.valueOf(3), "Permit carpet area");
            crptAreaSd.addColumnHeading(Integer.valueOf(4), "Deviation in %");
            crptAreaSd.addColumnHeading(Integer.valueOf(5), STATUS);
            ScrutinyDetail floors = new ScrutinyDetail();
            floors.setKey("Block_" + blockDetail.getNumber() + "_Number of Floors");
            floors.addColumnHeading(Integer.valueOf(1), "Oc Floors");
            floors.addColumnHeading(Integer.valueOf(2), "Permit Floors");
            floors.addColumnHeading(Integer.valueOf(3), STATUS);
            floorNos.put("Oc Floors", blockDetail.getNoOfFloorsOc().toString());
            floorNos.put("Permit Floors", blockDetail.getNoOfFloorsPermit().toString());
            floorNos.put(STATUS, blockDetail.getNoOfFloorsOc() > blockDetail.getNoOfFloorsPermit() ? Result.Not_Accepted.getResultVal() : Result.Accepted.getResultVal());
            floors.getDetail().add(floorNos);
            ScrutinyDetail bldngHgt = new ScrutinyDetail();
            bldngHgt.setKey("Block_" + blockDetail.getNumber() + "_Height of building");
            bldngHgt.addColumnHeading(Integer.valueOf(1), "Oc building height");
            bldngHgt.addColumnHeading(Integer.valueOf(2), "Permit building height");
            bldngHgt.addColumnHeading(Integer.valueOf(3), STATUS);
            bldngHgts.put("Oc building height", blockDetail.getHghtFromGroundOc().toString() + "m");
            bldngHgts.put("Permit building height", blockDetail.getHgtFromGroundPermit().toString() + "m");
            bldngHgts.put(STATUS, blockDetail.getHghtFromGroundOc().compareTo(blockDetail.getHgtFromGroundPermit()) > 0 ? Result.Not_Accepted.getResultVal() : Result.Accepted.getResultVal());
            bldngHgt.getDetail().add(bldngHgts);
            List comparisonReportFloorDetails = blockDetail.getComparisonReportFloorDetails();
            if (!comparisonReportFloorDetails.isEmpty()) {
                for (OcComparisonReportFloorDetail floor : comparisonReportFloorDetails) {
                    HashMap<String, String> bltUpAreaDetails = new HashMap<String, String>();
                    HashMap<String, String> flrAreaDetails = new HashMap<String, String>();
                    HashMap<String, String> crptAreaDetails = new HashMap<String, String>();
                    bltUpAreaDetails.put("Floor", floor.getNumber().toString());
                    bltUpAreaDetails.put("Oc built up area", floor.getOcBltUpArea().toString() + "m\u00b2");
                    bltUpAreaDetails.put("Permit built up area", floor.getPermitBltUpArea().toString() + "m\u00b2");
                    BigDecimal bltUpAreaDeviation = floor.getBltUpAreaDeviation();
                    bltUpAreaDetails.put("Deviation in %", bltUpAreaDeviation.toString());
                    bltUpAreaDetails.put(STATUS, bltUpAreaDeviation.compareTo(DEVIATION_VALUE) > 0 ? Result.Not_Accepted.getResultVal() : Result.Accepted.getResultVal());
                    bltUpAreaSd.getDetail().add(bltUpAreaDetails);
                    flrAreaDetails.put("Floor", floor.getNumber().toString());
                    flrAreaDetails.put("Oc floor area", floor.getOcFloorArea().toString() + "m\u00b2");
                    flrAreaDetails.put("Permit floor area", floor.getPermitFloorArea().toString() + "m\u00b2");
                    BigDecimal flrAreaDeviation = floor.getFloorAreaDeviation();
                    flrAreaDetails.put("Deviation in %", flrAreaDeviation.toString());
                    flrAreaDetails.put(STATUS, flrAreaDeviation.compareTo(DEVIATION_VALUE) > 0 ? Result.Not_Accepted.getResultVal() : Result.Accepted.getResultVal());
                    floorAreaSd.getDetail().add(flrAreaDetails);
                    crptAreaDetails.put("Floor", floor.getNumber().toString());
                    crptAreaDetails.put("Oc carpet area", floor.getOcCarpetArea().toString() + "m\u00b2");
                    crptAreaDetails.put("Permit carpet area", floor.getPermitCarpetArea().toString() + "m\u00b2");
                    BigDecimal crptAreaDeviation = floor.getCarpetAreaDeviation();
                    crptAreaDetails.put("Deviation in %", crptAreaDeviation.toString());
                    crptAreaDetails.put(STATUS, crptAreaDeviation.compareTo(DEVIATION_VALUE) > 0 ? Result.Not_Accepted.getResultVal() : Result.Accepted.getResultVal());
                    crptAreaSd.getDetail().add(crptAreaDetails);
                }
            }
            scrutinyDetails.add(bltUpAreaSd);
            scrutinyDetails.add(floorAreaSd);
            scrutinyDetails.add(crptAreaSd);
            scrutinyDetails.add(floors);
            scrutinyDetails.add(bldngHgt);
        }
        return scrutinyDetails;
    }

    private String buildQRCodeDetails(EdcrApplication dcrApplication, boolean reportStatus) {
        StringBuilder qrCodeValue = new StringBuilder();
        qrCodeValue = !StringUtils.isEmpty((CharSequence)dcrApplication.getEdcrApplicationDetails().get(0).getDcrNumber()) ? qrCodeValue.append("OCDCR Number : ").append(dcrApplication.getEdcrApplicationDetails().get(0).getDcrNumber()).append("\n") : qrCodeValue.append("OCDCR Number : ").append("N/A").append("\n");
        qrCodeValue = !StringUtils.isEmpty((CharSequence)dcrApplication.getApplicationNumber()) ? qrCodeValue.append("Application Number : ").append(dcrApplication.getApplicationNumber()).append("\n") : qrCodeValue.append("Application Number : ").append("N/A").append("\n");
        qrCodeValue = dcrApplication.getApplicationDate() != null ? qrCodeValue.append("Application Date : ").append(DateUtils.toDefaultDateFormat((Date)dcrApplication.getApplicationDate())).append("\n") : qrCodeValue.append("Application Date : ").append("N/A").append("\n");
        String applicationTypeVal = dcrApplication.getApplicationType().getApplicationTypeVal();
        qrCodeValue = qrCodeValue.append("Application Type : ").append(applicationTypeVal).append("\n");
        if (ApplicationType.OCCUPANCY_CERTIFICATE.getApplicationTypeVal().equalsIgnoreCase(applicationTypeVal)) {
            qrCodeValue = qrCodeValue.append("Applicant Name : ").append(dcrApplication.getApplicantName()).append("\n");
        }
        ConcurrentHashMap<String, String> serviceTypeList = new ConcurrentHashMap<String, String>();
        serviceTypeList.put("NEW_CONSTRUCTION", "New Construction");
        if (StringUtils.isNotBlank((CharSequence)dcrApplication.getServiceType())) {
            String serviceType = (String)serviceTypeList.get(dcrApplication.getServiceType());
            qrCodeValue = qrCodeValue.append("Service Type : ").append(serviceType).append("\n");
        }
        qrCodeValue = qrCodeValue.append("Report Status :").append(reportStatus ? "Accepted" : "Not Accepted").append("\n");
        return qrCodeValue.toString();
    }

    private List<ConditionalStyle> getConditonalStyles() {
        ArrayList<ConditionalStyle> conditionalStyles = new ArrayList<ConditionalStyle>();
        FetchCondition fc = new FetchCondition(STATUS, "Not Accepted");
        ConditionalStyle cs = new ConditionalStyle((ConditionStyleExpression)fc, this.reportService.getDetailStyle(Color.RED));
        conditionalStyles.add(cs);
        fc = new FetchCondition(STATUS, "Accepted");
        cs = new ConditionalStyle((ConditionStyleExpression)fc, this.reportService.getDetailStyle(new Color(0, 128, 0)));
        conditionalStyles.add(cs);
        fc = new FetchCondition(STATUS, "Verify");
        cs = new ConditionalStyle((ConditionStyleExpression)fc, this.reportService.getDetailStyle(new Color(30, 144, 255)));
        conditionalStyles.add(cs);
        return conditionalStyles;
    }
}

