/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.egov.common.entity.dcr.helper.ErrorDetail;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.PlanInformation;
import org.egov.commons.mdms.config.MdmsConfiguration;
import org.egov.edcr.config.properties.EdcrApplicationSettings;
import org.egov.edcr.contract.EdcrDetail;
import org.egov.edcr.contract.EdcrRequest;
import org.egov.edcr.entity.ApplicationType;
import org.egov.edcr.entity.EdcrApplication;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.service.EdcrApplicationDetailService;
import org.egov.edcr.service.EdcrApplicationService;
import org.egov.edcr.service.OcComparisonService;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.microservice.contract.RequestInfoWrapper;
import org.egov.infra.microservice.contract.ResponseInfo;
import org.egov.infra.microservice.models.RequestInfo;
import org.egov.infra.microservice.models.UserInfo;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.TenantUtils;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class EdcrRestService {
    private static final String MSG_UNQ_TRANSACTION_NUMBER = "Transaction Number should be unique";
    private static final String REQ_BODY_REQUIRED = "Required request body is missing";
    private static final String USER_ID_IS_MANDATORY = "User id is mandatory";
    private static final String BPA_01 = "BPA-01";
    private static final String BPA_07 = "BPA-07";
    private static final String BPA_05 = "BPA-05";
    private static Logger LOG = Logger.getLogger(EdcrApplicationService.class);
    public static final String FILE_DOWNLOAD_URL = "%s/edcr/rest/dcr/downloadfile/";
    @Autowired
    protected SecurityUtils securityUtils;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EdcrApplicationSettings edcrApplicationSettings;
    @Autowired
    private EdcrApplicationService edcrApplicationService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private TenantUtils tenantUtils;
    @Autowired
    private CityService cityService;
    @Autowired
    private MdmsConfiguration mdmsConfiguration;
    @Autowired
    private OcComparisonService ocComparisonService;
    @Autowired
    private EdcrApplicationDetailService applicationDetailService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public EdcrDetail createEdcr(EdcrRequest edcrRequest, MultipartFile file, Map<String, List<Object>> masterData) {
        EdcrApplication edcrApplication = new EdcrApplication();
        edcrApplication.setMdmsMasterData(masterData);
        EdcrApplicationDetail edcrApplicationDetail = new EdcrApplicationDetail();
        if (ApplicationType.OCCUPANCY_CERTIFICATE.toString().equalsIgnoreCase(edcrRequest.getAppliactionType())) {
            edcrApplicationDetail.setComparisonDcrNumber(edcrRequest.getComparisonEdcrNumber());
        }
        ArrayList<EdcrApplicationDetail> edcrApplicationDetails = new ArrayList<EdcrApplicationDetail>();
        edcrApplicationDetails.add(edcrApplicationDetail);
        edcrApplication.setTransactionNumber(edcrRequest.getTransactionNumber());
        if (StringUtils.isNotBlank((CharSequence)edcrRequest.getApplicantName())) {
            edcrApplication.setApplicantName(edcrRequest.getApplicantName());
        } else {
            edcrApplication.setApplicantName("ANONYMOUS");
        }
        edcrApplication.setArchitectInformation("ANONYMOUS");
        edcrApplication.setServiceType(edcrRequest.getApplicationSubType());
        if (edcrRequest.getAppliactionType() == null) {
            edcrApplication.setApplicationType(ApplicationType.PERMIT);
        } else {
            edcrApplication.setApplicationType(ApplicationType.valueOf(edcrRequest.getAppliactionType()));
        }
        if (edcrRequest.getPermitNumber() != null) {
            edcrApplication.setPlanPermitNumber(edcrRequest.getPermitNumber());
        }
        if (edcrRequest.getPermitDate() != null) {
            edcrApplication.setApplicationDate(edcrRequest.getPermitDate());
            edcrApplication.setPermitApplicationDate(edcrRequest.getPermitDate());
        }
        edcrApplication.setEdcrApplicationDetails(edcrApplicationDetails);
        edcrApplication.setDxfFile(file);
        if (edcrRequest.getRequestInfo() != null && edcrRequest.getRequestInfo().getUserInfo() != null) {
            edcrApplication.setThirdPartyUserCode(StringUtils.isNotBlank((CharSequence)edcrRequest.getRequestInfo().getUserInfo().getId()) ? edcrRequest.getRequestInfo().getUserInfo().getId() : "");
            edcrApplication.setThirdPartyUserTenant(StringUtils.isNotBlank((CharSequence)edcrRequest.getTenantId()) ? edcrRequest.getTenantId() : edcrRequest.getRequestInfo().getUserInfo().getTenantId());
        }
        edcrApplication = this.edcrApplicationService.createRestEdcr(edcrApplication);
        return this.setEdcrResponse(edcrApplication.getEdcrApplicationDetails().get(0), edcrRequest);
    }

    @Transactional
    public List<EdcrDetail> edcrDetailsResponse(List<EdcrApplicationDetail> edcrApplications, EdcrRequest edcrRequest) {
        ArrayList<EdcrDetail> edcrDetails = new ArrayList<EdcrDetail>();
        for (EdcrApplicationDetail edcrApp : edcrApplications) {
            edcrDetails.add(this.setEdcrResponse(edcrApp, edcrRequest));
        }
        return edcrDetails;
    }

    public EdcrDetail setEdcrResponse(EdcrApplicationDetail edcrApplnDtl, EdcrRequest edcrRequest) {
        File file;
        ApplicationType applicationType;
        EdcrDetail edcrDetail = new EdcrDetail();
        ArrayList<String> planPdfs = new ArrayList<String>();
        edcrDetail.setTransactionNumber(edcrApplnDtl.getApplication().getTransactionNumber());
        LOG.info((Object)("edcr number == " + edcrApplnDtl.getDcrNumber()));
        edcrDetail.setEdcrNumber(edcrApplnDtl.getDcrNumber());
        edcrDetail.setStatus(edcrApplnDtl.getStatus());
        LOG.info((Object)("application number ==" + edcrApplnDtl.getApplication().getApplicationNumber()));
        edcrDetail.setApplicationNumber(edcrApplnDtl.getApplication().getApplicationNumber());
        edcrDetail.setApplicationDate(edcrApplnDtl.getApplication().getApplicationDate());
        if (edcrApplnDtl.getApplication().getPlanPermitNumber() != null) {
            edcrDetail.setPermitNumber(edcrApplnDtl.getApplication().getPlanPermitNumber());
        }
        if (edcrApplnDtl.getApplication().getPermitApplicationDate() != null) {
            edcrDetail.setPermitDate(edcrApplnDtl.getApplication().getPermitApplicationDate());
        }
        if ((applicationType = edcrApplnDtl.getApplication().getApplicationType()) != null) {
            Boolean mdmsEnabled = this.mdmsConfiguration.getMdmsEnabled();
            if (mdmsEnabled != null && mdmsEnabled.booleanValue()) {
                if (ApplicationType.PERMIT.getApplicationTypeVal().equalsIgnoreCase(edcrApplnDtl.getApplication().getApplicationType().getApplicationTypeVal())) {
                    edcrDetail.setAppliactionType("BUILDING_PLAN_SCRUTINY");
                } else {
                    edcrDetail.setAppliactionType("BUILDING_OC_PLAN_SCRUTINY");
                }
            } else {
                edcrDetail.setAppliactionType(applicationType.getApplicationTypeVal());
            }
        }
        if (edcrApplnDtl.getApplication().getServiceType() != null) {
            edcrDetail.setApplicationSubType(edcrApplnDtl.getApplication().getServiceType());
        }
        if (edcrApplnDtl.getDxfFileId() != null) {
            edcrDetail.setDxfFile(String.format(this.getFileDownloadUrl(edcrApplnDtl.getDxfFileId().getFileStoreId(), ApplicationThreadLocals.getTenantID()), new Object[0]));
        }
        if (edcrApplnDtl.getScrutinizedDxfFileId() != null) {
            edcrDetail.setUpdatedDxfFile(String.format(this.getFileDownloadUrl(edcrApplnDtl.getScrutinizedDxfFileId().getFileStoreId(), ApplicationThreadLocals.getTenantID()), new Object[0]));
        }
        if (edcrApplnDtl.getReportOutputId() != null) {
            edcrDetail.setPlanReport(String.format(this.getFileDownloadUrl(edcrApplnDtl.getReportOutputId().getFileStoreId(), ApplicationThreadLocals.getTenantID()), new Object[0]));
        }
        File file2 = file = edcrApplnDtl.getPlanDetailFileStore() != null ? this.fileStoreService.fetch(edcrApplnDtl.getPlanDetailFileStore().getFileStoreId(), "Digit DCR") : null;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("**************** End - Reading Plan detail file **************" + file));
        }
        try {
            if (file == null) {
                Plan pl1 = new Plan();
                PlanInformation pi = new PlanInformation();
                pi.setApplicantName(edcrApplnDtl.getApplication().getApplicantName());
                pl1.setPlanInformation(pi);
                edcrDetail.setPlanDetail(pl1);
            } else {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                Plan pl1 = (Plan)mapper.readValue(file, Plan.class);
                pl1.getPlanInformation().setApplicantName(edcrApplnDtl.getApplication().getApplicantName());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("**************** Plan detail object **************" + pl1));
                }
                edcrDetail.setPlanDetail(pl1);
            }
        }
        catch (IOException e) {
            LOG.log((Priority)Level.ERROR, (Object)e);
        }
        if (edcrApplnDtl.getDxfFileId() != null) {
            planPdfs.add(String.format(this.getFileDownloadUrl(edcrApplnDtl.getDxfFileId().getFileStoreId(), ApplicationThreadLocals.getTenantID()), new Object[0]));
        }
        if (edcrApplnDtl.getReportOutputId() != null) {
            planPdfs.add(String.format(this.getFileDownloadUrl(edcrApplnDtl.getReportOutputId().getFileStoreId(), ApplicationThreadLocals.getTenantID()), new Object[0]));
        }
        edcrDetail.setPlanPdfs(planPdfs);
        edcrDetail.setTenantId(edcrRequest.getTenantId());
        if (StringUtils.isNotBlank((CharSequence)edcrRequest.getComparisonEdcrNumber())) {
            edcrDetail.setComparisonEdcrNumber(edcrRequest.getComparisonEdcrNumber());
        }
        if (!edcrApplnDtl.getStatus().equalsIgnoreCase("Accepted")) {
            edcrDetail.setStatus(edcrApplnDtl.getStatus());
        }
        return edcrDetail;
    }

    public EdcrDetail setEdcrResponseForAcrossTenants(Object[] applnDtls, String stateCityCode) {
        EdcrDetail edcrDetail = new EdcrDetail();
        edcrDetail.setTransactionNumber(String.valueOf(applnDtls[1]));
        edcrDetail.setEdcrNumber(String.valueOf(applnDtls[2]));
        edcrDetail.setStatus(String.valueOf(applnDtls[3]));
        edcrDetail.setApplicationDate(new LocalDate((Object)String.valueOf(applnDtls[9])).toDate());
        edcrDetail.setApplicationNumber(String.valueOf(applnDtls[10]));
        if (String.valueOf(applnDtls[5]) != null) {
            edcrDetail.setDxfFile(String.format(this.getFileDownloadUrl(String.valueOf(applnDtls[5]), String.valueOf(applnDtls[0])), new Object[0]));
        }
        if (String.valueOf(applnDtls[6]) != null) {
            edcrDetail.setUpdatedDxfFile(String.format(this.getFileDownloadUrl(String.valueOf(applnDtls[6]), String.valueOf(applnDtls[0])), new Object[0]));
        }
        if (String.valueOf(applnDtls[7]) != null) {
            edcrDetail.setPlanReport(String.format(this.getFileDownloadUrl(String.valueOf(applnDtls[7]), String.valueOf(applnDtls[0])), new Object[0]));
        }
        Plan pl1 = new Plan();
        PlanInformation pi = new PlanInformation();
        pi.setApplicantName(String.valueOf(applnDtls[4]));
        pl1.setPlanInformation(pi);
        edcrDetail.setPlanDetail(pl1);
        edcrDetail.setTenantId(stateCityCode.concat(".").concat(String.valueOf(applnDtls[0])));
        if (!String.valueOf(applnDtls[3]).equalsIgnoreCase("Accepted")) {
            edcrDetail.setStatus(String.valueOf(applnDtls[3]));
        }
        return edcrDetail;
    }

    public List<EdcrDetail> fetchEdcr(EdcrRequest edcrRequest, RequestInfoWrapper reqInfoWrapper) {
        List<EdcrApplicationDetail> edcrApplications = new ArrayList();
        UserInfo userInfo = reqInfoWrapper.getRequestInfo() == null ? null : reqInfoWrapper.getRequestInfo().getUserInfo();
        boolean onlyTenantId = edcrRequest != null && StringUtils.isBlank((CharSequence)edcrRequest.getEdcrNumber()) && StringUtils.isBlank((CharSequence)edcrRequest.getTransactionNumber()) && StringUtils.isBlank((CharSequence)edcrRequest.getAppliactionType()) && StringUtils.isBlank((CharSequence)edcrRequest.getApplicationSubType()) && StringUtils.isNotBlank((CharSequence)edcrRequest.getTenantId());
        City stateCity = this.cityService.fetchStateCityDetails();
        if (edcrRequest != null && edcrRequest.getTenantId().equalsIgnoreCase(stateCity.getCode())) {
            ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
            Map tenants = this.tenantUtils.tenantsMap();
            StringBuilder queryStr = new StringBuilder();
            Iterator tenantItr = tenants.entrySet().iterator();
            while (tenantItr.hasNext()) {
                Object appliactionType;
                Map.Entry value = tenantItr.next();
                queryStr.append("(select '").append((String)value.getKey()).append("' as tenantId,appln.transactionNumber,dtl.dcrNumber,dtl.status,appln.applicantName,dxf.fileStoreId as dxfFileId,scrudxf.fileStoreId as scrutinizedDxfFileId,rofile.fileStoreId as reportOutputId,pdfile.fileStoreId as planDetailFileStore,appln.applicationDate,appln.applicationNumber from ").append((String)value.getKey()).append(".edcr_application appln, ").append((String)value.getKey()).append(".edcr_application_detail dtl, ").append((String)value.getKey()).append(".eg_filestoremap dxf, ").append((String)value.getKey()).append(".eg_filestoremap scrudxf, ").append((String)value.getKey()).append(".eg_filestoremap rofile, ").append((String)value.getKey()).append(".eg_filestoremap pdfile ").append("where appln.id = dtl.application and dtl.dxfFileId=dxf.id and dtl.scrutinizedDxfFileId=scrudxf.id and dtl.reportOutputId=rofile.id and dtl.planDetailFileStore=pdfile.id ");
                if (StringUtils.isNotBlank((CharSequence)edcrRequest.getEdcrNumber())) {
                    queryStr.append("and dtl.dcrNumber=:dcrNumber ");
                    params.put("dcrNumber", edcrRequest.getEdcrNumber());
                }
                if (StringUtils.isNotBlank((CharSequence)edcrRequest.getTransactionNumber())) {
                    queryStr.append("and appln.transactionNumber=:transactionNumber ");
                    params.put("transactionNumber", edcrRequest.getTransactionNumber());
                }
                if (onlyTenantId && userInfo != null && StringUtils.isNotBlank((CharSequence)userInfo.getId())) {
                    queryStr.append("and appln.thirdPartyUserCode=:thirdPartyUserCode ");
                    params.put("thirdPartyUserCode", userInfo.getId());
                }
                if (StringUtils.isNotBlank((CharSequence)(appliactionType = edcrRequest.getAppliactionType()))) {
                    ApplicationType applicationType = null;
                    if ("BUILDING_PLAN_SCRUTINY".equalsIgnoreCase((String)appliactionType)) {
                        applicationType = ApplicationType.PERMIT;
                    } else if ("BUILDING_OC_PLAN_SCRUTINY".equalsIgnoreCase((String)appliactionType)) {
                        applicationType = ApplicationType.OCCUPANCY_CERTIFICATE;
                    } else if ("Permit".equalsIgnoreCase((String)appliactionType)) {
                        applicationType = ApplicationType.PERMIT;
                    } else if ("Occupancy certificate".equalsIgnoreCase((String)appliactionType)) {
                        applicationType = ApplicationType.OCCUPANCY_CERTIFICATE;
                    }
                    queryStr.append("and appln.applicationType=:applicationtype ");
                    params.put("applicationtype", applicationType.toString());
                }
                if (StringUtils.isNotBlank((CharSequence)edcrRequest.getApplicationSubType())) {
                    queryStr.append("and appln.serviceType=:servicetype ");
                    params.put("servicetype", edcrRequest.getApplicationSubType());
                }
                queryStr.append(" order by appln.createddate desc)");
                if (!tenantItr.hasNext()) continue;
                queryStr.append(" union ");
            }
            SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
            for (Map.Entry param : params.entrySet()) {
                query.setParameter((String)param.getKey(), param.getValue());
            }
            List applns = query.list();
            if (applns.isEmpty()) {
                EdcrDetail edcrDetail = new EdcrDetail();
                edcrDetail.setErrors("No Record Found");
                return Arrays.asList(edcrDetail);
            }
            ArrayList<EdcrDetail> edcrDetails2 = new ArrayList<EdcrDetail>();
            for (Object[] appln : applns) {
                edcrDetails2.add(this.setEdcrResponseForAcrossTenants(appln, stateCity.getCode()));
            }
            return edcrDetails2;
        }
        Criteria criteria = this.getCurrentSession().createCriteria(EdcrApplicationDetail.class, "edcrApplicationDetail");
        criteria.createAlias("edcrApplicationDetail.application", "application");
        if (edcrRequest != null && StringUtils.isNotBlank((CharSequence)edcrRequest.getEdcrNumber())) {
            criteria.add((Criterion)Restrictions.eq((String)"edcrApplicationDetail.dcrNumber", (Object)edcrRequest.getEdcrNumber()));
        }
        if (edcrRequest != null && StringUtils.isNotBlank((CharSequence)edcrRequest.getTransactionNumber())) {
            criteria.add((Criterion)Restrictions.eq((String)"application.transactionNumber", (Object)edcrRequest.getTransactionNumber()));
        }
        String appliactionType = edcrRequest.getAppliactionType();
        if (edcrRequest != null && StringUtils.isNotBlank((CharSequence)appliactionType)) {
            ApplicationType applicationType = null;
            if ("BUILDING_PLAN_SCRUTINY".equalsIgnoreCase(appliactionType)) {
                applicationType = ApplicationType.PERMIT;
            } else if ("BUILDING_OC_PLAN_SCRUTINY".equalsIgnoreCase(appliactionType)) {
                applicationType = ApplicationType.OCCUPANCY_CERTIFICATE;
            }
            if ("Permit".equalsIgnoreCase(appliactionType)) {
                applicationType = ApplicationType.PERMIT;
            } else if ("Occupancy certificate".equalsIgnoreCase(appliactionType)) {
                applicationType = ApplicationType.OCCUPANCY_CERTIFICATE;
            }
            criteria.add((Criterion)Restrictions.eq((String)"application.applicationType", (Object)((Object)applicationType)));
        }
        if (edcrRequest != null && StringUtils.isNotBlank((CharSequence)edcrRequest.getApplicationSubType())) {
            criteria.add((Criterion)Restrictions.eq((String)"application.serviceType", (Object)edcrRequest.getApplicationSubType()));
        }
        if (onlyTenantId && userInfo != null && StringUtils.isNotBlank((CharSequence)userInfo.getId())) {
            criteria.add((Criterion)Restrictions.eq((String)"application.thirdPartyUserCode", (Object)userInfo.getId()));
        }
        criteria.addOrder(Order.asc((String)"edcrApplicationDetail.createdDate"));
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        edcrApplications = criteria.list();
        LOG.info((Object)("The number of records = " + edcrApplications.size()));
        if (edcrApplications.isEmpty()) {
            EdcrDetail edcrDetail = new EdcrDetail();
            edcrDetail.setErrors("No Record Found");
            return Arrays.asList(edcrDetail);
        }
        return this.edcrDetailsResponse(edcrApplications, edcrRequest);
    }

    public ErrorDetail validatePlanFile(MultipartFile file) {
        String fileSize;
        ArrayList<String> dcrAllowedExtenstions = new ArrayList<String>(Arrays.asList(this.edcrApplicationSettings.getValue("dcr.dxf.allowed.extenstions").split(",")));
        String maxAllowSizeInMB = fileSize = this.edcrApplicationSettings.getValue("dcr.dxf.max.size");
        if (file != null && !file.isEmpty()) {
            String extension = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(46) + 1);
            if (extension != null && !extension.isEmpty()) {
                if (!dcrAllowedExtenstions.contains(extension.toLowerCase())) {
                    return new ErrorDetail("BPA-02", "Please upload " + dcrAllowedExtenstions + " format file only");
                }
                if (file.getSize() > Long.valueOf(maxAllowSizeInMB) * 1024L * 1024L) {
                    return new ErrorDetail("BPA-04", "File size should not exceed 30 MB");
                }
            }
        } else {
            return new ErrorDetail(BPA_05, "Please upload plan file, It is mandatory");
        }
        return null;
    }

    public ErrorDetail validateEdcrRequest(EdcrRequest edcrRequest, MultipartFile planFile) {
        if (edcrRequest.getRequestInfo() == null) {
            return new ErrorDetail(BPA_07, REQ_BODY_REQUIRED);
        }
        if (edcrRequest.getRequestInfo().getUserInfo() == null || edcrRequest.getRequestInfo().getUserInfo() != null && StringUtils.isBlank((CharSequence)edcrRequest.getRequestInfo().getUserInfo().getId())) {
            return new ErrorDetail(BPA_07, USER_ID_IS_MANDATORY);
        }
        if (StringUtils.isBlank((CharSequence)edcrRequest.getTransactionNumber())) {
            return new ErrorDetail(BPA_07, "Please enter transaction number");
        }
        if (StringUtils.isNotBlank((CharSequence)edcrRequest.getTransactionNumber()) && this.edcrApplicationService.findByTransactionNumber(edcrRequest.getTransactionNumber()) != null) {
            return new ErrorDetail(BPA_01, MSG_UNQ_TRANSACTION_NUMBER);
        }
        return this.validatePlanFile(planFile);
    }

    public ErrorDetail validateEdcrOcRequest(EdcrRequest edcrRequest, MultipartFile planFile) {
        if (edcrRequest.getRequestInfo() == null) {
            return new ErrorDetail(BPA_07, REQ_BODY_REQUIRED);
        }
        if (edcrRequest.getRequestInfo().getUserInfo() == null || edcrRequest.getRequestInfo().getUserInfo() != null && StringUtils.isBlank((CharSequence)edcrRequest.getRequestInfo().getUserInfo().getId())) {
            return new ErrorDetail(BPA_07, USER_ID_IS_MANDATORY);
        }
        if (StringUtils.isBlank((CharSequence)edcrRequest.getTransactionNumber())) {
            return new ErrorDetail(BPA_07, "Transaction number is mandatory");
        }
        if (null == edcrRequest.getPermitDate()) {
            return new ErrorDetail("BPA-08", "Permit Date is mandatory");
        }
        if (StringUtils.isNotBlank((CharSequence)edcrRequest.getTransactionNumber()) && this.edcrApplicationService.findByTransactionNumber(edcrRequest.getTransactionNumber()) != null) {
            return new ErrorDetail(BPA_01, MSG_UNQ_TRANSACTION_NUMBER);
        }
        return this.validatePlanFile(planFile);
    }

    public List<ErrorDetail> validateScrutinizeOcRequest(EdcrRequest edcrRequest, MultipartFile planFile) {
        String dcrNo;
        ArrayList<ErrorDetail> errorDetails = new ArrayList<ErrorDetail>();
        if (edcrRequest.getRequestInfo() == null) {
            errorDetails.add(new ErrorDetail(BPA_07, REQ_BODY_REQUIRED));
        } else if (edcrRequest.getRequestInfo().getUserInfo() == null || edcrRequest.getRequestInfo().getUserInfo() != null && StringUtils.isBlank((CharSequence)edcrRequest.getRequestInfo().getUserInfo().getId())) {
            errorDetails.add(new ErrorDetail("BPA-08", USER_ID_IS_MANDATORY));
        }
        if (StringUtils.isBlank((CharSequence)edcrRequest.getTransactionNumber())) {
            errorDetails.add(new ErrorDetail("BPA-09", "Transaction number is mandatory"));
        }
        if (null == edcrRequest.getPermitDate()) {
            errorDetails.add(new ErrorDetail("BPA-10", "Permit Date is mandatory"));
        }
        if (StringUtils.isNotBlank((CharSequence)edcrRequest.getTransactionNumber()) && this.edcrApplicationService.findByTransactionNumber(edcrRequest.getTransactionNumber()) != null) {
            errorDetails.add(new ErrorDetail("BPA-11", MSG_UNQ_TRANSACTION_NUMBER));
        }
        if (StringUtils.isBlank((CharSequence)(dcrNo = edcrRequest.getComparisonEdcrNumber()))) {
            errorDetails.add(new ErrorDetail("BPA-29", "Comparison eDcr number is mandatory"));
        } else {
            EdcrApplicationDetail permitDcr = this.applicationDetailService.findByDcrNumberAndTPUserTenant(dcrNo, edcrRequest.getTenantId());
            if (permitDcr != null && permitDcr.getApplication() != null && StringUtils.isBlank((CharSequence)permitDcr.getApplication().getServiceType())) {
                errorDetails.add(new ErrorDetail("BPA-26", "No service type found for dcr number " + dcrNo));
            }
            if (permitDcr == null) {
                errorDetails.add(new ErrorDetail("BPA-24", "No record found with dcr number " + dcrNo));
            }
            if (permitDcr != null && permitDcr.getApplication() != null && edcrRequest.getAppliactionType().equalsIgnoreCase(permitDcr.getApplication().getApplicationType().toString())) {
                errorDetails.add(new ErrorDetail("BPA-27", "Application types are same"));
            }
            if (permitDcr != null && permitDcr.getApplication() != null && !edcrRequest.getApplicationSubType().equalsIgnoreCase(permitDcr.getApplication().getServiceType())) {
                errorDetails.add(new ErrorDetail("BPA-28", "Service types are not mathing"));
            }
        }
        ErrorDetail validatePlanFile = this.validatePlanFile(planFile);
        if (validatePlanFile != null) {
            errorDetails.add(validatePlanFile);
        }
        return errorDetails;
    }

    public List<ErrorDetail> validateEdcrMandatoryFields(EdcrRequest edcrRequest) {
        ArrayList<ErrorDetail> errors = new ArrayList<ErrorDetail>();
        if (StringUtils.isBlank((CharSequence)edcrRequest.getAppliactionType())) {
            errors.add(new ErrorDetail("BPA-10", "Application type is missing"));
        }
        if (StringUtils.isBlank((CharSequence)edcrRequest.getApplicationSubType())) {
            errors.add(new ErrorDetail("BPA-11", "Service type is missing"));
        }
        return errors;
    }

    public ErrorDetail validateSearchRequest(String edcrNumber, String transactionNumber) {
        ErrorDetail errorDetail = null;
        if (StringUtils.isBlank((CharSequence)edcrNumber) && StringUtils.isBlank((CharSequence)transactionNumber)) {
            return new ErrorDetail(BPA_07, "Please enter valid edcr number or transaction number");
        }
        return errorDetail;
    }

    public ErrorDetail validateParam(List<String> allowedExtenstions, List<String> mimeTypes, MultipartFile file, String maxAllowSizeInMB) {
        if (file != null && !file.isEmpty()) {
            String extension = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(46) + 1);
            if (extension != null && !extension.isEmpty()) {
                if (!allowedExtenstions.contains(extension.toLowerCase())) {
                    return new ErrorDetail("BPA-02", "Please upload " + allowedExtenstions + " format file only");
                }
                if (file.getSize() > Long.valueOf(maxAllowSizeInMB) * 1024L * 1024L) {
                    return new ErrorDetail("BPA-04", "File size should not exceed 30 MB");
                }
            }
        } else {
            return new ErrorDetail(BPA_05, "Please, upload plan file is mandatory");
        }
        return null;
    }

    public ResponseInfo createResponseInfoFromRequestInfo(RequestInfo requestInfo, Boolean success) {
        String apiId = null;
        String ver = null;
        String ts = null;
        String resMsgId = "";
        String msgId = null;
        if (requestInfo != null) {
            apiId = requestInfo.getApiId();
            ver = requestInfo.getVer();
            if (requestInfo.getTs() != null) {
                ts = requestInfo.getTs().toString();
            }
            msgId = requestInfo.getMsgId();
        }
        String responseStatus = success != false ? "successful" : "failed";
        return new ResponseInfo(apiId, ver, ts, resMsgId, msgId, responseStatus);
    }

    public String getFileDownloadUrl(String fileStoreId, String tenantId) {
        return String.format(FILE_DOWNLOAD_URL, ApplicationThreadLocals.getDomainURL()) + fileStoreId + "?tenantId=" + tenantId;
    }
}

