/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.egov.common.entity.dcr.helper.EdcrApplicationInfo;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.FloorDescription;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.Plan;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.service.EdcrApplicationDetailService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EdcrExternalService {
    private Logger LOG = Logger.getLogger(EdcrExternalService.class);
    private static final String SITE_PLAN = "Site_Plan";
    private static final String SERVICE_PLAN = "Service_Plan";
    private static final String PARKING_PLAN = "Parking_Plan";
    private static final String BUILDING_PLAN = "Building_Plan";
    private static final String TERRACE_PLAN = "Terrace_Plan";
    private static final String ROOF_PLAN = "Roof_Plan";
    private static final String ELEVATION_PLAN = "Elevation_Plans";
    private static final String SECTION_PLAN = "Section_Plans";
    private static final String DETAILS_PLAN = "Details_Plan";
    private static final String FLOOR_PLAN = "Floor_Plans";
    private static final String FLOOR_PLAN_ELEVTN_SECTN = "Floor_Plans,_Elevations,_Sections";
    @Autowired
    private EdcrApplicationDetailService edcrApplicationDetailService;
    @Autowired
    private FileStoreService fileStoreService;

    public EdcrApplicationInfo loadEdcrApplicationDetails(String eDcrNumber) {
        EdcrApplicationDetail applicationDetail = this.edcrApplicationDetailService.findByDcrNumber(eDcrNumber);
        return this.buildDcrApplicationDetails(applicationDetail);
    }

    public EdcrApplicationInfo buildDcrApplicationDetails(EdcrApplicationDetail applicationDetail) {
        EdcrApplicationInfo applicationInfo = new EdcrApplicationInfo();
        applicationInfo.seteDcrApplicationId(applicationDetail.getApplication().getId());
        applicationInfo.setApplicationDate(DateUtils.toDefaultDateFormat((Date)applicationDetail.getApplication().getApplicationDate()));
        applicationInfo.setCreatedDate(DateUtils.toDefaultDateTimeFormat((Date)applicationDetail.getApplication().getCreatedDate()));
        applicationInfo.setApplicationNumber(applicationDetail.getApplication().getApplicationNumber());
        applicationInfo.setDcrNumber(applicationDetail.getDcrNumber());
        applicationInfo.seteDcrApplicationId(applicationDetail.getApplication().getId());
        applicationInfo.setDxfFile(applicationDetail.getDxfFileId());
        applicationInfo.setReportOutput(applicationDetail.getReportOutputId());
        applicationInfo.setProjectType(applicationDetail.getApplication().getProjectType());
        applicationInfo.setApplicationType(applicationDetail.getApplication().getApplicationType().getApplicationTypeVal());
        applicationInfo.setPlanPermitNumber(applicationDetail.getApplication().getPlanPermitNumber());
        applicationInfo.setServiceType(applicationDetail.getApplication().getServiceType() == null ? "N/A" : applicationDetail.getApplication().getServiceType());
        applicationInfo.setOwnerName(applicationDetail.getApplication().getApplicantName() == null ? "N/A" : applicationDetail.getApplication().getApplicantName());
        if (applicationDetail.getPlanDetailFileStore() != null) {
            applicationInfo.setPlanDetailFileStore(applicationDetail.getPlanDetailFileStore().getId());
        }
        if (applicationDetail.getPlanDetailFileStore() == null) {
            this.edcrApplicationDetailService.buildBuildingDetailForApprovedPlans(applicationDetail, applicationInfo);
        } else {
            this.LOG.info((Object)"Before de-serialization....................");
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)"**************** Start - Reading Plan detail file **************");
            }
            File file = this.fileStoreService.fetch(applicationDetail.getPlanDetailFileStore().getFileStoreId(), "Digit DCR");
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)("**************** End - Reading Plan detail file **************" + file));
            }
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                Plan pl1 = (Plan)mapper.readValue(file, Plan.class);
                if (this.LOG.isInfoEnabled()) {
                    this.LOG.info((Object)("**************** Plan detail object **************" + pl1));
                }
                applicationInfo.setPlan(pl1);
            }
            catch (IOException e) {
                this.LOG.log((Priority)Level.ERROR, (Object)e);
            }
            this.LOG.debug((Object)"Completed de-serialization");
            if (applicationInfo.getPlan() != null) {
                for (Block b : applicationInfo.getPlan().getBlocks()) {
                    for (Floor f : b.getBuilding().getFloors()) {
                        f.setName(this.getFloorDescription(f));
                        for (Occupancy occupancy : f.getOccupancies()) {
                            occupancy.setBuiltUpArea(occupancy.getBuiltUpArea().subtract(occupancy.getExistingBuiltUpArea()));
                            occupancy.setFloorArea(occupancy.getFloorArea().subtract(occupancy.getExistingFloorArea()));
                            occupancy.setCarpetArea(occupancy.getCarpetArea().subtract(occupancy.getExistingCarpetArea()));
                        }
                    }
                    for (Occupancy actualOccupancy : b.getBuilding().getTotalArea()) {
                        actualOccupancy.setBuiltUpArea(actualOccupancy.getBuiltUpArea().subtract(actualOccupancy.getExistingBuiltUpArea()));
                        actualOccupancy.setFloorArea(actualOccupancy.getFloorArea().subtract(actualOccupancy.getExistingFloorArea()));
                        actualOccupancy.setCarpetArea(actualOccupancy.getCarpetArea().subtract(actualOccupancy.getExistingCarpetArea()));
                    }
                    b.getBuilding().setTotalBuitUpArea(b.getBuilding().getTotalBuitUpArea().subtract(b.getBuilding().getTotalExistingBuiltUpArea()));
                    b.getBuilding().setTotalFloorArea(b.getBuilding().getTotalBuitUpArea().subtract(b.getBuilding().getTotalExistingBuiltUpArea()));
                }
            }
        }
        if (applicationInfo.getPlan() != null && applicationInfo.getPlan().getPlanInformation() != null) {
            applicationInfo.setAmenities(applicationInfo.getPlan().getPlanInformation().getAmenities() == null ? "N/A" : applicationInfo.getPlan().getPlanInformation().getAmenities());
            applicationInfo.setOccupancy(applicationInfo.getPlan().getPlanInformation().getOccupancy() == null ? "N/A" : applicationInfo.getPlan().getPlanInformation().getOccupancy());
            applicationInfo.setArchitectInformation(applicationInfo.getPlan().getPlanInformation().getArchitectInformation() == null ? "N/A" : applicationInfo.getPlan().getPlanInformation().getArchitectInformation());
            applicationInfo.setPlotArea(applicationInfo.getPlan().getPlanInformation().getPlotArea() == null ? BigDecimal.ZERO : applicationInfo.getPlan().getPlanInformation().getPlotArea());
        } else {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)("**************** Error Occurred while de-serialization **************" + applicationDetail.getDcrNumber()));
            }
            if (applicationDetail.getApplication().getPlanInformation() != null) {
                applicationInfo.setAmenities(applicationDetail.getApplication().getPlanInformation().getAmenities() == null ? "N/A" : applicationDetail.getApplication().getPlanInformation().getAmenities());
                applicationInfo.setServiceType(applicationDetail.getApplication().getPlanInformation().getServiceType() == null ? "N/A" : applicationDetail.getApplication().getPlanInformation().getServiceType());
                applicationInfo.setOccupancy(applicationDetail.getApplication().getPlanInformation().getOccupancy() == null ? "N/A" : applicationInfo.getPlan().getPlanInformation().getOccupancy());
                applicationInfo.setArchitectInformation(applicationDetail.getApplication().getPlanInformation().getArchitectInformation() == null ? "N/A" : applicationDetail.getApplication().getPlanInformation().getArchitectInformation());
                applicationInfo.setPlotArea(applicationDetail.getApplication().getPlanInformation().getPlotArea() == null ? BigDecimal.ZERO : applicationDetail.getApplication().getPlanInformation().getPlotArea());
                applicationInfo.setOwnerName(applicationDetail.getApplication().getPlanInformation().getOwnerName() == null ? "N/A" : applicationDetail.getApplication().getPlanInformation().getOwnerName());
            }
        }
        return applicationInfo;
    }

    private String getFloorDescription(Floor floor) {
        String name = floor.getNumber() < 0 ? FloorDescription.CELLAR_FLOOR.getFloorDescriptionVal() : (floor.getNumber() > 0 && floor.getTerrace() != false ? FloorDescription.TERRACE_FLOOR.getFloorDescriptionVal() : (floor.getNumber() > 0 ? FloorDescription.UPPER_FLOOR.getFloorDescriptionVal() : FloorDescription.GROUND_FLOOR.getFloorDescriptionVal()));
        return name;
    }
}

