/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.common.entity.dcr.helper.ErrorDetail;
import org.egov.infra.config.core.EnvironmentSettings;
import org.egov.infra.web.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service(value="edcrBpaRestService")
public class EdcrBpaRestService {
    private static final String BPACHECKDEMOND = "%s/bpa/rest/stakeholder/check/demand-pending/{userId}";
    private static final String REDIRECTTOCOLLECTION = "%s/bpa/application/stakeholder/generate-bill/{userId}";
    private static final String STAKEHOLDER_VALIDATION_URL = "%s/bpa/rest/validate/stakeholder/{userId}";
    private static final String EDCR_SERVICES_URL = "%s/bpa/rest/fetch/servicetype/edcr-required";
    @Autowired
    private EnvironmentSettings environmentSettings;

    public Boolean checkAnyTaxIsPendingToCollectForStakeHolder(Long userId, HttpServletRequest request) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(BPACHECKDEMOND, WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false));
        Map checkPending = (Map)restTemplate.getForObject(url, Map.class, new Object[]{userId});
        return checkPending.get("pending") != null && (Boolean)checkPending.get("pending") != false;
    }

    public String generateBillAndRedirectToCollection(Long userId, HttpServletRequest request) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(REDIRECTTOCOLLECTION, WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false));
        return (String)restTemplate.getForObject(url, String.class, new Object[]{userId});
    }

    public ErrorDetail validateStakeholder(Long userId, HttpServletRequest request) {
        RestTemplate restTemplate = new RestTemplate();
        Boolean isDomainBased = (Boolean)this.environmentSettings.getProperty("stakeholder.domain.based", Boolean.class);
        String externalDomainUrl = (String)this.environmentSettings.getProperty("stakeholder.domain.url", String.class);
        String url = isDomainBased == false && StringUtils.isNotBlank((CharSequence)externalDomainUrl) ? String.format(STAKEHOLDER_VALIDATION_URL, this.environmentSettings.getProperty("stakeholder.domain.url", String.class)) : String.format(STAKEHOLDER_VALIDATION_URL, WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false));
        return (ErrorDetail)restTemplate.getForObject(url, ErrorDetail.class, new Object[]{userId});
    }

    public List<String> getEdcrIntegratedServices(HttpServletRequest request) {
        RestTemplate restTemplate = new RestTemplate();
        String url = String.format(EDCR_SERVICES_URL, WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false));
        return (List)restTemplate.getForObject(url, List.class, new Object[0]);
    }
}

