/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Plan;
import org.egov.edcr.entity.ApplicationType;
import org.egov.edcr.entity.EdcrApplication;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.entity.SearchBuildingPlanScrutinyForm;
import org.egov.edcr.repository.EdcrApplicationDetailRepository;
import org.egov.edcr.repository.EdcrApplicationRepository;
import org.egov.edcr.service.DcrReportSearchSpec;
import org.egov.edcr.service.EdcrApplicationDetailService;
import org.egov.edcr.service.PlanService;
import org.egov.edcr.service.es.EdcrIndexService;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class EdcrApplicationService {
    private static final String RESUBMIT_SCRTNY = "Resubmit Plan Scrutiny";
    private static final String NEW_SCRTNY = "New Plan Scrutiny";
    public static final String ULB_NAME = "ulbName";
    public static final String ABORTED = "Aborted";
    private static Logger LOG = Logger.getLogger(EdcrApplicationService.class);
    @Autowired
    protected SecurityUtils securityUtils;
    @Autowired
    private EdcrApplicationRepository edcrApplicationRepository;
    @Autowired
    private EdcrApplicationDetailRepository edcrApplicationDetailRepository;
    @Autowired
    private PlanService planService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private EdcrIndexService edcrIndexService;
    @Autowired
    private EdcrApplicationDetailService edcrApplicationDetailService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public EdcrApplication create(EdcrApplication edcrApplication) {
        edcrApplication.setApplicationDate(new Date());
        edcrApplication.setApplicationNumber(this.applicationNumberGenerator.generate());
        edcrApplication.setSavedDxfFile(this.saveDXF(edcrApplication));
        edcrApplication.setStatus(ABORTED);
        this.edcrApplicationRepository.save((Object)edcrApplication);
        this.edcrIndexService.updateIndexes(edcrApplication, NEW_SCRTNY);
        Plan planDetail = this.callDcrProcess(edcrApplication, NEW_SCRTNY);
        this.edcrIndexService.updateIndexes(edcrApplication, NEW_SCRTNY);
        return edcrApplication;
    }

    @Transactional
    public EdcrApplication update(EdcrApplication edcrApplication) {
        edcrApplication.setSavedDxfFile(this.saveDXF(edcrApplication));
        edcrApplication.setStatus(ABORTED);
        Plan unsavedPlanDetail = edcrApplication.getEdcrApplicationDetails().get(0).getPlan();
        EdcrApplication applicationRes = (EdcrApplication)((Object)this.edcrApplicationRepository.save((Object)edcrApplication));
        edcrApplication.getEdcrApplicationDetails().get(0).setPlan(unsavedPlanDetail);
        this.edcrIndexService.updateIndexes(edcrApplication, RESUBMIT_SCRTNY);
        Plan planDetail = this.callDcrProcess(edcrApplication, RESUBMIT_SCRTNY);
        return applicationRes;
    }

    private Plan callDcrProcess(EdcrApplication edcrApplication, String applicationType) {
        Plan planDetail = new Plan();
        try {
            planDetail = this.planService.process(edcrApplication, applicationType);
            this.updateFile(planDetail, edcrApplication);
            this.edcrApplicationDetailService.saveAll(edcrApplication.getEdcrApplicationDetails());
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurred, when processing plan scrutiny!!!!!", (Throwable)e);
        }
        return planDetail;
    }

    private File saveDXF(EdcrApplication edcrApplication) {
        FileStoreMapper fileStoreMapper = this.addToFileStore(edcrApplication.getDxfFile());
        File dxfFile = this.fileStoreService.fetch(fileStoreMapper.getFileStoreId(), "Digit DCR");
        this.planService.buildDocuments(edcrApplication, fileStoreMapper, null, null);
        List<EdcrApplicationDetail> edcrApplicationDetails = edcrApplication.getEdcrApplicationDetails();
        edcrApplicationDetails.get(0).setStatus(ABORTED);
        edcrApplication.setEdcrApplicationDetails(edcrApplicationDetails);
        return dxfFile;
    }

    public File savePlanDXF(MultipartFile file) {
        FileStoreMapper fileStoreMapper = this.addToFileStore(file);
        return this.fileStoreService.fetch(fileStoreMapper.getFileStoreId(), "Digit DCR");
    }

    private FileStoreMapper addToFileStore(MultipartFile file) {
        FileStoreMapper fileStoreMapper;
        try {
            fileStoreMapper = this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "Digit DCR");
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Error occurred, while getting input stream!!!!!", (Throwable)e);
        }
        return fileStoreMapper;
    }

    public List<EdcrApplication> findAll() {
        return this.edcrApplicationRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public EdcrApplication findOne(Long id) {
        return (EdcrApplication)((Object)this.edcrApplicationRepository.findOne(id));
    }

    public EdcrApplication findByApplicationNo(String appNo) {
        return this.edcrApplicationRepository.findByApplicationNumber(appNo);
    }

    public EdcrApplication findByApplicationNoAndType(String applnNo, ApplicationType type) {
        return this.edcrApplicationRepository.findByApplicationNumberAndApplicationType(applnNo, type);
    }

    public EdcrApplication findByPlanPermitNumber(String permitNo) {
        return this.edcrApplicationRepository.findByPlanPermitNumber(permitNo);
    }

    public EdcrApplication findByTransactionNumber(String transactionNo) {
        return this.edcrApplicationRepository.findByTransactionNumber(transactionNo);
    }

    public EdcrApplication findByTransactionNumberAndTPUserCode(String transactionNo, String userCode) {
        return this.edcrApplicationRepository.findByTransactionNumberAndThirdPartyUserCode(transactionNo, userCode);
    }

    public List<EdcrApplication> search(EdcrApplication edcrApplication) {
        return this.edcrApplicationRepository.findAll();
    }

    public List<EdcrApplication> findByThirdPartyUserCode(String userCode) {
        return this.edcrApplicationRepository.findByThirdPartyUserCode(userCode);
    }

    public List<EdcrApplication> getEdcrApplications() {
        PageRequest pageable = new PageRequest(0, 25, Sort.Direction.DESC, new String[]{"id"});
        Page edcrApplications = this.edcrApplicationRepository.findAll((Pageable)pageable);
        return edcrApplications.getContent();
    }

    @ReadOnly
    public Page<SearchBuildingPlanScrutinyForm> planScrutinyPagedSearch(SearchBuildingPlanScrutinyForm searchRequest) {
        PageRequest pageable = new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize(), searchRequest.orderDir(), new String[]{searchRequest.orderBy()});
        ArrayList<SearchBuildingPlanScrutinyForm> searchResults = new ArrayList<SearchBuildingPlanScrutinyForm>();
        Page dcrApplications = this.edcrApplicationDetailRepository.findAll(DcrReportSearchSpec.searchReportsSpecification(searchRequest), (Pageable)pageable);
        for (EdcrApplicationDetail applicationDetail : dcrApplications) {
            searchResults.add(this.buildResponseAsPerForm(applicationDetail));
        }
        return new PageImpl(searchResults, (Pageable)pageable, dcrApplications.getTotalElements());
    }

    private SearchBuildingPlanScrutinyForm buildResponseAsPerForm(EdcrApplicationDetail applicationDetail) {
        SearchBuildingPlanScrutinyForm planScrtnyFrm = new SearchBuildingPlanScrutinyForm();
        EdcrApplication application = applicationDetail.getApplication();
        planScrtnyFrm.setApplicationNumber(application.getApplicationNumber());
        planScrtnyFrm.setApplicationDate(application.getApplicationDate());
        planScrtnyFrm.setApplicantName(application.getApplicantName());
        planScrtnyFrm.setBuildingPlanScrutinyNumber(applicationDetail.getDcrNumber());
        planScrtnyFrm.setUploadedDateAndTime(applicationDetail.getCreatedDate());
        if (applicationDetail.getDxfFileId() != null) {
            planScrtnyFrm.setDxfFileStoreId(applicationDetail.getDxfFileId().getFileStoreId());
        }
        if (applicationDetail.getDxfFileId() != null) {
            planScrtnyFrm.setDxfFileName(applicationDetail.getDxfFileId().getFileName());
        }
        if (applicationDetail.getReportOutputId() != null) {
            planScrtnyFrm.setReportOutputFileStoreId(applicationDetail.getReportOutputId().getFileStoreId());
        }
        if (applicationDetail.getReportOutputId() != null) {
            planScrtnyFrm.setReportOutputFileName(applicationDetail.getReportOutputId().getFileName());
        }
        planScrtnyFrm.setStakeHolderId(application.getCreatedBy().getId());
        planScrtnyFrm.setStatus(applicationDetail.getStatus());
        planScrtnyFrm.setBuildingLicenceeName(application.getCreatedBy().getName());
        return planScrtnyFrm;
    }

    private static String readFile(File srcFile) {
        String fileAsString = null;
        try (FileInputStream is = new FileInputStream(srcFile);
             BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line).append("\n");
                line = br.readLine();
            }
            fileAsString = sb.toString();
        }
        catch (IOException e) {
            LOG.error((Object)"Error occurred when reading file!!!!!", (Throwable)e);
        }
        return fileAsString;
    }

    private void updateFile(Plan pl, EdcrApplication edcrApplication) {
        String readFile = EdcrApplicationService.readFile(edcrApplication.getSavedDxfFile());
        String replace = readFile.replace("ENTITIES", "ENTITIES\n0\n" + pl.getAdditionsToDxf());
        String newFile = edcrApplication.getDxfFile().getOriginalFilename().replace(".dxf", "_system_scrutinized.dxf");
        File f = new File(newFile);
        try (FileOutputStream fos = new FileOutputStream(f);){
            if (!f.exists()) {
                f.createNewFile();
            }
            fos.write(replace.getBytes());
            fos.flush();
            FileStoreMapper fileStoreMapper = this.fileStoreService.store(f, f.getName(), edcrApplication.getDxfFile().getContentType(), "Digit DCR");
            edcrApplication.getEdcrApplicationDetails().get(0).setScrutinizedDxfFileId(fileStoreMapper);
        }
        catch (IOException e) {
            LOG.error((Object)"Error occurred when reading file!!!!!", (Throwable)e);
        }
    }

    @Transactional
    public EdcrApplication createRestEdcr(EdcrApplication edcrApplication) {
        String comparisonDcrNo = edcrApplication.getEdcrApplicationDetails().get(0).getComparisonDcrNumber();
        if (edcrApplication.getApplicationDate() == null) {
            edcrApplication.setApplicationDate(new Date());
        }
        edcrApplication.setApplicationNumber(this.applicationNumberGenerator.generate());
        edcrApplication.setSavedDxfFile(this.saveDXF(edcrApplication));
        edcrApplication.setStatus(ABORTED);
        this.edcrApplicationRepository.save((Object)edcrApplication);
        edcrApplication.getEdcrApplicationDetails().get(0).setComparisonDcrNumber(comparisonDcrNo);
        this.callDcrProcess(edcrApplication, NEW_SCRTNY);
        this.edcrIndexService.updateEdcrRestIndexes(edcrApplication, NEW_SCRTNY);
        return edcrApplication;
    }
}

