/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.service;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.egov.edcr.entity.EdcrApplicationDetail;
import org.egov.edcr.entity.SearchBuildingPlanScrutinyForm;
import org.springframework.data.jpa.domain.Specification;

public final class DcrReportSearchSpec {
    private DcrReportSearchSpec() {
    }

    public static Specification<EdcrApplicationDetail> searchReportsSpecification(SearchBuildingPlanScrutinyForm requestForm) {
        return (root, query, builder) -> {
            Predicate predicate = builder.conjunction();
            Join dcrApplicationJoin = root.join("application");
            if (requestForm.getBuildingPlanScrutinyNumber() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("dcrNumber"), (Object)requestForm.getBuildingPlanScrutinyNumber()));
            }
            if (requestForm.getStatus() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("status"), (Object)requestForm.getStatus()));
            }
            if (requestForm.getApplicationNumber() != null) {
                predicate.getExpressions().add(builder.equal((Expression)dcrApplicationJoin.get("applicationNumber"), (Object)requestForm.getApplicationNumber()));
            }
            if (requestForm.getFromDate() != null) {
                predicate.getExpressions().add(builder.greaterThanOrEqualTo((Expression)dcrApplicationJoin.get("createdDate"), (Comparable)requestForm.getFromDate()));
            }
            if (requestForm.getToDate() != null) {
                predicate.getExpressions().add(builder.lessThanOrEqualTo((Expression)dcrApplicationJoin.get("createdDate"), (Comparable)requestForm.getToDate()));
            }
            if (requestForm.getBuildingLicenceeName() != null) {
                predicate.getExpressions().add(builder.equal((Expression)dcrApplicationJoin.get("createdBy").get("id"), (Object)Long.valueOf(requestForm.getBuildingLicenceeName())));
            }
            query.orderBy(new Order[]{builder.desc((Expression)root.get("id"))});
            query.distinct(true);
            return predicate;
        };
    }
}

