/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.security.oauth2.custom;

import java.util.ArrayList;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.security.authentication.userdetail.CurrentUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private UserService userService;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public Authentication authenticate(Authentication authentication) {
        String userName = authentication.getName();
        User user = this.userService.getUserByUsername(userName);
        if (user == null) {
            throw new OAuth2Exception("Invalid login credentials");
        }
        String password = authentication.getCredentials().toString();
        if (this.passwordEncoder.matches((CharSequence)password, user.getPassword())) {
            ArrayList grantedAuths = new ArrayList();
            user.getRoles().forEach(role -> grantedAuths.add(new SimpleGrantedAuthority("ROLE_" + role.getName())));
            return new UsernamePasswordAuthenticationToken((Object)new CurrentUser(user), (Object)password, grantedAuths);
        }
        throw new OAuth2Exception("Invalid login credentials");
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

