/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.security.oauth2.config;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.edcr.security.oauth2.entity.SecuredResource;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.error.OAuth2AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@EnableResourceServer
public class ResourceServerConfiguration
extends ResourceServerConfigurerAdapter {
    private static final Logger LOGGER = Logger.getLogger(ResourceServerConfiguration.class);
    private static final String APIS_CONFIG = "config/restapi-secured-apis-config.json";
    private static final String APIS_CONFIG_OVERRIDE = "config/restapi-secured-apis-config-override.json";
    private static final String RESOURCE_ID = "egov-edcr";

    public void configure(ResourceServerSecurityConfigurer resources) {
        resources.resourceId(RESOURCE_ID).stateless(false);
    }

    public void configure(HttpSecurity http) throws Exception {
        http.requestMatchers().and();
        this.configurePatterns(http);
        http.exceptionHandling().accessDeniedHandler((AccessDeniedHandler)new OAuth2AccessDeniedHandler());
    }

    private void configurePatterns(HttpSecurity http) throws Exception {
        this.getSecuredResourceFromResource().getResources().forEach(record -> {
            try {
                ExpressionUrlAuthorizationConfigurer.AuthorizedUrl authorizedUrl = (ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{record.getUrl()});
                if (StringUtils.isNotEmpty((String)record.getRoles())) {
                    authorizedUrl.access(record.getRoles());
                } else {
                    authorizedUrl.authenticated();
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("Exception occured while configuring: ", (Throwable)e);
            }
        });
    }

    private SecuredResource getSecuredResourceFromResource() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        return (SecuredResource)mapper.readValue(this.getResourcesConfig().getInputStream(), SecuredResource.class);
    }

    private Resource getResourcesConfig() {
        ClassPathResource res = new ClassPathResource(APIS_CONFIG_OVERRIDE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Overridden config present:" + res.exists()));
        }
        if (!res.exists()) {
            res = new ClassPathResource(APIS_CONFIG);
        }
        return res;
    }
}

