/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.security.oauth2.config;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.edcr.security.oauth2.entity.SecuredClient;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.rest.support.CustomTokenEnhancer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.config.annotation.builders.InMemoryClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenStore;

@Configuration
@EnableAuthorizationServer
public class AuthorizationServerConfiguration
extends AuthorizationServerConfigurerAdapter {
    private static final Logger LOGGER = Logger.getLogger(AuthorizationServerConfiguration.class);
    private static final String CLIENTS_CONFIG = "config/restapi-secured-clients-config.json";
    private static final String CLIENTS_CONFIG_OVERRIDE = "config/restapi-secured-clients-config-override.json";
    private static final String SCOPE_WRITE = "write";
    private static final String SCOPE_READ = "read";
    private static final String GRANT_TYPE_PASSWORD = "password";
    private static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    private static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    private static final String RESOURCE_ID = "egov-edcr";
    @Autowired
    @Qualifier(value="authenticationManagerBean")
    private AuthenticationManager authenticationManager;
    @Autowired
    private ClientDetailsService clientDetailsService;
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private CustomTokenEnhancer customTokenEnhancer;

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        InMemoryClientDetailsServiceBuilder serviceBuilder = clients.inMemory();
        this.getSecuredClientFromResource().getClients().forEach(client -> {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Client Id:" + client.getClientId()));
                }
                serviceBuilder.withClient(client.getClientId()).secret(client.getClientSecret()).authorizedGrantTypes(new String[]{GRANT_TYPE_AUTHORIZATION_CODE, GRANT_TYPE_REFRESH_TOKEN, GRANT_TYPE_PASSWORD}).scopes(new String[]{SCOPE_READ, SCOPE_WRITE}).resourceIds(new String[]{RESOURCE_ID}).accessTokenValiditySeconds(client.getAccessTokenValidity() * 60).refreshTokenValiditySeconds(client.getRefreshTokenValidity() * 60);
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("Exception occured while configuring: ", (Throwable)e);
            }
        });
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        endpoints.tokenStore(this.tokenStore).tokenEnhancer((TokenEnhancer)this.customTokenEnhancer).authenticationManager(this.authenticationManager).setClientDetailsService(this.clientDetailsService);
    }

    private SecuredClient getSecuredClientFromResource() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        return (SecuredClient)mapper.readValue(this.getClientsConfig().getInputStream(), SecuredClient.class);
    }

    private Resource getClientsConfig() {
        ClassPathResource res = new ClassPathResource(CLIENTS_CONFIG_OVERRIDE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Overridden config present:" + res.exists()));
        }
        if (!res.exists()) {
            res = new ClassPathResource(CLIENTS_CONFIG);
        }
        return res;
    }
}

