/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.RoadOutput;
import org.egov.edcr.constants.DxfFileConstants;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class Well
extends FeatureProcess {
    private static final String SUB_RULE_104_4_PLOT_DESCRIPTION = "Minimum distance from waste treatment facility like: leach pit,soak pit etc to nearest point on the plot boundary";
    private static final String WELL_DISTANCE_FROM_ROAD = "Minimum distance from well to road";
    private static final String SUB_RULE_104_1_DESCRIPTION = "Open well: Minimum distance between street boundary and the well ";
    private static final String SUB_RULE_104_2_DESCRIPTION = "Minimum distance from well to nearest point on plot boundary";
    private static final String SUB_RULE_104_4_DESCRIPTION = "Minimum distance from well to nearest point on leach pit, soak pit, refuse pit, earth closet or septic tanks ";
    private static final String SUB_RULE_104_1 = "104-1";
    private static final String SUB_RULE_104_2 = "104-2";
    private static final String SUB_RULE_104_4 = "104-4";
    private static final BigDecimal three = BigDecimal.valueOf(3L);
    private static final BigDecimal TWO_MTR = BigDecimal.valueOf(2L);
    private static final BigDecimal ONE_ANDHALF_MTR = BigDecimal.valueOf(1.5);

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        return pl;
    }

    private void printOutputForProposedWellWithNoWasteDisposalDefined(Plan pl) {
        String subRule = null;
        String subRuleDesc = null;
        boolean valid = false;
        for (RoadOutput roadOutput : pl.getUtility().getWellDistance()) {
            BigDecimal minimumDistance = BigDecimal.ZERO;
            if (this.checkConditionForNotifiedNonNotifiedRoad(roadOutput)) {
                minimumDistance = three;
                subRule = SUB_RULE_104_1;
                subRuleDesc = SUB_RULE_104_1_DESCRIPTION;
            } else if (this.checkConditionForCuldesacRoad(roadOutput)) {
                minimumDistance = TWO_MTR;
                subRule = SUB_RULE_104_1;
                subRuleDesc = SUB_RULE_104_1_DESCRIPTION;
            } else if (this.checkConditionForLane(roadOutput)) {
                minimumDistance = ONE_ANDHALF_MTR;
                subRule = SUB_RULE_104_1;
                subRuleDesc = SUB_RULE_104_1_DESCRIPTION;
            } else {
                if (!this.checkConditionForBoundary(roadOutput)) continue;
                subRule = SUB_RULE_104_2;
                subRuleDesc = SUB_RULE_104_2_DESCRIPTION;
                minimumDistance = ONE_ANDHALF_MTR;
            }
            this.printReportOutput(pl, subRule, subRuleDesc, valid, roadOutput, minimumDistance);
        }
    }

    private void printOutputForExistingWellAndProposedWasteDisposal(Plan pl) {
        String subRule = null;
        String subRuleDesc = null;
        boolean valid = false;
        for (RoadOutput roadOutput : pl.getUtility().getWellDistance()) {
            BigDecimal minimumDistance = BigDecimal.ZERO;
            if (this.checkConditionForWellToLeachPit(roadOutput)) {
                subRule = SUB_RULE_104_4;
                subRuleDesc = SUB_RULE_104_4_DESCRIPTION;
                minimumDistance = BigDecimal.valueOf(7.5);
            } else {
                if (!this.checkConditionForLeachPitToBoundary(roadOutput)) continue;
                subRule = SUB_RULE_104_4;
                subRuleDesc = SUB_RULE_104_4_PLOT_DESCRIPTION;
                minimumDistance = BigDecimal.valueOf(1.2);
            }
            this.printReportOutput(pl, subRule, subRuleDesc, valid, roadOutput, minimumDistance);
        }
    }

    private void printOutputForProposedWellAndExistingWasteDisposal(Plan pl) {
        String subRule = null;
        String subRuleDesc = null;
        boolean valid = false;
        for (RoadOutput roadOutput : pl.getUtility().getWellDistance()) {
            BigDecimal minimumDistance = BigDecimal.ZERO;
            if (this.checkConditionForNotifiedNonNotifiedRoad(roadOutput)) {
                minimumDistance = three;
                subRule = SUB_RULE_104_1;
                subRuleDesc = SUB_RULE_104_1_DESCRIPTION;
            } else if (this.checkConditionForCuldesacRoad(roadOutput)) {
                minimumDistance = TWO_MTR;
                subRule = SUB_RULE_104_1;
                subRuleDesc = SUB_RULE_104_1_DESCRIPTION;
            } else if (this.checkConditionForLane(roadOutput)) {
                minimumDistance = ONE_ANDHALF_MTR;
                subRule = SUB_RULE_104_1;
                subRuleDesc = SUB_RULE_104_1_DESCRIPTION;
            } else if (this.checkConditionForBoundary(roadOutput)) {
                subRule = SUB_RULE_104_2;
                subRuleDesc = SUB_RULE_104_2_DESCRIPTION;
                minimumDistance = ONE_ANDHALF_MTR;
            } else {
                if (!this.checkConditionForWellToLeachPit(roadOutput)) continue;
                subRule = SUB_RULE_104_4;
                subRuleDesc = SUB_RULE_104_4_DESCRIPTION;
                minimumDistance = BigDecimal.valueOf(7.5);
            }
            this.printReportOutput(pl, subRule, subRuleDesc, valid, roadOutput, minimumDistance);
        }
    }

    private void printOutputForProposedWellAndProposedWasteDisposal(Plan pl) {
        String subRule = null;
        String subRuleDesc = null;
        boolean valid = false;
        for (RoadOutput roadOutput : pl.getUtility().getWellDistance()) {
            BigDecimal minimumDistance = BigDecimal.ZERO;
            if (this.checkConditionForNotifiedNonNotifiedRoad(roadOutput)) {
                minimumDistance = three;
                subRule = SUB_RULE_104_1;
                subRuleDesc = SUB_RULE_104_1_DESCRIPTION;
            } else if (this.checkConditionForCuldesacRoad(roadOutput)) {
                minimumDistance = TWO_MTR;
                subRule = SUB_RULE_104_1;
                subRuleDesc = SUB_RULE_104_1_DESCRIPTION;
            } else if (this.checkConditionForLane(roadOutput)) {
                minimumDistance = ONE_ANDHALF_MTR;
                subRule = SUB_RULE_104_1;
                subRuleDesc = SUB_RULE_104_1_DESCRIPTION;
            } else if (this.checkConditionForBoundary(roadOutput)) {
                subRule = SUB_RULE_104_2;
                subRuleDesc = SUB_RULE_104_2_DESCRIPTION;
                minimumDistance = ONE_ANDHALF_MTR;
            } else if (this.checkConditionForWellToLeachPit(roadOutput)) {
                subRule = SUB_RULE_104_4;
                subRuleDesc = SUB_RULE_104_4_DESCRIPTION;
                minimumDistance = BigDecimal.valueOf(7.5);
            } else {
                if (!this.checkConditionForLeachPitToBoundary(roadOutput)) continue;
                subRule = SUB_RULE_104_4;
                subRuleDesc = SUB_RULE_104_4_PLOT_DESCRIPTION;
                minimumDistance = BigDecimal.valueOf(1.2);
            }
            this.printReportOutput(pl, subRule, subRuleDesc, valid, roadOutput, minimumDistance);
        }
    }

    private void printReportOutput(Plan pl, String subRule, String subRuleDesc, boolean valid, RoadOutput roadOutput, BigDecimal minimumDistance) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (minimumDistance.compareTo(BigDecimal.ZERO) == 0) {
            errors.put("Minimum distance from the well ", this.getLocaleMessage("msg.error.color.well", roadOutput.distance != null ? roadOutput.distance.toString() : ""));
            pl.addErrors(errors);
        } else {
            if (roadOutput.distance != null && roadOutput.distance.compareTo(BigDecimal.ZERO) > 0 && roadOutput.distance.compareTo(minimumDistance) >= 0) {
                valid = true;
            }
            if (valid) {
                this.setReportOutputDetailsWithoutOccupancy(pl, subRule, subRuleDesc, minimumDistance.toString() + "(MTR)", roadOutput.distance + "(MTR)", Result.Accepted.getResultVal());
            } else {
                this.setReportOutputDetailsWithoutOccupancy(pl, subRule, subRuleDesc, minimumDistance.toString() + "(MTR)", roadOutput.distance + "(MTR)", Result.Not_Accepted.getResultVal());
            }
        }
    }

    private boolean checkConditionForLeachPitToBoundary(RoadOutput roadOutput) {
        return Integer.valueOf(roadOutput.colourCode) == DxfFileConstants.COLOUR_CODE_LEACHPIT_TO_PLOT_BNDRY;
    }

    private boolean checkConditionForWellToLeachPit(RoadOutput roadOutput) {
        return Integer.valueOf(roadOutput.colourCode) == 8;
    }

    private boolean checkConditionForBoundary(RoadOutput roadOutput) {
        return Integer.valueOf(roadOutput.colourCode) == 7;
    }

    private boolean checkConditionForLane(RoadOutput roadOutput) {
        return Integer.valueOf(roadOutput.colourCode) == 5;
    }

    private boolean checkConditionForCuldesacRoad(RoadOutput roadOutput) {
        return Integer.valueOf(roadOutput.colourCode) == 6;
    }

    private boolean checkConditionForNotifiedNonNotifiedRoad(RoadOutput roadOutput) {
        return Integer.valueOf(roadOutput.colourCode) == 1 || Integer.valueOf(roadOutput.colourCode) == 2;
    }

    private void setReportOutputDetailsWithoutOccupancy(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

