/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.OccupancyType;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class WaterTreatmentPlant
extends FeatureProcess {
    private static final String SUB_RULE_53_5_DESCRIPTION = "Liquid waste management treatment plant ";
    private static final String SUB_RULE_53_5 = "53-5";
    private static final BigDecimal TWOTHOUSANDFIVEHUNDER = BigDecimal.valueOf(2500L);

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        return pl;
    }

    private void processLiquidWasteTreatment(Plan pl) {
        if (!pl.getUtility().getLiquidWasteTreatementPlant().isEmpty()) {
            this.setReportOutputDetailsWithoutOccupancy(pl, SUB_RULE_53_5, SUB_RULE_53_5_DESCRIPTION, "", " Defined in the plan.", Result.Accepted.getResultVal());
            return;
        }
        this.setReportOutputDetailsWithoutOccupancy(pl, SUB_RULE_53_5, SUB_RULE_53_5_DESCRIPTION, "", " Not defined in the plan.", Result.Not_Accepted.getResultVal());
    }

    private boolean checkOccupancyTypeEqualsToNonConditionalOccupancyTypes(OccupancyType occupancyType) {
        return occupancyType.equals((Object)OccupancyType.OCCUPANCY_B1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_B2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_B3) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_C) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_C1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_C2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_C3) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_D) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_D1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_D2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_G1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_G2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_H) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_I1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_I2);
    }

    private boolean checkOccupancyTypeEqualsToConditionalOccupancyTypes(OccupancyType occupancyType) {
        return occupancyType.equals((Object)OccupancyType.OCCUPANCY_A1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_A2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_A3) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_A4) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_A5) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_E) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F3) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F4);
    }

    private void setReportOutputDetailsWithoutOccupancy(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

