/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.stereotype.Service;

@Service
public class WaterTankCapacity
extends FeatureProcess {
    private static final String RULE_59_10_vii = "59-10-vii";
    private static final String RULE_59_10_vii_DESCRIPTION = "Water tank capacity";
    private static final String WATER_TANK_CAPACITY = "Minimum capacity of Water tank";
    private static final BigDecimal TWELVE_POINTFIVE = BigDecimal.valueOf(12.5);
    private static final BigDecimal ONEHUNDRED_THIRTYFIVE = BigDecimal.valueOf(135L);

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        this.scrutinyDetail = new ScrutinyDetail();
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        this.scrutinyDetail.setKey("Common_Water tank capacity");
        String subRule = RULE_59_10_vii;
        String subRuleDesc = RULE_59_10_vii_DESCRIPTION;
        BigDecimal expectedWaterTankCapacity = BigDecimal.ZERO;
        if (pl.getUtility() != null && pl.getVirtualBuilding() != null && pl.getUtility().getWaterTankCapacity() != null) {
            Boolean valid = false;
            BigDecimal totalBuitUpArea = pl.getVirtualBuilding().getTotalBuitUpArea();
            BigDecimal noOfPersons = totalBuitUpArea.divide(TWELVE_POINTFIVE, 2, DcrConstants.ROUNDMODE_MEASUREMENTS);
            expectedWaterTankCapacity = ONEHUNDRED_THIRTYFIVE.multiply(noOfPersons.setScale(0, 4));
            expectedWaterTankCapacity = expectedWaterTankCapacity.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS);
            BigDecimal providedWaterTankCapacity = pl.getUtility().getWaterTankCapacity();
            if ((providedWaterTankCapacity = providedWaterTankCapacity.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS)).compareTo(expectedWaterTankCapacity) >= 0) {
                valid = true;
            }
            this.processWaterTankCapacity(pl, "", subRule, subRuleDesc, expectedWaterTankCapacity, valid);
        }
        return pl;
    }

    private void processWaterTankCapacity(Plan plan, String rule, String subRule, String subRuleDesc, BigDecimal expectedWaterTankCapacity, Boolean valid) {
        if (expectedWaterTankCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
            if (valid.booleanValue()) {
                this.setReportOutputDetails(plan, subRule, WATER_TANK_CAPACITY, expectedWaterTankCapacity.toString(), plan.getUtility().getWaterTankCapacity().toString(), Result.Accepted.getResultVal());
            } else {
                this.setReportOutputDetails(plan, subRule, WATER_TANK_CAPACITY, expectedWaterTankCapacity.toString() + " L ", plan.getUtility().getWaterTankCapacity().toString() + " L ", Result.Not_Accepted.getResultVal());
            }
        }
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

