/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.RoadOutput;
import org.egov.edcr.constants.DxfFileConstants;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class WasteDisposal
extends FeatureProcess {
    private static final String SUB_RULE_26A_DESCRIPTION = "Waste Disposal";
    private static final String SUB_RULE_26A = "26-A";
    private static final String SUB_RULE_104_4_WD = "104-4";
    private static final String SUB_RULE_104_4_PLOT_DESCRIPTION_WD = "Minimum distance from waste treatment facility like: leach pit,soak pit etc to nearest point on the plot boundary";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        return pl;
    }

    private void setReportOutputDetailsWithoutOccupancy(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    private void printOutputForProposedWasteDisposal(Plan pl) {
        boolean valid = false;
        for (RoadOutput roadOutput : pl.getUtility().getWellDistance()) {
            if (!this.checkConditionForLeachPitToBoundary(roadOutput)) continue;
            String subRule = SUB_RULE_104_4_WD;
            String subRuleDesc = SUB_RULE_104_4_PLOT_DESCRIPTION_WD;
            BigDecimal minimumDistance = BigDecimal.valueOf(1.2);
            this.printReportOutput(pl, subRule, subRuleDesc, valid, roadOutput, minimumDistance);
        }
    }

    private void printReportOutput(Plan pl, String subRule, String subRuleDesc, boolean valid, RoadOutput roadOutput, BigDecimal minimumDistance) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (minimumDistance.compareTo(BigDecimal.ZERO) == 0) {
            errors.put("Minimum distance from the waste disposal ", this.getLocaleMessage("msg.error.color.wastedisposal", roadOutput.distance != null ? roadOutput.distance.toString() : ""));
            pl.addErrors(errors);
        } else {
            if (roadOutput.distance != null && roadOutput.distance.compareTo(BigDecimal.ZERO) > 0 && roadOutput.distance.compareTo(minimumDistance) >= 0) {
                valid = true;
            }
            if (valid) {
                this.setReportOutputDetailsWithoutOccupancy(pl, subRule, subRuleDesc, minimumDistance.toString() + "(MTR)", roadOutput.distance + "(MTR)", Result.Accepted.getResultVal());
            } else {
                this.setReportOutputDetailsWithoutOccupancy(pl, subRule, subRuleDesc, minimumDistance.toString() + "(MTR)", roadOutput.distance + "(MTR)", Result.Not_Accepted.getResultVal());
            }
        }
    }

    private boolean checkConditionForLeachPitToBoundary(RoadOutput roadOutput) {
        return Integer.valueOf(roadOutput.colourCode) == DxfFileConstants.COLOUR_CODE_LEACHPIT_TO_PLOT_BNDRY;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

